/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfw4j.framework;

import com.cognos.mfw4j.framework.MFWModelRes;
import com.cognos.mfw4j.utilities.MFWException;
import com.cognos.mfw4j.utilities.MFWMessage;
import java.util.List;
import org.jaxen.JaxenHandler;
import org.jaxen.expr.Expr;
import org.jaxen.expr.LocationPath;
import org.jaxen.expr.NameStep;
import org.jaxen.expr.Step;
import org.jaxen.saxpath.SAXPathException;
import org.jaxen.saxpath.XPathHandler;
import org.jaxen.saxpath.XPathReader;
import org.jaxen.saxpath.helpers.XPathReaderFactory;

public final class MFWQuerySpec {
    String mXPathQuery;
    private int mRetrievalDepth = -1;
    private int mRetrievalStartIndex = 0;
    private int mRetrievalCount = 0;
    private LocationPath mRootPath = null;
    private Step mCurrentStep;
    private short mCurrentStepRID;
    private boolean m_suppressLogging;
    private MFWQuerySpec mMainQuerySpec = null;

    public static MFWQuerySpec create(String aQueryPath) {
        return new MFWQuerySpec(aQueryPath);
    }

    private MFWQuerySpec(String queryPath) {
        this.mXPathQuery = queryPath;
        this.m_suppressLogging = false;
        this.mCurrentStep = null;
        this.mCurrentStepRID = (short)-1;
    }

    public void setPrimaryQuerySpec(MFWQuerySpec aQuerySpec) {
        this.mMainQuerySpec = aQuerySpec;
    }

    public MFWQuerySpec getPrimaryQuerySpec() {
        return this.mMainQuerySpec;
    }

    private void parse() {
        try {
            XPathReader xpathReader = XPathReaderFactory.createReader();
            JaxenHandler myHandler = new JaxenHandler();
            xpathReader.setXPathHandler((XPathHandler)myHandler);
            xpathReader.parse(this.mXPathQuery);
            Expr xExpr = myHandler.getXPathExpr().getRootExpr();
            MFWException.ASSERT(xExpr instanceof LocationPath, "Unable tp parse XPath query:", this.mXPathQuery);
            this.mRootPath = (LocationPath)xExpr;
        }
        catch (SAXPathException pe) {
            throw new RuntimeException(pe.getMessage(), pe);
        }
    }

    public String getXPathQuery() {
        return this.mXPathQuery;
    }

    public void suppressActionLogging(Object player) {
        if (player.getClass().getName() != "com.cognos.mfwa4j.testApps.MFWScriptPlayer") {
            this.m_suppressLogging = true;
        }
    }

    public boolean isSuppressActionLogging() {
        return this.m_suppressLogging;
    }

    LocationPath getRootPath() {
        if (this.mRootPath == null) {
            this.parse();
        }
        return this.mRootPath;
    }

    void setCurrentStep(NameStep aStep) {
        this.mCurrentStep = aStep;
        this.mCurrentStepRID = MFWQuerySpec.getStepRID((Step)aStep);
    }

    public Step getCurrentStepPattern() {
        this.ensureCurrentIsSet();
        return this.mCurrentStep;
    }

    public short getCurrentStepPatternRID() {
        this.ensureCurrentIsSet();
        return this.mCurrentStepRID;
    }

    private void ensureCurrentIsSet() {
        if (this.mCurrentStep == null) {
            if (this.mRootPath == null) {
                this.parse();
            }
            MFWException.ASSERT(this.mRootPath != null, "Invalid root path when trying to get current step:");
            List steps = this.mRootPath.getSteps();
            if (steps != null && steps.size() > 0 && steps.get(0) instanceof NameStep) {
                this.setCurrentStep((NameStep)steps.get(0));
            }
        }
    }

    public void setRetrievalDepth(int depth) {
        this.mRetrievalDepth = depth;
    }

    public int getRetrievalDepth() {
        return this.mRetrievalDepth;
    }

    public void setRetrievalStartIndex(int startIdx) {
        this.mRetrievalStartIndex = startIdx;
    }

    public int getRetrievalStartIndex() {
        return this.mRetrievalStartIndex;
    }

    public void setRetrievalCount(int count) {
        this.mRetrievalCount = count;
    }

    public int getRetrievalCount() {
        return this.mRetrievalCount;
    }

    public String toString() {
        StringBuffer outStr = new StringBuffer("MFWQuerySpec: ");
        outStr.append("\n\tRetrieval Depth: ");
        outStr.append(Integer.toString(this.mRetrievalDepth));
        outStr.append("\n\tRetrieval Start Index: ");
        outStr.append(Integer.toString(this.mRetrievalStartIndex));
        outStr.append("\n\tRetrieval Count: ");
        outStr.append(Integer.toString(this.mRetrievalCount));
        outStr.append("\n\t");
        outStr.append(this.mXPathQuery);
        return outStr.toString();
    }

    public static short getStepRID(Step aStep) {
        short outRID = -1;
        String stepName = ((NameStep)aStep).getLocalName();
        if ("*".equals(stepName) || ".".equals(stepName) || "..".equals(stepName)) {
            return outRID;
        }
        outRID = MFWModelRes.getInstance().getResourceID(stepName);
        if (outRID == -1) {
            MFWMessage msg = new MFWMessage("mfw4j", "XPH_PRS_INVALID_STEP_PATTERN", new String[]{((NameStep)aStep).getLocalName()});
            MFWException e = new MFWException();
            e.addMessage(msg);
            throw e;
        }
        return outRID;
    }
}

