/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfw4j.framework;

import com.cognos.mfw4j.framework.MFWRequestContextUser;
import com.cognos.mfw4j.utilities.IMFWCMRequestExecutor;
import com.cognos.mfw4j.utilities.IMFWUsageIndicator;
import com.cognos.mfw4j.utilities.MFWException;
import com.cognos.mfw4j.utilities.MFWSimpleCMRequestExecutor;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.reportservice.RequestInvoker;
import java.util.Iterator;
import org.dom4j.Element;

public class MFWRequestContext {
    private String mProductLocale = null;
    private String mContentLocale = null;
    private String mUserPassport = null;
    private Element mConnectionSpec = null;
    private Element mPromptResolution = null;
    private boolean mUseAdvancedIDResolution = false;
    private RequestInvoker mInvoker = null;
    private BIBusEnvelope mBiBusEnvelope = null;
    private Object mXQEExecutionEnv = null;
    private IMFWUsageIndicator mMFWUsageIndicator = null;
    private IMFWCMRequestExecutor mCMRequestExecutor = null;
    private boolean mForceCMTrusted = false;
    private boolean mMetadataRequest = false;
    private boolean mIgnoreMetadataUpdateRetainPeriod = false;

    public static MFWRequestContext create(String localeProduct, String localeContent, String userPassport) {
        return new MFWRequestContextUser(localeProduct, localeContent, userPassport);
    }

    protected MFWRequestContext(String localeProduct, String localeContent, String userPassport) {
        this.mProductLocale = localeProduct;
        this.mContentLocale = localeContent;
        this.mUserPassport = userPassport;
    }

    public void destroy() {
        this.mConnectionSpec = null;
        this.mPromptResolution = null;
    }

    public String getProductLocale() {
        return this.mProductLocale;
    }

    public String getContentLocale() {
        return this.mContentLocale;
    }

    public String getUserPassport() {
        return this.mUserPassport;
    }

    public void setBiBusEnvelope(BIBusEnvelope bibusEnvelope) {
        this.mBiBusEnvelope = bibusEnvelope;
    }

    public BIBusEnvelope getBiBusEnvelope() {
        return this.mBiBusEnvelope;
    }

    public void setCMRequestExecutor(IMFWCMRequestExecutor executor) {
        this.mCMRequestExecutor = executor;
    }

    public IMFWCMRequestExecutor getCMRequestExecutor() {
        if (this.mCMRequestExecutor == null) {
            this.mCMRequestExecutor = new MFWSimpleCMRequestExecutor(this.mBiBusEnvelope, this.mUserPassport);
        }
        return this.mCMRequestExecutor;
    }

    public void setRequestInvoker(RequestInvoker invoker) {
        this.mInvoker = invoker;
    }

    public RequestInvoker getInvoker() {
        return this.mInvoker;
    }

    public void setConnectionSpec(Element elmConn) {
        this.mConnectionSpec = elmConn;
        Iterator itr = elmConn.elementIterator();
        while (itr.hasNext()) {
            Element elem = (Element)itr.next();
            if (!elem.getName().equals("parameters")) continue;
            this.setPromptResolution(elem);
            return;
        }
    }

    public Element getConnectionSpec() {
        return this.mConnectionSpec;
    }

    public void setPromptResolution(Element promptInfo) {
        this.mPromptResolution = promptInfo;
    }

    public Element getPromptResolution() {
        return this.mPromptResolution;
    }

    public void setAdvancedIDResolution(boolean bUseAdvancedResoloution) {
        this.mUseAdvancedIDResolution = bUseAdvancedResoloution;
    }

    public boolean getAdvancedIDResolution() {
        return this.mUseAdvancedIDResolution;
    }

    public void setXQEExecutionEnvironment(Object xqeExecEnv) {
        MFWException.ASSERT("com.cognos.xqe.query.engine.ExecutionEnvironment".equals(xqeExecEnv.getClass().getName()), "Unexpected execution environment object type!");
        this.mXQEExecutionEnv = xqeExecEnv;
    }

    public Object getXQEExecutionEnvironment() {
        return this.mXQEExecutionEnv;
    }

    public void setXQEUsageIndicatorService(IMFWUsageIndicator xqeUsageIndicatorService) {
        this.mMFWUsageIndicator = xqeUsageIndicatorService;
    }

    public IMFWUsageIndicator getXQEUsageIndicatorService() {
        return this.mMFWUsageIndicator;
    }

    public void setForceCMTrusted(boolean value) {
        this.mForceCMTrusted = value;
    }

    public boolean getForceCMTrusted() {
        return this.mForceCMTrusted;
    }

    public void setMetadataRequest(boolean value) {
        this.mMetadataRequest = value;
    }

    public boolean getMetadataRequest() {
        return this.mMetadataRequest;
    }

    public void setIgnoreMetadataUpdateRetainPeriod(boolean b) {
        this.mIgnoreMetadataUpdateRetainPeriod = b;
    }

    public boolean getIgnoreUpdateRetainPeriod() {
        return this.mIgnoreMetadataUpdateRetainPeriod;
    }
}

