/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfw4j.framework;

import com.cognos.mfw4j.framework.MFWCluster;
import com.cognos.mfw4j.framework.MFWModelRes;
import com.cognos.mfw4j.framework.MFWNodeObject;
import com.cognos.mfw4j.framework.MFWRequestContext;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class MFWRequestContextUser
extends MFWRequestContext {
    public static final String HIDDEN_AND_ACCESSIBLE = "hiddenAndAccessible";
    public static final String HIDDEN = "hidden";
    public static final String VISIBLE = "visible";
    public static final String VISIBLE_AND_ACCESSIBLE = "visibleAndAccessible";
    private MFWCluster mGatewayCluster = null;
    private HashSet<MFWNodeObject> mAccessibleSecurityViews = new HashSet();
    private HashSet<MFWCluster> mCalculatedSecurityClusters = new HashSet();
    private HashMap<MFWCluster, Set<String>> mIncludeSet = new HashMap();
    private HashSet<MFWCluster> mRoleBasedDefined = new HashSet();
    private HashMap<MFWCluster, Set<String>> mRoleBasedIncludeSet = new HashMap();
    private HashMap<MFWCluster, Set<String>> mRoleBasedHideSet = new HashMap();
    private HashMap<MFWCluster, Set<String>> mRoleBasedExcludeSet = new HashMap();
    private HashMap<MFWCluster, Set<String>> mBaseViewHideSet = new HashMap();
    private HashSet<MFWCluster> mBaseViewDefined = new HashSet();

    MFWRequestContextUser(String localeProduct, String localeContent, String userPassport) {
        super(localeProduct, localeContent, userPassport);
    }

    @Override
    public void destroy() {
        super.destroy();
        this.mAccessibleSecurityViews.clear();
        this.mCalculatedSecurityClusters.clear();
        this.mIncludeSet.clear();
        this.mRoleBasedIncludeSet.clear();
        this.mRoleBasedHideSet.clear();
        this.mRoleBasedExcludeSet.clear();
        this.mBaseViewHideSet.clear();
        this.mBaseViewDefined.clear();
    }

    public MFWCluster getGatewayCluster() {
        return this.mGatewayCluster;
    }

    void setGatewayCluster(MFWCluster aCluster) {
        this.mGatewayCluster = aCluster;
    }

    public boolean areSecuritySetsCalculatedFor(MFWCluster aCluster) {
        return this.mCalculatedSecurityClusters.contains(aCluster);
    }

    public void setSecuritySetsCalculatedFor(MFWCluster aCluster) {
        this.mCalculatedSecurityClusters.add(aCluster);
    }

    public void addAccessibleSecurityView(MFWNodeObject securityView) {
        this.mAccessibleSecurityViews.add(securityView);
    }

    public void addIncludeSet(MFWCluster cluster, MFWNodeObject objectNode) {
        this.addObjectToSet(cluster, objectNode, this.mIncludeSet);
    }

    public void setRoleBasedDefined(MFWCluster aCluster, boolean defined) {
        if (defined) {
            this.mRoleBasedDefined.add(aCluster);
        } else {
            this.mRoleBasedDefined.remove(aCluster);
        }
    }

    public void addRoleBasedIncludeSet(MFWCluster aCluster, MFWNodeObject objectNode) {
        this.addObjectToSet(aCluster, objectNode, this.mRoleBasedIncludeSet);
    }

    public void addRoleBasedHideSet(MFWCluster aCluster, MFWNodeObject objectNode) {
        this.addObjectToSet(aCluster, objectNode, this.mRoleBasedHideSet);
    }

    public void addRoleExcludeSet(MFWCluster aCluster, MFWNodeObject objectNode) {
        this.addObjectToSet(aCluster, objectNode, this.mRoleBasedExcludeSet);
    }

    public void setBaseViewDefined(MFWCluster aCluster, boolean defined) {
        if (defined) {
            this.mBaseViewDefined.add(aCluster);
        } else {
            this.mBaseViewDefined.remove(aCluster);
        }
    }

    public void addBaseViewHideSet(MFWCluster aCluster, MFWNodeObject objectNode) {
        this.addObjectToSet(aCluster, objectNode, this.mBaseViewHideSet);
    }

    public boolean isObjectVisibleBySecurityViews(MFWCluster aCluster, MFWNodeObject objectNode) {
        MFWModelRes gModelRes = MFWModelRes.getInstance();
        if (objectNode.getNameRID() == gModelRes.RID_securityView) {
            return this.mAccessibleSecurityViews.contains(objectNode);
        }
        String objectId = objectNode.getPropertyValue(gModelRes.RID_ID);
        if (objectId == null) {
            return true;
        }
        boolean visible = false;
        Set<String> includeSets = this.mIncludeSet.get(aCluster);
        if (includeSets != null) {
            visible = includeSets.contains(objectId);
        }
        return visible;
    }

    public boolean isObjectAccessibleBySecurityViews(MFWCluster aCluster, MFWNodeObject objectNode) {
        String refObj;
        boolean baseViewDefined;
        MFWModelRes gModelRes = MFWModelRes.getInstance();
        if (objectNode.getNameRID() == gModelRes.RID_securityView) {
            return this.mAccessibleSecurityViews.contains(objectNode);
        }
        Set<String> roleBasedIncludedRefs = this.mRoleBasedIncludeSet.get(aCluster);
        Set<String> roleBasedHiddenRefs = this.mRoleBasedHideSet.get(aCluster);
        Set<String> roleBasedExcludedRefs = this.mRoleBasedExcludeSet.get(aCluster);
        if (!this.mRoleBasedDefined.contains(aCluster)) {
            return true;
        }
        String objectId = objectNode.getPropertyValue(gModelRes.RID_ID);
        if (objectId == null) {
            return true;
        }
        Set<String> baseViewHiddenRefs = this.mBaseViewHideSet.get(aCluster);
        boolean visible = this.isObjectAccessible(objectId, roleBasedIncludedRefs, roleBasedHiddenRefs, roleBasedExcludedRefs, baseViewHiddenRefs, baseViewDefined = this.mBaseViewDefined.contains(aCluster));
        if (!visible) {
            return false;
        }
        if (objectNode.getNameRID() == gModelRes.RID_shortcut && (refObj = objectNode.getPropertyValue(gModelRes.RID_refobj)) != null) {
            return this.isObjectAccessible(refObj, roleBasedIncludedRefs, roleBasedHiddenRefs, roleBasedExcludedRefs, baseViewHiddenRefs, baseViewDefined);
        }
        return true;
    }

    private boolean isObjectAccessible(String objectID, Set<String> roleBasedIncludedRefs, Set<String> roleBasedHiddenRefs, Set<String> roleBasedExcludedRefs, Set<String> baseViewHiddenRefs, boolean isBaseViewDefined) {
        if (isBaseViewDefined) {
            if (roleBasedIncludedRefs != null && roleBasedIncludedRefs.contains(objectID)) {
                return true;
            }
            if (roleBasedHiddenRefs != null && roleBasedHiddenRefs.contains(objectID)) {
                return false;
            }
            return baseViewHiddenRefs == null || !baseViewHiddenRefs.contains(objectID);
        }
        if (roleBasedExcludedRefs != null && roleBasedExcludedRefs.contains(objectID)) {
            return false;
        }
        return roleBasedIncludedRefs != null && roleBasedIncludedRefs.contains(objectID);
    }

    private void addObjectToSet(MFWCluster aCluster, MFWNodeObject objViewSet, HashMap<MFWCluster, Set<String>> aHashSet) {
        List<String> viewRefObjs = objViewSet.getPropertyValues(MFWModelRes.getInstance().RID_refobj);
        if (viewRefObjs == null || viewRefObjs.isEmpty()) {
            return;
        }
        Set<String> refObjs = aHashSet.get(aCluster);
        if (refObjs == null) {
            refObjs = new HashSet<String>();
            aHashSet.put(aCluster, refObjs);
        }
        refObjs.addAll(viewRefObjs);
    }
}

