/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfw4j.framework.implHeap;

import com.cognos.mfw4j.framework.MFWCluster;
import com.cognos.mfw4j.framework.MFWLinkManager;
import com.cognos.mfw4j.framework.MFWMetadataSource;
import com.cognos.mfw4j.framework.MFWNodeObject;
import com.cognos.mfw4j.utilities.MFWException;
import java.util.Vector;

public final class MFWLinkManagerHeap
extends MFWLinkManager {
    Vector<MFWLinkManager.Link> mLinks = new Vector();

    public MFWLinkManagerHeap(MFWCluster aCluster) {
        super(aCluster);
    }

    @Override
    public void destroy() {
        super.destroy();
        this.mLinks.clear();
    }

    @Override
    protected MFWMetadataSource getLinkSource(short idLink) {
        MFWException.ASSERT(idLink >= 0 && idLink < this.mLinks.size(), "Invalid link source id");
        MFWLinkManager.Link aLink = this.mLinks.get(idLink);
        return aLink.mMetadataSrc;
    }

    @Override
    protected MFWNodeObject getLinkContainer(short idLink) {
        MFWException.ASSERT(idLink >= 0 && idLink < this.mLinks.size(), "Invalid link source id");
        MFWLinkManager.Link aLink = this.mLinks.get(idLink);
        return aLink.mLinkParent;
    }

    @Override
    public short findOrAddLink(MFWMetadataSource aSource, MFWNodeObject aParent) {
        for (int idx = 0; idx < this.mLinks.size(); ++idx) {
            MFWLinkManager.Link aLink = this.mLinks.get(idx);
            MFWMetadataSource aSrc = aLink.mMetadataSrc;
            if (!aSrc.equals(aSource)) continue;
            return (short)idx;
        }
        this.mLinks.add(new MFWLinkManager.Link(aSource, aParent));
        short idNewLink = (short)(this.mLinks.size() - 1);
        this.setupGlobalLinks(aSource, idNewLink);
        return idNewLink;
    }

    @Override
    protected short[] getLinkIDs() {
        short[] outIDs = new short[this.mLinks.size()];
        for (int idx = 0; idx < this.mLinks.size(); ++idx) {
            outIDs[idx] = (short)idx;
        }
        return outIDs;
    }
}

