/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfw4j.framework.implHeap;

import com.cognos.mfw4j.framework.MFWCluster;
import com.cognos.mfw4j.framework.MFWInfoObjectImpl;
import com.cognos.mfw4j.framework.MFWInfoProperty;
import com.cognos.mfw4j.framework.MFWNode;
import com.cognos.mfw4j.framework.MFWQuerySpec;
import com.cognos.mfw4j.framework.MFWRequestContextUser;
import com.cognos.mfw4j.framework.implHeap.MFWNodeObjectHeap;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

final class MFWNodeObjectHeapExpandable
extends MFWNodeObjectHeap {
    private byte[] mChildExpandStats = null;
    private ReadWriteLock mExpandLock = new ReentrantReadWriteLock();

    MFWNodeObjectHeapExpandable(MFWNodeObjectHeap objParent, MFWInfoObjectImpl objInfo) {
        super(objParent, objInfo);
        this.mChildExpandStats = new byte[objInfo.getChildrenSize()];
        Arrays.fill(this.mChildExpandStats, (byte)2);
    }

    @Override
    public void destroy() {
        this.mChildExpandStats = null;
        this.mExpandLock = null;
        super.destroy();
    }

    @Override
    public byte getExpandStatus(short ridChild) {
        int ridIdx = this.mInfo.getChildIndex(ridChild);
        return this.mChildExpandStats[ridIdx];
    }

    @Override
    public void setExpandStatus(short ridChild, byte expandStat) {
        int ridIdx = this.mInfo.getChildIndex(ridChild);
        this.mChildExpandStats[ridIdx] = expandStat;
    }

    @Override
    public Object getExpandLock() {
        return this.mExpandLock;
    }

    @Override
    protected void queryChild(MFWRequestContextUser aContext, MFWQuerySpec aQuerySpec, List<MFWNode> outResults) {
        short ridChildName = aQuerySpec.getCurrentStepPatternRID();
        this.doQueryChild(aContext, ridChildName, aQuerySpec, outResults);
    }

    @Override
    protected void queryChild(MFWRequestContextUser aContext, short ridChildName, List<MFWNode> outResults) {
        this.doQueryChild(aContext, ridChildName, null, outResults);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doQueryChild(MFWRequestContextUser aContext, short ridChildName, MFWQuerySpec aQuerySpec, List<MFWNode> outResults) {
        MFWInfoObjectImpl.ChildInfo childInfo = this.validateChild(ridChildName, (short)0);
        this.mExpandLock.readLock().lock();
        try {
            if (this.getExpandStatus(childInfo.getInfo().getRID()) == 1) {
                this.queryChildInstances(aContext, childInfo, aQuerySpec, outResults);
                return;
            }
        }
        finally {
            this.mExpandLock.readLock().unlock();
        }
        this.mExpandLock.writeLock().lock();
        try {
            if (this.getExpandStatus(childInfo.getInfo().getRID()) != 1) {
                MFWCluster ownerCluster = this.getCluster();
                if (aQuerySpec == null) {
                    MFWQuerySpec newQuerySpec = MFWQuerySpec.create(childInfo.getInfo().getName());
                    ownerCluster.expand(this, aContext, newQuerySpec);
                } else {
                    ownerCluster.expand(this, aContext, aQuerySpec);
                }
            }
            this.queryChildInstances(aContext, childInfo, aQuerySpec, outResults);
        }
        finally {
            this.mExpandLock.writeLock().unlock();
        }
    }

    @Override
    protected MFWNode querySingleChild(MFWRequestContextUser aContext, MFWQuerySpec aQuerySpec) {
        short ridChildName = aQuerySpec.getCurrentStepPatternRID();
        return this.doQuerySingleChild(aContext, ridChildName, aQuerySpec);
    }

    @Override
    protected MFWNode querySingleChild(MFWRequestContextUser aContext, short ridChildName) {
        return this.doQuerySingleChild(aContext, ridChildName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MFWNode doQuerySingleChild(MFWRequestContextUser aContext, short ridChildName, MFWQuerySpec aQuerySpec) {
        MFWNode outNode = null;
        MFWInfoObjectImpl.ChildInfo childInfo = this.validateChild(ridChildName, (short)0);
        this.mExpandLock.readLock().lock();
        try {
            if (this.getExpandStatus(childInfo.getInfo().getRID()) == 1) {
                MFWNode mFWNode = outNode = this.querySingleChildInstance(aContext, childInfo);
                return mFWNode;
            }
        }
        finally {
            this.mExpandLock.readLock().unlock();
        }
        this.mExpandLock.writeLock().lock();
        try {
            if (this.getExpandStatus(childInfo.getInfo().getRID()) != 1) {
                MFWCluster ownerCluster = this.getCluster();
                if (aQuerySpec == null) {
                    MFWQuerySpec newQuerySpec = MFWQuerySpec.create(childInfo.getInfo().getName());
                    ownerCluster.expand(this, aContext, newQuerySpec);
                } else {
                    ownerCluster.expand(this, aContext, aQuerySpec);
                }
            }
            outNode = this.querySingleChildInstance(aContext, childInfo);
        }
        finally {
            this.mExpandLock.writeLock().unlock();
        }
        return outNode;
    }

    @Override
    protected void queryAllChildren(MFWRequestContextUser aContext, MFWQuerySpec aQuerySpec, List<MFWNode> outResults) {
        this.doQueryAllChildren(aContext, aQuerySpec, outResults);
    }

    @Override
    protected void queryAllChildren(MFWRequestContextUser aContext, List<MFWNode> outResults) {
        this.doQueryAllChildren(aContext, null, outResults);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doQueryAllChildren(MFWRequestContextUser aContext, MFWQuerySpec aQuerySpec, List<MFWNode> outResults) {
        List<MFWInfoObjectImpl.ChildInfo> vChildrenInfo = this.mInfo.getDetailedChildrenInfo();
        this.mExpandLock.readLock().lock();
        try {
            if (this.isAllExpanded(vChildrenInfo)) {
                super.queryAllChildren(aContext, outResults);
                return;
            }
        }
        finally {
            this.mExpandLock.readLock().unlock();
        }
        this.mExpandLock.writeLock().lock();
        try {
            if (!this.isAllExpanded(vChildrenInfo)) {
                MFWCluster ownerCluster = this.getCluster();
                if (aQuerySpec == null) {
                    MFWQuerySpec newQuerySpec = MFWQuerySpec.create("*");
                    ownerCluster.expand(this, aContext, newQuerySpec);
                } else {
                    ownerCluster.expand(this, aContext, aQuerySpec);
                }
            }
            super.queryAllChildren(aContext, outResults);
        }
        finally {
            this.mExpandLock.writeLock().unlock();
        }
    }

    private boolean isAllExpanded(List<MFWInfoObjectImpl.ChildInfo> vChildrenInfo) {
        boolean bAllExpanded = true;
        for (int idx = 0; idx < vChildrenInfo.size() && bAllExpanded; ++idx) {
            MFWInfoObjectImpl.ChildInfo aDetailedInfo = vChildrenInfo.get(idx);
            if (aDetailedInfo.getInfo().getNodeType() == 1 && ((MFWInfoProperty)aDetailedInfo.getInfo()).isDynamic()) continue;
            short eExpStat = this.getExpandStatus(aDetailedInfo.getInfo().getRID());
            bAllExpanded = eExpStat == 1;
        }
        return bAllExpanded;
    }
}

