/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfw4j.framework.implHeap;

import com.cognos.mfw4j.framework.MFWStringPool;

public final class MFWStringPoolHeap
implements MFWStringPool {
    private static int Max_PoolSize = 1024;
    private static int MAX_BucketCapacity = 8;
    private Bucket[] mPool = new Bucket[Max_PoolSize];

    @Override
    public void destroy() {
        for (int idx = 0; idx < this.mPool.length; ++idx) {
            if (this.mPool[idx] == null) continue;
            this.mPool[idx].destroy();
        }
    }

    String poolString(String inString) {
        int idx = Math.abs(inString.hashCode() % Max_PoolSize);
        if (this.mPool[idx] == null) {
            this.mPool[idx] = new Bucket();
        }
        return this.mPool[idx].getString(inString);
    }

    private class Bucket {
        private byte mCurrentIdx = 0;
        private String[] mValues = new String[MFWStringPoolHeap.access$000()];
        private Bucket mNext = null;

        Bucket() {
        }

        void destroy() {
            if (this.mNext != null) {
                this.mNext.destroy();
            }
            this.mNext = null;
        }

        String getString(String inString) {
            for (int idx = 0; idx < this.mCurrentIdx; ++idx) {
                if (inString.hashCode() != this.mValues[idx].hashCode() || !this.mValues[idx].equals(inString)) continue;
                return this.mValues[idx];
            }
            if (this.mNext != null) {
                return this.mNext.getString(inString);
            }
            if (this.mCurrentIdx < MAX_BucketCapacity) {
                return this.add(inString);
            }
            this.mNext = new Bucket();
            return this.mNext.add(inString);
        }

        String add(String inString) {
            this.mValues[this.mCurrentIdx] = inString;
            this.mCurrentIdx = (byte)(this.mCurrentIdx + 1);
            return inString;
        }
    }
}

