/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfw4j.framework.implPersistence;

import com.cognos.mfw4j.framework.MFWModelRes;
import com.cognos.mfw4j.framework.MFWNode;
import com.cognos.mfw4j.framework.MFWNodeLink;
import com.cognos.mfw4j.framework.MFWNodeObject;
import com.cognos.mfw4j.framework.MFWNodeProperty;
import com.cognos.mfw4j.framework.implPersistence.MFWNodeLinkPrst;
import com.cognos.mfw4j.framework.implPersistence.MFWNodeObjectPrst;
import com.cognos.mfw4j.framework.implPersistence.MFWPersistentMetadataCluster;
import com.cognos.mfw4j.utilities.MFWException;
import com.cognos.mfw4j.utilities.MFWStringHelper;
import java.io.IOException;
import java.io.Writer;
import java.util.List;

public final class MFWDumpPMC {
    public static void main(String[] args) {
        MFWException.ASSERT(args.length >= 1 && args.length <= 2, "Invalid use of argument, the acceptable pattern is '[-v] pmc-filePath'");
        String pmcFilePath = null;
        boolean detailed = false;
        if (args.length == 1) {
            pmcFilePath = args[0];
        } else {
            MFWException.ASSERT("-v".equals(args[0]), "Invalid option. The only acceptable option is '-v'");
            detailed = true;
            pmcFilePath = args[1];
        }
        try {
            MFWPersistentMetadataCluster.dump(pmcFilePath, detailed);
            System.out.println("Finished successfully!");
        }
        catch (Throwable th) {
            System.out.println("Failure! Excountered an exception:\n" + th.getMessage());
        }
    }

    private MFWDumpPMC() {
    }

    static void nodeAsXML(Writer osw, MFWNode aNode, boolean isDetailed) throws IOException {
        switch (aNode.getInfo().getNodeType()) {
            case 1: {
                MFWNodeProperty aProp = (MFWNodeProperty)aNode;
                String propValue = aProp.getValue();
                if (propValue == null) break;
                osw.write(MFWStringHelper.escapeAndTagStr(aNode.getName(), propValue));
                break;
            }
            case 2: {
                MFWDumpPMC.dumpNodeBegin(osw, aNode, isDetailed);
                MFWNodeObject anObj = (MFWNodeObject)aNode;
                List<MFWNode> vChildren = anObj.getChildNodes();
                for (MFWNode aChild : vChildren) {
                    MFWDumpPMC.nodeAsXML(osw, aChild, isDetailed);
                }
                MFWDumpPMC.dumpNodeEnd(osw, aNode);
                break;
            }
            case 3: {
                MFWNodeLink aLink = (MFWNodeLink)aNode;
                MFWDumpPMC.dumpNodeBegin(osw, aNode, isDetailed);
                osw.write(MFWStringHelper.escapeAndTagStr("linkSourceID", Integer.toString(aLink.getLinkSourceID())));
                osw.write(MFWStringHelper.escapeAndTagStr("linking", MFWModelRes.getInstance().getResource(aLink.getLinkChildRID())));
                osw.write(MFWStringHelper.escapeAndTagStr("queryPath", aLink.getQuerySpec().getXPathQuery()));
                MFWDumpPMC.dumpNodeEnd(osw, aNode);
            }
        }
    }

    private static void dumpNodeBegin(Writer osw, MFWNode aNode, boolean isDetailed) throws IOException {
        osw.write(60);
        osw.write(aNode.getName());
        if (isDetailed) {
            if (aNode instanceof MFWNodeObjectPrst) {
                osw.write(" pos=\"");
                osw.write(Integer.toString(((MFWNodeObjectPrst)aNode).getPosition()));
                osw.write(34);
            } else if (aNode instanceof MFWNodeLinkPrst) {
                osw.write(" pos=\"");
                osw.write(Integer.toString(((MFWNodeLinkPrst)aNode).getPosition()));
                osw.write(34);
            }
        }
        osw.write(62);
    }

    private static void dumpNodeEnd(Writer osw, MFWNode aNode) throws IOException {
        osw.write("</");
        osw.write(aNode.getName());
        osw.write(62);
    }
}

