/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfw4j.framework.nodeKey;

import com.cognos.mfw4j.framework.MFWInfo;
import com.cognos.mfw4j.framework.MFWInfoObjectImpl;
import com.cognos.mfw4j.framework.MFWModel;
import com.cognos.mfw4j.framework.MFWModelRes;
import com.cognos.mfw4j.framework.MFWNode;
import com.cognos.mfw4j.framework.MFWNodeObject;
import com.cognos.mfw4j.framework.MFWNodeProperty;
import com.cognos.mfw4j.framework.nodeKey.MFWNodeKey;
import com.cognos.mfw4j.utilities.MFWException;
import java.util.Arrays;
import java.util.List;

public final class MFWNodeKeyXPath
extends MFWNodeKey {
    private static final String gFixed_Project_ID = "[]";
    private String mIndexedID = "";
    private short[] mPathGUIDs = new short[10];
    private int[] mPathIndxs = new int[10];

    public MFWNodeKeyXPath(MFWNode aNode) {
        Arrays.fill(this.mPathGUIDs, (short)-1);
        Arrays.fill(this.mPathIndxs, -1);
        this.buildPath(aNode);
    }

    public String toString() {
        return this.getXPath();
    }

    public String getXPath() {
        StringBuilder outPath = new StringBuilder();
        if (this.mIndexedID.length() > 0) {
            outPath.append("//*[ID='");
            if (this.mIndexedID.contains("'")) {
                outPath.append(this.mIndexedID.replaceAll("'", "&apos;"));
            } else {
                outPath.append(this.mIndexedID);
            }
            outPath.append("']");
        }
        for (int idx = 9; idx >= 0; --idx) {
            if (this.mPathGUIDs[idx] == -1) continue;
            MFWInfo anInfo = MFWModel.getInstance().findInfoByGUID(this.mPathGUIDs[idx]);
            outPath.append('/');
            outPath.append(anInfo.getName());
            if (this.mPathIndxs[idx] == -1) continue;
            outPath.append('[');
            outPath.append(Integer.toString(this.mPathIndxs[idx]));
            outPath.append(']');
        }
        return outPath.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof MFWNodeKeyXPath) {
            MFWNodeKeyXPath that = (MFWNodeKeyXPath)obj;
            boolean bID = this.mIndexedID.equals(that.mIndexedID);
            if (!bID) {
                return false;
            }
            return Arrays.equals(this.mPathGUIDs, that.mPathGUIDs) && Arrays.equals(this.mPathIndxs, that.mPathIndxs);
        }
        return false;
    }

    public int hashCode() {
        return this.mIndexedID.hashCode() * Arrays.hashCode(this.mPathGUIDs) * Arrays.hashCode(this.mPathIndxs);
    }

    private void buildPath(MFWNode aNode) {
        MFWModelRes gModelRes = MFWModelRes.getInstance();
        int depthIdx = 0;
        MFWNode currNode = aNode;
        while (currNode != null && currNode.getInfo().getGUID() != 0) {
            MFWNodeObject currParent = currNode.getParentObject();
            if (currNode.getInfo().findChildInfo(gModelRes.RID_ID) != null) {
                MFWNodeObject no = (MFWNodeObject)currNode;
                this.mIndexedID = no.getPropertyValue(gModelRes.RID_ID);
                if (this.mIndexedID == null && no.getNameRID() == gModelRes.RID_project) {
                    this.mIndexedID = gFixed_Project_ID;
                    break;
                }
                MFWException.ASSERT(this.mIndexedID != null && this.mIndexedID.length() > 0, "Expecting a valid ID when generating XPath node key");
                break;
            }
            MFWInfoObjectImpl.ChildInfo cInfo = ((MFWInfoObjectImpl)currParent.getInfo()).findDetailedChildInfo(currNode.getNameRID());
            this.mPathGUIDs[depthIdx] = cInfo.getInfo().getGUID();
            if (!cInfo.hasSingleMultiplicity()) {
                int childIndex = 0;
                if (currNode.isProperty()) {
                    List<String> vPropVals = currParent.getPropertyValues(currNode.getNameRID());
                    if (vPropVals != null) {
                        childIndex = vPropVals.indexOf(((MFWNodeProperty)currNode).getValue());
                    }
                } else {
                    List<MFWNode> vObjs = currParent.getObjectNodes(currNode.getNameRID());
                    childIndex = vObjs.indexOf(currNode);
                }
                this.mPathIndxs[depthIdx] = childIndex;
            }
            currNode = currParent;
            MFWException.ASSERT(++depthIdx < 10, "Exceeding expected maximum node depth when generating XPath node key");
        }
    }
}

