/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfw4j.framework.policies;

import com.cognos.mfw4j.framework.MFWConnectionReuseInfo;
import com.cognos.mfw4j.utilities.MFWException;
import java.util.ArrayList;

public abstract class MFWEvictionPolicy {
    public static final short MFWUnknownEvictAction = 0;
    public static final short MFWPolicyApplies = 1;
    public static final short MFWPolicyDoesNotApply = 2;
    private ArrayList m_appliesToSources = new ArrayList();
    private int m_priority;

    public MFWEvictionPolicy(int priority) {
        MFWException.ASSERT(priority > 0 && priority < 10000, "Invalid priority for eviction policy - must be a value between 1 and 9999.");
        this.m_priority = priority;
    }

    public int getPriority() {
        return this.m_priority;
    }

    public short getEvictionAction(MFWConnectionReuseInfo reuseInfo) {
        String type = reuseInfo.getMetadataSource().getType();
        if (this.m_appliesToSources.indexOf(type) != -1 || this.m_appliesToSources.indexOf("*") != -1) {
            return this.getEvictionActionImpl(reuseInfo);
        }
        return 2;
    }

    public void addAppliesToSource(String string) {
        this.m_appliesToSources.add(string);
    }

    protected abstract short getEvictionActionImpl(MFWConnectionReuseInfo var1);
}

