/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfw4j.persistence;

import com.cognos.mfw4j.persistence.MFWPElement;
import com.cognos.mfw4j.persistence.MFWPList;
import com.cognos.mfw4j.persistence.MFWPStore;
import com.cognos.mfw4j.utilities.MFWException;

public final class MFWPHashMap<K extends MFWPElement, V extends MFWPElement> {
    private MFWPStore mStore;
    private int mMap;
    private short mPrimarySlots;
    private short mSecondarySlots;
    private Class<K> mKeyClass;
    private Class<V> mValueClass;

    public static <K extends MFWPElement, V extends MFWPElement> MFWPHashMap<K, V> create(Class<K> kc, Class<V> vc, MFWPStore aStore, short primarySlotNo, short secondarySlotNo) {
        int aMapPosition = aStore.putShort(primarySlotNo);
        aStore.putShort(secondarySlotNo);
        for (int idx = 0; idx < primarySlotNo * secondarySlotNo; ++idx) {
            aStore.putInt(0);
        }
        return new MFWPHashMap<K, V>(kc, vc, aStore, aMapPosition, primarySlotNo, secondarySlotNo);
    }

    public static <K extends MFWPElement, V extends MFWPElement> MFWPHashMap<K, V> open(Class<K> kc, Class<V> vc, MFWPStore aStore, int aMapPosition) {
        short primarySlotNo = aStore.getShort(aMapPosition);
        short secondarySlotNo = aStore.getShort(aMapPosition + 2);
        return new MFWPHashMap<K, V>(kc, vc, aStore, aMapPosition, primarySlotNo, secondarySlotNo);
    }

    private MFWPHashMap(Class<K> kc, Class<V> vc, MFWPStore aStore, int aMapPosition, short primarySlotNo, short secondarySlotNo) {
        this.mStore = aStore;
        this.mMap = aMapPosition;
        this.mPrimarySlots = primarySlotNo;
        this.mSecondarySlots = secondarySlotNo;
        this.mKeyClass = kc;
        this.mValueClass = vc;
    }

    public int getPosition() {
        return this.mMap;
    }

    public void put(K aKey, V aValue) {
        Entry inEntry = new Entry(this, this.mKeyClass, this.mValueClass, aKey, aValue);
        int aListPos = this.getListPosition(aKey.getHashCode());
        int aList = this.mStore.getInt(aListPos);
        if (aList != 0) {
            MFWPList<Entry> myList = MFWPList.open(this.mStore, aList);
            Entry anEntry = this.findInList(myList, inEntry);
            if (anEntry != null) {
                anEntry.updateValue(this.mStore, aValue);
            } else {
                myList.add(inEntry);
            }
        } else {
            MFWPList<Entry> myList = MFWPList.create(this.mStore, (short)8, inEntry);
            this.mStore.updateInt(aListPos, myList.getPosition());
            myList.add(inEntry);
        }
    }

    public V get(K aKey) {
        MFWPList<Entry> myList;
        Entry anEntry;
        Entry inEntry = new Entry(this, this.mKeyClass, this.mValueClass, aKey, null);
        int aListPos = this.getListPosition(aKey.getHashCode());
        int aList = this.mStore.getInt(aListPos);
        if (aList != 0 && (anEntry = this.findInList(myList = MFWPList.open(this.mStore, aList), inEntry)) != null) {
            return (V)anEntry.mValue;
        }
        return null;
    }

    public int size() {
        int totalEntries = 0;
        for (int idx = 0; idx < this.mPrimarySlots * this.mSecondarySlots; ++idx) {
            int aList = this.mStore.getInt(this.mMap + (idx + 1) * 4);
            if (aList == 0) continue;
            MFWPList myList = MFWPList.open(this.mStore, aList);
            totalEntries += myList.size();
        }
        return totalEntries;
    }

    public Iterator getIterator() {
        return new Iterator();
    }

    private Entry findInList(MFWPList<Entry> myList, Entry inEntry) {
        Entry anEntry = new Entry(this, this.mKeyClass, this.mValueClass, null, null);
        MFWPList.Iterator itr = myList.getIterator();
        while (itr.hasNext()) {
            itr.next(anEntry);
            if (!anEntry.isEqual(this.mStore, inEntry)) continue;
            return anEntry;
        }
        return null;
    }

    private int getListPosition(int key) {
        int posKey = Math.abs(key);
        int slotPrimary = posKey % this.mPrimarySlots;
        int slotSecondary = posKey / this.mPrimarySlots % this.mSecondarySlots;
        return this.mMap + 4 + slotPrimary * 4 * this.mSecondarySlots + slotSecondary * 4;
    }

    public final class Iterator {
        private short mCurrSlotIndex = (short)-1;
        private MFWPList.Iterator mCurrentItr = null;

        private Iterator() {
        }

        public boolean hasNext() {
            if (this.mCurrentItr != null && this.mCurrentItr.hasNext()) {
                return true;
            }
            return this.findNextEntry();
        }

        public void next(K key, V value) {
            MFWException.ASSERT(this.mCurrentItr != null, "Persistent Map iteration failed ... ensure hasNext has been called first");
            Entry anEntry = new Entry(MFWPHashMap.this, MFWPHashMap.this.mKeyClass, MFWPHashMap.this.mValueClass, key, value);
            this.mCurrentItr.next(anEntry);
        }

        private boolean findNextEntry() {
            while ((this.mCurrSlotIndex = (short)(this.mCurrSlotIndex + 1)) < MFWPHashMap.this.mPrimarySlots * MFWPHashMap.this.mSecondarySlots) {
                int aList = MFWPHashMap.this.mStore.getInt(MFWPHashMap.this.mMap + (this.mCurrSlotIndex + 1) * 4);
                if (aList == 0) continue;
                MFWPList myList = MFWPList.open(MFWPHashMap.this.mStore, aList);
                this.mCurrentItr = myList.getIterator();
                if (this.mCurrentItr.hasNext()) {
                    return true;
                }
                this.mCurrentItr = null;
            }
            return false;
        }
    }

    public static final class Entry
    implements MFWPElement {
        private K mKey;
        private V mValue;
        private int mPosition;
        final /* synthetic */ MFWPHashMap this$0;

        Entry(Class<K> kc, Class<V> vc, K aKey, V aValue) {
            this.this$0 = this$0;
            try {
                this.mKey = aKey == null ? (MFWPElement)kc.newInstance() : aKey;
                this.mValue = aValue == null ? (MFWPElement)vc.newInstance() : aValue;
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to instantiate MFWPHashMap.Entry", e);
            }
            this.mPosition = -1;
        }

        @Override
        public boolean isEqual(MFWPStore aStore, MFWPElement that) {
            return this.mKey.isEqual(aStore, (MFWPElement)((Entry)that).mKey);
        }

        @Override
        public void load(MFWPStore aStore, int aPosition) {
            this.mPosition = aPosition;
            this.mKey.load(aStore, aPosition);
            this.mValue.load(aStore, aPosition + this.mKey.sizeof());
        }

        @Override
        public void persist(MFWPStore aStore, int aPosition) {
            this.mPosition = aPosition;
            this.mKey.persist(aStore, aPosition);
            this.mValue.persist(aStore, aPosition + this.mKey.sizeof());
        }

        private void updateValue(MFWPStore aStore, V aValue) {
            this.mValue = aValue;
            this.mValue.persist(aStore, this.mPosition + this.mKey.sizeof());
        }

        @Override
        public short sizeof() {
            return (short)(this.mKey.sizeof() + this.mValue.sizeof());
        }

        @Override
        public int getHashCode() {
            return this.mKey.getHashCode();
        }

        void reset(K aKey, V aValue) {
            this.mKey = aKey;
            this.mValue = aValue;
        }
    }
}

