/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfw4j.persistence;

import com.cognos.mfw4j.utilities.MFWException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class MFWPStore {
    private static final double BUFFER_GROWTH_RATE = 0.3;
    private EMode mMode = EMode.kModeUnknown;
    private String mRepositoryFilePath = null;
    private RandomAccessFile mRepositoryFile = null;
    private FileChannel mFileChannel = null;
    private ByteBuffer mBuffer = null;
    private int mPosition = 0;

    public MFWPStore(String filePath) {
        this.mRepositoryFilePath = filePath;
    }

    public final String getFilePath() {
        return this.mRepositoryFilePath;
    }

    public final String getCanonicalFilePath() {
        try {
            File fileRep = new File(this.mRepositoryFilePath);
            return fileRep.getCanonicalPath();
        }
        catch (IOException ioe) {
            throw new RuntimeException("Failed to get canonical filePath", ioe);
        }
    }

    public final int getPosition() {
        return this.mPosition;
    }

    public final int open(EMode eMode) {
        MFWException.ASSERT(eMode != EMode.kModeUnknown, "Open model cannot be unknown!");
        this.mMode = eMode;
        try {
            this.mRepositoryFile = new RandomAccessFile(this.mRepositoryFilePath, this.mMode == EMode.kModeReadWrite ? "rw" : "r");
            this.mFileChannel = this.mRepositoryFile.getChannel();
            int sz = (int)this.mRepositoryFile.getChannel().size();
            if (sz > 0) {
                this.mBuffer = ByteBuffer.allocate(sz);
                this.mBuffer.rewind();
                this.mFileChannel.read(this.mBuffer);
                this.mBuffer.rewind();
            } else if (this.mMode == EMode.kModeReadOnly) {
                this.closeChannelAndFile();
                return -1;
            }
            this.mPosition = 0;
        }
        catch (IOException ioe) {
            throw new RuntimeException("Exception when opening persistent store:" + this.mRepositoryFilePath, ioe);
        }
        return this.mPosition;
    }

    public final EMode getMode() {
        return this.mMode;
    }

    public final void create(int initSizeKB) {
        this.mMode = EMode.kModeReadWrite;
        File fileRep = new File(this.mRepositoryFilePath);
        if (fileRep.exists()) {
            fileRep.delete();
        } else {
            fileRep.getParentFile().mkdirs();
        }
        try {
            this.mRepositoryFile = new RandomAccessFile(fileRep, "rw");
            this.mFileChannel = this.mRepositoryFile.getChannel();
            this.mBuffer = ByteBuffer.allocate(initSizeKB * 1024);
            this.mBuffer.rewind();
            this.mPosition = 0;
        }
        catch (FileNotFoundException fe) {
            throw new RuntimeException("Exception when creating persistent store:" + this.mRepositoryFilePath, fe);
        }
    }

    public final void close() {
        this.save();
        if (this.mBuffer != null) {
            this.mBuffer.clear();
            this.mBuffer = null;
        }
        try {
            this.closeChannelAndFile();
        }
        catch (IOException ioe) {
            throw new RuntimeException("Exception when closing persistent store:" + this.mRepositoryFilePath, ioe);
        }
        this.mPosition = 0;
        this.mMode = EMode.kModeUnknown;
    }

    public void closeChannelAndFile() throws IOException {
        if (this.mFileChannel != null) {
            this.mFileChannel.close();
        }
        if (this.mRepositoryFile != null) {
            this.mRepositoryFile.close();
        }
    }

    private void save() {
        if (this.mMode == EMode.kModeReadWrite && this.mBuffer != null) {
            try {
                this.mBuffer.rewind();
                this.mFileChannel.position(0L);
                this.mFileChannel.write(this.mBuffer);
                this.mFileChannel.force(true);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public int putShort(short value) {
        int valuePosition = this.mPosition;
        this.reserve(2);
        this.mBuffer.putShort(this.mPosition, value);
        this.mPosition += 2;
        return valuePosition;
    }

    public void updateShort(int aPosition, short value) {
        this.mBuffer.putShort(aPosition, value);
    }

    public int putInt(int value) {
        int valuePosition = this.mPosition;
        this.reserve(4);
        this.mBuffer.putInt(this.mPosition, value);
        this.mPosition += 4;
        return valuePosition;
    }

    public void updateInt(int aPosition, int value) {
        this.mBuffer.putInt(aPosition, value);
    }

    public int putLong(long value) {
        int valuePosition = this.mPosition;
        this.reserve(8);
        this.mBuffer.putLong(this.mPosition, value);
        this.mPosition += 8;
        return valuePosition;
    }

    public void updateLong(int aPosition, long value) {
        this.mBuffer.putLong(aPosition, value);
    }

    public int putString(String value) {
        byte[] bytes = null;
        try {
            bytes = value.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return this.putBytes(bytes);
    }

    public int putBytes(byte[] value) {
        int valuePosition = this.mPosition;
        this.reserve(4 + value.length);
        this.mBuffer.putInt(this.mPosition, value.length);
        this.mPosition += 4;
        for (int idx = 0; idx < value.length; ++idx) {
            this.mBuffer.put(this.mPosition++, value[idx]);
        }
        return valuePosition;
    }

    public short getShort(int aPosition) {
        return this.mBuffer.getShort(aPosition);
    }

    public int getInt(int aPosition) {
        return this.mBuffer.getInt(aPosition);
    }

    public long getLong(int aPosition) {
        return this.mBuffer.getLong(aPosition);
    }

    public String getString(int aPosition) {
        byte[] bytes = this.getBytes(aPosition);
        try {
            return new String(bytes, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] getBytes(int aPosition) {
        int len = this.getInt(aPosition);
        aPosition += 4;
        byte[] bytes = new byte[len];
        for (int idx = 0; idx < len; ++idx) {
            bytes[idx] = this.mBuffer.get(aPosition++);
        }
        return bytes;
    }

    private void reserve(int size) {
        if (this.mPosition + size >= this.mBuffer.capacity()) {
            this.extend(size);
        }
    }

    private void extend(int reserveSize) {
        int currCapacity = this.mBuffer.capacity();
        int extra = (int)((double)currCapacity * 0.3);
        while (this.mPosition + reserveSize >= currCapacity + extra) {
            extra += (int)((double)currCapacity * 0.3);
        }
        try {
            try {
                this.growBuffer(currCapacity + extra);
            }
            catch (OutOfMemoryError ex) {
                this.growBuffer(currCapacity + reserveSize);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void growBuffer(int newSize) throws IOException {
        byte[] tempBuf = this.copyBuffer(this.mBuffer);
        ByteBuffer buf2 = ByteBuffer.allocate(newSize);
        buf2.rewind();
        buf2.put(tempBuf, 0, tempBuf.length);
        this.mBuffer = buf2;
    }

    private byte[] copyBuffer(ByteBuffer src) {
        byte[] tempBuf = new byte[src.capacity()];
        src.rewind();
        src.get(tempBuf);
        return tempBuf;
    }

    public static enum EMode {
        kModeUnknown,
        kModeReadOnly,
        kModeReadWrite;

    }
}

