/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfw4j.resourcePool;

import com.cognos.mfw4j.framework.MFWRequestContext;
import com.cognos.mfw4j.resourcePool.MFWDSConnectionSpec;
import com.cognos.mfw4j.resourcePool.MFWDSSelectionCriteria;
import com.cognos.mfw4j.resourcePool.MFWUserEntry;
import com.cognos.mfw4j.utilities.MFWContentHelper;
import com.cognos.mfw4j.utilities.QFException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

final class MFWDataSourceConnectionResolver {
    MFWDataSourceConnectionResolver() {
    }

    static MFWDSConnectionSpec resolve(MFWRequestContext reqContext, MFWDSSelectionCriteria dsSelectionCriteria, MFWUserEntry aUserEntry) {
        MFWDSConnectionSpec outConnSpec = null;
        MFWContentHelper.ConnectionRecord[] dsConnections = aUserEntry.getDataSourceConnections(reqContext, dsSelectionCriteria.getCMDataSourceName());
        if (dsConnections == null || dsConnections.length == 0) {
            MFWDataSourceConnectionResolver.throwInvalidConnectionFault(dsSelectionCriteria.getCMDataSourceName());
        }
        if (dsSelectionCriteria.getCMConnectionName() != null && dsSelectionCriteria.getCMConnectionName().length() > 0) {
            MFWContentHelper.ConnectionRecord selectedConn = MFWDataSourceConnectionResolver.findConnectionByName(dsConnections, dsSelectionCriteria.getCMConnectionName());
            if (selectedConn == null) {
                MFWDataSourceConnectionResolver.throwInvalidConnectionFault(dsSelectionCriteria.getCMDataSourceName());
            }
            outConnSpec = MFWDataSourceConnectionResolver.resolveSignon(reqContext, dsSelectionCriteria, aUserEntry, selectedConn);
        } else {
            if (dsConnections.length > 1) {
                MFWDataSourceConnectionResolver.throwAmbiguousConnectionFault(aUserEntry, reqContext, dsSelectionCriteria.getCMDataSourceName(), dsConnections);
            }
            outConnSpec = MFWDataSourceConnectionResolver.resolveSignon(reqContext, dsSelectionCriteria, aUserEntry, dsConnections[0]);
        }
        return outConnSpec;
    }

    private static MFWDSConnectionSpec resolveSignon(MFWRequestContext reqContext, MFWDSSelectionCriteria dsSelectionCriteria, MFWUserEntry aUserEntry, MFWContentHelper.ConnectionRecord selectedConn) {
        MFWDSConnectionSpec outConnSpec = null;
        MFWContentHelper.SignonRecord[] dsSignons = aUserEntry.getDataSourceSignons(reqContext, selectedConn.getSearchPath());
        if (dsSelectionCriteria.getCMSignonName() != null && dsSelectionCriteria.getCMSignonName().length() > 0) {
            MFWContentHelper.SignonRecord selectedSignon = MFWDataSourceConnectionResolver.findSignonByName(dsSignons, dsSelectionCriteria.getCMSignonName());
            if (selectedSignon == null) {
                MFWDataSourceConnectionResolver.throwInvalidSignonFault(aUserEntry, reqContext, dsSelectionCriteria.getCMDataSourceName(), selectedConn);
            }
            outConnSpec = MFWDataSourceConnectionResolver.makeConnectionSpec(dsSelectionCriteria, selectedConn, selectedSignon);
        } else {
            if (dsSignons != null && dsSignons.length > 1) {
                MFWDataSourceConnectionResolver.throwAmbiguousSignonFault(dsSelectionCriteria.getCMDataSourceName(), selectedConn, dsSignons);
            }
            outConnSpec = MFWDataSourceConnectionResolver.makeConnectionSpec(dsSelectionCriteria, selectedConn, dsSignons != null ? dsSignons[0] : null);
        }
        if (selectedConn.getCredentialNamespace() != null) {
            outConnSpec.setCubeAuthenicationNamespace(selectedConn.getCredentialNamespace());
        }
        return outConnSpec;
    }

    private static MFWDSConnectionSpec makeConnectionSpec(MFWDSSelectionCriteria dsSelectionCriteria, MFWContentHelper.ConnectionRecord recordConnection, MFWContentHelper.SignonRecord recordSignon) {
        MFWDSConnectionSpec outDSConn = new MFWDSConnectionSpec(dsSelectionCriteria.getCMDataSourceName());
        outDSConn.setConnectionName(recordConnection.getName());
        outDSConn.setConnectionSearchPath(recordConnection.getSearchPath());
        outDSConn.setConnectionString(recordConnection.getConnectionString());
        if (recordSignon != null) {
            outDSConn.setSignonUID(recordSignon.getUserName());
            outDSConn.setSignonPWD(recordSignon.getPassword());
            outDSConn.setCubeAuthenicationNamespace(recordSignon.getNamespace());
            outDSConn.setCubeAuthenticationPassword(recordSignon.getCubePassword());
            outDSConn.setTicket(recordSignon.getTicket());
        }
        return outDSConn;
    }

    private static void throwInvalidConnectionFault(String cmDataSourceName) {
        QFException e = new QFException(-5000053);
        Element faultElement = QFException.createFaultElement("CQE-804", "Connection not found");
        faultElement.add(MFWDataSourceConnectionResolver.dataSourceAsXML(cmDataSourceName));
        e.setDOM(faultElement);
        throw e;
    }

    private static void throwAmbiguousConnectionFault(MFWUserEntry aUserEntry, MFWRequestContext reqContext, String cmDataSourceName, MFWContentHelper.ConnectionRecord[] recordConnections) {
        QFException e = new QFException(-5000049);
        Element faultElement = QFException.createFaultElement("CQE-801", "Ambiguous connection");
        Element elmDataSrc = MFWDataSourceConnectionResolver.dataSourceAsXML(cmDataSourceName);
        for (int idx = 0; idx < recordConnections.length; ++idx) {
            Element elmConn = MFWDataSourceConnectionResolver.connectionAsXML(recordConnections[idx]);
            MFWContentHelper.SignonRecord[] vSignons = aUserEntry.getDataSourceSignons(reqContext, recordConnections[idx].getSearchPath());
            if (vSignons != null) {
                for (int ii = 0; ii < vSignons.length; ++ii) {
                    elmConn.add(MFWDataSourceConnectionResolver.signonAsXML(vSignons[ii]));
                }
            }
            elmDataSrc.add(elmConn);
        }
        faultElement.add(elmDataSrc);
        e.setDOM(faultElement);
        throw e;
    }

    private static void throwInvalidSignonFault(MFWUserEntry aUserEntry, MFWRequestContext reqContext, String cmDataSourceName, MFWContentHelper.ConnectionRecord recordConnection) {
        QFException e = new QFException(-5000054);
        Element faultElement = QFException.createFaultElement("CQE-805", "Signon not found");
        Element elmDataSrc = MFWDataSourceConnectionResolver.dataSourceAsXML(cmDataSourceName);
        Element elmConn = MFWDataSourceConnectionResolver.connectionAsXML(recordConnection);
        MFWContentHelper.SignonRecord[] recordSignons = aUserEntry.getDataSourceSignons(reqContext, recordConnection.getSearchPath());
        for (int ii = 0; ii < recordSignons.length; ++ii) {
            elmConn.add(MFWDataSourceConnectionResolver.signonAsXML(recordSignons[ii]));
        }
        elmDataSrc.add(elmConn);
        faultElement.add(elmDataSrc);
        e.setDOM(faultElement);
        throw e;
    }

    private static void throwAmbiguousSignonFault(String cmDataSourceName, MFWContentHelper.ConnectionRecord recordConnection, MFWContentHelper.SignonRecord[] recordSignons) {
        QFException e = new QFException(-5000050);
        Element faultElement = QFException.createFaultElement("CQE-802", "Ambiguous signon");
        Element elmDataSrc = MFWDataSourceConnectionResolver.dataSourceAsXML(cmDataSourceName);
        Element elmConn = MFWDataSourceConnectionResolver.connectionAsXML(recordConnection);
        for (int ii = 0; ii < recordSignons.length; ++ii) {
            elmConn.add(MFWDataSourceConnectionResolver.signonAsXML(recordSignons[ii]));
        }
        elmDataSrc.add(elmConn);
        faultElement.add(elmDataSrc);
        e.setDOM(faultElement);
        throw e;
    }

    private static Element dataSourceAsXML(String cmDataSourceName) {
        Element dataSourceElement = DocumentHelper.createElement((String)"dataSource");
        Element nameElement = dataSourceElement.addElement("name");
        nameElement.addAttribute("value", cmDataSourceName);
        return dataSourceElement;
    }

    private static Element connectionAsXML(MFWContentHelper.ConnectionRecord aConn) {
        Element connectionElement = DocumentHelper.createElement((String)"dataSource");
        Element nameElement = connectionElement.addElement("name");
        nameElement.addAttribute("value", aConn.getName());
        Element searchPathElement = connectionElement.addElement("searchPath");
        searchPathElement.addAttribute("value", aConn.getSearchPath());
        return connectionElement;
    }

    private static Element signonAsXML(MFWContentHelper.SignonRecord aSignon) {
        Element signonElement = DocumentHelper.createElement((String)"signon");
        Element nameElement = signonElement.addElement("name");
        nameElement.addAttribute("value", aSignon.getName());
        Element searchPathElement = signonElement.addElement("searchPath");
        searchPathElement.addAttribute("value", aSignon.getSearchPath());
        return signonElement;
    }

    private static MFWContentHelper.ConnectionRecord findConnectionByName(MFWContentHelper.ConnectionRecord[] vConnections, String cmConnectionName) {
        for (int idx = 0; idx < vConnections.length; ++idx) {
            if (!cmConnectionName.equals(vConnections[idx].getName())) continue;
            return vConnections[idx];
        }
        return null;
    }

    private static MFWContentHelper.SignonRecord findSignonByName(MFWContentHelper.SignonRecord[] vSignons, String cmSignonName) {
        for (int idx = 0; idx < vSignons.length; ++idx) {
            if (!cmSignonName.equals(vSignons[idx].getName())) continue;
            return vSignons[idx];
        }
        return null;
    }
}

