/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfw4j.resourcePool;

import com.cognos.mfw4j.framework.MFWRequestContext;
import com.cognos.mfw4j.utilities.MFWContentHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;

final class MFWUserEntry {
    private ArrayList<String> mUserIdentity = null;
    private byte[] mDigestedUserIdentity = null;
    private long mLastAccessTime;
    private HashMap<String, ArrayList<String>> mPakageViews = null;
    private HashMap<String, MFWContentHelper.ConnectionRecord[]> mDataSource2Connection = null;
    private HashMap<String, MFWContentHelper.SignonRecord[]> mConnection2Signon = null;
    private ReentrantReadWriteLock mRWLock = new ReentrantReadWriteLock();

    MFWUserEntry() {
    }

    boolean isInUse() {
        return this.mRWLock.isWriteLocked() || this.mRWLock.getReadLockCount() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ArrayList<String> getUserIdentity(MFWRequestContext reqContext) {
        this.mRWLock.readLock().lock();
        try {
            if (this.mUserIdentity != null) {
                ArrayList<String> arrayList = this.mUserIdentity;
                return arrayList;
            }
        }
        finally {
            this.mRWLock.readLock().unlock();
        }
        this.mRWLock.writeLock().lock();
        try {
            if (this.mUserIdentity == null) {
                this.mUserIdentity = new ArrayList();
                MFWContentHelper myHelper = MFWContentHelper.create(reqContext.getProductLocale(), reqContext.getContentLocale(), reqContext.getCMRequestExecutor());
                myHelper.getUserIdentity(this.mUserIdentity);
            }
        }
        finally {
            this.mRWLock.writeLock().unlock();
        }
        return this.mUserIdentity;
    }

    byte[] getDigestedUserIdentity(MFWRequestContext reqContext) {
        this.mRWLock.readLock().lock();
        try {
            if (this.mDigestedUserIdentity != null) {
                byte[] byArray = this.mDigestedUserIdentity;
                return byArray;
            }
        }
        finally {
            this.mRWLock.readLock().unlock();
        }
        this.getUserIdentity(reqContext);
        this.mRWLock.writeLock().lock();
        try {
            if (this.mDigestedUserIdentity == null) {
                StringBuilder myDigest = new StringBuilder();
                for (int idx = 0; idx < this.mUserIdentity.size(); ++idx) {
                    String aMem = this.mUserIdentity.get(idx);
                    myDigest.append(aMem);
                }
                this.mDigestedUserIdentity = myDigest.toString().getBytes();
            }
        }
        catch (Throwable th) {
            if (th instanceof RuntimeException) {
                throw (RuntimeException)th;
            }
            throw new RuntimeException(th);
        }
        finally {
            this.mRWLock.writeLock().unlock();
        }
        return this.mDigestedUserIdentity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<String> getPackageViews(MFWRequestContext reqContext, String aPackagePath) {
        ArrayList<String> views = null;
        this.mRWLock.readLock().lock();
        try {
            if (this.mPakageViews != null && (views = this.mPakageViews.get(aPackagePath)) != null) {
                ArrayList<String> arrayList = views;
                return arrayList;
            }
        }
        finally {
            this.mRWLock.readLock().unlock();
        }
        this.mRWLock.writeLock().lock();
        try {
            if (this.mPakageViews == null) {
                this.mPakageViews = new HashMap();
            } else {
                views = this.mPakageViews.get(aPackagePath);
            }
            if (views != null) {
                ArrayList<String> arrayList = views;
                return arrayList;
            }
            MFWContentHelper myHelper = MFWContentHelper.create(reqContext.getProductLocale(), reqContext.getContentLocale(), reqContext.getCMRequestExecutor());
            views = new ArrayList();
            myHelper.getViews(aPackagePath, views);
            this.mPakageViews.put(aPackagePath, views);
            ArrayList<String> arrayList = views;
            return arrayList;
        }
        finally {
            this.mRWLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MFWContentHelper.ConnectionRecord[] getDataSourceConnections(MFWRequestContext reqContext, String cmDataSourceName) {
        MFWContentHelper.ConnectionRecord[] connSpecs = null;
        this.mRWLock.readLock().lock();
        try {
            if (this.mDataSource2Connection != null && (connSpecs = this.mDataSource2Connection.get(cmDataSourceName)) != null) {
                MFWContentHelper.ConnectionRecord[] connectionRecordArray = connSpecs;
                return connectionRecordArray;
            }
        }
        finally {
            this.mRWLock.readLock().unlock();
        }
        this.mRWLock.writeLock().lock();
        try {
            if (this.mDataSource2Connection == null) {
                this.mDataSource2Connection = new HashMap();
            } else {
                connSpecs = this.mDataSource2Connection.get(cmDataSourceName);
            }
            if (connSpecs == null) {
                MFWContentHelper myHelper = MFWContentHelper.create(reqContext.getProductLocale(), reqContext.getContentLocale(), reqContext.getCMRequestExecutor());
                connSpecs = myHelper.getDatasourceConnections(cmDataSourceName);
                this.mDataSource2Connection.put(cmDataSourceName, connSpecs);
            }
            MFWContentHelper.ConnectionRecord[] connectionRecordArray = connSpecs;
            return connectionRecordArray;
        }
        finally {
            this.mRWLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MFWContentHelper.SignonRecord[] getDataSourceSignons(MFWRequestContext reqContext, String cmConnectionPath) {
        MFWContentHelper.SignonRecord[] signonSpecs = null;
        this.mRWLock.readLock().lock();
        try {
            if (this.mConnection2Signon != null && (signonSpecs = this.mConnection2Signon.get(cmConnectionPath)) != null) {
                MFWContentHelper.SignonRecord[] signonRecordArray = signonSpecs;
                return signonRecordArray;
            }
        }
        finally {
            this.mRWLock.readLock().unlock();
        }
        this.mRWLock.writeLock().lock();
        try {
            if (this.mConnection2Signon == null) {
                this.mConnection2Signon = new HashMap();
            } else {
                signonSpecs = this.mConnection2Signon.get(cmConnectionPath);
            }
            if (signonSpecs == null) {
                MFWContentHelper myHelper = MFWContentHelper.create(reqContext.getProductLocale(), reqContext.getContentLocale(), reqContext.getCMRequestExecutor());
                signonSpecs = myHelper.getConnectionSignons(cmConnectionPath);
                this.mConnection2Signon.put(cmConnectionPath, signonSpecs);
            }
            MFWContentHelper.SignonRecord[] signonRecordArray = signonSpecs;
            return signonRecordArray;
        }
        finally {
            this.mRWLock.writeLock().unlock();
        }
    }

    void recordAccessTime() {
        this.mLastAccessTime = System.currentTimeMillis();
    }

    long getLastAccessTime() {
        return this.mLastAccessTime;
    }
}

