/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfw4j.utilities;

import com.cognos.cclcfgapi.base64;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.CAF;
import com.cognos.developer.schemas.bibus._3.CAM;
import com.cognos.developer.schemas.bibus._3.CAMPassport;
import com.cognos.developer.schemas.bibus._3.CAMSettings;
import com.cognos.developer.schemas.bibus._3.CookieVar;
import com.cognos.developer.schemas.bibus._3.DispatcherTransportVar;
import com.cognos.developer.schemas.bibus._3.EnvironmentVar;
import com.cognos.developer.schemas.bibus._3.FormFieldVar;
import com.cognos.developer.schemas.bibus._3.FormatEnum;
import com.cognos.developer.schemas.bibus._3.HdrSession;
import com.cognos.developer.schemas.bibus._3.SetCookieVar;
import com.cognos.developer.schemas.bibus._3.UserCapabilityCache;
import com.cognos.developer.schemas.bibus._3.UserCapabilityEnum;
import com.cognos.developer.schemas.bibus._3.UserPreferenceVar;
import com.cognos.pogo.pdk.BIBusEnvelope;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.apache.axis.client.Stub;
import org.apache.axis.message.SOAPHeaderElement;
import org.dom4j.Element;
import org.dom4j.Node;

public class MFWBiBusHelper {
    public static final BiBusHeader getBiBusHeader(Stub aStub) throws Exception {
        SOAPHeaderElement she = aStub.getResponseHeader("http://developer.cognos.com/schemas/bibus/3/", "biBusHeader");
        if (she == null) {
            she = aStub.getHeader("http://developer.cognos.com/schemas/bibus/3/", "biBusHeader");
        }
        BiBusHeader hdrBiBus = (BiBusHeader)she.getObjectValue(BiBusHeader.class);
        return hdrBiBus;
    }

    public static BiBusHeader buildBiBusHeaderFrom(BIBusEnvelope clientEnvelope) {
        if (clientEnvelope == null) {
            return null;
        }
        BiBusHeader header = new BiBusHeader();
        try {
            MFWBiBusHelper.copyCAMToService(clientEnvelope, header);
            MFWBiBusHelper.copyCAFToService(clientEnvelope, header);
            MFWBiBusHelper.copyCookiesToService(clientEnvelope, header);
            MFWBiBusHelper.copySetCookiesToService(clientEnvelope, header);
            MFWBiBusHelper.copyPrefsToService(clientEnvelope, header);
            MFWBiBusHelper.copyEnvironmentVarsToService(clientEnvelope, header);
            MFWBiBusHelper.copyFormFieldVarsToService(clientEnvelope, header);
            MFWBiBusHelper.copyUserCapabilitiesCache(clientEnvelope, header);
            MFWBiBusHelper.copyDispatcherTransportVarsToService(clientEnvelope, header);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Failed to round trip BUS header", e);
        }
        return header;
    }

    private static boolean hasTextChild(Node aNode) {
        if (aNode == null || aNode.getNodeType() != 1) {
            return false;
        }
        String txt = aNode.getText();
        return txt != null && txt.length() > 0;
    }

    private static void copyUserCapabilitiesCache(BIBusEnvelope clientEnvelope, BiBusHeader bibus) {
        Element elmUserCapabilitiesCache = clientEnvelope.getUserCapabilitiesCache();
        if (elmUserCapabilitiesCache == null) {
            return;
        }
        Element elmCapabilities = elmUserCapabilitiesCache.element("userCapabilities");
        if (elmCapabilities == null) {
            return;
        }
        Element elmSignature = elmUserCapabilitiesCache.element("signature");
        if (!MFWBiBusHelper.hasTextChild((Node)elmSignature)) {
            return;
        }
        List listCapabilities = elmCapabilities.elements();
        if (listCapabilities == null || listCapabilities.size() == 0) {
            return;
        }
        UserCapabilityEnum[] eCapabilities = new UserCapabilityEnum[listCapabilities.size()];
        for (int idx = 0; idx < listCapabilities.size(); ++idx) {
            Node anItem = (Node)listCapabilities.get(idx);
            if (!MFWBiBusHelper.hasTextChild(anItem)) continue;
            eCapabilities[idx] = UserCapabilityEnum.fromValue((String)((Element)anItem).getTextTrim());
        }
        UserCapabilityCache myCache = new UserCapabilityCache();
        myCache.setUserCapabilities(eCapabilities);
        byte[] decodedValue = base64.decode((int)0, (String)elmSignature.getText());
        myCache.setSignature(decodedValue);
        bibus.setUserCapabilityCache(myCache);
    }

    private static void copyEnvironmentVarsToService(BIBusEnvelope clientEnvelope, BiBusHeader bibus) {
        Element elmEnvVars = clientEnvelope.getEnvironmentVars();
        if (elmEnvVars == null) {
            return;
        }
        List listEnvVars = elmEnvVars.elements();
        if (listEnvVars == null || listEnvVars.size() == 0) {
            return;
        }
        EnvironmentVar[] cVars = new EnvironmentVar[listEnvVars.size()];
        for (int idx = 0; idx < listEnvVars.size(); ++idx) {
            Element eEnvVarNode = (Element)listEnvVars.get(idx);
            EnvironmentVar envVar = new EnvironmentVar();
            Element eEnvVarName = eEnvVarNode.element("name");
            Element eEnvVarValue = eEnvVarNode.element("value");
            if (MFWBiBusHelper.hasTextChild((Node)eEnvVarName)) {
                envVar.setName(eEnvVarName.getTextTrim());
            }
            if (MFWBiBusHelper.hasTextChild((Node)eEnvVarValue)) {
                envVar.setValue(eEnvVarValue.getTextTrim());
            } else {
                envVar.setValue("");
            }
            cVars[idx] = envVar;
        }
        if (bibus.getHdrSession() == null) {
            bibus.setHdrSession(new HdrSession());
        }
        bibus.getHdrSession().setEnvironmentVars(cVars);
    }

    private static void copyDispatcherTransportVarsToService(BIBusEnvelope clientEnvelope, BiBusHeader bibus) {
        Element elmDispVars = clientEnvelope.getDispatcherTransportVars();
        if (elmDispVars == null) {
            return;
        }
        List listDispVars = elmDispVars.elements();
        if (listDispVars == null || listDispVars.size() == 0) {
            return;
        }
        DispatcherTransportVar[] cVars = new DispatcherTransportVar[listDispVars.size()];
        for (int idx = 0; idx < listDispVars.size(); ++idx) {
            Element eFormFieldVarNode = (Element)listDispVars.get(idx);
            DispatcherTransportVar dispVar = new DispatcherTransportVar();
            Element eFormFieldVarName = eFormFieldVarNode.element("name");
            Element eFormFieldVarValue = eFormFieldVarNode.element("value");
            if (MFWBiBusHelper.hasTextChild((Node)eFormFieldVarName)) {
                dispVar.setName(eFormFieldVarName.getTextTrim());
            }
            if (MFWBiBusHelper.hasTextChild((Node)eFormFieldVarValue)) {
                dispVar.setValue(eFormFieldVarValue.getTextTrim());
            }
            cVars[idx] = dispVar;
        }
        bibus.setDispatcherTransportVars(cVars);
    }

    private static void copyFormFieldVarsToService(BIBusEnvelope clientEnvelope, BiBusHeader bibus) {
        Element elmFormFieldVars = clientEnvelope.getFormFieldVars();
        if (elmFormFieldVars == null) {
            return;
        }
        List listFormFieldVars = elmFormFieldVars.elements();
        if (listFormFieldVars == null || listFormFieldVars.size() == 0) {
            return;
        }
        FormFieldVar[] cVars = new FormFieldVar[listFormFieldVars.size()];
        for (int idx = 0; idx < listFormFieldVars.size(); ++idx) {
            Element eFormFieldVarNode = (Element)listFormFieldVars.get(idx);
            FormFieldVar formFieldVar = new FormFieldVar();
            Element eFormFieldVarName = eFormFieldVarNode.element("name");
            Element eFormFieldVarValue = eFormFieldVarNode.element("value");
            if (MFWBiBusHelper.hasTextChild((Node)eFormFieldVarName)) {
                formFieldVar.setName(eFormFieldVarName.getTextTrim());
            }
            if (MFWBiBusHelper.hasTextChild((Node)eFormFieldVarValue)) {
                formFieldVar.setValue(eFormFieldVarValue.getTextTrim());
            }
            formFieldVar.setFormat(FormatEnum.not_encrypted);
            cVars[idx] = formFieldVar;
        }
        if (bibus.getHdrSession() == null) {
            bibus.setHdrSession(new HdrSession());
        }
        bibus.getHdrSession().setFormFieldVars(cVars);
    }

    private static void copyPrefsToService(BIBusEnvelope clientEnvelope, BiBusHeader bibus) {
        Element elmUserPrefs = clientEnvelope.getUserPreferenceVars();
        if (elmUserPrefs == null) {
            return;
        }
        List listUserPrefs = elmUserPrefs.elements();
        if (listUserPrefs == null || listUserPrefs.size() == 0) {
            return;
        }
        UserPreferenceVar[] uPrefs = new UserPreferenceVar[listUserPrefs.size()];
        for (int idx = 0; idx < listUserPrefs.size(); ++idx) {
            Element eNode = (Element)listUserPrefs.get(idx);
            UserPreferenceVar uVar = new UserPreferenceVar();
            Element eName = eNode.element("name");
            Element eValue = eNode.element("value");
            if (MFWBiBusHelper.hasTextChild((Node)eName)) {
                uVar.setName(eName.getText());
            }
            if (MFWBiBusHelper.hasTextChild((Node)eValue)) {
                uVar.setValue(eValue.getText());
            }
            uPrefs[idx] = uVar;
        }
        bibus.setUserPreferenceVars(uPrefs);
    }

    private static void copySetCookiesToService(BIBusEnvelope clientEnvelope, BiBusHeader bibus) {
        Element elmSetCookieVars = clientEnvelope.getSetCookieVars();
        if (elmSetCookieVars == null) {
            return;
        }
        List listSetCookieVars = elmSetCookieVars.elements();
        if (listSetCookieVars == null || listSetCookieVars.size() == 0) {
            return;
        }
        SetCookieVar[] cVars = new SetCookieVar[listSetCookieVars.size()];
        for (int idx = 0; idx < listSetCookieVars.size(); ++idx) {
            Element eCookieNode = (Element)listSetCookieVars.get(idx);
            SetCookieVar cCookie = new SetCookieVar();
            Element eCookieName = eCookieNode.element("name");
            Element eCookieValue = eCookieNode.element("value");
            if (MFWBiBusHelper.hasTextChild((Node)eCookieName)) {
                cCookie.setName(eCookieName.getTextTrim());
            }
            if (MFWBiBusHelper.hasTextChild((Node)eCookieValue)) {
                cCookie.setValue(eCookieValue.getTextTrim());
            }
            cVars[idx] = cCookie;
        }
        if (bibus.getHdrSession() == null) {
            bibus.setHdrSession(new HdrSession());
        }
        bibus.getHdrSession().setSetCookieVars(cVars);
    }

    private static void copyCookiesToService(BIBusEnvelope clientEnvelope, BiBusHeader bibus) {
        Element elmCookieVars = clientEnvelope.getCookieVars();
        if (elmCookieVars == null) {
            return;
        }
        List listCookieVars = elmCookieVars.elements();
        if (listCookieVars == null || listCookieVars.size() == 0) {
            return;
        }
        CookieVar[] cVars = new CookieVar[listCookieVars.size()];
        for (int idx = 0; idx < listCookieVars.size(); ++idx) {
            Element eCookieNode = (Element)listCookieVars.get(idx);
            CookieVar cCookie = new CookieVar();
            Element eCookieName = eCookieNode.element("name");
            Element eCookieValue = eCookieNode.element("value");
            if (MFWBiBusHelper.hasTextChild((Node)eCookieName)) {
                cCookie.setName(eCookieName.getTextTrim());
            }
            if (MFWBiBusHelper.hasTextChild((Node)eCookieValue)) {
                cCookie.setValue(eCookieValue.getTextTrim());
            }
            cVars[idx] = cCookie;
        }
        if (bibus.getHdrSession() == null) {
            bibus.setHdrSession(new HdrSession());
        }
        bibus.getHdrSession().setCookieVars(cVars);
    }

    private static void copyCAFToService(BIBusEnvelope clientEnvelope, BiBusHeader bibus) {
        CAF caf = bibus.getCAF();
        if (caf == null) {
            caf = new CAF();
            bibus.setCAF(caf);
        }
        String secureState = clientEnvelope.getCAFSecureState();
        caf.setSecureState(secureState);
    }

    private static void copyCAMToService(BIBusEnvelope clientEnvelope, BiBusHeader bibus) throws UnsupportedEncodingException {
        Element settings;
        Element userSessionID;
        Element CAMCredentialPath;
        Element securityBlob;
        CAMPassport cPassport;
        CAM cSecurity = bibus.getCAM();
        if (cSecurity == null) {
            cSecurity = new CAM();
            bibus.setCAM(cSecurity);
        }
        if (null == (cPassport = cSecurity.getCAMPassport())) {
            cPassport = new CAMPassport();
        }
        cPassport.setId(clientEnvelope.getPassportID());
        Element canCallLogon = null;
        Element generation = null;
        Element ipfLogEnabled = null;
        Element isAnnoymous = null;
        Element cam = clientEnvelope.getCAM();
        Element camPassport = cam.element("CAMPassport");
        if (camPassport != null) {
            canCallLogon = camPassport.element("canCallLogon");
            generation = camPassport.element("generation");
            ipfLogEnabled = camPassport.element("ipfLogEnabled");
            isAnnoymous = camPassport.element("isAnonymous");
        }
        if (canCallLogon != null) {
            boolean canCall = Boolean.parseBoolean(canCallLogon.getText());
            cPassport.setCanCallLogon(canCall);
        }
        if (generation != null) {
            try {
                cPassport.setGeneration(Integer.parseInt(generation.getText()));
            }
            catch (NumberFormatException canCall) {
                // empty catch block
            }
        }
        if (ipfLogEnabled != null) {
            cPassport.setLogEnabled(Boolean.parseBoolean(ipfLogEnabled.getText()));
        }
        if (isAnnoymous != null) {
            cPassport.setIsAnonymous(Boolean.parseBoolean(isAnnoymous.getText()));
        }
        cSecurity.setCAMPassport(cPassport);
        if (cSecurity.getException() != null) {
            cSecurity.setException(null);
        }
        cSecurity.setAction(clientEnvelope.getCAMAction());
        Element authencityToken = cam.element("authenticityToken");
        if (MFWBiBusHelper.hasTextChild((Node)authencityToken)) {
            cSecurity.setAuthenticityToken(authencityToken.getText().getBytes("UTF8"));
        }
        if (MFWBiBusHelper.hasTextChild((Node)(securityBlob = cam.element("securityBlob")))) {
            cSecurity.setSecurityBlob(securityBlob.getText().getBytes("UTF8"));
        }
        if (MFWBiBusHelper.hasTextChild((Node)(CAMCredentialPath = cam.element("CAMCredentialPath")))) {
            cSecurity.setCAMCredentialPath(CAMCredentialPath.getText());
        }
        if (MFWBiBusHelper.hasTextChild((Node)(userSessionID = cam.element("userSessionID")))) {
            cSecurity.setUserSessionID(userSessionID.getText().getBytes("UTF8"));
        }
        if ((settings = cam.element("settings")) != null) {
            Element annoymousAllowed = settings.element("anonymousAllowed");
            Element namespacesConfigured = settings.element("namespacesConfigured");
            CAMSettings camSettings = new CAMSettings();
            if (annoymousAllowed != null) {
                camSettings.setAnonymousAllowed(Boolean.parseBoolean(annoymousAllowed.getText()));
            }
            if (namespacesConfigured != null) {
                camSettings.setNamespacesConfigured(Boolean.parseBoolean(namespacesConfigured.getText()));
            }
            cSecurity.setSettings(camSettings);
        }
    }
}

