/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfw4j.utilities;

import com.cognos.ccl4j.exceptions.CCLRuntimeException;
import com.cognos.ccl4j.util.CCLFileUtils;
import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.mfw4j.utilities.MFWException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class MFWConfiguration {
    private static final String TAG_VALUE = "value";
    private static final String TAG_NAME = "name";
    private static final String TAG_ITEM = "item";
    private static MFWConfiguration gSingleton = new MFWConfiguration();
    private HashMap<String, MFWConfigSource> mConfigConnSrc = null;
    private HashMap<String, String> mGeneralCapabilities = new HashMap();
    private boolean mGWLoggingEnabled = false;
    private boolean mUseIPFForRendering = false;
    private int mUserPoolMaxSize = 100;
    private int mGenericPoolMaxSize = 100;
    private int mUserEntryMaxIdleTime = 1200000;
    private Element m_connectionManagerConfig;
    private String mPMCDirectoryPath = null;
    private List<String> mKnownErrorCode = new LinkedList<String>();

    public static MFWConfiguration getInstance() {
        return gSingleton;
    }

    private MFWConfiguration() {
        this.mConfigConnSrc = new HashMap();
        this.loadConfigFile();
    }

    public void destroy() {
        for (MFWConfigSource element : this.mConfigConnSrc.values()) {
            element.destroy();
        }
        this.mConfigConnSrc.clear();
    }

    public void registerConfigurationSource(MFWConfigSource source) {
        this.mConfigConnSrc.put(source.getSourceType(), source);
    }

    public String getPMCDirectoryPath() {
        return this.mPMCDirectoryPath;
    }

    public Element getConnectionManagerConfiguration() {
        return this.m_connectionManagerConfig;
    }

    public MFWConfigSource getConfigInfoFor(String aSrcType) {
        return this.mConfigConnSrc.get(aSrcType);
    }

    public boolean isGatewayLoggingenabled() {
        return this.mGWLoggingEnabled;
    }

    public boolean useIPFForRendering() {
        return this.mUseIPFForRendering;
    }

    public int getUserPoolMaxSize() {
        return this.mUserPoolMaxSize;
    }

    public int getGenericPoolMaxSize() {
        return this.mGenericPoolMaxSize;
    }

    public String getGeneralCapability(String aName) {
        return this.mGeneralCapabilities.get(aName);
    }

    public boolean isKnownErrorCode(String errorCode) {
        if (errorCode != null) {
            for (String ignoreErrorCode : this.mKnownErrorCode) {
                if (!errorCode.contains(ignoreErrorCode)) continue;
                return true;
            }
        }
        return false;
    }

    public int getUserEntryMaxIdleTime() {
        return this.mUserEntryMaxIdleTime;
    }

    private void loadConfigFile() {
        try {
            ICCLConfiguration icclConfig = CCLConfigurationFactory.getInstance();
            String mfwConfigFile = "../configuration/mfw4jConfig.xml";
            mfwConfigFile = icclConfig.resolveEffectivePath(mfwConfigFile);
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(mfwConfigFile));
            DocumentBuilder myBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document docConfig = myBuilder.parse(is);
            for (Node currentChild = docConfig.getDocumentElement().getFirstChild(); currentChild != null; currentChild = currentChild.getNextSibling()) {
                if (!(currentChild instanceof Element)) continue;
                Element elem = (Element)currentChild;
                if ("generalCapabilities".equals(elem.getTagName())) {
                    this.processItems(elem, TAG_NAME, TAG_VALUE, this.mGeneralCapabilities);
                    continue;
                }
                if ("logging".equals(elem.getTagName())) {
                    this.processLoggingConfig(elem);
                    continue;
                }
                if ("adaptors".equals(elem.getTagName())) {
                    this.processSourceConfig(elem);
                    continue;
                }
                if ("connectionManager".equals(elem.getTagName())) {
                    this.m_connectionManagerConfig = elem;
                    continue;
                }
                if ("userInfoCaching".equals(elem.getTagName())) {
                    this.processUserInfoCachingConfig(elem);
                    continue;
                }
                if (!"ignoreException".equals(elem.getTagName())) continue;
                this.processIgnoreException(elem);
            }
            is.close();
            String dataDir = icclConfig.getValue("data", true);
            if (dataDir == null || dataDir.isEmpty()) {
                dataDir = "../data";
            }
            StringBuilder pmcDir = new StringBuilder(dataDir);
            pmcDir.append("/mfw4j/PMCs");
            this.mPMCDirectoryPath = icclConfig.resolveEffectivePath(pmcDir.toString());
            if (!CCLFileUtils.isDirectory((String)this.mPMCDirectoryPath)) {
                new File(this.mPMCDirectoryPath).mkdirs();
            }
        }
        catch (Exception e) {
            throw new CCLRuntimeException((Throwable)e, e.getMessage());
        }
    }

    private void processLoggingConfig(Element elmRoot) {
        for (Node currentChild = elmRoot.getFirstChild(); currentChild != null; currentChild = currentChild.getNextSibling()) {
            if (!(currentChild instanceof Element)) continue;
            Element elem = (Element)currentChild;
            if ("gatewayLoggingEnabled".equals(elem.getTagName())) {
                this.mGWLoggingEnabled = "true".equals(elem.getAttribute(TAG_VALUE));
                continue;
            }
            if (!"useIPFRendering".equals(elem.getTagName())) continue;
            this.mUseIPFForRendering = "true".equals(elem.getAttribute(TAG_VALUE));
        }
    }

    private void processUserInfoCachingConfig(Element elmRoot) {
        for (Node currentChild = elmRoot.getFirstChild(); currentChild != null; currentChild = currentChild.getNextSibling()) {
            if (!(currentChild instanceof Element)) continue;
            Element elem = (Element)currentChild;
            if ("maxSize".equals(elem.getTagName())) {
                this.mUserPoolMaxSize = Integer.parseInt(elem.getAttribute(TAG_VALUE));
                continue;
            }
            if ("maxGenericSize".equals(elem.getTagName())) {
                this.mGenericPoolMaxSize = Integer.parseInt(elem.getAttribute(TAG_VALUE));
                continue;
            }
            if (!"maxIdleTime".equals(elem.getTagName())) continue;
            this.mUserEntryMaxIdleTime = Integer.parseInt(elem.getAttribute(TAG_VALUE)) * 1000;
        }
    }

    private void processIgnoreException(Element elmRoot) {
        for (Node currentChild = elmRoot.getFirstChild(); currentChild != null; currentChild = currentChild.getNextSibling()) {
            Element elem;
            if (!(currentChild instanceof Element) || !"exceptionErrorCode".equals((elem = (Element)currentChild).getTagName())) continue;
            this.mKnownErrorCode.add(elem.getAttribute(TAG_VALUE));
        }
    }

    private void processSourceConfig(Element elmRoot) {
        NodeList listAdaptors = elmRoot.getElementsByTagName("adaptor");
        for (int aIdx = 0; aIdx < listAdaptors.getLength(); ++aIdx) {
            MFWException.ASSERT(listAdaptors.item(aIdx).getNodeType() == 1, "unexpected config info");
            Element elmAdaptor = (Element)listAdaptors.item(aIdx);
            String sAdaptorName = elmAdaptor.getAttribute(TAG_NAME);
            String sAdaptorClass = elmAdaptor.getAttribute("class");
            MFWException.ASSERT(sAdaptorClass.length() > 0, "Missing adaptor class for adaptor:", sAdaptorName);
            NodeList listSources = elmAdaptor.getElementsByTagName("source");
            for (int sIdx = 0; sIdx < listSources.getLength(); ++sIdx) {
                MFWException.ASSERT(listSources.item(sIdx).getNodeType() == 1, "unexpected a valid <source> element");
                Element elmSource = (Element)listSources.item(sIdx);
                String sSrcType = elmSource.getAttribute("type");
                MFWException.ASSERT(sSrcType.length() > 0, "Missing required source type for adaptor", sAdaptorName);
                NodeList listPrvds = elmSource.getElementsByTagName("qfwProvider");
                String sQFWProviderName = "";
                if (listPrvds.getLength() > 0) {
                    MFWException.ASSERT(listPrvds.item(0).getNodeType() == 1, "Something is wrong");
                    MFWException.ASSERT(listPrvds.item(0).getFirstChild().getNodeType() == 3, "Unable to locate qfw provider");
                    sQFWProviderName = listPrvds.item(0).getFirstChild().getNodeValue();
                }
                MFWConfigSource aSource = new MFWConfigSource(sAdaptorClass, sQFWProviderName, sSrcType);
                this.mConfigConnSrc.put(sSrcType, aSource);
                this.processItems(MFWConfiguration.firstChild(elmSource, "capabilities"), TAG_NAME, TAG_VALUE, aSource.mCapabilities);
                this.processItems(MFWConfiguration.firstChild(elmSource, "connection"), TAG_NAME, "nameInRequest", aSource.mConnectionItems);
            }
        }
    }

    private void processItems(Element elmSection, String tagName, String tagValue, Map<String, String> aMap) {
        if (elmSection == null) {
            return;
        }
        NodeList listItems = elmSection.getElementsByTagName(TAG_ITEM);
        for (int i = 0; i < listItems.getLength(); ++i) {
            if (listItems.item(i).getNodeType() != 1) continue;
            Element elmItem = (Element)listItems.item(i);
            aMap.put(elmItem.getAttribute(tagName), elmItem.getAttribute(tagValue));
        }
    }

    private static Element firstChild(Element aParent, String sChildName) {
        NodeList listSections = aParent.getElementsByTagName(sChildName);
        if (listSections.getLength() < 1 || listSections.item(0).getNodeType() != 1) {
            return null;
        }
        return (Element)listSections.item(0);
    }

    public static class MFWConfigSource {
        private String mAdaptorClassName;
        private String mQFWProviderName;
        private HashMap<String, String> mCapabilities = null;
        private HashMap<String, String> mConnectionItems = null;
        private String mSrcType = null;

        public MFWConfigSource(String adaptorClassName, String qfwProviderName, String sSrcType) {
            this.mAdaptorClassName = adaptorClassName;
            this.mQFWProviderName = qfwProviderName;
            this.mCapabilities = new HashMap();
            this.mConnectionItems = new HashMap();
            this.mSrcType = sSrcType;
        }

        public void destroy() {
            this.mCapabilities.clear();
            this.mConnectionItems.clear();
        }

        public final String getAdaptorClassName() {
            return this.mAdaptorClassName;
        }

        public final String getQFWProviderName() {
            return this.mQFWProviderName;
        }

        public final String getSourceType() {
            return this.mSrcType;
        }

        public final void addCapability(String aName, String aValue) {
            this.mCapabilities.put(aName, aValue);
        }

        public final String getCapability(String aName) {
            return this.mCapabilities.get(aName);
        }

        public final void addConnectionItem(String aName, String aValue) {
            this.mConnectionItems.put(aName, aValue);
        }

        public final Map<String, String> getConnectionItems() {
            return this.mConnectionItems;
        }
    }
}

