/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfw4j.utilities;

import com.cognos.ccl4j.exceptions.CCLRuntimeException;
import com.cognos.ccl4j.util.CCLFileUtils;
import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.developer.schemas.bibus._3.Account;
import com.cognos.mfw4j.framework.MFWRequestContext;
import com.cognos.mfw4j.resourcePool.MFWGenericEntry;
import com.cognos.mfw4j.resourcePool.MFWUserPool;
import com.cognos.mfw4j.utilities.IMFWCMRequestExecutor;
import com.cognos.mfw4j.utilities.IMFWUsageIndicator;
import com.cognos.mfw4j.utilities.MFWConfiguration;
import com.cognos.mfw4j.utilities.MFWContentHelperXml;
import com.cognos.mfw4j.utilities.MFWException;
import com.cognos.mfw4j.utilities.MFWRCIHelper;
import com.cognos.mfw4j.utilities.MFWSimpleCMRequestExecutor;
import com.cognos.mfw4j.utilities.MFWXMLStringDecryptionHelper;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.dom4j.Dom4jSoapFaultException;
import java.io.File;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.Calendar;
import java.util.List;
import org.dom4j.Element;

public abstract class MFWContentHelper {
    public static final String OBJ_PROP_defaultName = "defaultName";
    public static final String OBJ_PROP_creationTime = "creationTime";
    public static final String OBJ_PROP_modificationTime = "modificationTime";
    public static final String OBJ_PROP_defaultScreenTip = "defaultScreenTip";
    public static final String OBJ_PROP_defaultDescription = "defaultDescription";
    public static final String OBJ_PROP_storeID = "storeID";
    public static final String OBJ_PROP_parent = "parent";
    public static final String OBJ_PROP_options = "options";
    private static final int DEFAULT_NAME_INDEX = 0;
    private static final int MOD_TIME_INDEX = 2;
    private static final int SCREEN_TIP_INDEX = 3;
    private static final int DEFAULT_DESCRIPTION_INDEX = 4;
    private static final int STORE_ID_INDEX = 5;
    private static final int OPTIONS_INDEX = 8;
    private static final String TAG_queryCMObject = "MFW4J/ContentHelper/queryCMObjectProperties";
    private static final String[] gDefaultPackagePropNames = new String[]{"defaultName", "creationTime", "modificationTime", "defaultScreenTip", "defaultDescription", "storeID", "parent", "options"};
    private static File sCMImposterFile = MFWContentHelper.getImposterFile();
    private static String gGatewayURI = MFWContentHelper.queryGatewayURI();
    private static String gDispatcherURI = MFWContentHelper.queryDispatcherURI();
    private static int gModelInfoRetainPeriod = 30000;

    @Deprecated
    public static MFWContentHelper create(String userPassport, String productLocale, String contentLocale, BIBusEnvelope bibusEnvelope) {
        return MFWContentHelper.create(productLocale, contentLocale, new MFWSimpleCMRequestExecutor(bibusEnvelope, userPassport));
    }

    public static MFWContentHelper create(String productLocale, String contentLocale, IMFWCMRequestExecutor executor) {
        MFWContentHelper myHelper = null;
        myHelper = sCMImposterFile != null ? new MFWContentHelperXml(executor.getPassport(), sCMImposterFile) : new MFWRCIHelper(productLocale, contentLocale, executor);
        return myHelper;
    }

    public static MFWContentHelper create(String productLocale, String contentLocale) {
        return MFWContentHelper.create(null, productLocale, contentLocale, null);
    }

    public void destroy() {
    }

    public abstract String authenticateUser(String var1, String var2, String var3);

    public abstract void getUserIdentity(List<String> var1);

    public abstract String getUserName();

    public abstract Account getUserAccount();

    public InputStream queryPackage(String sPackageCmPath) {
        return this.queryPackage(sPackageCmPath, false);
    }

    public abstract InputStream queryPackage(String var1, boolean var2);

    public abstract void queryReport(String var1, Element var2, Element var3, StringBuffer var4, StringBuffer var5);

    public abstract List<Object> getObjectProperties(String var1, String[] var2);

    public abstract List<Object> getObjectProperties(String var1, String[] var2, boolean var3);

    public abstract List<Object> getObjectProperties(String var1, String[] var2, boolean var3, boolean var4);

    public abstract void getViews(String var1, List<String> var2);

    public abstract String updateMetadata(String var1, String var2) throws RemoteException;

    public abstract ConnectionRecord[] getDatasourceConnections(String var1);

    public abstract SignonRecord[] getConnectionSignons(String var1);

    public static String getCMGatewayURI() {
        return gGatewayURI;
    }

    private static String queryGatewayURI() {
        try {
            ICCLConfiguration config = CCLConfigurationFactory.getInstance();
            return config.getValue("gateway", false);
        }
        catch (CCLConfigurationException ce) {
            throw new CCLRuntimeException((Throwable)ce, ce.getMessage());
        }
    }

    public static String getCMDispatcherURI() {
        return gDispatcherURI;
    }

    private static String queryDispatcherURI() {
        try {
            ICCLConfiguration config = CCLConfigurationFactory.getInstance();
            return config.getValue("sdk", false);
        }
        catch (CCLConfigurationException ce) {
            throw new CCLRuntimeException((Throwable)ce, ce.getMessage());
        }
    }

    private static File getImposterFile() {
        File aFile = null;
        String sPath = "CMImposter.xml";
        ICCLConfiguration cclConfig = CCLConfigurationFactory.getInstance();
        sPath = cclConfig.resolveEffectivePath(sPath);
        try {
            aFile = CCLFileUtils.check((String)sPath, (int)49);
        }
        catch (CCLFileUtils.FileCheckException fileCheckException) {
            // empty catch block
        }
        return aFile;
    }

    public static boolean isImposterAround() {
        return sCMImposterFile != null;
    }

    public static String getQueryStack(List<Option> options) {
        if (options != null) {
            for (Option op : options) {
                if (!MFWContentHelper.isQueryModeOption(op) || !"http://developer.cognos.com/ceba/constants/queryModeEnum#dynamic".equals(op.m_value)) continue;
                return "queryService";
            }
        }
        return "queryFramework";
    }

    private static boolean isQueryModeOption(Option op) {
        return "http://developer.cognos.com/ceba/constants/queryOptionEnum#mode".equals(op.m_name);
    }

    public final CMObjectInfo getCMObjectProperties(String cmModelPath, MFWRequestContext aContext) {
        CMObjectInfo outObjectInfo = null;
        MFWGenericEntry cachedEntry = MFWUserPool.getInstance().findOrAddGenericCacheItem(cmModelPath, gModelInfoRetainPeriod, aContext.getIgnoreUpdateRetainPeriod());
        if (cachedEntry.doesValueNeedSetting()) {
            outObjectInfo = this.getObjectFromCM(cmModelPath, aContext, outObjectInfo, cachedEntry);
        } else {
            outObjectInfo = (CMObjectInfo)cachedEntry.getValue();
            if (outObjectInfo == null) {
                outObjectInfo = this.getObjectFromCM(cmModelPath, aContext, outObjectInfo, cachedEntry);
            }
        }
        return outObjectInfo;
    }

    private CMObjectInfo getObjectFromCM(String cmModelPath, MFWRequestContext aContext, CMObjectInfo outObjectInfo, MFWGenericEntry cachedEntry) {
        try {
            outObjectInfo = new CMObjectInfo(cmModelPath);
            long b4Time = System.currentTimeMillis();
            MFWException.ASSERT(outObjectInfo.getCmProperties(aContext.getForceCMTrusted(), aContext.getMetadataRequest()).size() > 0, "Expecting several values back when querying package properties");
            this.logUsageIndicator(aContext, TAG_queryCMObject, b4Time);
            cachedEntry.setValue(outObjectInfo);
        }
        catch (Throwable th) {
            cachedEntry.setValueFailed(th);
            throw cachedEntry.getSetException();
        }
        return outObjectInfo;
    }

    private void logUsageIndicator(MFWRequestContext aContext, String category, long b4Time) {
        long executionTime = System.currentTimeMillis() - b4Time;
        IMFWUsageIndicator usageIndicator = aContext.getXQEUsageIndicatorService();
        if (usageIndicator != null) {
            usageIndicator.logMeasurements(category, executionTime);
        }
    }

    public static boolean isModelNotFoundException(Exception ex) {
        Throwable cause2;
        if (MFWContentHelper.isDom4jCMError4011(ex)) {
            return true;
        }
        Throwable cause1 = ex.getCause();
        if (MFWContentHelper.isDom4jCMError4011(cause1)) {
            return true;
        }
        return cause1 != null && MFWContentHelper.isDom4jCMError4011(cause2 = cause1.getCause());
    }

    private static boolean isDom4jCMError4011(Throwable t) {
        Dom4jSoapFaultException exception;
        String detailedException;
        return t != null && t instanceof Dom4jSoapFaultException && (detailedException = (exception = (Dom4jSoapFaultException)t).getDetail()).contains("CM-REQ-4011");
    }

    static {
        String maxRetain = MFWConfiguration.getInstance().getConfigInfoFor("modelFM").getCapability("modelInfoRetainPeriod");
        if (maxRetain != null && maxRetain.length() > 0) {
            gModelInfoRetainPeriod = Integer.parseInt(maxRetain) * 1000;
        }
    }

    public final class CMObjectInfo {
        private List<Object> mCMProperties = null;
        private String mCMModelPath;

        private CMObjectInfo(String cmModelPath) {
            this.mCMModelPath = cmModelPath;
        }

        private List<Object> getCmProperties(boolean forceCMTrusted, boolean metadataRequest) {
            if (this.mCMProperties == null) {
                this.mCMProperties = MFWContentHelper.this.getObjectProperties(this.mCMModelPath, gDefaultPackagePropNames, forceCMTrusted, metadataRequest);
            }
            return this.mCMProperties;
        }

        public Calendar getLastModificationTime() {
            return (Calendar)this.mCMProperties.get(2);
        }

        public String getPackageStoreID() {
            return (String)this.mCMProperties.get(5);
        }

        public String getQueryStack() {
            if (this.mCMProperties.size() > 8) {
                return MFWContentHelper.getQueryStack((List)this.mCMProperties.get(8));
            }
            return MFWContentHelper.getQueryStack(null);
        }

        public String getDefaultName() {
            return (String)this.mCMProperties.get(0);
        }

        public String getDefaultScreenTip() {
            return (String)this.mCMProperties.get(3);
        }

        public String getDefaultDescription() {
            return (String)this.mCMProperties.get(4);
        }
    }

    public static final class SignonRecord {
        private String mName = null;
        private String mSearchPath = null;
        private String mCredentialsXML = null;
        private MFWXMLStringDecryptionHelper mDecryptHelper = null;

        public SignonRecord(String aName, String path, String credentials) {
            this.mName = aName;
            this.mSearchPath = path;
            this.mCredentialsXML = credentials;
            this.mDecryptHelper = new MFWXMLStringDecryptionHelper(this.mCredentialsXML);
        }

        public String getName() {
            return this.mName;
        }

        public String getSearchPath() {
            return this.mSearchPath;
        }

        public String getCredentials() {
            return this.mCredentialsXML;
        }

        public String getUserName() {
            return this.getCredentialItem("username");
        }

        public String getPassword() {
            return this.getCredentialItem("password");
        }

        public String getTicket() {
            return this.getCredentialItem("SAPLogonTicket");
        }

        public String getNamespace() {
            return this.getCredentialItem("namespace");
        }

        public String getCubePassword() {
            return this.getCredentialItem("cubePassword");
        }

        private String getCredentialItem(String parameterItemName) {
            String parameterItemValue = "";
            if (this.mDecryptHelper != null) {
                parameterItemValue = this.mDecryptHelper.extractCredentialsFromXMLString(parameterItemName);
            }
            return parameterItemValue;
        }
    }

    public static final class ConnectionRecord {
        private String mName = null;
        private String mSearchPath = null;
        private String mConnectonStr = null;
        private String mCredentialNamespace = null;

        public ConnectionRecord(String aName, String path, String connStr, String credentialNamespace) {
            this.mName = aName;
            this.mSearchPath = path;
            this.mConnectonStr = connStr;
            this.mCredentialNamespace = credentialNamespace;
        }

        public String getName() {
            return this.mName;
        }

        public String getSearchPath() {
            return this.mSearchPath;
        }

        public String getConnectionString() {
            return this.mConnectonStr;
        }

        public String getCredentialNamespace() {
            return this.mCredentialNamespace;
        }
    }

    public static class Option {
        public static final Option UNKNOWN = new Option();
        public String m_name;
        public String m_value;

        public Option() {
        }

        public Option(String name, String value) {
            this.m_name = name;
            this.m_value = value;
        }
    }
}

