/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfw4j.utilities;

import com.cognos.mfw4j.utilities.MFWMessage;
import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;

public class MFWException
extends RuntimeException {
    public static final int ERROR_CODE_CM_OBJECT_NOT_FOUND = 100;
    private static final long serialVersionUID = 1L;
    private int mErrorCode = 0;
    private ArrayList<MFWMessage> mMsgs = new ArrayList();

    public static final void ASSERT(boolean expr, String devHint) {
        if (!expr) {
            MFWMessage msg1 = new MFWMessage("mfw4j", "MFW_UT_INTERNAL_ERROR", null);
            MFWMessage msg2 = new MFWMessage("mfw4j", "MFW_UT_INTERNAL_ERROR_DETAIL", new String[]{devHint});
            MFWException e = new MFWException();
            e.addMessage(msg1);
            e.addMessage(msg2);
            throw e;
        }
    }

    public static final void ASSERT(boolean expr, String fmtDevHint, Object ... devHintArgs) {
        if (!expr) {
            MFWMessage msg1 = new MFWMessage("mfw4j", "MFW_UT_INTERNAL_ERROR", null);
            MFWMessage msg2 = new MFWMessage("mfw4j", "MFW_UT_INTERNAL_ERROR_DETAIL", new String[]{String.format(fmtDevHint, devHintArgs)});
            MFWException e = new MFWException();
            e.addMessage(msg1);
            e.addMessage(msg2);
            throw e;
        }
    }

    public static final void ASSERT(boolean expr, String devHint, String parm1) {
        if (!expr) {
            StringBuilder msg = new StringBuilder(devHint);
            msg.append(" ");
            msg.append(parm1);
            MFWException.ASSERT(expr, msg.toString());
        }
    }

    public static final void ASSERT(boolean expr, String devHint, String parm1, String parm2) {
        if (!expr) {
            StringBuilder msg = new StringBuilder(devHint);
            msg.append(" ");
            msg.append(parm1);
            msg.append(" ");
            msg.append(parm2);
            MFWException.ASSERT(expr, msg.toString());
        }
    }

    public MFWException(int errorCode) {
        this.mErrorCode = errorCode;
    }

    public MFWException() {
        this.mErrorCode = 0;
    }

    public void addMessage(MFWMessage msg) {
        this.mMsgs.add(msg);
    }

    public int getErrorCode() {
        return this.mErrorCode;
    }

    @Override
    public String getMessage() {
        return this.getLocalizedMessage(Locale.getDefault());
    }

    public String getLocalizedMessage(Locale aLocale) {
        StringBuffer outMsgStr = new StringBuffer();
        String currBundleName = null;
        ResourceBundle currBundle = null;
        for (int idx = 0; idx < this.mMsgs.size(); ++idx) {
            MFWMessage aMsg = this.mMsgs.get(idx);
            if (currBundleName == null || !currBundleName.equals(aMsg.getBundleName())) {
                currBundleName = aMsg.getBundleName();
                currBundle = ResourceBundle.getBundle(currBundleName, aLocale);
            }
            outMsgStr.append(aMsg.render(currBundle, aLocale));
            outMsgStr.append("\n\t");
        }
        return outMsgStr.toString();
    }

    public static String getExceptionAndStackTrace(Throwable t) {
        StackTraceElement[] st = t.getStackTrace();
        StringBuilder sb = new StringBuilder(t.toString());
        sb.append("\n");
        for (StackTraceElement se : st) {
            sb.append(se.toString());
        }
        return sb.toString();
    }
}

