/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfw4j.utilities;

import com.cognos.ccl4j.util.CCLXMLUtils;
import java.util.List;

public class MFWStringHelper {
    public static final String TAG_GT = ">";
    public static final String TAG_LT = "<";
    public static final String TAG_LT_SLASH = "</";

    public static final String normalizeCRNLocale(String crnLocale) {
        String outValue = crnLocale.toLowerCase();
        return outValue.replace('_', '-');
    }

    public static final void split(String in, String strDelimeter, List<String> vout) {
        int start = 0;
        while (true) {
            int end;
            if ((end = in.indexOf(strDelimeter, start)) == -1) {
                if (start >= in.length()) break;
                vout.add(in.substring(start));
                break;
            }
            vout.add(in.substring(start, end));
            start = end + strDelimeter.length();
        }
    }

    public static final String makeUnique(String candidateName, List<String> comapreToList, boolean useUnderscore) {
        String uniqueName = candidateName;
        for (int seqNo = 0; seqNo < comapreToList.size() && comapreToList.contains(uniqueName); ++seqNo) {
            if (useUnderscore) {
                uniqueName = candidateName + "_" + Integer.toString(seqNo);
                continue;
            }
            uniqueName = candidateName + Integer.toString(seqNo);
        }
        return uniqueName;
    }

    public static final String escapeXMLChars(String inStr) {
        StringBuffer out = new StringBuffer();
        CCLXMLUtils.xmlEncode((String)inStr, (StringBuffer)out);
        return out.toString();
    }

    public static final String unescapeXMLChars(String inStr) {
        StringBuilder outStr = new StringBuilder("");
        int c_apos = 39;
        int c_lt = 60;
        int c_gt = 62;
        int c_amp = 38;
        int c_quot = 34;
        int inStrLength = inStr.length();
        int readPos = 0;
        for (int idx = 0; idx < inStrLength; ++idx) {
            int c = inStr.charAt(idx);
            if (c == 38 && (readPos = idx) + 1 < inStrLength) {
                block0 : switch (inStr.charAt(++readPos)) {
                    case 'a': {
                        if (readPos + 1 >= inStrLength) break;
                        switch (inStr.charAt(++readPos)) {
                            case 'm': {
                                if (readPos + 2 >= inStrLength || inStr.charAt(++readPos) != 'p' || inStr.charAt(++readPos) != ';') break block0;
                                c = c_amp;
                                idx += 4;
                                break block0;
                            }
                            case 'p': {
                                if (readPos + 3 >= inStrLength || inStr.charAt(++readPos) != 'o' || inStr.charAt(++readPos) != 's' || inStr.charAt(++readPos) != ';') break block0;
                                c = c_apos;
                                idx += 5;
                                break block0;
                            }
                        }
                        break;
                    }
                    case 'g': {
                        if (readPos + 2 >= inStrLength || inStr.charAt(++readPos) != 't' || inStr.charAt(++readPos) != ';') break;
                        c = c_gt;
                        idx += 3;
                        break;
                    }
                    case 'l': {
                        if (readPos + 2 >= inStrLength || inStr.charAt(++readPos) != 't' || inStr.charAt(++readPos) != ';') break;
                        c = c_lt;
                        idx += 3;
                        break;
                    }
                    case 'q': {
                        if (readPos + 4 >= inStrLength || inStr.charAt(++readPos) != 'u' || inStr.charAt(++readPos) != 'o' || inStr.charAt(++readPos) != 't' || inStr.charAt(++readPos) != ';') break;
                        c = c_quot;
                        idx += 5;
                        break;
                    }
                }
            }
            outStr.append((char)c);
        }
        return outStr.toString();
    }

    public static final String escapeAndTagStr(String sTag, String sValue) {
        StringBuffer outStr = new StringBuffer(TAG_LT);
        outStr.append(sTag);
        outStr.append(TAG_GT);
        outStr.append(MFWStringHelper.escapeXMLChars(sValue));
        outStr.append(TAG_LT_SLASH);
        outStr.append(sTag);
        outStr.append(TAG_GT);
        return outStr.toString();
    }

    public static final String replaceAll(String input, String old, String newVal) {
        StringBuilder newBuffer = new StringBuilder();
        int fromIndex = 0;
        int idx = input.indexOf(old, fromIndex);
        while (idx != -1) {
            newBuffer.append(input.substring(fromIndex, idx));
            newBuffer.append(newVal);
            fromIndex = idx + old.length();
            idx = input.indexOf(old, fromIndex);
        }
        if (fromIndex < input.length()) {
            newBuffer.append(input.substring(fromIndex));
        }
        return newBuffer.toString();
    }

    public static final String cleanupFileName(String inFileName) {
        String outFileName = MFWStringHelper.replaceAll(inFileName, ".", "_");
        outFileName = MFWStringHelper.replaceAll(outFileName, ":", "_");
        outFileName = MFWStringHelper.replaceAll(outFileName, "/", "_");
        outFileName = MFWStringHelper.replaceAll(outFileName, "\\", "_");
        return outFileName;
    }

    public static final boolean areEqual(String str1, String str2) {
        if (str1 == null && str2 == null) {
            return true;
        }
        return str1 != null && str1.equals(str2) || str2 != null && str2.equals(str1);
    }
}

