/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfw4j.utilities;

import com.cognos.ccl4j.util.CCLXMLUtils;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Element;

public class MFWXMLDump {
    private StringBuffer m_xmlString = new StringBuffer();
    public static final int eStartAttrib = 0;
    public static final int eStartNoAttrib = 1;
    public static final int eEnd = 2;
    public static final int eEndNoLeadingLF = 3;

    public void destroy() {
        this.m_xmlString = null;
    }

    public String getXML() {
        return this.m_xmlString.toString();
    }

    public void addElement(String name, int type) {
        switch (type) {
            case 0: {
                this.m_xmlString.append("\n<");
                this.m_xmlString.append(name);
                break;
            }
            case 1: {
                this.m_xmlString.append("\n");
                this.m_xmlString.append("<");
                this.m_xmlString.append(name);
                this.m_xmlString.append(">");
                break;
            }
            case 2: {
                this.m_xmlString.append("\n");
                this.m_xmlString.append("</");
                this.m_xmlString.append(name);
                this.m_xmlString.append(">");
                break;
            }
            case 3: {
                this.m_xmlString.append("</");
                this.m_xmlString.append(name);
                this.m_xmlString.append(">");
            }
        }
    }

    public void addEmptyElement(String name) {
        this.m_xmlString.append("\n<");
        this.m_xmlString.append(name);
        this.m_xmlString.append("/>");
    }

    public void addAttribute(String name, String value) {
        this.m_xmlString.append(" ");
        this.m_xmlString.append(name);
        this.m_xmlString.append("=\"");
        this.m_xmlString.append(value);
        this.m_xmlString.append("\"");
    }

    public void addAttribute(String name, int value) {
        this.addAttribute(name, Integer.toString(value));
    }

    public void endElement(boolean bAddSlash) {
        if (bAddSlash) {
            this.m_xmlString.append("/");
        }
        this.m_xmlString.append(">");
    }

    public void addCData(String name, String value) {
        this.addElement(name, 1);
        this.m_xmlString.append("![CDATA[");
        this.m_xmlString.append(value);
        this.m_xmlString.append("]]");
        this.addElement(name, 2);
    }

    public void addText(String text) {
        this.m_xmlString.append(text);
    }

    public void addText(String text, boolean escape) {
        String escapedText = text;
        if (escape) {
            StringBuffer sEscapedValue = new StringBuffer();
            CCLXMLUtils.xmlEncode((String)text, (StringBuffer)sEscapedValue);
            escapedText = sEscapedValue.toString();
        }
        this.m_xmlString.append(escapedText);
    }

    public void addInt(int value) {
        this.m_xmlString.append(value);
    }

    public static String DumpElement(Element elem) {
        try {
            OutputFormat format = new OutputFormat();
            format.setOmitDocumentType(true);
            format.setOmitXMLDeclaration(true);
            StringWriter result = new StringWriter();
            XMLSerializer serializer = new XMLSerializer((Writer)result, format);
            serializer.serialize(elem);
            return result.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

