/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfw4j.utilities.soap;

import com.cognos.ccl4j.exceptions.CCLRuntimeException;
import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.CAM;
import com.cognos.developer.schemas.bibus._3.ContentManagerService_PortType;
import com.cognos.developer.schemas.bibus._3.EncodingEnum;
import com.cognos.developer.schemas.bibus._3.FormFieldVar;
import com.cognos.developer.schemas.bibus._3.FormatEnum;
import com.cognos.developer.schemas.bibus._3.HdrSession;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.QueryOptions;
import com.cognos.developer.schemas.bibus._3.SearchPathMultipleObject;
import com.cognos.mfw4j.utilities.MFWBiBusHelper;
import com.cognos.mfw4j.utilities.soap.AxisSoapCommand;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import javax.xml.rpc.ServiceException;
import org.apache.axis.client.Stub;

public class AuthenticationCommand
extends AxisSoapCommand {
    private String m_user;
    private String m_pass;
    private String m_namespace;

    public AuthenticationCommand(String contentLocale, String productLocale, String namespace, String user, String pass) {
        super(contentLocale, productLocale);
        this.m_user = user;
        this.m_pass = pass;
        this.m_namespace = namespace;
    }

    public void execute() {
        this.m_passport = this.queryForPassport();
    }

    public String getPassport() {
        return this.m_passport;
    }

    private BiBusHeader buildHeader() {
        BiBusHeader header = new BiBusHeader();
        CAM cam = new CAM();
        if (!(this.m_namespace == null || "".equals(this.m_namespace) || this.m_user == null || "".equals(this.m_user) || this.m_pass == null || "".equals(this.m_pass))) {
            cam.setAction("logonAs");
            HdrSession hdrSession = new HdrSession();
            FormFieldVar[] vars = new FormFieldVar[3];
            vars[0] = new FormFieldVar();
            vars[0].setName("CAMNamespace");
            vars[0].setFormat(FormatEnum.not_encrypted);
            vars[0].setValue(this.m_namespace);
            vars[1] = new FormFieldVar();
            vars[1].setName("CAMUsername");
            vars[1].setValue(this.m_user);
            vars[1].setFormat(FormatEnum.not_encrypted);
            vars[2] = new FormFieldVar();
            vars[2].setName("CAMPassword");
            vars[2].setValue(this.m_pass);
            vars[2].setFormat(FormatEnum.not_encrypted);
            hdrSession.setFormFieldVars(vars);
            header.setHdrSession(hdrSession);
        } else {
            cam.setAction("logon");
        }
        header.setCAM(cam);
        this.addUserPreferences(header);
        return header;
    }

    String queryForPassport() {
        try {
            BiBusHeader header = this.buildHeader();
            ContentManagerService_PortType port = this.getContentManagerServicePort(header);
            SearchPathMultipleObject smo = new SearchPathMultipleObject("~");
            PropEnum[] props = new PropEnum[]{PropEnum.defaultName};
            QueryOptions options = new QueryOptions();
            options.setSchemaInfo(false);
            options.setPermission("read");
            options.setMaxObjects(BigInteger.ZERO);
            options.setSkipObjects(BigInteger.ZERO);
            options.setDataEncoding(EncodingEnum.base64);
            options.setMaxDataBytes(BigInteger.ZERO);
            options.setSkipDataBytes(BigInteger.ZERO);
            port.query(smo, props, null, options);
            BiBusHeader bibus = MFWBiBusHelper.getBiBusHeader((Stub)port);
            String passport = bibus.getCAM().getCAMPassport().getId();
            return passport;
        }
        catch (ServiceException se) {
            throw new CCLRuntimeException((Throwable)se, se.getMessage());
        }
        catch (MalformedURLException mu) {
            throw new CCLRuntimeException((Throwable)mu, mu.getMessage());
        }
        catch (RemoteException re) {
            throw new CCLRuntimeException((Throwable)re, re.getMessage());
        }
        catch (CCLConfigurationException ce) {
            throw new CCLRuntimeException((Throwable)ce, ce.getMessage());
        }
        catch (Exception e) {
            throw new CCLRuntimeException((Throwable)e, e.getMessage());
        }
    }
}

