/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfw4j.utilities.soap;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.mfw4j.utilities.MFWContentHelper;
import com.cognos.mfw4j.utilities.MFWModelNotFoundException;
import com.cognos.mfw4j.utilities.ThreadSafeDateFormat;
import com.cognos.mfw4j.utilities.soap.BIBusCommandHelper;
import com.cognos.pogo.bibus.CommandExecutionException;
import com.cognos.pogo.contentmanager.CMClass;
import com.cognos.pogo.contentmanager.ContentManagerQueryCommand;
import com.cognos.pogo.http.ConnectionPool;
import com.cognos.pogo.http.ServerConnection;
import com.cognos.pogo.pdk.BIBusEnvelope;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import java.util.zip.GZIPInputStream;
import org.dom4j.Element;

public final class DispatcherContentManagerQueryCommand
extends ContentManagerQueryCommand {
    private static final Object DISPATCHER_CONNECTION_POOL_LOCK = new Object();
    private static ConnectionPool DISPATCHER_CONNECTION_POOL = null;
    private static String DISPATCHER_URL_PATH = null;
    private static final String TAG_item = "item";
    private static final String TAG_name = "name";
    private static final String TAG_value = "value";
    private static final String TAG_searchPath = "searchPath";
    private static final String TAG_storeID = "storeID";
    protected static ThreadSafeDateFormat gUTCFormat = new ThreadSafeDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    private String m_passport;
    private String m_contentLocale;
    private String m_productLocale;
    private ServerConnection m_serverConnection;
    private BIBusEnvelope m_envelope;
    private int m_connectionTimeout;
    private boolean m_isCompressedMIME = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DispatcherContentManagerQueryCommand(String path, boolean isTrusted, boolean isCompressedMIME, String passport, String contentLocale, String productLocale, BIBusEnvelope envelope) {
        super(path);
        this.m_passport = passport;
        this.m_contentLocale = contentLocale;
        this.m_productLocale = productLocale;
        this.m_isCompressedMIME = isCompressedMIME;
        if (isCompressedMIME) {
            super.setMimeCompressedDataEncoding();
            super.setAutoRelease(false);
        } else {
            super.setMimeDataEncoding();
            super.setAutoRelease(true);
        }
        super.setDoTrustedRequest(isTrusted, "XQE");
        super.setPermission("read");
        this.m_envelope = envelope;
        this.m_connectionTimeout = -1;
        Object object = DISPATCHER_CONNECTION_POOL_LOCK;
        synchronized (object) {
            if (DISPATCHER_CONNECTION_POOL == null) {
                try {
                    String localDispatcher = CCLConfigurationFactory.getInstance().getValue("internalDispatcher", false);
                    URL dispatcherURL = new URL(localDispatcher);
                    DISPATCHER_CONNECTION_POOL = new ConnectionPool(dispatcherURL.getHost(), dispatcherURL.getPort(), "https".equals(dispatcherURL.getProtocol()), 20);
                    DISPATCHER_URL_PATH = dispatcherURL.getPath();
                }
                catch (CCLConfigurationException ccf) {
                    throw new RuntimeException(ccf.getMessage(), ccf);
                }
                catch (MalformedURLException mue) {
                    throw new RuntimeException(mue.getMessage(), mue);
                }
            }
        }
    }

    protected void addExtraSOAPHeaders() {
        if (this.m_envelope == null) {
            BIBusCommandHelper.populateBIBusHeader(super.getRequestEnvelope().getBIBusHeader(), super.getRequestCAMElement(), this.m_passport, this.m_contentLocale, this.m_productLocale);
        } else {
            Element header = (Element)this.m_envelope.getBIBusHeader().clone();
            header.detach();
            super.getRequestEnvelope().setBIBusHeader(header);
        }
    }

    public InputStream getModel() {
        Iterator it = this.getAttachments();
        InputStream st = null;
        try {
            if (it.hasNext()) {
                st = (InputStream)it.next();
                st = BIBusCommandHelper.stripMIMEHeaders(st);
                st = new GZIPInputStream(st);
                st = new ReleaseInputStream(st);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return st;
    }

    protected ServerConnection fetchServerConnection() {
        this.m_serverConnection = DISPATCHER_CONNECTION_POOL.getConnection();
        if (this.m_connectionTimeout != -1) {
            this.m_serverConnection.setConnectionTimeout(this.m_connectionTimeout);
        }
        this.m_serverConnection.getHttpClient().getState().clearCookies();
        return this.m_serverConnection;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        super.setConnectionTimeout(connectionTimeout);
        this.m_connectionTimeout = connectionTimeout;
    }

    protected String fetchRequestContext() {
        return DISPATCHER_URL_PATH;
    }

    public List<Object> getObjectProperties(String searchPath, String[] queryProps) throws CommandExecutionException {
        List vResults = this.getResultList();
        if (vResults.size() == 0) {
            throw new MFWModelNotFoundException(searchPath);
        }
        ArrayList<Object> outList = new ArrayList<Object>(queryProps.length + 1);
        CMClass cmResponse = (CMClass)vResults.get(0);
        for (int idx = 0; idx < queryProps.length; ++idx) {
            if (!cmResponse.getPropertyList().contains(queryProps[idx])) continue;
            Element anElement = cmResponse.getPropertyAsElement(queryProps[idx]);
            if ("modificationTime".equals(queryProps[idx]) || "creationTime".equals(queryProps[idx])) {
                outList.add(DispatcherContentManagerQueryCommand.getCalendarValue(anElement));
                continue;
            }
            if ("options".equals(queryProps[idx])) {
                outList.add(DispatcherContentManagerQueryCommand.getQueryOptionValue(anElement));
                continue;
            }
            if ("parent".equals(queryProps[idx])) {
                DispatcherContentManagerQueryCommand.addParentValues(outList, anElement);
                continue;
            }
            outList.add(DispatcherContentManagerQueryCommand.getStringValue(anElement, TAG_value));
        }
        return outList;
    }

    private static String getStringValue(Element elmParent, String tag) {
        String outValue = null;
        Element elmValue = elmParent.element(tag);
        if (elmValue != null) {
            outValue = elmValue.getText();
        }
        return outValue;
    }

    private static Calendar getCalendarValue(Element elmParent) {
        Calendar outValue = null;
        String timeStamp = DispatcherContentManagerQueryCommand.getStringValue(elmParent, TAG_value);
        try {
            if (timeStamp != null && timeStamp.length() > 0) {
                Date aDate = gUTCFormat.parse(timeStamp);
                outValue = Calendar.getInstance();
                outValue.setTime(aDate);
            }
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        return outValue;
    }

    private static List<MFWContentHelper.Option> getQueryOptionValue(Element elmParent) {
        ArrayList<MFWContentHelper.Option> outOptions = new ArrayList<MFWContentHelper.Option>();
        if ((elmParent = elmParent.element(TAG_value)) == null) {
            return outOptions;
        }
        List elmItems = elmParent.elements(TAG_item);
        for (Element anOption : elmItems) {
            String optName = DispatcherContentManagerQueryCommand.getStringValue(anOption, TAG_name);
            String optValue = DispatcherContentManagerQueryCommand.getStringValue(anOption, TAG_value);
            outOptions.add(new MFWContentHelper.Option(optName, optValue));
        }
        return outOptions;
    }

    private static void addParentValues(List<Object> outList, Element elmParent) {
        if ((elmParent = elmParent.element(TAG_value)) == null) {
            outList.add(null);
            outList.add(null);
            return;
        }
        if ((elmParent = elmParent.element(TAG_item)) == null) {
            outList.add(null);
            outList.add(null);
            return;
        }
        Element elmValue = elmParent.element(TAG_searchPath);
        if (elmValue != null) {
            outList.add(DispatcherContentManagerQueryCommand.getStringValue(elmValue, TAG_value));
        } else {
            outList.add(null);
        }
        elmValue = elmParent.element(TAG_storeID);
        if (elmValue != null) {
            outList.add(DispatcherContentManagerQueryCommand.getStringValue(elmValue, TAG_value));
        } else {
            outList.add(null);
        }
    }

    public void getModelViews(String searchPath, List<String> outValues) throws CommandExecutionException {
        List vResults = this.getResultList();
        for (CMClass cmResponse : vResults) {
            Element anElement = cmResponse.getPropertyAsElement("defaultName");
            outValues.add(DispatcherContentManagerQueryCommand.getStringValue(anElement, TAG_value));
        }
    }

    public void releaseConnection() {
        ServerConnection sc;
        if (this.m_isCompressedMIME && (sc = this.getConnection()) != null) {
            sc.release();
        }
    }

    static {
        gUTCFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    private class ReleaseInputStream
    extends InputStream {
        private InputStream m_stream;

        public ReleaseInputStream(InputStream stream) {
            this.m_stream = stream;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int rd = -1;
            if (this.m_stream != null) {
                rd = this.m_stream.read(b, off, len);
            }
            if (rd == -1) {
                DispatcherContentManagerQueryCommand.this.m_serverConnection.release();
                this.m_stream = null;
                DispatcherContentManagerQueryCommand.this.m_serverConnection = null;
            }
            return rd;
        }

        @Override
        public int read() throws IOException {
            int rd = -1;
            if (this.m_stream != null && (rd = this.m_stream.read()) == -1) {
                DispatcherContentManagerQueryCommand.this.m_serverConnection.release();
                this.m_stream = null;
                DispatcherContentManagerQueryCommand.this.m_serverConnection = null;
            }
            return rd;
        }
    }
}

