/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfw4j.utilities.soap;

import com.cognos.ccl4j.exceptions.CCLRuntimeException;
import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BaseClassArrayProp;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.ContentManagerService_PortType;
import com.cognos.developer.schemas.bibus._3.DateTimeProp;
import com.cognos.developer.schemas.bibus._3.GenericOption;
import com.cognos.developer.schemas.bibus._3.GenericOptionAnyURI;
import com.cognos.developer.schemas.bibus._3.GuidProp;
import com.cognos.developer.schemas.bibus._3.Model;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.OptionArrayProp;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.SearchPathMultipleObject;
import com.cognos.developer.schemas.bibus._3.StringProp;
import com.cognos.developer.schemas.bibus._3.TokenProp;
import com.cognos.developer.schemas.bibus._3.UiClass;
import com.cognos.mfw4j.utilities.MFWContentHelper;
import com.cognos.mfw4j.utilities.MFWException;
import com.cognos.mfw4j.utilities.MFWModelNotFoundException;
import com.cognos.mfw4j.utilities.soap.AxisSoapCommand;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.rpc.ServiceException;

public class ObjectPropertiesCommand
extends AxisSoapCommand {
    public ObjectPropertiesCommand(String passport, String contentLocale, String productLocale, BiBusHeader bibusHeader) {
        super(contentLocale, productLocale, passport, bibusHeader);
    }

    public List<Object> queryObjectProperties(String searchPath, String[] queryProps) {
        MFWException.ASSERT(queryProps != null, "Expecting a valid set of properties to query");
        try {
            BiBusHeader header = this.buildSimpleHeader();
            ContentManagerService_PortType port = this.getContentManagerServicePort(header);
            SearchPathMultipleObject smo = new SearchPathMultipleObject(searchPath);
            PropEnum[] props = new PropEnum[queryProps.length];
            for (int idx = 0; idx < queryProps.length; ++idx) {
                props[idx] = PropEnum.fromValue((String)queryProps[idx]);
            }
            BaseClass[] res = port.query(smo, props, null, null);
            if (res.length == 0) {
                throw new MFWModelNotFoundException(searchPath);
            }
            BaseClass baseClass = res[0];
            ArrayList<Object> outList = new ArrayList<Object>(queryProps.length);
            for (int idx = 0; idx < queryProps.length; ++idx) {
                if ("defaultName".equals(queryProps[idx])) {
                    TokenProp name = baseClass.getDefaultName();
                    outList.add(name != null ? name.getValue() : null);
                    continue;
                }
                if ("modificationTime".equals(queryProps[idx])) {
                    DateTimeProp mt = baseClass.getModificationTime();
                    outList.add(mt != null ? mt.getValue() : null);
                    continue;
                }
                if ("creationTime".equals(queryProps[idx])) {
                    DateTimeProp ct = baseClass.getCreationTime();
                    outList.add(ct != null ? ct.getValue() : null);
                    continue;
                }
                if ("storeID".equals(queryProps[idx])) {
                    GuidProp si = baseClass.getStoreID();
                    outList.add(si != null && si.getValue() != null ? si.getValue().get_value() : null);
                    continue;
                }
                if ("defaultDescription".equals(queryProps[idx])) {
                    MFWException.ASSERT(baseClass instanceof UiClass, "Default description is supported only for UI objects");
                    StringProp dd = ((UiClass)baseClass).getDefaultDescription();
                    outList.add(dd != null && dd.getValue() != null ? dd.getValue() : null);
                    continue;
                }
                if ("defaultScreenTip".equals(queryProps[idx])) {
                    MFWException.ASSERT(baseClass instanceof UiClass, "Default screen tip is supported only for UI objects");
                    StringProp ds = ((UiClass)baseClass).getDefaultScreenTip();
                    outList.add(ds != null && ds.getValue() != null ? ds.getValue() : null);
                    continue;
                }
                if ("parent".equals(queryProps[idx])) {
                    BaseClassArrayProp parentProps = baseClass.getParent();
                    BaseClass[] values = parentProps.getValue();
                    if (values != null && values.length > 0) {
                        outList.add(values[0].getSearchPath());
                        GuidProp si = values[0].getStoreID();
                        outList.add(si != null && si.getValue() != null ? si.getValue().get_value() : null);
                        continue;
                    }
                    outList.add(null);
                    outList.add(null);
                    continue;
                }
                if ("options".equals(queryProps[idx])) {
                    Option[] values;
                    if (!(baseClass instanceof Model)) continue;
                    Model m = (Model)baseClass;
                    ArrayList<MFWContentHelper.Option> resOptions = new ArrayList<MFWContentHelper.Option>();
                    OptionArrayProp options = m.getOptions();
                    if (options != null && (values = options.getValue()) != null) {
                        for (Option op : values) {
                            GenericOption go;
                            String name;
                            boolean known = false;
                            if (op instanceof GenericOption && "http://developer.cognos.com/ceba/constants/queryOptionEnum#mode".equals(name = (go = (GenericOption)op).getName())) {
                                GenericOptionAnyURI uo = (GenericOptionAnyURI)op;
                                String value = uo.getValue();
                                MFWContentHelper.Option option = new MFWContentHelper.Option();
                                option.m_name = name;
                                option.m_value = value;
                                resOptions.add(option);
                                known = true;
                            }
                            if (known) continue;
                            resOptions.add(MFWContentHelper.Option.UNKNOWN);
                        }
                    }
                    outList.add(resOptions);
                    continue;
                }
                MFWException.ASSERT(false, "Uusupported CM property");
            }
            return outList;
        }
        catch (ServiceException se) {
            throw new CCLRuntimeException((Throwable)se, se.getMessage());
        }
        catch (MalformedURLException mu) {
            throw new CCLRuntimeException((Throwable)mu, mu.getMessage());
        }
        catch (RemoteException re) {
            throw ObjectPropertiesCommand.handleRemoteException(re);
        }
        catch (CCLConfigurationException ce) {
            throw new CCLRuntimeException((Throwable)ce, ce.getMessage());
        }
    }
}

