/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfw4j.utilities.soap.prompt;

import com.cognos.mfw4j.utilities.soap.prompt.MFWQsParamValueItemHierarchyHelper;
import com.cognos.mfw4j.utilities.soap.prompt.MFWQsParamValueItemRangeHelper;
import com.cognos.mfw4j.utilities.soap.prompt.MFWQsParamValueItemSimpleHelper;
import org.dom4j.Element;

abstract class MFWQsParamValueItemHelper {
    Element m_elmValueItem;
    private boolean m_isInclusive;

    static MFWQsParamValueItemHelper Create(String type, Element elmItem) {
        MFWQsParamValueItemHelper pItemHelper = null;
        if ("bus:simpleParmValueItem".equals(type)) {
            pItemHelper = new MFWQsParamValueItemSimpleHelper();
        } else if ("bus:hierarchicalParmValueItem".equals(type)) {
            pItemHelper = new MFWQsParamValueItemHierarchyHelper();
        } else if ("bus:boundRangeParmValueItem".equals(type) || "bus:unboundedStartParmValueItem".equals(type) || "bus:unboundedEndParmValueItem".equals(type)) {
            pItemHelper = new MFWQsParamValueItemRangeHelper();
        } else {
            throw new RuntimeException("Invalid type passed to MFWQsParamValueItemHelper::Create");
        }
        ((MFWQsParamValueItemHelper)pItemHelper).doTake(elmItem);
        return pItemHelper;
    }

    MFWQsParamValueItemHelper(boolean bIsInclusive) {
        this.m_isInclusive = bIsInclusive;
    }

    void destroy() {
        this.m_elmValueItem = null;
    }

    boolean isInclusive() {
        return this.m_isInclusive;
    }

    void setInclusive(boolean bIsInclusive) {
        this.m_isInclusive = bIsInclusive;
    }

    void doTake(Element elmValueItem) {
        this.m_elmValueItem = elmValueItem;
        String strValue = null;
        Element inclusive = (Element)this.m_elmValueItem.selectSingleNode("inclusive");
        if (inclusive != null) {
            strValue = inclusive.getText();
        }
        this.m_isInclusive = !"false".equals(strValue);
    }

    Element doMake(Element parent) {
        Element itemElem = parent.addElement("item");
        itemElem.addAttribute("xsi:type", this.getBiBusType());
        this.makeProperties(itemElem);
        return itemElem;
    }

    void makeProperties(Element domRequest) {
        Element inc = (Element)domRequest.selectSingleNode("inclusive");
        if (inc == null) {
            inc = domRequest.addElement("inclusive");
        }
        inc.setText(this.m_isInclusive ? "true" : "false");
    }

    abstract String getBiBusType();
}

