/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfwa4j.adaptorBW;

import com.cognos.mfw4j.framework.log.MFWLogDimAdaptorTraceEvent;
import com.cognos.mfwa4j.adaptorBW.MFWOLAPSchema;
import com.cognos.xqe.data.values.DateTimeValue;
import com.cognos.xqe.metadata.record.CubeRecord;
import com.cognos.xqe.metadata.record.DimensionRecord;
import com.cognos.xqe.metadata.record.HierarchyRecord;
import com.cognos.xqe.metadata.record.LevelRecord;
import com.cognos.xqe.metadata.record.MeasureRecord;
import com.cognos.xqe.metadata.record.MemberRecord;
import com.cognos.xqe.metadata.record.MetadataRecord;
import com.cognos.xqe.metadata.record.PropertyRecord;
import com.cognos.xqe.metadata.record.VariableRecord;
import java.text.SimpleDateFormat;
import java.util.TimeZone;

public class MFWMetadataXQEResponseEntity {
    private MetadataRecord mRecord = null;
    private short mClassType;

    MFWMetadataXQEResponseEntity(MetadataRecord metadata, short classType) {
        this.mRecord = metadata;
        this.mClassType = classType;
    }

    String getPropertyValue(int propID) {
        String value = null;
        switch (this.mClassType) {
            case 10: {
                value = this.getAttributePropertyValue(propID, null);
                break;
            }
            case 20: {
                value = this.getCubePropertyValue(propID);
                break;
            }
            case 30: {
                value = this.getDimensionPropertyValue(propID, null);
                break;
            }
            case 40: {
                value = this.getHierarchyPropertyValue(propID, null);
                break;
            }
            case 50: {
                value = this.getLevelPropertyValue(propID, null);
                break;
            }
            case 70: {
                value = this.getMeasurePropertyValue(propID, null);
                break;
            }
            case 80: {
                value = this.getMemberPropertyValue(propID, null);
                break;
            }
            case 100: {
                value = this.getVariablePropertyValue(propID, null);
                break;
            }
            default: {
                value = null;
            }
        }
        MFWLogDimAdaptorTraceEvent log = new MFWLogDimAdaptorTraceEvent();
        log.logMDRequest(MFWOLAPSchema.getClassStr(this.mClassType), MFWOLAPSchema.OLAPProperty.getString(propID) + "\t\t" + value);
        return value != null ? value : "";
    }

    String getPropertyValue(int propID, String propLocale) {
        String value = null;
        switch (this.mClassType) {
            case 10: {
                value = this.getAttributePropertyValue(propID, propLocale);
                break;
            }
            case 30: {
                value = this.getDimensionPropertyValue(propID, propLocale);
                break;
            }
            case 40: {
                value = this.getHierarchyPropertyValue(propID, propLocale);
                break;
            }
            case 50: {
                value = this.getLevelPropertyValue(propID, propLocale);
                break;
            }
            case 70: {
                value = this.getMeasurePropertyValue(propID, propLocale);
                break;
            }
            case 80: {
                value = this.getMemberPropertyValue(propID, propLocale);
                break;
            }
            case 100: {
                value = this.getVariablePropertyValue(propID, null);
                break;
            }
            default: {
                value = null;
            }
        }
        MFWLogDimAdaptorTraceEvent log = new MFWLogDimAdaptorTraceEvent();
        log.logMDRequest(MFWOLAPSchema.getClassStr(this.mClassType), MFWOLAPSchema.OLAPProperty.getString(propID) + "\t\t" + value);
        return value != null ? value : "";
    }

    private String getCubePropertyValue(int propID) {
        switch (propID) {
            case 7: {
                return this.mRecord.getName();
            }
            case 6: {
                return MFWMetadataXQEResponseEntity.toModelString(((CubeRecord)this.mRecord).getCreatedDate());
            }
            case 26: {
                return MFWMetadataXQEResponseEntity.toModelString(((CubeRecord)this.mRecord).getDataUpdateDate());
            }
            case 50: {
                return ((CubeRecord)this.mRecord).getCatalogName();
            }
            case 52: {
                return ((CubeRecord)this.mRecord).getSchemaName();
            }
            case 13: {
                return this.mRecord.getDescription();
            }
            case 45: {
                return ((CubeRecord)this.mRecord).getSuppressionType() != null ? ((CubeRecord)this.mRecord).getSuppressionType().toString() : null;
            }
            case 24: {
                return ((CubeRecord)this.mRecord).getIsOptimized() ? "true" : "false";
            }
            case 8: {
                return ((CubeRecord)this.mRecord).getCurrentPeriod();
            }
            case 27: {
                return MFWMetadataXQEResponseEntity.toModelString(((CubeRecord)this.mRecord).getSchemaUpdateDate());
            }
        }
        return null;
    }

    private String getDimensionPropertyValue(int propID, String propLocale) {
        switch (propID) {
            case 16: {
                return this.mRecord.getUniqueName();
            }
            case 10: {
                return ((DimensionRecord)this.mRecord).getDefaultHierarchyUniqueName();
            }
            case 5: {
                return propLocale == null ? this.mRecord.getCaption().toString(this.mRecord.getCaption().getDefaultLocale()) : this.mRecord.getCaption().toString(propLocale);
            }
            case 13: {
                return this.mRecord.getDescription();
            }
            case 48: {
                return ((DimensionRecord)this.mRecord).getType() == null ? null : ((DimensionRecord)this.mRecord).getType().toFMType();
            }
            case 38: {
                return ((DimensionRecord)this.mRecord).getUniqueId();
            }
            case 14: {
                return ((DimensionRecord)this.mRecord).getDimensionGroupName();
            }
            case 23: {
                return ((DimensionRecord)this.mRecord).isHidden() ? "true" : "false";
            }
            case 15: {
                return ((DimensionRecord)this.mRecord).getDimensionGroupDescription();
            }
            case 7: {
                return ((DimensionRecord)this.mRecord).getCubeName();
            }
            case 53: {
                return ((DimensionRecord)this.mRecord).getIsStructure() == null ? null : ((DimensionRecord)this.mRecord).getIsStructure().toString();
            }
            case 54: {
                return new Integer(((DimensionRecord)this.mRecord).getCardinality()).toString();
            }
        }
        return null;
    }

    private String getHierarchyPropertyValue(int propID, String propLocale) {
        switch (propID) {
            case 22: {
                return this.mRecord.getUniqueName();
            }
            case 3: {
                return ((HierarchyRecord)this.mRecord).isBalanced() ? "true" : "false";
            }
            case 40: {
                return ((HierarchyRecord)this.mRecord).isRagged() ? "true" : "false";
            }
            case 37: {
                return ((HierarchyRecord)this.mRecord).isParentChild() ? "true" : "false";
            }
            case 5: {
                return propLocale == null ? this.mRecord.getCaption().toString(this.mRecord.getCaption().getDefaultLocale()) : this.mRecord.getCaption().toString(propLocale);
            }
            case 13: {
                return this.mRecord.getDescription();
            }
            case 38: {
                return ((HierarchyRecord)this.mRecord).getUniqueId();
            }
            case 23: {
                return ((HierarchyRecord)this.mRecord).isHidden() ? "true" : "false";
            }
            case 12: {
                return ((HierarchyRecord)this.mRecord).getDefaultMemberUniqueName();
            }
            case 54: {
                return new Integer(((HierarchyRecord)this.mRecord).getCardinality()).toString();
            }
            case 55: {
                return ((HierarchyRecord)this.mRecord).getValidFrom() == null ? null : ((HierarchyRecord)this.mRecord).getValidFrom();
            }
            case 56: {
                return ((HierarchyRecord)this.mRecord).getValidTo() == null ? null : ((HierarchyRecord)this.mRecord).getValidTo();
            }
        }
        return null;
    }

    private String getLevelPropertyValue(int propID, String propLocale) {
        switch (propID) {
            case 29: {
                return this.mRecord.getUniqueName();
            }
            case 28: {
                return Integer.toString(((LevelRecord)this.mRecord).getLevelNumber());
            }
            case 5: {
                return propLocale == null ? this.mRecord.getCaption().toString(this.mRecord.getCaption().getDefaultLocale()) : this.mRecord.getCaption().toString(propLocale);
            }
            case 13: {
                return this.mRecord.getDescription();
            }
            case 38: {
                return ((LevelRecord)this.mRecord).getUniqueId();
            }
            case 25: {
                return ((LevelRecord)this.mRecord).hasUniqueMemberNames() ? "true" : "false";
            }
            case 23: {
                return ((LevelRecord)this.mRecord).isHidden() ? "true" : "false";
            }
            case 22: {
                return ((LevelRecord)this.mRecord).getHierarchyUniqueName();
            }
            case 54: {
                return new Integer(((LevelRecord)this.mRecord).getCardinality()).toString();
            }
        }
        return null;
    }

    private String getMeasurePropertyValue(int propID, String propLocale) {
        switch (propID) {
            case 34: {
                return this.mRecord.getUniqueName();
            }
            case 5: {
                return propLocale == null ? this.mRecord.getCaption().toString(this.mRecord.getCaption().getDefaultLocale()) : this.mRecord.getCaption().toString(propLocale);
            }
            case 1: {
                return ((MeasureRecord)this.mRecord).getRegularAggregate().getModelName();
            }
            case 47: {
                return ((MeasureRecord)this.mRecord).getSemiAggregate().getModelName();
            }
            case 58: {
                return ((MeasureRecord)this.mRecord).getTimestateAggregatorDimension();
            }
            case 9: {
                return ((MeasureRecord)this.mRecord).getDataType().toModelType();
            }
            case 13: {
                return this.mRecord.getDescription();
            }
            case 49: {
                return ((MeasureRecord)this.mRecord).getUnits();
            }
            case 39: {
                return Integer.toString(((MeasureRecord)this.mRecord).getDataType().getPrecision());
            }
            case 43: {
                return Integer.toString(((MeasureRecord)this.mRecord).getDataType().getScale());
            }
            case 20: {
                return null;
            }
        }
        return null;
    }

    private String getAttributePropertyValue(int propID, String propLocale) {
        switch (propID) {
            case 2: {
                return this.mRecord.getUniqueName();
            }
            case 5: {
                return propLocale == null ? this.mRecord.getCaption().toString(this.mRecord.getCaption().getDefaultLocale()) : this.mRecord.getCaption().toString(propLocale);
            }
            case 13: {
                return this.mRecord.getDescription();
            }
            case 9: {
                return ((PropertyRecord)this.mRecord).getDataType().toModelType();
            }
            case 42: {
                return ((PropertyRecord)this.mRecord).getRoleType() != null ? ((PropertyRecord)this.mRecord).getRoleType().toRoleValue() : null;
            }
            case 62: {
                return ((PropertyRecord)this.mRecord).getDimensionUniqueName();
            }
        }
        return null;
    }

    private String getMemberPropertyValue(int propID, String propLocale) {
        switch (propID) {
            case 35: {
                return this.mRecord.getUniqueName();
            }
            case 5: {
                return propLocale == null ? this.mRecord.getCaption().toString(this.mRecord.getCaption().getDefaultLocale()) : this.mRecord.getCaption().toString(propLocale);
            }
            case 0: {
                return ((MemberRecord)this.mRecord).getRollupType().toMDDSType();
            }
        }
        return null;
    }

    private String getVariablePropertyValue(int propID, String propLocale) {
        switch (propID) {
            case 61: {
                return this.mRecord.getUniqueName();
            }
            case 5: {
                return propLocale == null ? this.mRecord.getCaption().toString(this.mRecord.getCaption().getDefaultLocale()) : this.mRecord.getCaption().toString(propLocale);
            }
            case 63: {
                return ((VariableRecord)this.mRecord).getHierarchyUniqueName();
            }
            case 62: {
                return ((VariableRecord)this.mRecord).getDimensionUniqueName();
            }
            case 64: {
                return ((VariableRecord)this.mRecord).getSelectionType().toFMType();
            }
            case 65: {
                return ((VariableRecord)this.mRecord).getEntryType().toFMEntryType();
            }
            case 9: {
                return ((VariableRecord)this.mRecord).getDataType().getTypeName();
            }
            case 48: {
                return ((VariableRecord)this.mRecord).getType().toMDDSType();
            }
            case 66: {
                return ((VariableRecord)this.mRecord).getDefaultLow().getString();
            }
            case 67: {
                return ((VariableRecord)this.mRecord).getDefaultHigh().getString();
            }
            case 13: {
                return ((VariableRecord)this.mRecord).getDescription();
            }
        }
        return null;
    }

    private static String toModelString(DateTimeValue dateTimeValue) {
        String dateTimeString = null;
        if (dateTimeValue != null && dateTimeValue.getDate() != null) {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSS'Z'");
            formatter.setTimeZone(TimeZone.getTimeZone("GMT"));
            dateTimeString = formatter.format(dateTimeValue.getDate());
        }
        return dateTimeString;
    }
}

