/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfwa4j.adaptorBW;

import com.cognos.mfw4j.framework.MFWMetadataSource;
import com.cognos.mfw4j.framework.MFWModelRes;
import com.cognos.mfw4j.framework.MFWNodeObject;
import com.cognos.mfw4j.framework.MFWRequestContextUser;
import com.cognos.mfw4j.utilities.MFWException;
import com.cognos.mfwa4j.adaptorBW.MFWMetadataXQERequest;
import com.cognos.mfwa4j.adaptorBW.MFWMetadataXQEResponseEntity;
import java.util.ArrayList;
import java.util.Map;

final class MFWSapBWLocaleHelper {
    private ArrayList mLocales = new ArrayList();

    static String getLocalizedName(MFWNodeObject objNode, String aLocale) {
        String outValue = null;
        MFWModelRes gModelRes = MFWModelRes.getInstance();
        ArrayList vNames = new ArrayList();
        objNode.findObjectNodes(gModelRes.RID_name, gModelRes.RID_locale, aLocale, vNames);
        if (vNames.size() > 0) {
            outValue = ((MFWNodeObject)vNames.get(0)).getPropertyValue(gModelRes.RID__Value);
        }
        if (outValue == null) {
            StringBuffer msg = new StringBuffer("Unable to find a name entry for locale:");
            msg.append(aLocale);
            msg.append(" for object of type:");
            msg.append(objNode.getName());
            MFWException.ASSERT((boolean)false, (String)msg.toString());
        }
        return outValue;
    }

    MFWSapBWLocaleHelper(MFWMetadataSource aMetadataSrc) {
    }

    void destroy() {
        this.mLocales.clear();
    }

    void setupLocales(MFWRequestContextUser aContext, MFWMetadataSource aMetadataSrc, MFWNodeObject projNode, boolean isInitialSetup) {
        this.mLocales.add(aContext.getContentLocale());
        Map allLocales = aMetadataSrc.getAliasInfo();
        allLocales.remove(aContext.getContentLocale());
        this.mLocales.addAll(allLocales.values());
        if (isInitialSetup) {
            this.setupProjectLocales(projNode);
        }
        MFWException.ASSERT((this.mLocales.size() > 0 ? 1 : 0) != 0, (String)"Expecting at least one project locale");
    }

    MFWNodeObject addLocalizedProp(MFWNodeObject parentObj, short ridPropName, String sValue, String sLocale) {
        MFWNodeObject locProp = parentObj.addObjectNode(ridPropName);
        locProp.addProperty(MFWModelRes.getInstance().RID_locale, sLocale);
        locProp.addProperty(MFWModelRes.getInstance().RID__Value, sValue);
        return locProp;
    }

    String getDesignLocale() {
        return (String)this.mLocales.get(0);
    }

    ArrayList getAllLocales() {
        return this.mLocales;
    }

    private void setupProjectLocales(MFWNodeObject projNode) {
        MFWModelRes gModelRes = MFWModelRes.getInstance();
        projNode.addProperty(gModelRes.RID_defaultLocale, (String)this.mLocales.get(0));
        for (int idx = 0; idx < this.mLocales.size(); ++idx) {
            projNode.addProperty(gModelRes.RID_locale, (String)this.mLocales.get(idx));
        }
    }

    MFWNodeObject addLocalizedProperties(MFWNodeObject parentObj, short ridPropName, String sValue, MFWMetadataXQEResponseEntity responseEntity, int propID) {
        MFWNodeObject locProp = this.addLocalizedProp(parentObj, ridPropName, sValue, this.getDesignLocale());
        for (int idx = 1; idx < this.mLocales.size(); ++idx) {
            String aLocale = (String)this.mLocales.get(idx);
            if (responseEntity != null) {
                String sLocalizedVal = responseEntity.getPropertyValue(propID, aLocale);
                this.addLocalizedProp(parentObj, ridPropName, sLocalizedVal != null ? sLocalizedVal : sValue, aLocale);
                continue;
            }
            this.addLocalizedProp(parentObj, ridPropName, sValue, aLocale);
        }
        return locProp;
    }

    public void addAliasTablesForLocales(MFWMetadataXQERequest aMDRequest) {
        for (int idx = 0; idx < this.mLocales.size(); ++idx) {
            aMDRequest.addAliasTable((String)this.mLocales.get(idx), (String)this.mLocales.get(idx));
        }
    }
}

