/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfwa4j.adaptorDim;

import com.cognos.mfw4j.framework.MFWCrnIDGenerator;
import com.cognos.mfw4j.framework.MFWMetadataSource;
import com.cognos.mfw4j.framework.MFWModelRes;
import com.cognos.mfw4j.framework.MFWNodeObject;
import com.cognos.mfw4j.framework.MFWRequestContextUser;
import com.cognos.mfw4j.utilities.MFWException;
import com.cognos.mfw4j.utilities.MFWStringHelper;
import com.cognos.xqe.metadata.record.MetadataRecord;
import com.cognos.xqe.util.ILocalizedString;
import com.cognos.xqe.util.LocalizedString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class MFWDimLocaleHelper {
    private ArrayList<String> mLocales = new ArrayList();
    private HashMap<String, DimAliasInfo> mDimension2Aliases = null;

    static ArrayList<String> getProjectLocales(MFWNodeObject objNode) {
        MFWModelRes gModelRes = MFWModelRes.getInstance();
        MFWNodeObject parentProj = objNode.getCluster().getRootNode().getObjectNode(gModelRes.RID_project);
        MFWException.ASSERT((parentProj != null ? 1 : 0) != 0, (String)"Parent project node must exist");
        List vModelLocales = parentProj.getPropertyValues(gModelRes.RID_locale);
        ArrayList<String> outLocales = new ArrayList<String>(vModelLocales.size());
        String defaultLocale = parentProj.getPropertyValue(gModelRes.RID_defaultLocale);
        MFWException.ASSERT((defaultLocale != null && defaultLocale.length() > 0 ? 1 : 0) != 0, (String)"Expecting a valid default locale");
        outLocales.add(defaultLocale);
        for (int idx = 0; idx < vModelLocales.size(); ++idx) {
            if (defaultLocale.equals(vModelLocales.get(idx))) continue;
            outLocales.add((String)vModelLocales.get(idx));
        }
        return outLocales;
    }

    static String getLocalizedName(MFWNodeObject objNode, String aLocale) {
        String outValue = null;
        MFWModelRes gModelRes = MFWModelRes.getInstance();
        ArrayList vNames = new ArrayList();
        objNode.findObjectNodes(gModelRes.RID_name, gModelRes.RID_locale, aLocale, vNames);
        if (vNames.size() > 0) {
            outValue = ((MFWNodeObject)vNames.get(vNames.size() - 1)).getPropertyValue(gModelRes.RID__Value);
        }
        if (outValue == null) {
            StringBuffer msg = new StringBuffer("Unable to find a name entry for locale:");
            msg.append(aLocale);
            msg.append(" for object of type:");
            msg.append(objNode.getName());
            MFWException.ASSERT((boolean)false, (String)msg.toString());
        }
        return outValue;
    }

    MFWDimLocaleHelper(MFWMetadataSource aMetadataSrc) {
        Set locales = aMetadataSrc.getAliasInfo().keySet();
        if (!locales.isEmpty()) {
            this.mLocales.addAll(locales);
        }
        this.mDimension2Aliases = new HashMap();
        if ("TM".equals(aMetadataSrc.getType())) {
            this.extractDimensionBasedAliasInfo(aMetadataSrc);
        }
    }

    void destroy() {
        this.mLocales.clear();
        for (DimAliasInfo aliasInfo : this.mDimension2Aliases.values()) {
            aliasInfo.destroy();
        }
        this.mDimension2Aliases.clear();
    }

    void setupLocales(MFWRequestContextUser aContext, MFWNodeObject projNode, MFWNodeObject linkNodeParent, boolean isInitialSetup) {
        if (linkNodeParent == null) {
            this.mLocales.add(aContext.getContentLocale());
        } else {
            this.mLocales = MFWDimLocaleHelper.getProjectLocales(linkNodeParent);
        }
        if (isInitialSetup) {
            this.setupProjectLocales(projNode);
        }
        MFWException.ASSERT((this.mLocales.size() > 0 ? 1 : 0) != 0, (String)"Expecting at least one project locale");
    }

    MFWNodeObject addLocalizedProp(MFWNodeObject parentObj, short ridPropName, String sValue, String sLocale) {
        MFWNodeObject locProp = parentObj.addObjectNode(ridPropName);
        locProp.addProperty(MFWModelRes.getInstance().RID_locale, sLocale);
        locProp.addProperty(MFWModelRes.getInstance().RID__Value, sValue);
        return locProp;
    }

    String getDesignLocale() {
        return this.mLocales.get(0);
    }

    ArrayList<String> getAllLocales() {
        return this.mLocales;
    }

    void setupAlaisParamMaps(MFWMetadataSource aMetadataSrc, MFWCrnIDGenerator idGenerator, MFWNodeObject projNode, MFWNodeObject dataSrcNode, String sDataSrcName) {
        MFWModelRes gModelRes = MFWModelRes.getInstance();
        if (aMetadataSrc.getAliasInfo().size() == 0) {
            return;
        }
        MFWNodeObject paramMaps = projNode.getObjectNode(gModelRes.RID_parameterMaps);
        if (paramMaps == null) {
            paramMaps = projNode.addObjectNode(gModelRes.RID_parameterMaps);
        }
        if ("TM".equals(aMetadataSrc.getType())) {
            for (DimAliasInfo aliasInfo : this.mDimension2Aliases.values()) {
                aliasInfo.mParamMapRef = this.createAlaisParamMap(idGenerator, paramMaps, aliasInfo.mDimName, aliasInfo.mLocale2Aliases);
            }
        } else {
            String sMapID = this.createAlaisParamMap(idGenerator, paramMaps, sDataSrcName, aMetadataSrc.getAliasInfo());
            dataSrcNode.addProperty(gModelRes.RID_aliasTableMapRef, sMapID);
        }
    }

    private String createAlaisParamMap(MFWCrnIDGenerator idGenerator, MFWNodeObject paramMaps, String sParamMapName, Map localTablePairs) {
        MFWModelRes gModelRes = MFWModelRes.getInstance();
        MFWNodeObject paramMap = paramMaps.addObjectNode(gModelRes.RID_parameterMap);
        String sCleanedName = null;
        if (sParamMapName.charAt(0) == '_') {
            int offset;
            for (offset = 1; offset < sParamMapName.length() && sParamMapName.charAt(offset) == '_'; ++offset) {
            }
            sCleanedName = offset < sParamMapName.length() ? sParamMapName.substring(offset) : "parameterMap";
        } else {
            sCleanedName = sParamMapName;
        }
        String sUsedName = idGenerator.generate(paramMap, sCleanedName, true);
        paramMap.addProperty(gModelRes.RID_name, sUsedName);
        for (Map.Entry entry : localTablePairs.entrySet()) {
            MFWNodeObject mapEntry = paramMap.addObjectNode(gModelRes.RID_parameterMapEntry);
            String aName = idGenerator.generate(mapEntry, (String)entry.getKey(), true);
            mapEntry.addProperty(gModelRes.RID_key, aName);
            mapEntry.addProperty(gModelRes.RID_value, (String)entry.getValue());
        }
        String sMapID = paramMap.getPropertyValue(gModelRes.RID_ID);
        return sMapID;
    }

    void setAialsTableMapRefForDimension(MFWNodeObject objDim, String dimUName) {
        DimAliasInfo anAliasInfo = this.mDimension2Aliases.get(dimUName);
        if (anAliasInfo != null) {
            objDim.addProperty(MFWModelRes.getInstance().RID_aliasTableMapRef, anAliasInfo.mParamMapRef);
        }
    }

    private void setupProjectLocales(MFWNodeObject projNode) {
        MFWModelRes gModelRes = MFWModelRes.getInstance();
        projNode.addProperty(gModelRes.RID_defaultLocale, this.mLocales.get(0));
        for (int idx = 0; idx < this.mLocales.size(); ++idx) {
            projNode.addProperty(gModelRes.RID_locale, this.mLocales.get(idx));
        }
    }

    private void extractDimensionBasedAliasInfo(MFWMetadataSource aMetadataSrc) {
        for (Map.Entry aPair : aMetadataSrc.getAliasInfo().entrySet()) {
            ArrayList vSplitAliasInfo = new ArrayList();
            MFWStringHelper.split((String)((String)aPair.getKey()), (String)"+++***DELIMITER***+++", vSplitAliasInfo);
            if (vSplitAliasInfo.size() != 3) continue;
            DimAliasInfo anAliasInfo = this.mDimension2Aliases.get((String)vSplitAliasInfo.get(0));
            if (anAliasInfo == null) {
                anAliasInfo = new DimAliasInfo((String)vSplitAliasInfo.get(1));
                this.mDimension2Aliases.put((String)vSplitAliasInfo.get(0), anAliasInfo);
            }
            anAliasInfo.mLocale2Aliases.put((String)vSplitAliasInfo.get(2), (String)aPair.getValue());
        }
    }

    MFWNodeObject addLocalizedProperties(MFWNodeObject parentObj, short ridPropName, String sValue, MetadataRecord responseEntity, ELocalizedProp eProp) {
        MFWNodeObject locProp = this.addLocalizedProp(parentObj, ridPropName, sValue, this.getDesignLocale());
        int startWith = 1;
        LocalizedString caption = null;
        if (responseEntity != null) {
            caption = responseEntity.getCaption();
        }
        if (caption != null && caption.isOverrideDefault()) {
            startWith = 0;
        }
        for (int idx = startWith; idx < this.mLocales.size(); ++idx) {
            String aLocale = this.mLocales.get(idx);
            if (responseEntity != null) {
                String sLocalizedVal = null;
                switch (eProp) {
                    case ePropertyCaption: {
                        sLocalizedVal = responseEntity.getCaption().toString(aLocale);
                        break;
                    }
                    case ePropertyDescription: {
                        sLocalizedVal = responseEntity.getDescription();
                        break;
                    }
                    case ePropertyMacroName: {
                        sLocalizedVal = responseEntity.getName();
                        break;
                    }
                    default: {
                        MFWException.ASSERT((boolean)false, (String)"Unexpected localized property");
                    }
                }
                this.addLocalizedProp(parentObj, ridPropName, sLocalizedVal != null ? sLocalizedVal : sValue, aLocale);
                continue;
            }
            this.addLocalizedProp(parentObj, ridPropName, sValue, aLocale);
        }
        return locProp;
    }

    MFWNodeObject addLocalizedProperties(MFWNodeObject parentObj, short ridPropName, String sValue, ILocalizedString sLocValue) {
        MFWNodeObject locProp = this.addLocalizedProp(parentObj, ridPropName, sValue, this.getDesignLocale());
        for (int idx = 1; idx < this.mLocales.size(); ++idx) {
            String aLocale = this.mLocales.get(idx);
            this.addLocalizedProp(parentObj, ridPropName, sLocValue.toString(aLocale), aLocale);
        }
        return locProp;
    }

    Map<String, Object> getEmptyAliasTablesForLocales() {
        LinkedHashMap<String, Object> locales = new LinkedHashMap<String, Object>();
        this.addEmptyAliasTablesForLocales(locales);
        return locales;
    }

    Map<String, Object> getAliasTables(short objRID, MFWMetadataSource aMetadataSrc, MFWNodeObject parentNode) {
        MFWModelRes gModelRes = MFWModelRes.getInstance();
        LinkedHashMap<String, Object> outMap = new LinkedHashMap<String, Object>();
        boolean isTMR = "TMR".equals(aMetadataSrc.getType());
        if (isTMR) {
            this.addEmptyAliasTablesForLocales(outMap);
        }
        if (isTMR || "TM".equals(aMetadataSrc.getType())) {
            if (objRID == gModelRes.RID_dimension || objRID == gModelRes.RID_cube) {
                for (DimAliasInfo aliasInfo : this.mDimension2Aliases.values()) {
                    this.addAliasTablesForLocales(aliasInfo.mLocale2Aliases, outMap);
                }
            } else {
                DimAliasInfo aliasInfo;
                String propExtName = null;
                while (propExtName == null && parentNode != null && parentNode.getNameRID() != gModelRes.RID_namespace) {
                    if (parentNode.getNameRID() == gModelRes.RID_dimension) {
                        propExtName = parentNode.getPropertyValue(gModelRes.RID_externalName);
                    }
                    parentNode = parentNode.getParentObject();
                }
                if (propExtName != null && (aliasInfo = this.mDimension2Aliases.get(propExtName)) != null) {
                    this.addAliasTablesForLocales(aliasInfo.mLocale2Aliases, outMap);
                }
            }
        } else {
            this.addAliasTablesForLocales(aMetadataSrc.getAliasInfo(), outMap);
        }
        return outMap;
    }

    private void addEmptyAliasTablesForLocales(Map<String, Object> outMap) {
        for (String locale : this.mLocales) {
            outMap.put(locale, "");
        }
    }

    private void addAliasTablesForLocales(Map<String, ? extends Object> local2AliasTables, Map<String, Object> outMap) {
        String sAliasTable = (String)local2AliasTables.get(this.mLocales.get(0));
        if (sAliasTable != null && sAliasTable.length() > 0) {
            outMap.put(this.mLocales.get(0), sAliasTable);
        }
        for (int idx = 1; idx < this.mLocales.size(); ++idx) {
            String locale = this.mLocales.get(idx);
            sAliasTable = (String)local2AliasTables.get(locale);
            if (outMap.containsKey(locale)) {
                if (sAliasTable == null) continue;
                String existingValue = (String)outMap.get(locale);
                if (existingValue == null) {
                    outMap.put(this.mLocales.get(idx), sAliasTable);
                    continue;
                }
                sAliasTable = existingValue + ';' + sAliasTable;
                outMap.put(this.mLocales.get(idx), sAliasTable);
                continue;
            }
            outMap.put(this.mLocales.get(idx), sAliasTable);
        }
    }

    private static class DimAliasInfo {
        private String mDimName = null;
        private HashMap<String, String> mLocale2Aliases = null;
        private String mParamMapRef = null;

        DimAliasInfo(String dimName) {
            this.mDimName = dimName;
            this.mLocale2Aliases = new HashMap();
            this.mParamMapRef = null;
        }

        void destroy() {
            this.mLocale2Aliases.clear();
        }
    }

    static enum ELocalizedProp {
        ePropertyUnknown,
        ePropertyCaption,
        ePropertyDescription,
        ePropertyMacroName;

    }
}

