/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfwa4j.adaptorDim;

import com.cognos.mfw4j.framework.MFWCluster;
import com.cognos.mfw4j.framework.MFWCrnIDGenerator;
import com.cognos.mfw4j.framework.MFWInfo;
import com.cognos.mfw4j.framework.MFWInfoObject;
import com.cognos.mfw4j.framework.MFWInfoProperty;
import com.cognos.mfw4j.framework.MFWMetadataSource;
import com.cognos.mfw4j.framework.MFWModelRes;
import com.cognos.mfw4j.framework.MFWNodeObject;
import com.cognos.mfw4j.framework.MFWQuerySpec;
import com.cognos.mfw4j.framework.MFWRequestContextUser;
import com.cognos.mfw4j.utilities.MFWConfiguration;
import com.cognos.mfw4j.utilities.MFWException;
import com.cognos.mfw4j.utilities.MFWStringHelper;
import com.cognos.mfwa4j.adaptorDim.MFWDimConnection;
import com.cognos.mfwa4j.adaptorDim.MFWDimLocaleHelper;
import com.cognos.mfwa4j.adaptorDim.MFWMUNTransformations;
import com.cognos.mfwa4j.adaptorDim.MFWMetadataResponse;
import com.cognos.mfwa4j.adaptorDim.MFWOLAPSchema;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.metadata.DimensionTypeEnum;
import com.cognos.xqe.metadata.IAggregateRule;
import com.cognos.xqe.metadata.record.CubeRecord;
import com.cognos.xqe.metadata.record.DimensionRecord;
import com.cognos.xqe.metadata.record.HierarchyNamedSetRecord;
import com.cognos.xqe.metadata.record.HierarchyRecord;
import com.cognos.xqe.metadata.record.LevelRecord;
import com.cognos.xqe.metadata.record.MacroRecord;
import com.cognos.xqe.metadata.record.MeasureRecord;
import com.cognos.xqe.metadata.record.MemberRecord;
import com.cognos.xqe.metadata.record.MetadataRecord;
import com.cognos.xqe.metadata.record.NamedSetRecord;
import com.cognos.xqe.metadata.record.PropertyRecord;
import com.cognos.xqe.util.ILocalizedString;
import com.cognos.xqe.util.LocalizedString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

final class MFWDimObjectLoader {
    private static final boolean gIncludeCubeNameInDataSourceName = !"false".equals(MFWConfiguration.getInstance().getGeneralCapability("includeCubeNameInDataSourceName"));
    private static MFWModelRes gModelRes = MFWModelRes.getInstance();
    private MFWDimConnection mDimConnection;
    private MFWCrnIDGenerator mIDGenerator;
    MFWDimLocaleHelper mHlprLocale;
    String mDataSourceId;
    private boolean mSupportsDisplayPath;
    private boolean mAggregateRules;

    MFWDimObjectLoader(MFWDimConnection dimConnection, MFWDimLocaleHelper hlprLocale) {
        this.mDimConnection = dimConnection;
        this.mIDGenerator = new MFWCrnIDGenerator(dimConnection.getCluster());
        this.mHlprLocale = hlprLocale;
        this.mDataSourceId = null;
        String sDispPath = this.mDimConnection.getAdaptor().getSourceConfig().getCapability("Display_Path");
        this.mSupportsDisplayPath = "true".equals(sDispPath);
        String sAggrRules = this.mDimConnection.getAdaptor().getSourceConfig().getCapability("aggregateRules");
        this.mAggregateRules = "true".equals(sAggrRules);
    }

    void destroy() {
        this.mDimConnection = null;
        this.mIDGenerator.destroy();
        this.mHlprLocale = null;
    }

    MFWCrnIDGenerator getIDGenerator() {
        return this.mIDGenerator;
    }

    void populateCluster(MFWRequestContextUser aContext, MFWQuerySpec querySpec, short olapType, MFWNodeObject objNode, List<? extends MetadataRecord> response) {
        switch (olapType) {
            case 3: {
                this.populateDimensions(aContext, querySpec, objNode, response);
                break;
            }
            case 4: {
                this.populateHierarchies(aContext, querySpec, objNode, response);
                break;
            }
            case 8: {
                this.populateHierarchyRootMember(aContext, querySpec, objNode, response);
                break;
            }
            case 9: {
                this.populateHierarchyCalculatedMember(aContext, querySpec, objNode, response);
                break;
            }
            case 5: {
                this.populateLevels(aContext, querySpec, objNode, response);
                break;
            }
            case 1: {
                this.populateAttributes(aContext, querySpec, objNode, response);
                break;
            }
            case 7: 
            case 14: {
                this.populateMeasuresOrFolders(aContext, querySpec, objNode, response);
                break;
            }
            case 10: {
                this.populateNamedSets(aContext, querySpec, objNode, response);
                break;
            }
            case 15: {
                this.populateHierarchyNamedSets(aContext, querySpec, objNode, response);
                break;
            }
            case 6: {
                this.populateMacros(aContext, querySpec, objNode, response);
                break;
            }
            default: {
                MFWException.ASSERT((boolean)false, (String)"Unknown OLAP object type to query:", (String)(Integer.toString(olapType) + "=" + MFWOLAPSchema.gOLAPTypeNames[olapType]));
            }
        }
    }

    MFWNodeObject setupProject(MFWNodeObject rootNode, MFWMetadataSource aMetadataSrc) {
        String sCmDataSrcName = (String)aMetadataSrc.getConnectionItem("cmDataSource");
        MFWNodeObject projNode = rootNode.addObjectNode(MFWDimObjectLoader.gModelRes.RID_project);
        MFWException.ASSERT((projNode != null ? 1 : 0) != 0, (String)"Failed to create the project node");
        projNode.addProperty(MFWDimObjectLoader.gModelRes.RID_ID, "[]");
        String sUsedName = sCmDataSrcName == null || sCmDataSrcName.length() == 0 ? "olapProj" : sCmDataSrcName;
        projNode.addProperty(MFWDimObjectLoader.gModelRes.RID_name, sUsedName);
        projNode.addObjectNode(MFWDimObjectLoader.gModelRes.RID_parameterMaps);
        projNode.addObjectNode(MFWDimObjectLoader.gModelRes.RID_securityViews);
        return projNode;
    }

    MFWNodeObject setupRootNamespace(MFWNodeObject projNode, MFWNodeObject linkParent, String sCubeName) {
        MFWNodeObject nsNode = projNode.addExpandableObjectNode(MFWDimObjectLoader.gModelRes.RID_namespace);
        if (linkParent != null) {
            String sNSName = MFWDimLocaleHelper.getLocalizedName(linkParent, this.mHlprLocale.getDesignLocale());
            String sUsedName = this.mIDGenerator.generate(nsNode, sNSName, true);
            MFWException.ASSERT((boolean)sUsedName.equals(sNSName), (String)"The name of the OLAP root namespace must be the same as the name in the parent cluster");
            this.mHlprLocale.addLocalizedProp(nsNode, MFWDimObjectLoader.gModelRes.RID_name, sUsedName, this.mHlprLocale.getDesignLocale());
            ArrayList<String> vAltLocales = this.mHlprLocale.getAllLocales();
            for (int lIdx = 0; lIdx < vAltLocales.size(); ++lIdx) {
                sNSName = MFWDimLocaleHelper.getLocalizedName(linkParent, vAltLocales.get(lIdx));
                if (0 == lIdx && sUsedName.equals(sNSName)) continue;
                this.mHlprLocale.addLocalizedProp(nsNode, MFWDimObjectLoader.gModelRes.RID_name, sNSName, vAltLocales.get(lIdx));
            }
        } else {
            String sUsedName = this.mIDGenerator.generate(nsNode, sCubeName, true);
            this.mHlprLocale.addLocalizedProperties(nsNode, MFWDimObjectLoader.gModelRes.RID_name, sUsedName, null, MFWDimLocaleHelper.ELocalizedProp.ePropertyUnknown);
        }
        return nsNode;
    }

    MFWNodeObject reconstructDataSource(MFWNodeObject projNode) {
        MFWNodeObject dsNode = projNode.getObjectNode(MFWDimObjectLoader.gModelRes.RID_dataSource);
        MFWException.ASSERT((dsNode != null ? 1 : 0) != 0, (String)"Expecting a valid data source object --- DimObjectLoader::reconstructDataSource");
        this.mDataSourceId = dsNode.getPropertyValue(MFWDimObjectLoader.gModelRes.RID_ID);
        MFWException.ASSERT((this.mDataSourceId != null ? 1 : 0) != 0, (String)"Failed to query an ID property");
        return dsNode;
    }

    MFWNodeObject setupDataSource(MFWRequestContextUser aContext, MFWNodeObject projNode, MFWMetadataSource aMetadataSrc, String sCubeName) {
        MFWNodeObject dsNode = projNode.addExpandableObjectNode(MFWDimObjectLoader.gModelRes.RID_dataSource);
        StringBuilder sDataSrcName = new StringBuilder((String)aMetadataSrc.getConnectionItem("cmDataSource"));
        if ((gIncludeCubeNameInDataSourceName || sDataSrcName.length() == 0) && sCubeName != null) {
            sDataSrcName.append("-");
            sDataSrcName.append(sCubeName);
        }
        String sCmDataSrcUniqueName = this.makeDatasourceNameUnique(aContext, sDataSrcName.toString());
        String sUsedName = this.mIDGenerator.generate(dsNode, sCmDataSrcUniqueName, true);
        this.mDataSourceId = dsNode.getPropertyValue(MFWDimObjectLoader.gModelRes.RID_ID);
        MFWException.ASSERT((this.mDataSourceId != null ? 1 : 0) != 0, (String)"Failed to generate an ID property");
        dsNode.addProperty(MFWDimObjectLoader.gModelRes.RID_name, sUsedName);
        String temp = (String)aMetadataSrc.getConnectionItem("cmDataSource");
        if (temp != null) {
            dsNode.addProperty(MFWDimObjectLoader.gModelRes.RID_cmDataSource, temp);
        } else {
            dsNode.addProperty(MFWDimObjectLoader.gModelRes.RID_cmDataSource, sCubeName);
        }
        temp = (String)aMetadataSrc.getScope("catalog");
        if (temp != null) {
            dsNode.addProperty(MFWDimObjectLoader.gModelRes.RID_catalog, temp);
        }
        if ((temp = (String)aMetadataSrc.getScope("schema")) != null) {
            dsNode.addProperty(MFWDimObjectLoader.gModelRes.RID_schema, temp);
        }
        dsNode.addProperty(MFWDimObjectLoader.gModelRes.RID_cube, sCubeName);
        dsNode.addProperty(MFWDimObjectLoader.gModelRes.RID_queryType, "multidimensional");
        dsNode.addProperty(MFWDimObjectLoader.gModelRes.RID_interface, aMetadataSrc.getType());
        String tempValue = (String)aMetadataSrc.getConnectionItem("attribute");
        if ("dimension".equals(tempValue)) {
            dsNode.addProperty(gModelRes.getResourceID("attributeDimensionsAsProperties"), "false");
        }
        this.mHlprLocale.setupAlaisParamMaps(aMetadataSrc, this.mIDGenerator, projNode, dsNode, sUsedName);
        return dsNode;
    }

    void populateCubeProps(MFWNodeObject dataSourceNode, String cubePath, CubeRecord cubeEntity) {
        MFWException.ASSERT((cubeEntity != null ? 1 : 0) != 0, (String)"Expecting at least one entry in response to Cube properties query");
        String sTemp = null;
        sTemp = cubeEntity.getDescription();
        if (sTemp != null && sTemp.length() > 0) {
            dataSourceNode.addProperty(MFWDimObjectLoader.gModelRes.RID_cubeDescription, sTemp);
        }
        if (cubePath != null && cubePath.length() > 0) {
            dataSourceNode.addProperty(MFWDimObjectLoader.gModelRes.RID_cubePath, cubePath);
        }
        if ((sTemp = MFWMetadataResponse.toModelString(cubeEntity.getCreatedDate())) != null && sTemp.length() > 0) {
            dataSourceNode.addProperty(MFWDimObjectLoader.gModelRes.RID_cubeCreatedOn, sTemp);
        }
        if ((sTemp = MFWMetadataResponse.toModelString(cubeEntity.getDataUpdateDate())) != null && sTemp.length() > 0) {
            dataSourceNode.addProperty(MFWDimObjectLoader.gModelRes.RID_cubeDataUpdatedOn, sTemp);
        }
        if ((sTemp = MFWMetadataResponse.toModelString(cubeEntity.getSchemaUpdateDate())) != null && sTemp.length() > 0) {
            dataSourceNode.addProperty(MFWDimObjectLoader.gModelRes.RID_cubeSchemaUpdatedOn, sTemp);
        }
        if ((sTemp = MFWMetadataResponse.toModelString(cubeEntity.getIsOptimized())) != null && sTemp.length() > 0) {
            dataSourceNode.addProperty(MFWDimObjectLoader.gModelRes.RID_cubeIsOptimized, sTemp);
        }
        if ((sTemp = cubeEntity.getCurrentPeriod()) != null && sTemp.length() > 0) {
            dataSourceNode.addProperty(MFWDimObjectLoader.gModelRes.RID_cubeCurrentPeriod, sTemp);
        }
        if ((sTemp = MFWMetadataResponse.toModelString(cubeEntity.getSuppressionType())) != null && sTemp.length() > 0) {
            dataSourceNode.addProperty(MFWDimObjectLoader.gModelRes.RID_suppression, sTemp);
        }
    }

    private String genObjectProperties(MetadataRecord anEntity, MFWNodeObject objNode, MFWDimLocaleHelper.ELocalizedProp eNameProp, boolean isHidden, boolean isNotAccessible) {
        MFWException.ASSERT((eNameProp == MFWDimLocaleHelper.ELocalizedProp.ePropertyCaption || eNameProp == MFWDimLocaleHelper.ELocalizedProp.ePropertyMacroName ? 1 : 0) != 0, (String)"Unexpected name property");
        String sCaption = eNameProp == MFWDimLocaleHelper.ELocalizedProp.ePropertyCaption ? anEntity.getCaption().toString() : anEntity.getName();
        String sDescription = anEntity.getDescription();
        String sUsedName = this.mIDGenerator.generate(objNode, sCaption, true);
        this.mHlprLocale.addLocalizedProperties(objNode, MFWDimObjectLoader.gModelRes.RID_name, sUsedName, anEntity, eNameProp);
        if (sDescription != null && sDescription.length() > 0) {
            this.mHlprLocale.addLocalizedProperties(objNode, MFWDimObjectLoader.gModelRes.RID_description, sDescription, anEntity, MFWDimLocaleHelper.ELocalizedProp.ePropertyDescription);
        }
        if (isHidden) {
            if (isNotAccessible) {
                objNode.addProperty(MFWDimObjectLoader.gModelRes.RID_visible, "hidden");
            } else {
                objNode.addProperty(MFWDimObjectLoader.gModelRes.RID_visible, "hiddenAndAccessible");
            }
        } else if (isNotAccessible) {
            objNode.addProperty(MFWDimObjectLoader.gModelRes.RID_visible, "visible");
        }
        String objID = objNode.getPropertyValue(MFWDimObjectLoader.gModelRes.RID_ID);
        MFWException.ASSERT((objID != null ? 1 : 0) != 0, (String)"Expecting a valid ID property");
        return objID;
    }

    private String genObjectProperties(String sCaption, String sDescription, MFWNodeObject objNode) {
        String objID;
        String sUsedName = this.mIDGenerator.generate(objNode, sCaption, true);
        this.mHlprLocale.addLocalizedProperties(objNode, MFWDimObjectLoader.gModelRes.RID_name, sUsedName, null, MFWDimLocaleHelper.ELocalizedProp.ePropertyUnknown);
        if (sDescription != null && sDescription.length() > 0) {
            this.mHlprLocale.addLocalizedProperties(objNode, MFWDimObjectLoader.gModelRes.RID_description, sDescription, null, MFWDimLocaleHelper.ELocalizedProp.ePropertyUnknown);
        }
        MFWException.ASSERT(((objID = objNode.getPropertyValue(MFWDimObjectLoader.gModelRes.RID_ID)) != null ? 1 : 0) != 0, (String)"Expecting a valid ID property");
        return objID;
    }

    private String genObjectProperties(String sCaption, ILocalizedString sLocCaption, String sDescription, MFWNodeObject objNode) {
        String objID;
        String sUsedName = this.mIDGenerator.generate(objNode, sCaption, true);
        this.mHlprLocale.addLocalizedProperties(objNode, MFWDimObjectLoader.gModelRes.RID_name, sUsedName, sLocCaption);
        if (sDescription != null && sDescription.length() > 0) {
            this.mHlprLocale.addLocalizedProperties(objNode, MFWDimObjectLoader.gModelRes.RID_description, sDescription, null, MFWDimLocaleHelper.ELocalizedProp.ePropertyUnknown);
        }
        MFWException.ASSERT(((objID = objNode.getPropertyValue(MFWDimObjectLoader.gModelRes.RID_ID)) != null ? 1 : 0) != 0, (String)"Expecting a valid ID property");
        return objID;
    }

    private void populateDimensions(MFWRequestContextUser aContext, MFWQuerySpec querySpec, MFWNodeObject objNode, List<? extends MetadataRecord> response) {
        ArrayList<MFWNodeObject> vMsrDims = new ArrayList<MFWNodeObject>();
        ArrayList<MFWNodeObject> vRegDims = new ArrayList<MFWNodeObject>();
        String sDimGrp = this.mDimConnection.getAdaptor().getSourceConfig().getCapability("dimensionGroup");
        boolean bSupportsDimGroup = "true".equals(sDimGrp);
        ArrayList<String> vDuplicateNames = new ArrayList<String>();
        if (bSupportsDimGroup) {
            this.collectConflictingFolderNames(response, vDuplicateNames);
        }
        HashMap<String, MFWNodeObject> mapDim2Folders = new HashMap<String, MFWNodeObject>();
        for (MetadataRecord metadataRecord : response) {
            DimensionRecord dimRecord = (DimensionRecord)metadataRecord;
            String sDimGroupName = null;
            if (bSupportsDimGroup) {
                sDimGroupName = dimRecord.getDimensionGroupName();
            }
            MFWNodeObject dimObj = null;
            dimObj = sDimGroupName != null && sDimGroupName.length() > 0 ? this.addDimensionToFolder(objNode, sDimGroupName, vDuplicateNames, mapDim2Folders) : objNode.addExpandableObjectNode(MFWDimObjectLoader.gModelRes.RID_dimension);
            this.genObjectProperties((MetadataRecord)dimRecord, dimObj, MFWDimLocaleHelper.ELocalizedProp.ePropertyCaption, dimRecord.isHidden(), dimRecord.isNotAccessible());
            String sTemp = dimRecord.getUniqueId();
            dimObj.addProperty(MFWDimObjectLoader.gModelRes.RID_PPDS_CODE, sTemp);
            dimObj.addProperty(MFWDimObjectLoader.gModelRes.RID_definitionType, "mdQuery");
            dimObj.addProperty(MFWDimObjectLoader.gModelRes.RID_dataSourceRef, this.mDataSourceId);
            sTemp = dimRecord.getUniqueName();
            dimObj.addProperty(MFWDimObjectLoader.gModelRes.RID_externalName, sTemp);
            this.mHlprLocale.setAialsTableMapRefForDimension(dimObj, sTemp);
            dimObj.addProperty(MFWDimObjectLoader.gModelRes.RID_type, dimRecord.getType().toFMType());
            MFWNodeObject objMDDS = dimObj.addObjectNode(MFWDimObjectLoader.gModelRes.RID_property);
            objMDDS.addProperty(MFWDimObjectLoader.gModelRes.RID_name, "MDDSType");
            objMDDS.addProperty(MFWDimObjectLoader.gModelRes.RID__Value, dimRecord.getType().toMDDSType());
            MFWNodeObject objAttributeDim = dimObj.addObjectNode(MFWDimObjectLoader.gModelRes.RID_property);
            objAttributeDim.addProperty(MFWDimObjectLoader.gModelRes.RID_name, "isAttributeDimension");
            if (dimRecord.getIsAttributeDimension() == null) {
                objAttributeDim.addProperty(MFWDimObjectLoader.gModelRes.RID__Value, "false");
            } else {
                objAttributeDim.addProperty(MFWDimObjectLoader.gModelRes.RID__Value, Boolean.toString(dimRecord.getIsAttributeDimension()));
            }
            dimObj.addProperty(MFWDimObjectLoader.gModelRes.RID_membersRollup, dimRecord.getMembersRollup());
            if (dimRecord.getType() == DimensionTypeEnum.MEASURE) {
                vMsrDims.add(dimObj);
                String sLevelInfo = this.mDimConnection.getMeasureHierarchyInfo(dimObj, aContext);
                MFWNodeObject hierarchyProp = dimObj.addObjectNode(MFWDimObjectLoader.gModelRes.RID_property);
                hierarchyProp.addProperty(MFWDimObjectLoader.gModelRes.RID_name, "measureHierarchyInfo");
                hierarchyProp.addProperty(MFWDimObjectLoader.gModelRes.RID__Value, sLevelInfo);
                continue;
            }
            vRegDims.add(dimObj);
            sTemp = dimRecord.getDefaultHierarchyUniqueName();
            this.mDimConnection.expandChildren(aContext, querySpec, dimObj, MFWDimObjectLoader.gModelRes.RID_hierarchy);
            ArrayList childObjects = new ArrayList();
            dimObj.findObjectNodesRecursively(MFWDimObjectLoader.gModelRes.RID_hierarchy, MFWDimObjectLoader.gModelRes.RID_hierarchyFolder, MFWDimObjectLoader.gModelRes.RID_externalName, sTemp, true, childObjects);
            MFWException.ASSERT((childObjects.size() == 1 ? 1 : 0) != 0, (String)"Expecting one hierarchy object for dimension's specified default hierarchy:", (String)sTemp);
            String anID = ((MFWNodeObject)childObjects.get(0)).getPropertyValue(MFWDimObjectLoader.gModelRes.RID_ID);
            MFWException.ASSERT((anID != null ? 1 : 0) != 0, (String)"Expecting an ID property for the default hierarchy");
            dimObj.addProperty(MFWDimObjectLoader.gModelRes.RID_defaultHierarchy, anID);
        }
        this.populateScopeRelations(objNode, vMsrDims, vRegDims);
    }

    private MFWNodeObject addDimensionToFolder(MFWNodeObject parentObj, String sDimGroupName, ArrayList<String> vConflictingNames, HashMap<String, MFWNodeObject> mapDimGroups) {
        StringBuilder sModifiedName = new StringBuilder("");
        if (vConflictingNames.contains(sDimGroupName)) {
            sModifiedName.append("*");
        }
        sModifiedName.append(sDimGroupName);
        String nameModified = sModifiedName.toString();
        MFWNodeObject objDimFolder = mapDimGroups.get(nameModified);
        if (objDimFolder == null) {
            objDimFolder = parentObj.addObjectNode(MFWDimObjectLoader.gModelRes.RID_folder);
            this.genObjectProperties(nameModified, "", objDimFolder);
            mapDimGroups.put(nameModified, objDimFolder);
        }
        MFWNodeObject dimObj = objDimFolder.addExpandableObjectNode(MFWDimObjectLoader.gModelRes.RID_dimension);
        return dimObj;
    }

    private void populateHierarchies(MFWRequestContextUser aContext, MFWQuerySpec querySpec, MFWNodeObject objNode, List<? extends MetadataRecord> response) {
        HashMap<String, MFWNodeObject> mDispFolders = new HashMap<String, MFWNodeObject>();
        ArrayList<String> vDimCaptions = new ArrayList<String>();
        if (this.mSupportsDisplayPath) {
            this.collectObjectCaptions(response, vDimCaptions);
        }
        for (MetadataRecord metadataRecord : response) {
            HierarchyRecord hryRecord = (HierarchyRecord)metadataRecord;
            String sDispPath = null;
            if (this.mSupportsDisplayPath) {
                sDispPath = hryRecord.getDisplayPath();
            }
            if (sDispPath != null && sDispPath.length() > 0 && !"\\".equals(sDispPath)) {
                ArrayList<MFWNodeObject> vHierFolders = this.addOrFindFoldersForPath(objNode, sDispPath, vDimCaptions, MFWDimObjectLoader.gModelRes.RID_hierarchyFolder, mDispFolders);
                for (int idx = 0; idx < vHierFolders.size(); ++idx) {
                    this.addHierarchy(aContext, querySpec, vHierFolders.get(idx), hryRecord);
                }
                continue;
            }
            this.addHierarchy(aContext, querySpec, objNode, hryRecord);
        }
    }

    private void addHierarchy(MFWRequestContextUser aContext, MFWQuerySpec querySpec, MFWNodeObject parentObj, HierarchyRecord anEntity) {
        MFWNodeObject hierObj = parentObj.addExpandableObjectNode(MFWDimObjectLoader.gModelRes.RID_hierarchy);
        String sTemp = null;
        this.genObjectProperties((MetadataRecord)anEntity, hierObj, MFWDimLocaleHelper.ELocalizedProp.ePropertyCaption, anEntity.isHidden(), anEntity.isNotAccessible());
        sTemp = anEntity.getUniqueId();
        hierObj.addProperty(MFWDimObjectLoader.gModelRes.RID_PPDS_CODE, sTemp);
        sTemp = anEntity.getUniqueName();
        hierObj.addProperty(MFWDimObjectLoader.gModelRes.RID_externalName, sTemp);
        hierObj.addProperty(MFWDimObjectLoader.gModelRes.RID_cardinality, Integer.toString(anEntity.getCardinality()));
        hierObj.addProperty(MFWDimObjectLoader.gModelRes.RID_balanced, MFWMetadataResponse.toModelString(anEntity.isBalanced()));
        hierObj.addProperty(MFWDimObjectLoader.gModelRes.RID_ragged, MFWMetadataResponse.toModelString(anEntity.isRagged()));
        hierObj.addProperty(MFWDimObjectLoader.gModelRes.RID_sortedHierarchy, "none");
        String sParentChild = MFWMetadataResponse.toModelString(anEntity.isParentChild());
        hierObj.addProperty(MFWDimObjectLoader.gModelRes.RID_parentChild, sParentChild);
        sTemp = MFWMetadataResponse.toModelString(anEntity.getAttributeHierarchy());
        if ("true".equals(sTemp)) {
            MFWNodeObject pCustProp = hierObj.addObjectNode(MFWDimObjectLoader.gModelRes.RID_property);
            pCustProp.addProperty(MFWDimObjectLoader.gModelRes.RID_name, "attributeHierarchy");
            pCustProp.addProperty(MFWDimObjectLoader.gModelRes.RID_type, "hidden");
            pCustProp.addProperty(MFWDimObjectLoader.gModelRes.RID__Value, sTemp);
        }
        String sDefaultMem = anEntity.getDefaultMemberUniqueName();
        String modifiedMUN = MFWMUNTransformations.providerMUNToCognosMUN(this.mDimConnection.getSource().getType(), sDefaultMem);
        hierObj.addProperty(gModelRes.getResourceID("defaultMemberExternalName"), modifiedMUN);
        if (anEntity.isParentChild()) {
            String sLevelInfo = this.mDimConnection.getParentChildLevelInfo(hierObj, aContext);
            MFWNodeObject levelsProp = hierObj.addObjectNode(MFWDimObjectLoader.gModelRes.RID_property);
            levelsProp.addProperty(MFWDimObjectLoader.gModelRes.RID_name, "parentChildLevelInfo");
            levelsProp.addProperty(MFWDimObjectLoader.gModelRes.RID__Value, sLevelInfo);
            this.populatePreDefinedAttributes(hierObj);
        }
    }

    private void populateHierarchyRootMember(MFWRequestContextUser aContext, MFWQuerySpec querySpec, MFWNodeObject objNode, List<? extends MetadataRecord> response) {
        boolean bIsSingleRoot = response.size() == 1;
        objNode.addProperty(MFWDimObjectLoader.gModelRes.RID_multiRoot, bIsSingleRoot ? "false" : "true");
        if (bIsSingleRoot) {
            MemberRecord memRecord = (MemberRecord)response.get(0);
            objNode.addProperty(MFWDimObjectLoader.gModelRes.RID_rootMemberRollup, MFWMetadataResponse.toModelString(memRecord.getRollupType()));
            String sTemp = memRecord.getUniqueName();
            String modifiedMUN = MFWMUNTransformations.providerMUNToCognosMUN(this.mDimConnection.getSource().getType(), sTemp);
            objNode.addProperty(MFWDimObjectLoader.gModelRes.RID_rootMUN, modifiedMUN);
            String sCaption = memRecord.getCaption().toString();
            this.mHlprLocale.addLocalizedProperties(objNode, MFWDimObjectLoader.gModelRes.RID_rootCaption, sCaption, (MetadataRecord)memRecord, MFWDimLocaleHelper.ELocalizedProp.ePropertyCaption);
        }
    }

    private void populateHierarchyCalculatedMember(MFWRequestContextUser aContext, MFWQuerySpec querySpec, MFWNodeObject objHrchy, List<? extends MetadataRecord> response) {
        for (MetadataRecord metadataRecord : response) {
            String extendedCalculatedMember;
            MemberRecord memRecord = (MemberRecord)metadataRecord;
            MFWNodeObject objCalcMem = objHrchy.addObjectNode(MFWDimObjectLoader.gModelRes.RID_calculatedMember);
            objCalcMem.addProperty(MFWDimObjectLoader.gModelRes.RID_externalName, memRecord.getUniqueName());
            objCalcMem.addProperty(MFWDimObjectLoader.gModelRes.RID_ID, this.generateUniqueNameForCalculatedMember(memRecord));
            String memExpr = memRecord.getDynamicFieldAsString("calculatedMemberExpression");
            if (memExpr != null && memExpr.length() > 0) {
                String sExprAsText = MFWStringHelper.escapeAndTagStr((String)"expression", (String)memExpr);
                objCalcMem.addProperty(MFWDimObjectLoader.gModelRes.RID_expression, sExprAsText);
            } else {
                this.addPropertyWithDefaultValue(objCalcMem, MFWDimObjectLoader.gModelRes.RID_expression);
            }
            String solveOrder = memRecord.getDynamicFieldAsString("calculatedMemberSolveOrder");
            if (solveOrder != null && solveOrder.length() > 0) {
                objCalcMem.addProperty(MFWDimObjectLoader.gModelRes.RID_solveOrder, solveOrder);
            }
            if ((extendedCalculatedMember = memRecord.getDynamicFieldAsString("extendedCalculatedMember")) == null || extendedCalculatedMember.length() <= 0) continue;
            objCalcMem.addProperty(MFWDimObjectLoader.gModelRes.RID_extendedCalculatedMember, extendedCalculatedMember);
        }
    }

    private String generateUniqueNameForCalculatedMember(MemberRecord memRecord) {
        StringBuffer buf = new StringBuffer();
        buf.append("[calculated member ");
        buf.append(memRecord.getCubeName().replaceAll(Character.toString(']'), "]]"));
        buf.append("].");
        buf.append(memRecord.getUniqueName());
        return buf.toString();
    }

    private void populateLevels(MFWRequestContextUser aContext, MFWQuerySpec querySpec, MFWNodeObject objNode, List<? extends MetadataRecord> response) {
        for (MetadataRecord metadataRecord : response) {
            MFWNodeObject pCustProp;
            LevelRecord lvlRecord = (LevelRecord)metadataRecord;
            MFWNodeObject objLevel = objNode.addExpandableObjectNode(MFWDimObjectLoader.gModelRes.RID_level);
            this.genObjectProperties((MetadataRecord)lvlRecord, objLevel, MFWDimLocaleHelper.ELocalizedProp.ePropertyCaption, lvlRecord.isHidden(), lvlRecord.isNotAccessible());
            objLevel.addProperty(MFWDimObjectLoader.gModelRes.RID_PPDS_CODE, lvlRecord.getUniqueId());
            objLevel.addProperty(MFWDimObjectLoader.gModelRes.RID_isUnique, MFWMetadataResponse.toModelString(lvlRecord.hasUniqueMemberNames()));
            objLevel.addProperty(MFWDimObjectLoader.gModelRes.RID_externalName, lvlRecord.getUniqueName());
            objLevel.addProperty(MFWDimObjectLoader.gModelRes.RID_externalOrdinal, Integer.toString(lvlRecord.getLevelNumber()));
            String sTemp = lvlRecord.getAttributeHierarchyName();
            if (sTemp != null && sTemp.length() > 0) {
                pCustProp = objLevel.addObjectNode(MFWDimObjectLoader.gModelRes.RID_property);
                pCustProp.addProperty(MFWDimObjectLoader.gModelRes.RID_name, "baseAttributeHierarchyRef");
                pCustProp.addProperty(MFWDimObjectLoader.gModelRes.RID_type, "hidden");
                pCustProp.addProperty(MFWDimObjectLoader.gModelRes.RID__Value, sTemp);
            }
            pCustProp = objLevel.addObjectNode(MFWDimObjectLoader.gModelRes.RID_property);
            pCustProp.addProperty(MFWDimObjectLoader.gModelRes.RID_name, "levelCardinality");
            pCustProp.addProperty(MFWDimObjectLoader.gModelRes.RID_type, "hidden");
            pCustProp.addProperty(MFWDimObjectLoader.gModelRes.RID__Value, Integer.toString(lvlRecord.getCardinality()));
            this.populatePreDefinedAttributes(objLevel);
        }
    }

    private void populateAttributes(MFWRequestContextUser aContext, MFWQuerySpec querySpec, MFWNodeObject objNode, List<? extends MetadataRecord> response) {
        String visibleProp = objNode.getPropertyValue(MFWDimObjectLoader.gModelRes.RID_visible);
        if (visibleProp != null && ("hidden".equals(visibleProp) || "hiddenAndAccessible".equals(visibleProp))) {
            return;
        }
        for (MetadataRecord metadataRecord : response) {
            PropertyRecord attrRecord = (PropertyRecord)metadataRecord;
            MFWNodeObject pQIObj = objNode.addObjectNode(MFWDimObjectLoader.gModelRes.RID_queryItem);
            this.genObjectProperties((MetadataRecord)attrRecord, pQIObj, MFWDimLocaleHelper.ELocalizedProp.ePropertyCaption, false, false);
            pQIObj.addProperty(MFWDimObjectLoader.gModelRes.RID_externalName, attrRecord.getUniqueName());
            pQIObj.addProperty(MFWDimObjectLoader.gModelRes.RID_usage, "attribute");
            MFWDimObjectLoader.setDataTypeProperties(gModelRes, pQIObj, attrRecord.getDataType());
            String sTemp = MFWMetadataResponse.toModelString(attrRecord.getRoleType());
            if (sTemp != null && sTemp.length() > 0) {
                if ("_multiPartBusinessKey".equals(sTemp)) {
                    sTemp = "_businessKey";
                    MFWNodeObject pCustProp = pQIObj.addObjectNode(MFWDimObjectLoader.gModelRes.RID_property);
                    pCustProp.addProperty(MFWDimObjectLoader.gModelRes.RID_name, "multiPartKey");
                    pCustProp.addProperty(MFWDimObjectLoader.gModelRes.RID_type, "hidden");
                    pCustProp.addProperty(MFWDimObjectLoader.gModelRes.RID__Value, "true");
                }
                MFWNodeObject pRoleObj = pQIObj.addObjectNode(MFWDimObjectLoader.gModelRes.RID_role);
                this.mHlprLocale.addLocalizedProperties(pRoleObj, MFWDimObjectLoader.gModelRes.RID_name, sTemp, null, MFWDimLocaleHelper.ELocalizedProp.ePropertyUnknown);
            }
            this.addPropertyWithDefaultValue(pQIObj, MFWDimObjectLoader.gModelRes.RID_format);
            this.addPropertyWithDefaultValue(pQIObj, MFWDimObjectLoader.gModelRes.RID_size);
            this.addPropertyWithDefaultValue(pQIObj, MFWDimObjectLoader.gModelRes.RID_nullable);
            this.addPropertyWithDefaultValue(pQIObj, MFWDimObjectLoader.gModelRes.RID_regularAggregate);
            this.addPropertyWithDefaultValue(pQIObj, MFWDimObjectLoader.gModelRes.RID_semiAggregate);
        }
    }

    private static void setDataTypeProperties(MFWModelRes gModelRes, MFWNodeObject objItem, IDataType dataType) {
        objItem.addProperty(gModelRes.RID_datatype, MFWMetadataResponse.toModelString(dataType));
        if (dataType.hasPrecision()) {
            objItem.addProperty(gModelRes.RID_precision, Integer.toString(dataType.getPrecision()));
        } else {
            objItem.addProperty(gModelRes.RID_precision, "0");
        }
        if (dataType.hasScale()) {
            objItem.addProperty(gModelRes.RID_scale, Integer.toString(dataType.getScale()));
        } else {
            objItem.addProperty(gModelRes.RID_scale, "0");
        }
    }

    private void populatePreDefinedAttributes(MFWNodeObject objNode) {
        String visibleProp = objNode.getPropertyValue(MFWDimObjectLoader.gModelRes.RID_visible);
        if (visibleProp != null && ("hidden".equals(visibleProp) || "hiddenAndAccessible".equals(visibleProp))) {
            return;
        }
        ArrayList<String> projectLocales = this.mHlprLocale.getAllLocales();
        for (int idx = 0; idx < MFWOLAPSchema.gPredefinedAttributes.length; ++idx) {
            MFWOLAPSchema.PredefinedAttribute predefAttr = MFWOLAPSchema.gPredefinedAttributes[idx];
            MFWNodeObject objAttr = objNode.addObjectNode(MFWDimObjectLoader.gModelRes.RID_queryItem);
            if ("DIM_UI_CAPTION_NAME".equals(predefAttr.mNameMsg.getMessageKey())) {
                Iterator<String> sUsedName = this.mIDGenerator.generate(objAttr, "Member Caption_", true);
                for (String aLocale : projectLocales) {
                    this.mHlprLocale.addLocalizedProp(objAttr, MFWDimObjectLoader.gModelRes.RID_name, (String)((Object)sUsedName), aLocale);
                }
            } else {
                this.mIDGenerator.generate(objAttr, predefAttr.mNameMsg.render(this.mHlprLocale.getDesignLocale()), true);
                for (String aLocale : projectLocales) {
                    this.mHlprLocale.addLocalizedProp(objAttr, MFWDimObjectLoader.gModelRes.RID_name, predefAttr.mNameMsg.render(aLocale), aLocale);
                }
            }
            for (String aLocale : projectLocales) {
                this.mHlprLocale.addLocalizedProp(objAttr, MFWDimObjectLoader.gModelRes.RID_description, predefAttr.mDescriptionMsg.render(aLocale), aLocale);
            }
            objAttr.addProperty(MFWDimObjectLoader.gModelRes.RID_externalName, predefAttr.mExternalName);
            objAttr.addProperty(MFWDimObjectLoader.gModelRes.RID_usage, "attribute");
            objAttr.addProperty(MFWDimObjectLoader.gModelRes.RID_datatype, predefAttr.mDatatype);
            objAttr.addProperty(MFWDimObjectLoader.gModelRes.RID_precision, predefAttr.mPrecision);
            if (objNode.getNameRID() == MFWDimObjectLoader.gModelRes.RID_level && "_memberUniqueName".equals(predefAttr.mRole)) {
                List vLevels = objNode.getParentObject().getObjectNodes(MFWDimObjectLoader.gModelRes.RID_level);
                int parentIndex = vLevels.indexOf(objNode);
                MFWException.ASSERT((parentIndex >= 0 ? 1 : 0) != 0, (String)"The parent level must appear among the hierarchy's levels");
                if (parentIndex != 0) {
                    int higherIter = parentIndex - 1;
                    boolean bHighLevelFound = false;
                    while (true) {
                        String viProp;
                        boolean bl = bHighLevelFound = (viProp = ((MFWNodeObject)vLevels.get(higherIter)).getPropertyValue(MFWDimObjectLoader.gModelRes.RID_visible)) == null || !"hidden".equals(viProp) && !"hiddenAndAccessible".equals(viProp);
                        if (bHighLevelFound || higherIter == 0) break;
                        --higherIter;
                    }
                    if (bHighLevelFound) {
                        ArrayList vMUNQItems = new ArrayList();
                        ((MFWNodeObject)vLevels.get(higherIter)).findObjectNodes(MFWDimObjectLoader.gModelRes.RID_queryItem, MFWDimObjectLoader.gModelRes.RID_externalName, "memberUniqueName", vMUNQItems);
                        MFWException.ASSERT((vMUNQItems.size() == 1 ? 1 : 0) != 0, (String)"Expecting one and only one MUN qItem");
                        String aMunID = ((MFWNodeObject)vMUNQItems.get(0)).getPropertyValue(MFWDimObjectLoader.gModelRes.RID_ID);
                        MFWException.ASSERT((aMunID != null ? 1 : 0) != 0, (String)"Expecting an ID property for MUN qItem");
                        ArrayList vCapQItems = new ArrayList();
                        ((MFWNodeObject)vLevels.get(higherIter)).findObjectNodes(MFWDimObjectLoader.gModelRes.RID_queryItem, MFWDimObjectLoader.gModelRes.RID_externalName, "memberCaption", vCapQItems);
                        MFWException.ASSERT((vCapQItems.size() == 1 ? 1 : 0) != 0, (String)"Expecting one and only one Caption qItem");
                        String aCapID = ((MFWNodeObject)vCapQItems.get(0)).getPropertyValue(MFWDimObjectLoader.gModelRes.RID_ID);
                        MFWException.ASSERT((aCapID != null ? 1 : 0) != 0, (String)"Expecting an ID property for Caption qItem");
                        objAttr.addProperty(MFWDimObjectLoader.gModelRes.RID_promptType, "serverDetermined");
                        objAttr.addProperty(MFWDimObjectLoader.gModelRes.RID_promptCascadeOnRef, aMunID);
                        objAttr.addProperty(MFWDimObjectLoader.gModelRes.RID_promptDisplayItemRef, aCapID);
                    }
                }
            }
            MFWNodeObject objRole = objAttr.addObjectNode(MFWDimObjectLoader.gModelRes.RID_role);
            this.mHlprLocale.addLocalizedProperties(objRole, MFWDimObjectLoader.gModelRes.RID_name, predefAttr.mRole, null, MFWDimLocaleHelper.ELocalizedProp.ePropertyUnknown);
            this.addPropertyWithDefaultValue(objAttr, MFWDimObjectLoader.gModelRes.RID_format);
            this.addPropertyWithDefaultValue(objAttr, MFWDimObjectLoader.gModelRes.RID_scale);
            this.addPropertyWithDefaultValue(objAttr, MFWDimObjectLoader.gModelRes.RID_size);
            this.addPropertyWithDefaultValue(objAttr, MFWDimObjectLoader.gModelRes.RID_nullable);
            this.addPropertyWithDefaultValue(objAttr, MFWDimObjectLoader.gModelRes.RID_regularAggregate);
            this.addPropertyWithDefaultValue(objAttr, MFWDimObjectLoader.gModelRes.RID_semiAggregate);
        }
        objNode.setExpandStatus(MFWDimObjectLoader.gModelRes.RID_queryItem, (byte)2);
    }

    private void populateMeasuresOrFolders(MFWRequestContextUser aContext, MFWQuerySpec querySpec, MFWNodeObject objNode, List<? extends MetadataRecord> response) {
        HashMap<String, MFWNodeObject> mDispFolders = new HashMap<String, MFWNodeObject>();
        ArrayList<String> vMsrCaptions = new ArrayList<String>();
        if (this.mSupportsDisplayPath) {
            this.collectObjectCaptions(response, vMsrCaptions);
        }
        for (MetadataRecord metadataRecord : response) {
            MeasureRecord msrRecord = (MeasureRecord)metadataRecord;
            if ("RO".equals(this.mDimConnection.getSource().getType()) && msrRecord.getMeasureFolder().booleanValue()) {
                this.addMeasureFolder(objNode, msrRecord);
                continue;
            }
            String sDispPath = null;
            if (this.mSupportsDisplayPath) {
                sDispPath = msrRecord.getDisplayPath();
            }
            if (sDispPath != null && sDispPath.length() > 0 && !"\\".equals(sDispPath)) {
                ArrayList<MFWNodeObject> vMsrFolders = this.addOrFindFoldersForPath(objNode, sDispPath, vMsrCaptions, MFWDimObjectLoader.gModelRes.RID_measureFolder, mDispFolders);
                for (int idx = 0; idx < vMsrFolders.size(); ++idx) {
                    this.addMeasure(vMsrFolders.get(idx), msrRecord);
                }
                continue;
            }
            this.addMeasure(objNode, msrRecord);
        }
    }

    private void addMeasure(MFWNodeObject parentObj, MeasureRecord msrRecord) {
        MFWNodeObject pMsrObj = parentObj.addExpandableObjectNode(MFWDimObjectLoader.gModelRes.RID_measure);
        boolean isHidden = false;
        if ("RO".equals(this.mDimConnection.getSource().getType())) {
            isHidden = msrRecord.isHidden();
        }
        this.genObjectProperties((MetadataRecord)msrRecord, pMsrObj, MFWDimLocaleHelper.ELocalizedProp.ePropertyCaption, isHidden, false);
        if (msrRecord.getMeasureFolder().booleanValue()) {
            MFWNodeObject pCustProp = pMsrObj.addObjectNode(MFWDimObjectLoader.gModelRes.RID_property);
            pCustProp.addProperty(MFWDimObjectLoader.gModelRes.RID_name, "Measure_Folder");
            pCustProp.addProperty(MFWDimObjectLoader.gModelRes.RID_type, "hidden");
            pCustProp.addProperty(MFWDimObjectLoader.gModelRes.RID__Value, "true");
        }
        pMsrObj.addProperty(MFWDimObjectLoader.gModelRes.RID_externalName, msrRecord.getUniqueName());
        String msrExpr = msrRecord.getDynamicFieldAsString("calculatedMeasureExpression");
        if (msrExpr != null && msrExpr.length() > 0) {
            String sExprAsText = MFWStringHelper.escapeAndTagStr((String)"expression", (String)msrExpr);
            pMsrObj.addProperty(MFWDimObjectLoader.gModelRes.RID_expression, sExprAsText);
        } else {
            this.addPropertyWithDefaultValue(pMsrObj, MFWDimObjectLoader.gModelRes.RID_expression);
        }
        String solveOrder = msrRecord.getDynamicFieldAsString("calculatedMeasureSolveOrder");
        if (solveOrder != null && solveOrder.length() > 0) {
            pMsrObj.addProperty(MFWDimObjectLoader.gModelRes.RID_calculatedMeasureSolveOrder, solveOrder);
        }
        pMsrObj.addProperty(MFWDimObjectLoader.gModelRes.RID_usage, "fact");
        String sTemp = msrRecord.getDynamicFieldAsString("format");
        if (sTemp != null && sTemp.length() > 0) {
            String sFormatAsText = MFWStringHelper.escapeAndTagStr((String)"format", (String)sTemp);
            pMsrObj.addProperty(MFWDimObjectLoader.gModelRes.RID_format, sFormatAsText);
        } else {
            pMsrObj.addProperty(MFWDimObjectLoader.gModelRes.RID_format, sTemp);
        }
        sTemp = msrRecord.getUnits();
        if ("Currency".equals(sTemp)) {
            pMsrObj.addProperty(MFWDimObjectLoader.gModelRes.RID_currency, "undefined");
        }
        MFWDimObjectLoader.setDataTypeProperties(gModelRes, pMsrObj, msrRecord.getDataType());
        String mfwAggrVal = MFWMetadataResponse.toModelString(msrRecord.getRegularAggregate());
        pMsrObj.addProperty(MFWDimObjectLoader.gModelRes.RID_aggregationRule, mfwAggrVal);
        pMsrObj.addProperty(MFWDimObjectLoader.gModelRes.RID_promptType, "serverDetermined");
        pMsrObj.addProperty(MFWDimObjectLoader.gModelRes.RID_regularAggregate, mfwAggrVal);
        pMsrObj.addProperty(MFWDimObjectLoader.gModelRes.RID_semiAggregate, MFWMetadataResponse.toModelString(msrRecord.getSemiAggregate()));
        pMsrObj.addProperty(MFWDimObjectLoader.gModelRes.RID_isHierarchical, "true");
        this.addPropertyWithDefaultValue(pMsrObj, MFWDimObjectLoader.gModelRes.RID_size);
        this.addPropertyWithDefaultValue(pMsrObj, MFWDimObjectLoader.gModelRes.RID_nullable);
        if (this.mAggregateRules) {
            this.populateAggrgationRules(parentObj, pMsrObj, msrRecord);
        }
    }

    private void addMeasureFolder(MFWNodeObject parentObj, MeasureRecord msrRecord) {
        MFWNodeObject folderObj = parentObj.addObjectNode(MFWDimObjectLoader.gModelRes.RID_measureFolder);
        boolean isHidden = false;
        if ("RO".equals(this.mDimConnection.getSource().getType())) {
            isHidden = msrRecord.isHidden();
        }
        this.genObjectProperties((MetadataRecord)msrRecord, folderObj, MFWDimLocaleHelper.ELocalizedProp.ePropertyCaption, isHidden, false);
        folderObj.addProperty(MFWDimObjectLoader.gModelRes.RID_externalName, msrRecord.getUniqueName());
    }

    private void populateAggrgationRules(MFWNodeObject parentObj, MFWNodeObject pMsrObj, MeasureRecord msrRecord) {
        IAggregateRule[] vAggrRules = msrRecord.getAggregateRules();
        if (vAggrRules != null && vAggrRules.length > 0) {
            MFWNodeObject parentNS;
            for (parentNS = parentObj; parentNS != null && parentNS.getNameRID() != MFWDimObjectLoader.gModelRes.RID_namespace; parentNS = parentNS.getParentObject()) {
            }
            MFWException.ASSERT((parentNS != null ? 1 : 0) != 0, (String)"Failed to locate the container namespace when loading measure");
            for (int idx = 0; idx < vAggrRules.length; ++idx) {
                MFWNodeObject objAggrRule = pMsrObj.addObjectNode(MFWDimObjectLoader.gModelRes.RID_aggregateRule);
                ArrayList childDims = new ArrayList(2);
                parentNS.findObjectNodesRecursively(MFWDimObjectLoader.gModelRes.RID_dimension, MFWDimObjectLoader.gModelRes.RID_folder, MFWDimObjectLoader.gModelRes.RID_externalName, vAggrRules[idx].getDimensionRef(), true, childDims);
                MFWException.ASSERT((childDims.size() == 1 ? 1 : 0) != 0, (String)"Aggregate rule's referenced dimension cannot be found:", (String)vAggrRules[idx].getDimensionRef());
                String aggVal = MFWMetadataResponse.toModelString(vAggrRules[idx].getAggregate());
                objAggrRule.addProperty(MFWDimObjectLoader.gModelRes.RID_applyAggregate, aggVal);
                objAggrRule.addProperty(MFWDimObjectLoader.gModelRes.RID_dimensionRef, ((MFWNodeObject)childDims.get(0)).getPropertyValue(MFWDimObjectLoader.gModelRes.RID_ID));
            }
        }
    }

    private void populateNamedSets(MFWRequestContextUser aContext, MFWQuerySpec querySpec, MFWNodeObject objNode, List<? extends MetadataRecord> response) {
        HashMap<String, MFWNodeObject> mDispFolders = new HashMap<String, MFWNodeObject>();
        ArrayList<String> vCalcCaptions = new ArrayList<String>();
        if (this.mSupportsDisplayPath) {
            this.collectObjectCaptions(response, vCalcCaptions);
        }
        for (MetadataRecord metadataRecord : response) {
            NamedSetRecord nmsRecord = (NamedSetRecord)metadataRecord;
            ILocalizedString sLocDispPath = null;
            String sDispPath = null;
            if (this.mSupportsDisplayPath) {
                sLocDispPath = nmsRecord.getLocalizedDisplayPath();
                sDispPath = nmsRecord.getDisplayPath();
            }
            boolean useDispPath = false;
            if (sDispPath != null && sDispPath.length() > 0 && !"\\".equals(sDispPath)) {
                useDispPath = true;
            }
            boolean useLocDispPath = false;
            if (sLocDispPath != null && sLocDispPath.toString().length() > 0 && !"\\".equals(sLocDispPath)) {
                useLocDispPath = true;
            }
            if (useDispPath || useLocDispPath) {
                ArrayList<MFWNodeObject> vFolders = useLocDispPath ? this.addOrFindFoldersForPath(objNode, sLocDispPath, vCalcCaptions, MFWDimObjectLoader.gModelRes.RID_folder, mDispFolders) : this.addOrFindFoldersForPath(objNode, sDispPath, vCalcCaptions, MFWDimObjectLoader.gModelRes.RID_folder, mDispFolders);
                for (int idx = 0; idx < vFolders.size(); ++idx) {
                    this.addNamedSet(aContext, querySpec, vFolders.get(idx), nmsRecord);
                }
                continue;
            }
            this.addNamedSet(aContext, querySpec, objNode, nmsRecord);
        }
    }

    private void addNamedSet(MFWRequestContextUser aContext, MFWQuerySpec querySpec, MFWNodeObject parentObj, NamedSetRecord nmsRecord) {
        MFWNodeObject objNamedSet = parentObj.addObjectNode(MFWDimObjectLoader.gModelRes.RID_calculation);
        this.genObjectProperties((MetadataRecord)nmsRecord, objNamedSet, MFWDimLocaleHelper.ELocalizedProp.ePropertyCaption, false, false);
        String sTemp = nmsRecord.getExpression();
        if (sTemp == null || sTemp.length() == 0) {
            objNamedSet.addProperty(MFWDimObjectLoader.gModelRes.RID_expression, sTemp);
        } else {
            String sExprAsText = MFWStringHelper.escapeAndTagStr((String)"expression", (String)sTemp);
            objNamedSet.addProperty(MFWDimObjectLoader.gModelRes.RID_expression, sExprAsText);
        }
        objNamedSet.addProperty(MFWDimObjectLoader.gModelRes.RID_externalName, nmsRecord.getName());
        objNamedSet.addProperty(MFWDimObjectLoader.gModelRes.RID_calcType, "namedSet");
        MemberRecord firstNamedSetMem = this.mDimConnection.getFirstNamedSetMember(objNamedSet, aContext);
        if (firstNamedSetMem != null) {
            String sLevels;
            sTemp = firstNamedSetMem.getDimensionUniqueName();
            if (sTemp != null && sTemp.length() > 0) {
                MFWNodeObject parentNS;
                for (parentNS = parentObj; parentNS != null && parentNS.getNameRID() != MFWDimObjectLoader.gModelRes.RID_namespace; parentNS = parentNS.getParentObject()) {
                }
                MFWException.ASSERT((parentNS != null ? 1 : 0) != 0, (String)"Calculation for namedSets must appear under a namespace");
                if (this.mDimConnection.getExpandMode() == MFWDimConnection.EExpandMode.eExpandOnDemand) {
                    this.mDimConnection.expandChildren(aContext, querySpec, parentNS, MFWDimObjectLoader.gModelRes.RID_dimension);
                }
                ArrayList childDims = new ArrayList(2);
                parentNS.findObjectNodesRecursively(MFWDimObjectLoader.gModelRes.RID_dimension, MFWDimObjectLoader.gModelRes.RID_folder, MFWDimObjectLoader.gModelRes.RID_externalName, sTemp, true, childDims);
                if (childDims.size() == 1) {
                    MFWNodeObject namedSetDim = (MFWNodeObject)childDims.get(0);
                    String propDimID = namedSetDim.getPropertyValue(MFWDimObjectLoader.gModelRes.RID_ID);
                    MFWException.ASSERT((propDimID != null ? 1 : 0) != 0, (String)"Proprty ID for namedSet dimension is required.");
                    MFWNodeObject pDimensionRefObj = objNamedSet.addObjectNode(MFWDimObjectLoader.gModelRes.RID_dimensions);
                    pDimensionRefObj.addProperty(MFWDimObjectLoader.gModelRes.RID_refobj, propDimID);
                    sTemp = firstNamedSetMem.getHierarchyUniqueName();
                    if (sTemp != null && sTemp.length() > 0) {
                        if (this.mDimConnection.getExpandMode() == MFWDimConnection.EExpandMode.eExpandOnDemand) {
                            this.mDimConnection.expandChildren(aContext, querySpec, namedSetDim, MFWDimObjectLoader.gModelRes.RID_hierarchy);
                        }
                        ArrayList childHiers = new ArrayList(2);
                        namedSetDim.findObjectNodesRecursively(MFWDimObjectLoader.gModelRes.RID_hierarchy, MFWDimObjectLoader.gModelRes.RID_hierarchyFolder, MFWDimObjectLoader.gModelRes.RID_externalName, sTemp, true, childHiers);
                        if (childHiers.size() > 0) {
                            MFWException.ASSERT((childHiers.size() == 1 ? 1 : 0) != 0, (String)"Expecting one hierarchy object namedSet's associated hierarchy");
                            String propHierID = ((MFWNodeObject)childHiers.get(0)).getPropertyValue(MFWDimObjectLoader.gModelRes.RID_ID);
                            MFWException.ASSERT((propHierID != null ? 1 : 0) != 0, (String)"Proprty ID for namedSet hierarchy is required.");
                            MFWNodeObject pHierarchyRefObj = objNamedSet.addObjectNode(MFWDimObjectLoader.gModelRes.RID_hierarchies);
                            pHierarchyRefObj.addProperty(MFWDimObjectLoader.gModelRes.RID_refobj, propHierID);
                        }
                    }
                } else {
                    objNamedSet.addProperty(MFWDimObjectLoader.gModelRes.RID_visible, "hidden");
                }
            }
            if ((sLevels = this.mDimConnection.getNamedSetLevels(objNamedSet, aContext)) != null && sLevels.length() > 0) {
                MFWNodeObject objLevels = objNamedSet.addObjectNode(MFWDimObjectLoader.gModelRes.RID_property);
                objLevels.addProperty(MFWDimObjectLoader.gModelRes.RID_name, "levels");
                objLevels.addProperty(MFWDimObjectLoader.gModelRes.RID__Value, sLevels);
            }
        }
        MFWNodeObject pDatasourceRefObj = objNamedSet.addObjectNode(MFWDimObjectLoader.gModelRes.RID_datasources);
        pDatasourceRefObj.addProperty(MFWDimObjectLoader.gModelRes.RID_dataSourceRef, this.mDataSourceId);
    }

    private void populateHierarchyNamedSets(MFWRequestContextUser aContext, MFWQuerySpec querySpec, MFWNodeObject objNode, List<? extends MetadataRecord> response) {
        HashMap<String, MFWNodeObject> mDispFolders = new HashMap<String, MFWNodeObject>();
        ArrayList<String> vCalcCaptions = new ArrayList<String>();
        if (this.mSupportsDisplayPath) {
            this.collectObjectCaptions(response, vCalcCaptions);
        }
        for (MetadataRecord metadataRecord : response) {
            HierarchyNamedSetRecord hnmsRecord = (HierarchyNamedSetRecord)metadataRecord;
            ILocalizedString sLocDispPath = null;
            String sDispPath = null;
            if (this.mSupportsDisplayPath) {
                sLocDispPath = hnmsRecord.getLocalizedDisplayPath();
                sDispPath = hnmsRecord.getDisplayPath();
            }
            boolean useDispPath = false;
            if (sDispPath != null && sDispPath.length() > 0 && !"\\".equals(sDispPath)) {
                useDispPath = true;
            }
            boolean useLocDispPath = false;
            if (sLocDispPath != null && sLocDispPath.toString().length() > 0 && !"\\".equals(sLocDispPath)) {
                useLocDispPath = true;
            }
            if (useDispPath || useLocDispPath) {
                ArrayList<MFWNodeObject> vFolders = useLocDispPath ? this.addOrFindFoldersForPath(objNode, sLocDispPath, vCalcCaptions, MFWDimObjectLoader.gModelRes.RID_folder, mDispFolders) : this.addOrFindFoldersForPath(objNode, sDispPath, vCalcCaptions, MFWDimObjectLoader.gModelRes.RID_folder, mDispFolders);
                for (int idx = 0; idx < vFolders.size(); ++idx) {
                    this.addHierarchyNamedSet(aContext, querySpec, vFolders.get(idx), hnmsRecord);
                }
                continue;
            }
            this.addHierarchyNamedSet(aContext, querySpec, objNode, hnmsRecord);
        }
    }

    private void addHierarchyNamedSet(MFWRequestContextUser aContext, MFWQuerySpec querySpec, MFWNodeObject parentObj, HierarchyNamedSetRecord hnmsRecord) {
        MFWNodeObject objHierNamedSet = parentObj.addObjectNode(MFWDimObjectLoader.gModelRes.RID_hierarchyNamedSet);
        this.genObjectProperties((MetadataRecord)hnmsRecord, objHierNamedSet, MFWDimLocaleHelper.ELocalizedProp.ePropertyCaption, false, false);
        String sTemp = hnmsRecord.getExpression();
        if (sTemp == null || sTemp.length() == 0) {
            objHierNamedSet.addProperty(MFWDimObjectLoader.gModelRes.RID_expression, sTemp);
        } else {
            String sExprAsText = MFWStringHelper.escapeAndTagStr((String)"expression", (String)sTemp);
            objHierNamedSet.addProperty(MFWDimObjectLoader.gModelRes.RID_expression, sExprAsText);
        }
        objHierNamedSet.addProperty(MFWDimObjectLoader.gModelRes.RID_externalName, hnmsRecord.getName());
        String dimName = hnmsRecord.getDimensionName();
        if (dimName != null && !dimName.isEmpty()) {
            MFWNodeObject parentNS;
            for (parentNS = parentObj; parentNS != null && parentNS.getNameRID() == MFWDimObjectLoader.gModelRes.RID_folder; parentNS = parentNS.getParentObject()) {
            }
            MFWException.ASSERT((parentNS != null && parentNS.getNameRID() == MFWDimObjectLoader.gModelRes.RID_hierarchy ? 1 : 0) != 0, (String)"Hierarchy named sets must appear under a hierarchy.");
            while (parentNS != null && parentNS.getNameRID() != MFWDimObjectLoader.gModelRes.RID_namespace) {
                parentNS = parentNS.getParentObject();
            }
            MFWException.ASSERT((parentNS != null ? 1 : 0) != 0, (String)"Could not find a namespace above the hiearchy named set.");
            if (this.mDimConnection.getExpandMode() == MFWDimConnection.EExpandMode.eExpandOnDemand) {
                this.mDimConnection.expandChildren(aContext, querySpec, parentNS, MFWDimObjectLoader.gModelRes.RID_dimension);
            }
            ArrayList childDims = new ArrayList(2);
            parentNS.findObjectNodesRecursively(MFWDimObjectLoader.gModelRes.RID_dimension, MFWDimObjectLoader.gModelRes.RID_folder, MFWDimObjectLoader.gModelRes.RID_externalName, dimName, true, childDims);
            if (childDims.size() == 1) {
                MFWNodeObject namedSetDim = (MFWNodeObject)childDims.get(0);
                String propDimID = namedSetDim.getPropertyValue(MFWDimObjectLoader.gModelRes.RID_ID);
                MFWException.ASSERT((propDimID != null ? 1 : 0) != 0, (String)"Proprty ID for namedSet dimension is required.");
                MFWNodeObject pDimensionRefObj = objHierNamedSet.addObjectNode(MFWDimObjectLoader.gModelRes.RID_dimensions);
                pDimensionRefObj.addProperty(MFWDimObjectLoader.gModelRes.RID_refobj, propDimID);
                String hierName = hnmsRecord.getHierarchyName();
                if (hierName != null && !hierName.isEmpty()) {
                    if (this.mDimConnection.getExpandMode() == MFWDimConnection.EExpandMode.eExpandOnDemand) {
                        this.mDimConnection.expandChildren(aContext, querySpec, namedSetDim, MFWDimObjectLoader.gModelRes.RID_hierarchy);
                    }
                    ArrayList childHiers = new ArrayList(2);
                    namedSetDim.findObjectNodesRecursively(MFWDimObjectLoader.gModelRes.RID_hierarchy, MFWDimObjectLoader.gModelRes.RID_hierarchyFolder, MFWDimObjectLoader.gModelRes.RID_externalName, hierName, true, childHiers);
                    MFWException.ASSERT((childHiers.size() == 1 ? 1 : 0) != 0, (String)"Could not find named set's associated hierarchy");
                    String propHierID = ((MFWNodeObject)childHiers.get(0)).getPropertyValue(MFWDimObjectLoader.gModelRes.RID_ID);
                    MFWException.ASSERT((propHierID != null ? 1 : 0) != 0, (String)"Proprty ID for namedSet hierarchy is required.");
                    MFWNodeObject pHierarchyRefObj = objHierNamedSet.addObjectNode(MFWDimObjectLoader.gModelRes.RID_hierarchies);
                    pHierarchyRefObj.addProperty(MFWDimObjectLoader.gModelRes.RID_refobj, propHierID);
                }
            } else {
                objHierNamedSet.addProperty(MFWDimObjectLoader.gModelRes.RID_visible, "hidden");
            }
        }
        MFWNodeObject pDatasourceRefObj = objHierNamedSet.addObjectNode(MFWDimObjectLoader.gModelRes.RID_datasources);
        pDatasourceRefObj.addProperty(MFWDimObjectLoader.gModelRes.RID_dataSourceRef, this.mDataSourceId);
    }

    private void populateMacros(MFWRequestContextUser aContext, MFWQuerySpec querySpec, MFWNodeObject objNode, List<? extends MetadataRecord> response) {
        for (MetadataRecord metadataRecord : response) {
            MacroRecord mcrRecord = (MacroRecord)metadataRecord;
            MFWNodeObject calcObj = objNode.addObjectNode(MFWDimObjectLoader.gModelRes.RID_calculation);
            this.genObjectProperties((MetadataRecord)mcrRecord, calcObj, MFWDimLocaleHelper.ELocalizedProp.ePropertyMacroName, false, false);
            String sTemp = mcrRecord.getExpression();
            if (sTemp == null || sTemp.length() == 0) {
                calcObj.addProperty(MFWDimObjectLoader.gModelRes.RID_expression, "");
            } else {
                String sExprAsText = MFWStringHelper.escapeAndTagStr((String)"expression", (String)sTemp);
                calcObj.addProperty(MFWDimObjectLoader.gModelRes.RID_expression, sExprAsText);
            }
            calcObj.addProperty(MFWDimObjectLoader.gModelRes.RID_datatype, MFWMetadataResponse.toModelString(mcrRecord.getDataType()));
            calcObj.addProperty(MFWDimObjectLoader.gModelRes.RID_externalName, mcrRecord.getName());
            calcObj.addProperty(MFWDimObjectLoader.gModelRes.RID_calcType, "macros");
            MFWNodeObject pDatasourceRefObj = calcObj.addObjectNode(MFWDimObjectLoader.gModelRes.RID_datasources);
            pDatasourceRefObj.addProperty(MFWDimObjectLoader.gModelRes.RID_dataSourceRef, this.mDataSourceId);
        }
    }

    private void populateScopeRelations(MFWNodeObject objNode, ArrayList<MFWNodeObject> vMsrDims, ArrayList<MFWNodeObject> vRegDims) {
        for (int mIdx = 0; mIdx < vMsrDims.size(); ++mIdx) {
            MFWNodeObject dimMsr = vMsrDims.get(mIdx);
            MFWNodeObject nameObj1 = dimMsr.getObjectNode(MFWDimObjectLoader.gModelRes.RID_name);
            String propVal1 = nameObj1.getPropertyValue(MFWDimObjectLoader.gModelRes.RID__Value);
            String sMsrDimName = propVal1 == null ? "" : propVal1;
            String propID1 = dimMsr.getPropertyValue(MFWDimObjectLoader.gModelRes.RID_ID);
            String sMsrDimID = propID1 == null ? "" : propID1;
            for (int rIdx = 0; rIdx < vRegDims.size(); ++rIdx) {
                MFWNodeObject dimReg = vRegDims.get(rIdx);
                if (vMsrDims.contains(dimReg)) continue;
                MFWNodeObject nameObj = dimReg.getObjectNode(MFWDimObjectLoader.gModelRes.RID_name);
                String propVal = nameObj.getPropertyValue(MFWDimObjectLoader.gModelRes.RID__Value);
                String sRegDimName = propVal == null ? "" : propVal;
                String propID = dimReg.getPropertyValue(MFWDimObjectLoader.gModelRes.RID_ID);
                String sRegDimID = propID == null ? "" : propID;
                MFWNodeObject pSRObj = objNode.addObjectNode(MFWDimObjectLoader.gModelRes.RID_scopeRelationship);
                StringBuilder sTemp = new StringBuilder(sRegDimName);
                sTemp.append(" <--> ");
                sTemp.append(sMsrDimName);
                String sUsedName = this.mIDGenerator.generate(pSRObj, sTemp.toString(), true);
                pSRObj.addProperty(MFWDimObjectLoader.gModelRes.RID_name, sUsedName);
                pSRObj.addProperty(MFWDimObjectLoader.gModelRes.RID_leftrefobj, sRegDimID);
                pSRObj.addProperty(MFWDimObjectLoader.gModelRes.RID_leftmincard, "one");
                pSRObj.addProperty(MFWDimObjectLoader.gModelRes.RID_leftmaxcard, "one");
                pSRObj.addProperty(MFWDimObjectLoader.gModelRes.RID_rightrefobj, sMsrDimID);
                pSRObj.addProperty(MFWDimObjectLoader.gModelRes.RID_rightmincard, "many");
                pSRObj.addProperty(MFWDimObjectLoader.gModelRes.RID_rightmaxcard, "many");
            }
        }
    }

    private ArrayList<MFWNodeObject> addOrFindFoldersForPath(MFWNodeObject parentObj, String sDisplayPath, ArrayList<String> vObjCaptions, short ridFolder, HashMap<String, MFWNodeObject> mapPath2Objs) {
        ArrayList<MFWNodeObject> outFolderObjs = new ArrayList<MFWNodeObject>();
        ArrayList vPaths = new ArrayList();
        MFWStringHelper.split((String)sDisplayPath, (String)";", vPaths);
        for (int pIdx = 0; pIdx < vPaths.size(); ++pIdx) {
            MFWNodeObject folderParent = parentObj;
            ArrayList vFolders = new ArrayList();
            MFWStringHelper.split((String)((String)vPaths.get(pIdx)), (String)"\\", vFolders);
            StringBuilder sPartialPath = new StringBuilder("");
            MFWNodeObject pInnermostFolder = null;
            for (int fIdx = 0; fIdx < vFolders.size(); ++fIdx) {
                String sFolderName = (String)vFolders.get(fIdx);
                if (sFolderName.length() == 0) continue;
                sPartialPath.append("\\");
                sPartialPath.append(sFolderName);
                pInnermostFolder = mapPath2Objs.get(sPartialPath.toString());
                if (pInnermostFolder == null) {
                    sFolderName = MFWStringHelper.makeUnique((String)((String)vFolders.get(fIdx)), vObjCaptions, (boolean)false);
                    MFWNodeObject folderObj = folderParent.addObjectNode(ridFolder);
                    this.genObjectProperties(sFolderName, "", folderObj);
                    mapPath2Objs.put(sPartialPath.toString(), folderObj);
                    pInnermostFolder = folderObj;
                }
                folderParent = pInnermostFolder;
            }
            MFWException.ASSERT((pInnermostFolder != null ? 1 : 0) != 0, (String)"A valid folder parent must have been added");
            outFolderObjs.add(pInnermostFolder);
        }
        MFWException.ASSERT((outFolderObjs.size() > 0 ? 1 : 0) != 0, (String)"At least one folder must exist for the given display path");
        return outFolderObjs;
    }

    private ArrayList<MFWNodeObject> addOrFindFoldersForPath(MFWNodeObject parentObj, ILocalizedString sLocDisplayPath, ArrayList<String> vObjCaptions, short ridFolder, HashMap<String, MFWNodeObject> mapPath2Objs) {
        ArrayList<MFWNodeObject> outFolderObjs = new ArrayList<MFWNodeObject>();
        ArrayList<ArrayList<ILocalizedString>> locPaths = this.extractLocalizedPaths(sLocDisplayPath);
        for (int pIdx = 0; pIdx < locPaths.size(); ++pIdx) {
            MFWNodeObject folderParent = parentObj;
            ArrayList<ILocalizedString> path = locPaths.get(pIdx);
            StringBuilder sPartialPath = new StringBuilder("");
            MFWNodeObject pInnermostFolder = null;
            for (int fIdx = 0; fIdx < path.size(); ++fIdx) {
                ILocalizedString folderName = path.get(fIdx);
                if (folderName.toString().length() == 0) continue;
                sPartialPath.append("\\");
                sPartialPath.append(folderName);
                pInnermostFolder = mapPath2Objs.get(sPartialPath.toString());
                if (pInnermostFolder == null) {
                    String sUniqueFolderName = MFWStringHelper.makeUnique((String)folderName.toString(), vObjCaptions, (boolean)false);
                    MFWNodeObject folderObj = folderParent.addObjectNode(ridFolder);
                    this.genObjectProperties(sUniqueFolderName, folderName, "", folderObj);
                    mapPath2Objs.put(sPartialPath.toString(), folderObj);
                    pInnermostFolder = folderObj;
                }
                folderParent = pInnermostFolder;
            }
            MFWException.ASSERT((pInnermostFolder != null ? 1 : 0) != 0, (String)"A valid folder parent must have been added");
            outFolderObjs.add(pInnermostFolder);
        }
        MFWException.ASSERT((outFolderObjs.size() > 0 ? 1 : 0) != 0, (String)"At least one folder must exist for the given display path");
        return outFolderObjs;
    }

    private ArrayList<ArrayList<ILocalizedString>> extractLocalizedPaths(ILocalizedString locDisplayPath) {
        ArrayList<ArrayList<ILocalizedString>> paths = new ArrayList<ArrayList<ILocalizedString>>();
        String path = locDisplayPath.toString();
        ArrayList vPaths = new ArrayList();
        MFWStringHelper.split((String)path, (String)";", vPaths);
        for (int pIdx = 0; pIdx < vPaths.size(); ++pIdx) {
            ArrayList vFolders = new ArrayList();
            MFWStringHelper.split((String)((String)vPaths.get(pIdx)), (String)"\\", vFolders);
            ArrayList<LocalizedString> folders = new ArrayList<LocalizedString>();
            for (int fIdx = 0; fIdx < vFolders.size(); ++fIdx) {
                String sFolderName = (String)vFolders.get(fIdx);
                LocalizedString sLocFolderName = new LocalizedString(locDisplayPath.getDefaultLocale(), sFolderName);
                folders.add(sLocFolderName);
            }
            paths.add(folders);
        }
        String[] locales = locDisplayPath.getSupportedLocales();
        for (int lIdx = 0; lIdx < locales.length; ++lIdx) {
            if (locales[lIdx].equals(locDisplayPath.getDefaultLocale())) continue;
            path = locDisplayPath.toString(locales[lIdx]);
            vPaths = new ArrayList();
            MFWStringHelper.split((String)path, (String)";", vPaths);
            for (int pIdx = 0; pIdx < vPaths.size(); ++pIdx) {
                ArrayList vFolders = new ArrayList();
                MFWStringHelper.split((String)((String)vPaths.get(pIdx)), (String)"\\", vFolders);
                ArrayList<ILocalizedString> folders = paths.get(pIdx);
                for (int fIdx = 0; fIdx < vFolders.size(); ++fIdx) {
                    String sFolderName = (String)vFolders.get(fIdx);
                    ILocalizedString sLocFolderName = folders.get(fIdx);
                    sLocFolderName.put(locales[lIdx], sFolderName);
                }
            }
        }
        return paths;
    }

    private void addPropertyWithDefaultValue(MFWNodeObject objNode, short ridPropName) {
        MFWInfoObject objInfo = objNode.getObjectInfo();
        MFWInfo childInfo = objInfo.findChildInfo(ridPropName);
        MFWException.ASSERT((childInfo != null && childInfo.getNodeType() == 1 ? 1 : 0) != 0, (String)"must be a property");
        MFWInfoProperty propInfo = (MFWInfoProperty)childInfo;
        switch (propInfo.getDataType()) {
            case 2: {
                objNode.addProperty(ridPropName, propInfo.getDefaultEnumValue());
                break;
            }
            case 4: {
                objNode.addProperty(ridPropName, propInfo.getDefaultBooleanValue());
                break;
            }
            default: {
                objNode.addProperty(ridPropName, propInfo.getDefaultValue());
            }
        }
    }

    private void collectConflictingFolderNames(List<? extends MetadataRecord> respDimensions, ArrayList<String> vConflictingName) {
        for (MetadataRecord metadataRecord : respDimensions) {
            DimensionRecord dimRecord = (DimensionRecord)metadataRecord;
            String sDimGroupName = dimRecord.getDimensionGroupName();
            String sDimCaption = dimRecord.getCaption().toString();
            if (sDimGroupName == null || sDimGroupName.length() <= 0 || !sDimGroupName.equals(sDimCaption)) continue;
            vConflictingName.add(sDimGroupName);
        }
    }

    private void collectObjectCaptions(List<? extends MetadataRecord> respObjects, ArrayList<String> vCaptions) {
        for (MetadataRecord metadataRecord : respObjects) {
            String sDimCaption = metadataRecord.getCaption().toString();
            vCaptions.add(sDimCaption);
        }
    }

    private String makeDatasourceNameUnique(MFWRequestContextUser aContext, String sCmDataSrcName) {
        ArrayList<String> vDSNames = new ArrayList<String>();
        MFWCluster gwCluster = aContext.getGatewayCluster();
        if (gwCluster != null) {
            List vLinkedClusters = gwCluster.getAllLinkedClustersFor(aContext);
            for (int idx = 0; idx < vLinkedClusters.size(); ++idx) {
                MFWNodeObject pLinkProjNode = ((MFWCluster)vLinkedClusters.get(idx)).getRootNode().getObjectNode(MFWDimObjectLoader.gModelRes.RID_project);
                if (pLinkProjNode == null) continue;
                List vDatasources = pLinkProjNode.getObjectNodes(MFWDimObjectLoader.gModelRes.RID_dataSource);
                for (int j = 0; j < vDatasources.size(); ++j) {
                    String dsName = ((MFWNodeObject)vDatasources.get(j)).getPropertyValue(MFWDimObjectLoader.gModelRes.RID_name);
                    MFWException.ASSERT((dsName != null ? 1 : 0) != 0, (String)"Expecting a valid name property for linked data source");
                    vDSNames.add(dsName);
                }
            }
        }
        return MFWStringHelper.makeUnique((String)sCmDataSrcName, vDSNames, (boolean)false);
    }
}

