/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfwa4j.adaptorDim;

import com.cognos.mfw4j.framework.MFWMetadataSource;
import com.cognos.mfw4j.framework.MFWModelRes;
import com.cognos.mfw4j.framework.MFWNodeObject;
import com.cognos.mfw4j.framework.MFWRequestContext;
import com.cognos.mfw4j.framework.MFWRequestContextUser;
import com.cognos.mfw4j.framework.log.MFWLogDimAdaptorTraceEvent;
import com.cognos.mfw4j.resourcePool.MFWDSConnectionSpec;
import com.cognos.mfw4j.resourcePool.MFWDSSelectionCriteria;
import com.cognos.mfw4j.resourcePool.MFWUserPool;
import com.cognos.mfw4j.utilities.MFWException;
import com.cognos.mfw4j.utilities.MFWMessage;
import com.cognos.mfwa4j.adaptorDim.MFWOLAPSchema;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.xqe.bibushandler.datasource.DataSourceConnectionSignon;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceConnection;
import com.cognos.xqe.data.model.IDataSourceConnectionSignon;
import com.cognos.xqe.data.providers.SimpleDataSource;
import com.cognos.xqe.data.providers.olap.IRestrictions;
import com.cognos.xqe.data.providers.olap.MetadataOperation;
import com.cognos.xqe.data.providers.olap.MetadataRestriction;
import com.cognos.xqe.data.providers.olap.RestrictionType;
import com.cognos.xqe.metadata.TreeOperatorEnum;
import com.cognos.xqe.metadata.record.CubeRecord;
import com.cognos.xqe.metadata.record.MetadataRecord;
import com.cognos.xqe.olapjapi.IXQEODPSession;
import com.cognos.xqe.olapjapi.MetadataQueryArgs;
import com.cognos.xqe.olapjapi.XQEODPSessionBuilder;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.security.EncryptedObject;
import com.cognos.xqe.security.IEncryptedObject;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

final class MFWMetadataRequest {
    private XQEODPSessionBuilder mODPSessionBuilder = null;
    private IXQEODPSession mODPSession = null;
    private String mCatalog = null;
    private String mSchema = null;
    private String mCube = null;
    private String mRequestID = null;
    private String mModelDesignLocale = null;
    private MFWMetadataSource mMetadataSource = null;

    MFWMetadataRequest(MFWMetadataSource aMetadataSrc, String modelDesignLocale, MFWRequestContextUser aContext) {
        this.mCatalog = (String)aMetadataSrc.getScope("catalog");
        this.mSchema = (String)aMetadataSrc.getScope("schema");
        this.mCube = (String)aMetadataSrc.getScope("cube");
        this.mRequestID = "MFWDim:" + Long.toString(System.currentTimeMillis());
        this.mModelDesignLocale = modelDesignLocale;
        this.mMetadataSource = aMetadataSrc;
        this.createODPSessionBuilder(this.mMetadataSource, aContext);
        this.mODPSession = this.mODPSessionBuilder.createSession();
        MFWException.ASSERT((this.mODPSession != null ? 1 : 0) != 0, (String)"Failed to create an ODP session");
    }

    private void createODPSessionBuilder(MFWMetadataSource aMetadataSrc, MFWRequestContextUser aContext) {
        MFWLogDimAdaptorTraceEvent myLogger = new MFWLogDimAdaptorTraceEvent();
        myLogger.log(new String[]{"======> Starting a new Metadata Request", Integer.toString(this.hashCode())});
        String sCmDataSrc = (String)aMetadataSrc.getConnectionItem("cmDataSource");
        MFWException.ASSERT((sCmDataSrc != null && sCmDataSrc.length() > 0 ? 1 : 0) != 0, (String)"Expecting a valid CM Data Source connection parameter");
        myLogger.log(new String[]{"CM Data Source:", sCmDataSrc});
        myLogger.log(new String[]{"design Locale:", this.mModelDesignLocale});
        this.mODPSessionBuilder = new XQEODPSessionBuilder();
        HashMap<String, Object> mapConnProps = new HashMap<String, Object>();
        this.setupConnectionProperties(myLogger, aMetadataSrc, mapConnProps);
        this.mODPSessionBuilder.setDesignLocale(this.mModelDesignLocale);
        if (aContext.getXQEExecutionEnvironment() == null) {
            this.setupStandaloneSessionBuilder(myLogger, sCmDataSrc, aMetadataSrc, aContext, mapConnProps);
        } else {
            this.mODPSessionBuilder.setDataSource(sCmDataSrc, aMetadataSrc.getType(), mapConnProps);
            this.mODPSessionBuilder.setExecutionEnvironment((ExecutionEnvironment)aContext.getXQEExecutionEnvironment());
        }
    }

    void destroy() {
        if (this.mODPSession != null) {
            this.mODPSession.release();
            this.mODPSession = null;
        }
        this.mODPSessionBuilder = null;
    }

    String getResolvedConnectionStr() {
        MFWException.ASSERT((this.mODPSession != null && this.mODPSession.getDataSource() != null ? 1 : 0) != 0, (String)"Expecting a valid ODP session witha  valid associated data source");
        String cnxString = "";
        if (!"RO".equals(this.mODPSession.getDataSource().getType())) {
            IDataSourceConnection dsCnx = this.mODPSession.getDataSource().getDataSourceConnection();
            IDataSourceConnectionSignon dsSgn = dsCnx.getSignon();
            cnxString = dsCnx.getConnectionString(dsSgn);
        }
        return cnxString;
    }

    void setCubeName(String aCubeName) {
        this.mCube = aCubeName;
    }

    List<? extends MetadataRecord> doMetadataRequest(MFWNodeObject objParent, short olapType, Map<String, ? extends Object> aliasInfo, int startIndex, int retrievalCount, MFWRequestContextUser aContext) {
        MetadataRestriction queryConstraints = this.makeQueryConstraints(objParent, olapType, aliasInfo, startIndex, retrievalCount);
        if (aContext.getIgnoreUpdateRetainPeriod() && 2 == olapType) {
            queryConstraints.add(RestrictionType.REFRESH, (Object)Boolean.TRUE);
        }
        if (aliasInfo != null && !aliasInfo.isEmpty()) {
            queryConstraints.add(RestrictionType.ALIASES, aliasInfo);
            queryConstraints.add(RestrictionType.PROJECT_LOCALES, new ArrayList<String>(aliasInfo.keySet()));
        }
        return this.doMetadataRequest(olapType, queryConstraints, aContext);
    }

    CubeRecord doCubeRequest(MFWRequestContextUser aContext, MFWMetadataSource aSource, Map<String, ? extends Object> aliasInfo) {
        List<? extends MetadataRecord> cubeResponse = this.doMetadataRequest(null, (short)2, aliasInfo, 0, 0, aContext);
        if (cubeResponse == null || cubeResponse.size() < 1) {
            String sCmDataSrc = (String)aSource.getConnectionItem("cmDataSource");
            MFWException ex = new MFWException();
            ex.addMessage(new MFWMessage("mfwa4j", "DIM_ERR_CUBE_QUERY_FAILED", (Object[])new String[]{sCmDataSrc}));
            throw ex;
        }
        return (CubeRecord)cubeResponse.get(0);
    }

    List<? extends MetadataRecord> doMetadataRequest(short olapType, MetadataRestriction queryConstraints, MFWRequestContextUser aContext) {
        MFWLogDimAdaptorTraceEvent myLogger = new MFWLogDimAdaptorTraceEvent();
        myLogger.logMDRequest(MFWOLAPSchema.gOLAPTypeNames[olapType], queryConstraints.toString());
        List outRecords = null;
        try {
            this.setupODPSessionIfRequired(aContext);
            MetadataQueryArgs metadataQArgs = new MetadataQueryArgs();
            metadataQArgs.setRestrictions((IRestrictions)queryConstraints);
            switch (olapType) {
                case 1: {
                    metadataQArgs.setOperation(MetadataOperation.PROPERTIES);
                    break;
                }
                case 2: {
                    metadataQArgs.setOperation(MetadataOperation.CUBES);
                    break;
                }
                case 3: {
                    metadataQArgs.setOperation(MetadataOperation.DIMENSIONS);
                    break;
                }
                case 4: {
                    metadataQArgs.setOperation(MetadataOperation.HIERARCHIES);
                    break;
                }
                case 5: {
                    metadataQArgs.setOperation(MetadataOperation.LEVELS);
                    break;
                }
                case 6: {
                    metadataQArgs.setOperation(MetadataOperation.MACROS);
                    break;
                }
                case 7: 
                case 14: {
                    metadataQArgs.setOperation(MetadataOperation.MEASURES);
                    break;
                }
                case 8: {
                    metadataQArgs.setOperation(MetadataOperation.HIERARCHYROOTMEMBERS);
                    break;
                }
                case 9: {
                    metadataQArgs.setOperation(MetadataOperation.HIERARCHYCALCULATEDMEMBERS);
                    break;
                }
                case 10: {
                    metadataQArgs.setOperation(MetadataOperation.NAMEDSETS);
                    break;
                }
                case 15: {
                    metadataQArgs.setOperation(MetadataOperation.HIERARCHYNAMEDSETS);
                    break;
                }
                case 11: {
                    metadataQArgs.setOperation(MetadataOperation.NAMEDSETMEMBERS);
                    break;
                }
                default: {
                    MFWException.ASSERT((boolean)false, (String)"Unknown OLAP object type to query:", (String)(Integer.toString(olapType) + "=" + MFWOLAPSchema.gOLAPTypeNames[olapType]));
                }
            }
            outRecords = this.mODPSession.getMetadata(metadataQArgs);
            myLogger.logMDResponse(MFWOLAPSchema.gOLAPTypeNames[olapType], outRecords);
        }
        catch (Throwable th) {
            myLogger.logMDResponse(MFWOLAPSchema.gOLAPTypeNames[olapType], "****** Failed ******");
            this.handleException(th);
        }
        return outRecords;
    }

    String queryCubeDefaultMeasure(MFWRequestContextUser aContext, Map<String, ? extends Object> aliasInfo) {
        String defMsr = null;
        MFWLogDimAdaptorTraceEvent myLogger = new MFWLogDimAdaptorTraceEvent();
        myLogger.logMDRequest(MFWOLAPSchema.gOLAPTypeNames[12], "Catalog=" + this.mCatalog + ",Cube=" + this.mCube);
        try {
            this.setupODPSessionIfRequired(aContext);
            MetadataRestriction cubeRest = this.makeQueryConstraints(null, (short)2, aliasInfo, 0, 0);
            defMsr = this.mODPSession.getCubeDefaultMeasure((IRestrictions)cubeRest);
            myLogger.logMDResponse(MFWOLAPSchema.gOLAPTypeNames[12], defMsr);
        }
        catch (Throwable th) {
            myLogger.logMDResponse(MFWOLAPSchema.gOLAPTypeNames[12], "****** Failed ******");
            this.handleException(th);
        }
        return defMsr;
    }

    List<String> queryNamedSetLevelNames(MFWRequestContextUser aContext, MFWNodeObject namedSetNode) {
        List outValues = null;
        MFWLogDimAdaptorTraceEvent myLogger = new MFWLogDimAdaptorTraceEvent();
        myLogger.logMDRequest(MFWOLAPSchema.gOLAPTypeNames[13], "Catalog=" + this.mCatalog + ",Cube=" + this.mCube);
        try {
            this.setupODPSessionIfRequired(aContext);
            MetadataRestriction nsLevslsRest = this.makeQueryConstraints(namedSetNode, (short)13, null, 0, 0);
            outValues = this.mODPSession.getNamedSetLevelUniqueNames((IRestrictions)nsLevslsRest);
            myLogger.logMDResponse(MFWOLAPSchema.gOLAPTypeNames[13], outValues);
        }
        catch (Throwable th) {
            myLogger.logMDResponse(MFWOLAPSchema.gOLAPTypeNames[12], "****** Failed ******");
            this.handleException(th);
        }
        return outValues;
    }

    private void setupODPSessionIfRequired(MFWRequestContextUser aContext) {
        if (this.mODPSession == null) {
            if (this.mODPSessionBuilder == null) {
                this.createODPSessionBuilder(this.mMetadataSource, aContext);
            }
            this.mODPSessionBuilder.setExecutionEnvironment((ExecutionEnvironment)aContext.getXQEExecutionEnvironment());
            this.mODPSession = this.mODPSessionBuilder.createSession();
            MFWException.ASSERT((this.mODPSession != null ? 1 : 0) != 0, (String)"Failed to create an ODP session");
        }
    }

    private void handleException(Throwable th) {
        if (this.mODPSession != null) {
            this.mODPSession.release();
            this.mODPSession = null;
        }
        if (th instanceof RuntimeException) {
            throw (RuntimeException)th;
        }
        throw new RuntimeException(th);
    }

    MetadataRestriction makeQueryConstraints(MFWNodeObject objParent, short olapType, Map<String, ? extends Object> aliasInfo, int startIndex, int retrievalCount) {
        MFWModelRes gModelRes = MFWModelRes.getInstance();
        MetadataRestriction outConstraints = new MetadataRestriction();
        if (startIndex != 0) {
            outConstraints.add(RestrictionType.FROM, (Object)startIndex);
        }
        if (retrievalCount != 0) {
            outConstraints.add(RestrictionType.SIZE, (Object)retrievalCount);
        } else if (olapType == 8) {
            outConstraints.add(RestrictionType.SIZE, (Object)2);
        }
        if (this.mCatalog != null && this.mCatalog.length() > 0) {
            outConstraints.add(RestrictionType.CATALOG, (Object)this.mCatalog);
        }
        if (this.mSchema != null && this.mSchema.length() > 0) {
            outConstraints.add(RestrictionType.SCHEMA, (Object)this.mSchema);
        }
        if (this.mCube != null && this.mCube.length() > 0) {
            outConstraints.add(RestrictionType.CUBE, (Object)this.mCube);
        }
        if (aliasInfo != null && !aliasInfo.isEmpty()) {
            outConstraints.add(RestrictionType.ALIASES, aliasInfo);
            outConstraints.add(RestrictionType.PROJECT_LOCALES, new ArrayList<String>(aliasInfo.keySet()));
        }
        switch (olapType) {
            case 2: 
            case 12: {
                break;
            }
            case 7: 
            case 14: {
                if (objParent.getNameRID() == gModelRes.RID_dimension) {
                    this.addConstraint(objParent, outConstraints);
                    outConstraints.add(RestrictionType.LEVEL_NUMBER, (Object)0);
                    break;
                }
                if (objParent.getNameRID() == gModelRes.RID_measure || objParent.getNameRID() == gModelRes.RID_measureFolder) {
                    this.addConstraint(objParent, outConstraints);
                    outConstraints.add(RestrictionType.TREEOP, EnumSet.of(TreeOperatorEnum.CHILDREN));
                    break;
                }
                MFWException.ASSERT((boolean)false, (String)"Unexpected parent object when querying measures");
                break;
            }
            case 11: {
                MFWException.ASSERT((objParent.getNameRID() == gModelRes.RID_calculation || objParent.getNameRID() == gModelRes.RID_hierarchyNamedSet ? 1 : 0) != 0, (String)"Unexpected parent object when querying namedSet members");
                this.addConstraint(objParent, outConstraints);
                break;
            }
            default: {
                while (objParent.getNameRID() != gModelRes.RID_namespace && objParent.getNameRID() != gModelRes.RID_project) {
                    this.addConstraint(objParent, outConstraints);
                    objParent = (MFWNodeObject)objParent.getParent();
                }
                break block0;
            }
        }
        return outConstraints;
    }

    private void addConstraint(MFWNodeObject objNode, MetadataRestriction queryRestriction) {
        short ridObj = objNode.getNameRID();
        MFWModelRes gModelRes = MFWModelRes.getInstance();
        if (ridObj == gModelRes.RID_folder || ridObj == gModelRes.RID_hierarchyFolder) {
            return;
        }
        if (!"RO".equals(this.mODPSession.getDataSource().getType()) && ridObj == gModelRes.RID_measureFolder) {
            return;
        }
        String extName = objNode.getPropertyValue(gModelRes.RID_externalName);
        MFWException.ASSERT((extName != null ? 1 : 0) != 0, (String)"An externalName is expected -- AddConstraint");
        if (ridObj == gModelRes.RID_dimension) {
            queryRestriction.add(RestrictionType.DIMENSION_UNIQUE_NAME, (Object)extName);
        } else if (ridObj == gModelRes.RID_hierarchy) {
            queryRestriction.add(RestrictionType.HIERARCHY_UNIQUE_NAME, (Object)extName);
        } else if (ridObj == gModelRes.RID_level) {
            queryRestriction.add(RestrictionType.LEVEL_UNIQUE_NAME, (Object)extName);
        } else if (ridObj == gModelRes.RID_measure || ridObj == gModelRes.RID_measureFolder) {
            queryRestriction.add(RestrictionType.MEASURE_UNIQUE_NAME, (Object)extName);
        } else if (ridObj == gModelRes.RID_calculation) {
            queryRestriction.add(RestrictionType.SET, (Object)extName);
        } else if (ridObj == gModelRes.RID_hierarchyNamedSet) {
            queryRestriction.add(RestrictionType.SET, (Object)extName);
        } else {
            MFWException.ASSERT((boolean)false, (String)"Unexpected object type -- AddConstraint");
        }
    }

    private void setupConnectionProperties(MFWLogDimAdaptorTraceEvent myLogger, MFWMetadataSource aMetadataSrc, HashMap<String, Object> mapConnProps) {
        String temp;
        if (this.mCatalog != null && this.mCatalog.length() > 0) {
            mapConnProps.put("catalog", this.mCatalog);
            myLogger.log(new String[]{"catalog:", this.mCatalog});
        }
        if (this.mSchema != null && this.mSchema.length() > 0) {
            mapConnProps.put("schema", this.mSchema);
            myLogger.log(new String[]{"schema:", this.mSchema});
        }
        if (this.mCube != null && this.mCube.length() > 0) {
            mapConnProps.put("cube", this.mCube);
            myLogger.log(new String[]{"cube:", this.mCube});
        }
        if ((temp = (String)aMetadataSrc.getConnectionItem("attribute")) != null && temp.length() > 0) {
            mapConnProps.put("attribute", temp);
            myLogger.log(new String[]{"attribute:", temp});
        }
        if (aMetadataSrc.getAliasInfo() != null) {
            mapConnProps.put("project_locales", aMetadataSrc.getAliasInfo().keySet());
        }
    }

    private void setupStandaloneSessionBuilder(MFWLogDimAdaptorTraceEvent myLogger, String sCmDataSrc, MFWMetadataSource aMetadataSrc, MFWRequestContextUser aContext, HashMap<String, Object> mapConnProps) {
        MFWDSSelectionCriteria dsSelection = new MFWDSSelectionCriteria(sCmDataSrc);
        MFWDSConnectionSpec myResolvedSpec = MFWUserPool.getInstance().getConnectionSpec((MFWRequestContext)aContext, dsSelection);
        String signonUID = myResolvedSpec.getSignonUserID();
        String signonPWD = myResolvedSpec.getSignonUserPWD();
        String sRawConnStr = myResolvedSpec.getConnectionString();
        myLogger.log(new String[]{"Connection Str:", sRawConnStr});
        myLogger.log(new String[]{"UID:", signonUID});
        myLogger.log(new String[]{"PWD:", signonPWD});
        IDataSourceConnectionSignon signon = DataSourceConnectionSignon.createSignon((String)aMetadataSrc.getType(), (String)(sCmDataSrc + "--signon"), (String)(sCmDataSrc + "/connection[0]/signon[0]"), (String)signonUID, (IEncryptedObject)new EncryptedObject((Object)signonPWD), null, null);
        IDataSource testingDS = SimpleDataSource.newInstance((String)sCmDataSrc, (String)aMetadataSrc.getType(), (String)sRawConnStr, mapConnProps, (IDataSourceConnectionSignon)signon);
        this.mODPSessionBuilder.setCustomDataSource(testingDS);
        this.mODPSessionBuilder.setProductLocale(aContext.getProductLocale());
        this.mODPSessionBuilder.setRunLocale(aContext.getContentLocale());
        this.mODPSessionBuilder.setRequestId(this.mRequestID);
        if (aContext.getConnectionSpec() != null) {
            this.mODPSessionBuilder.setConnectionSpec(aContext.getConnectionSpec());
        } else {
            this.mODPSessionBuilder.setConnectionSpec(this.buildElement("<connection/>"));
        }
        if (aContext.getBiBusEnvelope() != null) {
            this.mODPSessionBuilder.setRequestEnvelope(aContext.getBiBusEnvelope());
        } else {
            BIBusEnvelope elmEnvelope = new BIBusEnvelope(this.buildElement("<soapenv:Header xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\"/>"));
            this.mODPSessionBuilder.setRequestEnvelope(elmEnvelope);
        }
    }

    private Element buildElement(String strXML) {
        try {
            StringReader myReader = new StringReader(strXML);
            SAXReader myParser = new SAXReader();
            Document document = myParser.read((Reader)myReader);
            return document.getRootElement();
        }
        catch (DocumentException de) {
            throw new RuntimeException(de);
        }
    }
}

