/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfwa4j.adaptorDimMDDS;

import com.cognos.mfw4j.framework.MFWAdaptor;
import com.cognos.mfw4j.framework.MFWCluster;
import com.cognos.mfw4j.framework.MFWConnection;
import com.cognos.mfw4j.framework.MFWConnectionReuseInfo;
import com.cognos.mfw4j.framework.MFWCrnIDAdvancedLookup;
import com.cognos.mfw4j.framework.MFWInfo;
import com.cognos.mfw4j.framework.MFWInfoProperty;
import com.cognos.mfw4j.framework.MFWMetadataSource;
import com.cognos.mfw4j.framework.MFWModelRes;
import com.cognos.mfw4j.framework.MFWNodeObject;
import com.cognos.mfw4j.framework.MFWQuerySpec;
import com.cognos.mfw4j.framework.MFWRequestContextUser;
import com.cognos.mfw4j.utilities.MFWConfiguration;
import com.cognos.mfw4j.utilities.MFWContentHelper;
import com.cognos.mfw4j.utilities.MFWCrnIDHelper;
import com.cognos.mfw4j.utilities.MFWException;
import com.cognos.mfwa4j.adaptorDimMDDS.MFWDimAdaptor;
import com.cognos.mfwa4j.adaptorDimMDDS.MFWDimConnectionReuseInfo;
import com.cognos.mfwa4j.adaptorDimMDDS.MFWDimLocaleHelper;
import com.cognos.mfwa4j.adaptorDimMDDS.MFWDimObjectLoader;
import com.cognos.mfwa4j.adaptorDimMDDS.MFWMetadataRequest;
import com.cognos.mfwa4j.adaptorDimMDDS.MFWMetadataResponse;
import com.cognos.mfwa4j.adaptorDimMDDS.MFWOLAPSchema;
import com.cognos.mfwa4j.v5Bridge.MFWV5Bridge;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.dom4j.Element;
import org.dom4j.Node;
import org.jaxen.expr.NameStep;
import org.jaxen.expr.Step;

public final class MFWDimConnection
extends MFWConnection {
    private MFWNodeObject mDataSourceNode = null;
    private MFWNodeObject mRootNamespace = null;
    private String mRootNamespaceID = null;
    private MFWDimLocaleHelper mHlprLocale = null;
    private MFWDimObjectLoader mObjLoader = null;
    private MFWV5Bridge mV5Bridge = null;
    private MFWOLAPSchema mOlapSchema = null;

    MFWDimConnection(MFWDimConnectionReuseInfo aReuseInfo, MFWDimAdaptor anAdaptor) {
        super((MFWConnectionReuseInfo)aReuseInfo, (MFWAdaptor)anAdaptor);
        MFWDimAdaptor.debugTrace("----------- Constructing a new connection:", (Object)this);
        this.mHlprLocale = new MFWDimLocaleHelper(this.getSource());
        this.mOlapSchema = new MFWOLAPSchema();
    }

    public void destroy() {
        MFWDimAdaptor.debugTrace("----------- destroying connection:", (Object)this);
        this.mHlprLocale.destroy();
        this.mObjLoader.destroy();
        this.mOlapSchema = null;
        if (this.mV5Bridge != null) {
            this.mV5Bridge.terminate();
        }
    }

    private MFWV5Bridge getV5Bridge(MFWRequestContextUser aContext) {
        if (this.mV5Bridge == null) {
            this.mV5Bridge = MFWV5Bridge.create(aContext);
        }
        return this.mV5Bridge;
    }

    protected void initialSetup(MFWRequestContextUser aContext, MFWNodeObject aLinkNodeParent) {
        MFWModelRes gModelRes = MFWModelRes.getInstance();
        this.mObjLoader = new MFWDimObjectLoader(this, this.mHlprLocale);
        MFWNodeObject projNode = this.mObjLoader.setupProject(this.getCluster().getRootNode(), this.getSource());
        this.mHlprLocale.setupLocales(aContext, projNode, aLinkNodeParent, true);
        String sCubeName = (String)this.getSource().getScope("cube");
        if (sCubeName == null || sCubeName.length() == 0) {
            sCubeName = this.queryCubeName(aContext);
            this.getSource().addScope("cube", (Object)sCubeName);
        }
        this.mRootNamespace = this.mObjLoader.setupRootNamespace(projNode, aLinkNodeParent, sCubeName);
        this.mRootNamespaceID = this.mRootNamespace.getPropertyValue(gModelRes.RID_ID);
        MFWException.ASSERT((this.mRootNamespaceID != null ? 1 : 0) != 0, (String)"Expecting an ID property for root LWM namespace");
        this.mDataSourceNode = this.mObjLoader.setupDataSource(aContext, projNode, this.getSource(), sCubeName);
        String sLastSchemaUpdateDate = this.queryCubeInfo(aContext, true);
        projNode.setExpandStatus(gModelRes.RID_namespace, (byte)1);
        projNode.setExpandStatus(gModelRes.RID_dataSource, (byte)1);
        ((MFWDimConnectionReuseInfo)this.getReuseInfo()).addRecentUser(aContext);
    }

    protected void reconstructSetup(MFWRequestContextUser aContext, MFWNodeObject aLinkNodeParent) {
        MFWModelRes gModelRes = MFWModelRes.getInstance();
        MFWNodeObject aProjNode = this.getCluster().getRootNode().getObjectNode(gModelRes.RID_project);
        MFWException.ASSERT((aProjNode != null ? 1 : 0) != 0, (String)"Failed to locate the project node in DimConnection::reconstructSetup");
        this.mHlprLocale.setupLocales(aContext, aProjNode, aLinkNodeParent, false);
        this.mObjLoader = new MFWDimObjectLoader(this, this.mHlprLocale);
        this.mRootNamespace = aProjNode.getObjectNode(gModelRes.RID_namespace);
        MFWException.ASSERT((this.mRootNamespace != null ? 1 : 0) != 0, (String)"Failed to locate the root namespace node in DimConnection::reconstructSetup");
        this.mRootNamespaceID = this.mRootNamespace.getPropertyValue(gModelRes.RID_ID);
        MFWException.ASSERT((this.mRootNamespaceID != null ? 1 : 0) != 0, (String)"Expecting an ID property for root LWM namespace in DimConnection::reconstructSetup");
        this.mDataSourceNode = this.mObjLoader.reconstructDataSource(aProjNode);
        ((MFWDimConnectionReuseInfo)this.getReuseInfo()).addRecentUser(aContext);
    }

    protected void expand(MFWRequestContextUser aContext, MFWQuerySpec aQuerySpec, MFWNodeObject objNode) {
        Step currStep = aQuerySpec.getCurrentStepPattern();
        MFWException.ASSERT((boolean)(currStep instanceof NameStep), (String)"Expecting a NameStep to expand");
        if (!"*".equals(((NameStep)currStep).getLocalName())) {
            this.expand(aContext, aQuerySpec, aQuerySpec.getCurrentStepPatternRID(), objNode);
        } else {
            MFWInfo[] vChildren = objNode.getObjectInfo().getChildrenInfo();
            for (int idx = 0; idx < vChildren.length; ++idx) {
                this.expand(aContext, aQuerySpec, vChildren[idx].getRID(), objNode);
            }
        }
    }

    protected String evaluateDynamicProperty(MFWRequestContextUser aContext, short ridDynProp, MFWNodeObject parentNode) {
        String outValue = null;
        outValue = ridDynProp == MFWModelRes.getInstance().RID_visible ? parentNode.getPropertyValue(MFWModelRes.getInstance().RID_visible) : super.evaluateDynamicProperty(aContext, ridDynProp, parentNode);
        return outValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MFWNodeObject lookup(MFWRequestContextUser aContext, MFWInfoProperty indexProp, String indexValue, MFWNodeObject rootNode, List<MFWNodeObject> ancestorsChain) {
        boolean bNameMatchupIsNeeded = this.mHlprLocale.getAllLocales().size() > 1;
        ArrayList vIDEntries = new ArrayList();
        MFWCrnIDHelper.parseID((String)indexValue, vIDEntries);
        if (vIDEntries.isEmpty()) {
            return null;
        }
        if (!this.doesNameMatch(this.mRootNamespace, (String)vIDEntries.get(0))) {
            return null;
        }
        MFWNodeObject lookedNode = null;
        String sPartialID = this.mRootNamespaceID;
        MFWNodeObject parentNode = this.mRootNamespace;
        MFWCluster aCluster = this.mRootNamespace.getCluster();
        for (int idx = 1; idx < vIDEntries.size(); ++idx) {
            sPartialID = MFWCrnIDHelper.addEntryToID((String)sPartialID, (String)((String)vIDEntries.get(idx)));
            lookedNode = aCluster.getIndexManager().lookup(indexProp, sPartialID);
            if (lookedNode == null) {
                short[] childRIDs = this.mOlapSchema.getChildTypes(parentNode.getNameRID());
                if (childRIDs == null) {
                    return null;
                }
                Object object = parentNode.getExpandLock();
                synchronized (object) {
                    for (int i = 0; lookedNode == null && i < childRIDs.length; ++i) {
                        MFWQuerySpec aQuerySpec = MFWQuerySpec.create((String)MFWModelRes.getInstance().getResource(childRIDs[i]));
                        this.expandChildren(aContext, aQuerySpec, parentNode, childRIDs[i]);
                        lookedNode = aCluster.getIndexManager().lookup(indexProp, sPartialID);
                        if (lookedNode != null || !bNameMatchupIsNeeded) continue;
                        lookedNode = this.lookChildrenByName(parentNode, childRIDs[i], (String)vIDEntries.get(idx));
                    }
                }
            }
            if (lookedNode == null) {
                return null;
            }
            parentNode = lookedNode;
        }
        if (lookedNode != null && ancestorsChain != null) {
            MFWCrnIDAdvancedLookup.addToAncestorsChain(lookedNode, (MFWNodeObject)this.mRootNamespace, ancestorsChain);
        }
        return lookedNode;
    }

    protected void notifyLinkSourceClosing(MFWCluster aSourceCluster, MFWRequestContextUser aContext) {
    }

    void expand(MFWRequestContextUser aContext, MFWQuerySpec querySpec, short ridChild, MFWNodeObject objNode) {
        if (objNode.getExpandStatus(ridChild) == 1) {
            return;
        }
        boolean bFound = this.expandChildren(aContext, querySpec, objNode, ridChild);
        if (!bFound) {
            bFound = this.expandFolders(aContext, querySpec, ridChild, objNode);
        }
        if (!bFound) {
            super.defaultExpand(aContext, ridChild, objNode);
        }
    }

    private boolean expandChildren(MFWRequestContextUser aContext, MFWQuerySpec aQuerySpec, MFWNodeObject parentNode, short ridChild) {
        if (!this.validateRequest(ridChild, parentNode)) {
            return false;
        }
        if (ridChild == MFWModelRes.getInstance().RID_rootMember) {
            return true;
        }
        if (parentNode.getExpandStatus(ridChild) == 1) {
            return true;
        }
        ArrayList<MFWOLAPSchema.DimObjectSpec> olapTypes = this.mOlapSchema.getObjectSpecs(ridChild);
        if (olapTypes.size() == 0) {
            return false;
        }
        for (int idx = 0; idx < olapTypes.size(); ++idx) {
            MFWOLAPSchema.DimObjectSpec olapType = olapTypes.get(idx);
            MFWMetadataRequest qfRequest = this.makeRequest(aContext, parentNode, olapType, aQuerySpec.getRetrievalDepth(), aQuerySpec.getRetrievalStartIndex(), aQuerySpec.getRetrievalCount());
            MFWMetadataResponse qfResponse = MFWMetadataRequest.doMetadataRequest(aContext.getContentLocale(), this.getSource(), qfRequest, this.getV5Bridge(aContext));
            this.populateCluster(aContext, aQuerySpec, parentNode, olapType, qfResponse);
        }
        return true;
    }

    private boolean expandFolders(MFWRequestContextUser aContext, MFWQuerySpec aQuerySpec, short ridPattern, MFWNodeObject objParent) {
        boolean bSupportsDimGroup;
        boolean bFound = false;
        MFWModelRes gModelRes = MFWModelRes.getInstance();
        String sConfigSetting = this.getAdaptor().getSourceConfig().getCapability("Display_Path");
        boolean bSupportsDisplayPath = sConfigSetting != null && "true".equals(sConfigSetting);
        sConfigSetting = this.getAdaptor().getSourceConfig().getCapability("dimensionGroup");
        boolean bl = bSupportsDimGroup = sConfigSetting != null && "true".equals(sConfigSetting);
        if (ridPattern == gModelRes.RID_folder && objParent.getNameRID() == gModelRes.RID_namespace) {
            if (bSupportsDimGroup) {
                bFound = this.expandChildren(aContext, aQuerySpec, objParent, gModelRes.RID_dimension);
            }
            if (bSupportsDisplayPath) {
                bFound = this.expandChildren(aContext, aQuerySpec, objParent, gModelRes.RID_calculation);
            }
        } else if (bSupportsDisplayPath && ridPattern == gModelRes.RID_hierarchyFolder && objParent.getNameRID() == gModelRes.RID_dimension) {
            bFound = this.expandChildren(aContext, aQuerySpec, objParent, gModelRes.RID_hierarchy);
        } else if (bSupportsDisplayPath && ridPattern == gModelRes.RID_measureFolder && (objParent.getNameRID() == gModelRes.RID_dimension || objParent.getNameRID() == gModelRes.RID_measure)) {
            bFound = this.expandChildren(aContext, aQuerySpec, objParent, gModelRes.RID_measure);
        }
        return bFound;
    }

    MFWMetadataResponse queryHierarchyRootMember(MFWRequestContextUser aContext, MFWNodeObject hierarchyObj) {
        ArrayList<MFWOLAPSchema.DimObjectSpec> olapTypes = this.mOlapSchema.getObjectSpecs(MFWModelRes.getInstance().RID_rootMember);
        MFWException.ASSERT((olapTypes.size() == 1 ? 1 : 0) != 0, (String)"Expecting exactly one OLAP type specification for root member");
        MFWMetadataRequest rootMemRequest = this.makeRequest(aContext, hierarchyObj, olapTypes.get(0), 0, 0, 2);
        return MFWMetadataRequest.doMetadataRequest(aContext.getContentLocale(), this.getSource(), rootMemRequest, this.getV5Bridge(aContext));
    }

    private MFWMetadataRequest makeRequest(MFWRequestContextUser aContext, MFWNodeObject objParent, MFWOLAPSchema.DimObjectSpec olapTypeInfo, int retrievalDepth, int startIndex, int retrievalCount) {
        MFWMetadataRequest outRequest = new MFWMetadataRequest(olapTypeInfo.getOLAPMetadataClass(), retrievalDepth, startIndex, retrievalCount);
        MFWModelRes gModelRes = MFWModelRes.getInstance();
        MFWDimConnection.makeConnection(aContext, outRequest, this.getSource(), this.mHlprLocale.getDesignLocale(), this.getAdaptor().getSourceConfig());
        for (int idx = 0; idx < olapTypeInfo.getOLAPProperties().length; ++idx) {
            outRequest.addProperty(olapTypeInfo.getOLAPProperties()[idx]);
        }
        this.addConstraint(this.mDataSourceNode, outRequest);
        this.mHlprLocale.addAliasTables(this.getSource(), objParent, outRequest);
        switch (olapTypeInfo.getOLAPType()) {
            case 70: {
                if (objParent.getNameRID() == gModelRes.RID_dimension) {
                    this.addConstraint(objParent, outRequest);
                    if ("DO".equals(this.getSource().getType()) || "EB".equals(this.getSource().getType())) {
                        outRequest.addConstraint(".[@Level_Number='1']");
                        break;
                    }
                    outRequest.addConstraint(".[@Level_Number='0']");
                    break;
                }
                if (objParent.getNameRID() == gModelRes.RID_measure || objParent.getNameRID() == gModelRes.RID_measureFolder) {
                    this.addConstraint(objParent, outRequest);
                    outRequest.addConstraint(".[@Tree_Operator='CHILDREN']");
                    break;
                }
                MFWException.ASSERT((boolean)false, (String)"Unexpected parent object when querying measures");
                break;
            }
            case 80: {
                outRequest.addConstraint(".[@Level_Number='0']");
            }
            default: {
                while (objParent.getNameRID() != gModelRes.RID_namespace) {
                    this.addConstraint(objParent, outRequest);
                    objParent = (MFWNodeObject)objParent.getParent();
                }
                break block0;
            }
        }
        return outRequest;
    }

    public static final void makeConnection(MFWRequestContextUser aContext, MFWMetadataRequest myReqHlpr, MFWMetadataSource aSource, String sDesignLocale, MFWConfiguration.MFWConfigSource srcConfig) {
        myReqHlpr.addConnectionEntry("dataSourceType", srcConfig.getQFWProviderName());
        myReqHlpr.addConnectionEntry("CAMPassport", aContext.getUserPassport());
        myReqHlpr.addConnectionEntry("contentManagerURI", MFWContentHelper.getCMDispatcherURI());
        String requestID = MFWDimConnection.getConnectionValueFor(aContext.getConnectionSpec(), "requestID");
        if (requestID != null && requestID.length() > 0) {
            myReqHlpr.addConnectionEntry("requestID", requestID);
        }
        myReqHlpr.addConnectionEntry("serviceID", "MFWA4J");
        myReqHlpr.addConnectionEntry("productLocale", aContext.getProductLocale());
        String sRunLocale = (String)aSource.getConnectionItem("runLocale");
        if (sRunLocale == null || sRunLocale.length() == 0) {
            myReqHlpr.addConnectionEntry("runLocale", sDesignLocale);
        }
        for (Map.Entry aPair : aSource.getConnectionInfo().entrySet()) {
            myReqHlpr.addConnectionEntry((String)aPair.getKey(), (String)aPair.getValue());
        }
        for (Map.Entry aPair : aSource.getScopeInfo().entrySet()) {
            myReqHlpr.addConnectionEntry((String)aPair.getKey(), (String)aPair.getValue());
        }
        for (Map.Entry aPair : aSource.getSignonInfo().entrySet()) {
            myReqHlpr.addConnectionEntry((String)aPair.getKey(), (String)aPair.getValue());
        }
    }

    private boolean validateRequest(short ridChild, MFWNodeObject objParent) {
        MFWModelRes gModelRes = MFWModelRes.getInstance();
        if (ridChild == gModelRes.RID_measure || ridChild == gModelRes.RID_measureFolder) {
            MFWNodeObject parent;
            for (parent = objParent; parent != null && parent.getNameRID() != gModelRes.RID_dimension; parent = parent.getParentObject()) {
            }
            MFWException.ASSERT((parent != null ? 1 : 0) != 0, (String)"Expecting a valid dimension in measure/measureFolder ancestry");
            String aProp = parent.getPropertyValue(gModelRes.RID_type);
            if (aProp == null || !"measure".equals(aProp)) {
                return false;
            }
        } else {
            if (ridChild == gModelRes.RID_dimension || ridChild == gModelRes.RID_calculation) {
                return objParent.getNameRID() == gModelRes.RID_namespace;
            }
            if (ridChild == gModelRes.RID_hierarchy) {
                if (objParent.getNameRID() != gModelRes.RID_dimension) {
                    return false;
                }
                String aProp = objParent.getPropertyValue(gModelRes.RID_type);
                if (aProp == null || "measure".equals(aProp)) {
                    return false;
                }
            } else if (ridChild == gModelRes.RID_queryItem) {
                if (objParent.getNameRID() != gModelRes.RID_level && objParent.getNameRID() != gModelRes.RID_hierarchy) {
                    return false;
                }
                String aProp = objParent.getPropertyValue(gModelRes.RID_visible);
                if (aProp != null && "hiddenAndAccessible".equals(aProp)) {
                    return false;
                }
                if (objParent.getNameRID() == gModelRes.RID_hierarchy) {
                    aProp = objParent.getPropertyValue(gModelRes.RID_parentChild);
                    return aProp != null && "true".equals(aProp);
                }
            } else if (ridChild == gModelRes.RID_rootMember) {
                String aProp = objParent.getPropertyValue(gModelRes.RID_visible);
                return aProp == null || !"hiddenAndAccessible".equals(aProp);
            }
        }
        return true;
    }

    private String queryCubeName(MFWRequestContextUser aContext) {
        MFWMetadataRequest cubeReq = new MFWMetadataRequest("Cube", 0, 0, 0);
        MFWDimConnection.makeConnection(aContext, cubeReq, this.getSource(), this.mHlprLocale.getDesignLocale(), this.getAdaptor().getSourceConfig());
        cubeReq.addProperty("Cube_Name");
        MFWMetadataResponse cubeResp = MFWMetadataRequest.doMetadataRequest(aContext.getContentLocale(), this.getSource(), cubeReq, this.getV5Bridge(aContext));
        Element firstEntry = cubeResp.getFirstEntity();
        MFWException.ASSERT((firstEntry != null ? 1 : 0) != 0, (String)"Expecting a response entry in response to a cube name query");
        return MFWMetadataResponse.getPropertyValue(firstEntry, "Cube_Name");
    }

    private void populateCluster(MFWRequestContextUser aContext, MFWQuerySpec aQuerySpec, MFWNodeObject objParent, MFWOLAPSchema.DimObjectSpec dimObjSpec, MFWMetadataResponse response) {
        this.mObjLoader.populateCluster(aContext, aQuerySpec, dimObjSpec.getOLAPType(), objParent, response);
        objParent.setExpandStatus(dimObjSpec.getObjRID(), (byte)1);
    }

    private String queryCubeInfo(MFWRequestContextUser aContext, boolean doPopulateDataSrcInfo) {
        String outLastSchemaUpdate = null;
        ArrayList<MFWOLAPSchema.DimObjectSpec> specs = this.mOlapSchema.getObjectSpecs(MFWModelRes.getInstance().RID_dataSource);
        MFWException.ASSERT((specs.size() == 1 ? 1 : 0) != 0, (String)"Expecting exactly one OLAP object spec for 'data source'");
        MFWOLAPSchema.DimObjectSpec cubeSpec = specs.get(0);
        MFWMetadataRequest cubeReq = new MFWMetadataRequest(cubeSpec.getOLAPMetadataClass(), 0, 0, 0);
        MFWDimConnection.makeConnection(aContext, cubeReq, this.getSource(), this.mHlprLocale.getDesignLocale(), this.getAdaptor().getSourceConfig());
        for (int idx = 0; idx < cubeSpec.getOLAPProperties().length; ++idx) {
            cubeReq.addProperty(cubeSpec.getOLAPProperties()[idx]);
        }
        this.addConstraint(this.mDataSourceNode, cubeReq);
        MFWMetadataResponse cubeResp = MFWMetadataRequest.doMetadataRequest(aContext.getContentLocale(), this.getSource(), cubeReq, this.getV5Bridge(aContext));
        Element firstEntry = cubeResp.getFirstEntity();
        MFWException.ASSERT((firstEntry != null ? 1 : 0) != 0, (String)"Expecting a response entry in response to a cube properties");
        outLastSchemaUpdate = MFWMetadataResponse.getPropertyValue(firstEntry, "Last_Schema_Update");
        if (doPopulateDataSrcInfo) {
            this.mObjLoader.populateCubeProps(this.mDataSourceNode, this.getSource(), firstEntry);
        }
        return outLastSchemaUpdate;
    }

    private void addConstraint(MFWNodeObject objNode, MFWMetadataRequest myReqHlpr) {
        MFWModelRes gModelRes = MFWModelRes.getInstance();
        if (objNode.getNameRID() == gModelRes.RID_folder || objNode.getNameRID() == gModelRes.RID_hierarchyFolder || objNode.getNameRID() == gModelRes.RID_measureFolder) {
            return;
        }
        if (objNode.getNameRID() == gModelRes.RID_dataSource) {
            String scopeDataSrc = objNode.getPropertyValue(gModelRes.RID_catalog);
            if (scopeDataSrc != null) {
                myReqHlpr.addConstraint("Catalog_Name", scopeDataSrc);
            }
            if ((scopeDataSrc = objNode.getPropertyValue(gModelRes.RID_schema)) != null) {
                myReqHlpr.addConstraint("Schema_Name", scopeDataSrc);
            }
            if ((scopeDataSrc = objNode.getPropertyValue(gModelRes.RID_cube)) != null) {
                myReqHlpr.addConstraint("Cube_Name", scopeDataSrc);
            }
        } else {
            String extName = objNode.getPropertyValue(gModelRes.RID_externalName);
            MFWException.ASSERT((extName != null ? 1 : 0) != 0, (String)"An externalName is expected -- AddConstraint");
            if (objNode.getNameRID() == gModelRes.RID_measureFolder) {
                myReqHlpr.addConstraint("Measure_Unique_Name", extName);
            } else {
                StringBuffer sConstName = new StringBuffer(objNode.getName().substring(0, 1).toUpperCase());
                sConstName.append(objNode.getName().substring(1));
                sConstName.append("_Unique_Name");
                myReqHlpr.addConstraint(sConstName.toString(), extName);
            }
        }
    }

    private static String getConnectionValueFor(Element elmConn, String sPropName) {
        String sPropValue = "";
        if (elmConn == null) {
            return sPropValue;
        }
        Node nodeProp = elmConn.selectSingleNode(sPropName);
        if (nodeProp != null && nodeProp instanceof Element) {
            sPropValue = ((Element)nodeProp).attributeValue("value");
        }
        return sPropValue;
    }

    private boolean doesNameMatch(MFWNodeObject objNode, String sName) {
        List vNames = objNode.getObjectNodes(MFWModelRes.getInstance().RID_name);
        for (int idx = 0; idx < vNames.size(); ++idx) {
            String value = ((MFWNodeObject)vNames.get(idx)).getPropertyValue(MFWModelRes.getInstance().RID__Value);
            if (value == null || !sName.equals(value)) continue;
            return true;
        }
        return false;
    }

    private MFWNodeObject lookChildrenByName(MFWNodeObject objNode, short ridChildName, String sName) {
        List vChildren = objNode.getObjectNodes(ridChildName);
        for (int idx = 0; idx < vChildren.size(); ++idx) {
            if (!this.doesNameMatch((MFWNodeObject)vChildren.get(idx), sName)) continue;
            return (MFWNodeObject)vChildren.get(idx);
        }
        return null;
    }
}

