/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfwa4j.adaptorDimMDDS;

import com.cognos.mfw4j.framework.MFWCluster;
import com.cognos.mfw4j.framework.MFWCrnIDGenerator;
import com.cognos.mfw4j.framework.MFWInfo;
import com.cognos.mfw4j.framework.MFWInfoObject;
import com.cognos.mfw4j.framework.MFWInfoProperty;
import com.cognos.mfw4j.framework.MFWMetadataSource;
import com.cognos.mfw4j.framework.MFWModelRes;
import com.cognos.mfw4j.framework.MFWNodeObject;
import com.cognos.mfw4j.framework.MFWQuerySpec;
import com.cognos.mfw4j.framework.MFWRequestContextUser;
import com.cognos.mfw4j.utilities.MFWException;
import com.cognos.mfw4j.utilities.MFWStringHelper;
import com.cognos.mfwa4j.adaptorDimMDDS.MFWDimConnection;
import com.cognos.mfwa4j.adaptorDimMDDS.MFWDimLocaleHelper;
import com.cognos.mfwa4j.adaptorDimMDDS.MFWMUNTransformations;
import com.cognos.mfwa4j.adaptorDimMDDS.MFWMetadataResponse;
import com.cognos.mfwa4j.adaptorDimMDDS.MFWOLAPSchema;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.dom4j.Element;

final class MFWDimObjectLoader {
    private MFWDimConnection mDimConnection;
    private MFWCrnIDGenerator mIDGenerator;
    MFWDimLocaleHelper mHlprLocale;
    String mDataSourceId;
    private boolean mSupportsDisplayPath;
    private MFWOLAPSchema mOlapSchema;

    MFWDimObjectLoader(MFWDimConnection dimConnection, MFWDimLocaleHelper hlprLocale) {
        this.mDimConnection = dimConnection;
        this.mIDGenerator = new MFWCrnIDGenerator(dimConnection.getCluster());
        this.mHlprLocale = hlprLocale;
        this.mDataSourceId = null;
        String sDispPath = this.mDimConnection.getAdaptor().getSourceConfig().getCapability("Display_Path");
        this.mSupportsDisplayPath = "true".equals(sDispPath);
        this.mOlapSchema = new MFWOLAPSchema();
    }

    void destroy() {
        this.mDimConnection = null;
        this.mIDGenerator.destroy();
        this.mHlprLocale = null;
        this.mOlapSchema = null;
    }

    void populateCluster(MFWRequestContextUser aContext, MFWQuerySpec querySpec, short olapType, MFWNodeObject objNode, MFWMetadataResponse response) {
        switch (olapType) {
            case 30: {
                this.populateDimensions(aContext, querySpec, objNode, response);
                break;
            }
            case 40: {
                this.populateHierarchies(aContext, querySpec, objNode, response);
                break;
            }
            case 50: {
                this.populateLevels(aContext, querySpec, objNode, response);
                break;
            }
            case 10: {
                this.populateAttributes(aContext, querySpec, objNode, response);
                break;
            }
            case 70: {
                this.populateMeasures(aContext, querySpec, objNode, response);
                break;
            }
            case 90: {
                this.populateNamedSets(aContext, querySpec, objNode, response);
                break;
            }
            case 60: {
                this.populateMacros(aContext, querySpec, objNode, response);
                break;
            }
            default: {
                MFWException.ASSERT((boolean)false, (String)"Unexpected olap object type:", (String)Integer.toString(olapType));
            }
        }
    }

    MFWNodeObject setupProject(MFWNodeObject rootNode, MFWMetadataSource aMetadataSrc) {
        MFWModelRes gModelRes = MFWModelRes.getInstance();
        String sCmDataSrcName = (String)aMetadataSrc.getConnectionItem("cmDataSource");
        MFWNodeObject projNode = rootNode.addObjectNode(gModelRes.RID_project);
        MFWException.ASSERT((projNode != null ? 1 : 0) != 0, (String)"Failed to create the project node");
        String sUsedName = sCmDataSrcName == null || sCmDataSrcName.length() == 0 ? "olapProj" : sCmDataSrcName;
        projNode.addProperty(gModelRes.RID_name, sUsedName);
        return projNode;
    }

    MFWNodeObject setupRootNamespace(MFWNodeObject projNode, MFWNodeObject linkParent, String sCubeName) {
        MFWModelRes gModelRes = MFWModelRes.getInstance();
        MFWNodeObject nsNode = projNode.addExpandableObjectNode(gModelRes.RID_namespace);
        if (linkParent != null) {
            String sNSName = MFWDimLocaleHelper.getLocalizedName(linkParent, this.mHlprLocale.getDesignLocale());
            String sUsedName = this.mIDGenerator.generate(nsNode, sNSName, true);
            MFWException.ASSERT((boolean)sUsedName.equals(sNSName), (String)"The name of the OLAP root namespace must be the same as the name in the parent cluster");
            this.mHlprLocale.addLocalizedProp(nsNode, gModelRes.RID_name, sUsedName, this.mHlprLocale.getDesignLocale());
            ArrayList<String> vAltLocales = this.mHlprLocale.getAllLocales();
            for (int lIdx = 1; lIdx < vAltLocales.size(); ++lIdx) {
                sNSName = MFWDimLocaleHelper.getLocalizedName(linkParent, vAltLocales.get(lIdx));
                this.mHlprLocale.addLocalizedProp(nsNode, gModelRes.RID_name, sNSName, vAltLocales.get(lIdx));
            }
        } else {
            String sUsedName = this.mIDGenerator.generate(nsNode, sCubeName, true);
            this.mHlprLocale.addLocalizedProperties(nsNode, gModelRes.RID_name, sUsedName, null, null);
        }
        return nsNode;
    }

    MFWNodeObject reconstructDataSource(MFWNodeObject projNode) {
        MFWModelRes gModelRes = MFWModelRes.getInstance();
        MFWNodeObject dsNode = projNode.getObjectNode(gModelRes.RID_dataSource);
        MFWException.ASSERT((dsNode != null ? 1 : 0) != 0, (String)"Expecting a valid data source object --- DimObjectLoader::reconstructDataSource");
        this.mDataSourceId = dsNode.getPropertyValue(gModelRes.RID_ID);
        MFWException.ASSERT((this.mDataSourceId != null ? 1 : 0) != 0, (String)"Failed to generate an ID property");
        return dsNode;
    }

    MFWNodeObject setupDataSource(MFWRequestContextUser aContext, MFWNodeObject projNode, MFWMetadataSource aMetadataSrc, String sCubeName) {
        MFWModelRes gModelRes = MFWModelRes.getInstance();
        MFWNodeObject dsNode = projNode.addObjectNode(gModelRes.RID_dataSource);
        String sCmDataSrcName = (String)aMetadataSrc.getConnectionItem("cmDataSource");
        String sCmDataSrcUniqueName = this.makeDatasourceNameUnique(aContext, sCmDataSrcName);
        String sUsedName = this.mIDGenerator.generate(dsNode, sCmDataSrcUniqueName != null && sCmDataSrcUniqueName.length() > 0 ? sCmDataSrcUniqueName : sCubeName, true);
        this.mDataSourceId = dsNode.getPropertyValue(gModelRes.RID_ID);
        MFWException.ASSERT((this.mDataSourceId != null ? 1 : 0) != 0, (String)"Failed to generate an ID property");
        dsNode.addProperty(gModelRes.RID_name, sUsedName);
        String temp = (String)aMetadataSrc.getConnectionItem("cmDataSource");
        if (temp != null) {
            dsNode.addProperty(gModelRes.RID_cmDataSource, temp);
        } else {
            dsNode.addProperty(gModelRes.RID_cmDataSource, sCubeName);
        }
        temp = (String)aMetadataSrc.getScope("catalog");
        if (temp != null) {
            dsNode.addProperty(gModelRes.RID_catalog, temp);
        }
        if ((temp = (String)aMetadataSrc.getScope("schema")) != null) {
            dsNode.addProperty(gModelRes.RID_schema, temp);
        }
        dsNode.addProperty(gModelRes.RID_cube, sCubeName);
        dsNode.addProperty(gModelRes.RID_queryType, "multidimensional");
        dsNode.addProperty(gModelRes.RID_interface, aMetadataSrc.getType());
        String tempValue = (String)aMetadataSrc.getConnectionItem("attribute");
        if ("dimension".equals(tempValue)) {
            dsNode.addProperty(gModelRes.getResourceID("attributeDimensionsAsProperties"), "false");
        }
        this.mHlprLocale.setupAlaisParamMaps(aMetadataSrc, this.mIDGenerator, projNode, dsNode, sUsedName);
        return dsNode;
    }

    void populateCubeProps(MFWNodeObject dataSourceNode, MFWMetadataSource aMetadataSrc, Element cubeEntity) {
        boolean isUnix;
        MFWModelRes gModelRes = MFWModelRes.getInstance();
        MFWException.ASSERT((cubeEntity != null ? 1 : 0) != 0, (String)"Expecting at least one entry in response to Cube properties query");
        String sTemp = null;
        sTemp = MFWMetadataResponse.getPropertyValue(cubeEntity, "Description");
        if (sTemp != null && sTemp.length() > 0) {
            dataSourceNode.addProperty(gModelRes.RID_cubeDescription, sTemp);
        }
        if ((sTemp = !(isUnix = "/".equals(System.getProperty("file.separator"))) ? (String)aMetadataSrc.getConnectionItem("winDataSource") : (String)aMetadataSrc.getConnectionItem("unixDataSource")) != null && sTemp.length() > 0) {
            dataSourceNode.addProperty(gModelRes.RID_cubePath, sTemp);
        }
        if ((sTemp = MFWMetadataResponse.getPropertyValue(cubeEntity, "Created_On")) != null && sTemp.length() > 0) {
            dataSourceNode.addProperty(gModelRes.RID_cubeCreatedOn, sTemp);
        }
        if ((sTemp = MFWMetadataResponse.getPropertyValue(cubeEntity, "Last_Data_Update")) != null && sTemp.length() > 0) {
            dataSourceNode.addProperty(gModelRes.RID_cubeDataUpdatedOn, sTemp);
        }
        if ((sTemp = MFWMetadataResponse.getPropertyValue(cubeEntity, "Last_Schema_Update")) != null && sTemp.length() > 0) {
            dataSourceNode.addProperty(gModelRes.RID_cubeSchemaUpdatedOn, sTemp);
        }
        if ((sTemp = MFWMetadataResponse.getPropertyValue(cubeEntity, "Is_Optimized")) != null && sTemp.length() > 0) {
            dataSourceNode.addProperty(gModelRes.RID_cubeIsOptimized, sTemp);
        }
        if ((sTemp = MFWMetadataResponse.getPropertyValue(cubeEntity, "Default_Measure")) != null && sTemp.length() > 0) {
            dataSourceNode.addProperty(gModelRes.RID_cubeDefaultMeasure, sTemp);
        }
        if ((sTemp = MFWMetadataResponse.getPropertyValue(cubeEntity, "Current_Period")) != null && sTemp.length() > 0) {
            dataSourceNode.addProperty(gModelRes.RID_cubeCurrentPeriod, sTemp);
        }
        if ((sTemp = MFWMetadataResponse.getPropertyValue(cubeEntity, "Suppression")) != null && sTemp.length() > 0) {
            dataSourceNode.addProperty(gModelRes.RID_suppression, sTemp);
        }
    }

    private String genObjectProperties(Element anEntity, MFWNodeObject objNode, String nameProp) {
        String idNode;
        String sIsHidden;
        MFWModelRes gModelRes = MFWModelRes.getInstance();
        String sCaption = MFWMetadataResponse.getPropertyValue(anEntity, nameProp);
        String sDescription = MFWMetadataResponse.getPropertyValue(anEntity, "Description");
        String sUsedName = this.mIDGenerator.generate(objNode, sCaption, true);
        this.mHlprLocale.addLocalizedProperties(objNode, gModelRes.RID_name, sUsedName, anEntity, "Caption");
        if (sDescription != null && sDescription.length() > 0) {
            this.mHlprLocale.addLocalizedProperties(objNode, gModelRes.RID_description, sDescription, anEntity, "Description");
        }
        if ((sIsHidden = MFWMetadataResponse.getPropertyValue(anEntity, "Is_Hidden")) != null && "true".equals(sIsHidden)) {
            objNode.addProperty(gModelRes.RID_visible, "hiddenAndAccessible");
        }
        MFWException.ASSERT(((idNode = objNode.getPropertyValue(gModelRes.RID_ID)) != null ? 1 : 0) != 0, (String)"Expecting a valid ID property");
        return idNode;
    }

    private String genObjectProperties(String sCaption, String sDescription, MFWNodeObject objNode) {
        String idNode;
        MFWModelRes gModelRes = MFWModelRes.getInstance();
        String sUsedName = this.mIDGenerator.generate(objNode, sCaption, true);
        this.mHlprLocale.addLocalizedProperties(objNode, gModelRes.RID_name, sUsedName, null, null);
        if (sDescription != null && sDescription.length() > 0) {
            this.mHlprLocale.addLocalizedProperties(objNode, gModelRes.RID_description, sDescription, null, null);
        }
        MFWException.ASSERT(((idNode = objNode.getPropertyValue(gModelRes.RID_ID)) != null ? 1 : 0) != 0, (String)"Expecting a valid ID property");
        return idNode;
    }

    private void populateDimensions(MFWRequestContextUser aContext, MFWQuerySpec querySpec, MFWNodeObject objNode, MFWMetadataResponse response) {
        ArrayList<MFWNodeObject> vMsrDims = new ArrayList<MFWNodeObject>();
        ArrayList<MFWNodeObject> vRegDims = new ArrayList<MFWNodeObject>();
        MFWModelRes gModelRes = MFWModelRes.getInstance();
        String sDimGrp = this.mDimConnection.getAdaptor().getSourceConfig().getCapability("dimensionGroup");
        boolean bSupportsDimGroup = "true".equals(sDimGrp);
        ArrayList<String> vDuplicateNames = new ArrayList<String>();
        if (bSupportsDimGroup) {
            this.collectConflictingFolderNames(response, vDuplicateNames);
        }
        HashMap<String, MFWNodeObject> mapDim2Folders = new HashMap<String, MFWNodeObject>();
        Element anEntity = response.getFirstEntity();
        while (anEntity != null) {
            String sDimGroupName = null;
            if (bSupportsDimGroup) {
                sDimGroupName = MFWMetadataResponse.getPropertyValue(anEntity, "Dimension_Group_Name");
            }
            MFWNodeObject dimObj = null;
            dimObj = sDimGroupName != null && sDimGroupName.length() > 0 ? this.addDimensionToFolder(objNode, sDimGroupName, vDuplicateNames, mapDim2Folders) : objNode.addExpandableObjectNode(gModelRes.RID_dimension);
            this.genObjectProperties(anEntity, dimObj, "Caption");
            String sTemp = MFWMetadataResponse.getPropertyValue(anEntity, "PPDS_CODE");
            dimObj.addProperty(gModelRes.RID_PPDS_CODE, sTemp);
            dimObj.addProperty(gModelRes.RID_definitionType, "mdQuery");
            dimObj.addProperty(gModelRes.RID_dataSourceRef, this.mDataSourceId);
            sTemp = MFWMetadataResponse.getPropertyValue(anEntity, "Dimension_Unique_Name");
            dimObj.addProperty(gModelRes.RID_externalName, sTemp);
            this.mHlprLocale.setAialsTableMapRefForDimension(dimObj, sTemp);
            String sType = MFWMetadataResponse.getPropertyValue(anEntity, "Type");
            dimObj.addProperty(gModelRes.RID_type, this.mOlapSchema.mapType(sType, MFWOLAPSchema.mDimensionTypes));
            this.determineMembersRollup(dimObj, sType);
            if ("Measure".equals(sType)) {
                vMsrDims.add(dimObj);
            } else {
                vRegDims.add(dimObj);
                sTemp = MFWMetadataResponse.getPropertyValue(anEntity, "Default_Hierarchy");
                this.mDimConnection.expand(aContext, querySpec, gModelRes.RID_hierarchy, dimObj);
                ArrayList childObjects = new ArrayList();
                dimObj.findObjectNodesRecursively(gModelRes.RID_hierarchy, gModelRes.RID_hierarchyFolder, gModelRes.RID_externalName, sTemp, true, childObjects);
                MFWException.ASSERT((childObjects.size() == 1 ? 1 : 0) != 0, (String)"Expecting one hierarchy object for dimension's specified default hierarchy:", (String)sTemp);
                String propId = ((MFWNodeObject)childObjects.get(0)).getPropertyValue(gModelRes.RID_ID);
                MFWException.ASSERT((propId != null ? 1 : 0) != 0, (String)"Expecting an ID property for the default hierarchy");
                dimObj.addProperty(gModelRes.RID_defaultHierarchy, propId);
            }
            anEntity = response.getNextEntity();
        }
        this.populateScopeRelations(objNode, vMsrDims, vRegDims);
    }

    private MFWNodeObject addDimensionToFolder(MFWNodeObject parentObj, String sDimGroupName, ArrayList<String> vConflictingNames, HashMap<String, MFWNodeObject> mapDimGroups) {
        MFWModelRes gModelRes = MFWModelRes.getInstance();
        StringBuffer sModifiedName = new StringBuffer("");
        if (vConflictingNames.contains(sDimGroupName)) {
            sModifiedName.append("*");
        }
        sModifiedName.append(sDimGroupName);
        String nameModified = sModifiedName.toString();
        MFWNodeObject objDimFolder = mapDimGroups.get(nameModified);
        if (objDimFolder == null) {
            objDimFolder = parentObj.addObjectNode(gModelRes.RID_folder);
            this.genObjectProperties(nameModified, "", objDimFolder);
            mapDimGroups.put(nameModified, objDimFolder);
        }
        MFWNodeObject dimObj = objDimFolder.addExpandableObjectNode(gModelRes.RID_dimension);
        return dimObj;
    }

    private void determineMembersRollup(MFWNodeObject objDim, String sDimType) {
        boolean bMembersRolledUp = true;
        if ("Account".equals(sDimType) || "Scenario".equals(sDimType) || "Time".equals(sDimType) && "PC".equals(this.mDimConnection.getSource().getType())) {
            bMembersRolledUp = false;
        }
        objDim.addProperty(MFWModelRes.getInstance().RID_membersRollup, bMembersRolledUp ? "true" : "false");
    }

    private void populateHierarchies(MFWRequestContextUser aContext, MFWQuerySpec querySpec, MFWNodeObject objNode, MFWMetadataResponse response) {
        MFWModelRes gModelRes = MFWModelRes.getInstance();
        HashMap<String, MFWNodeObject> mDispFolders = new HashMap<String, MFWNodeObject>();
        ArrayList<String> vDimCaptions = new ArrayList<String>();
        if (this.mSupportsDisplayPath) {
            this.collectObjectCaptions(response, vDimCaptions);
        }
        Element anEntity = response.getFirstEntity();
        while (anEntity != null) {
            String sDispPath = null;
            if (this.mSupportsDisplayPath) {
                sDispPath = MFWMetadataResponse.getPropertyValue(anEntity, "Display_Path");
            }
            if (sDispPath != null && sDispPath.length() > 0 && !"\\".equals(sDispPath)) {
                ArrayList<MFWNodeObject> vHierFolders = this.addOrFindFoldersForPath(objNode, sDispPath, vDimCaptions, gModelRes.RID_hierarchyFolder, mDispFolders);
                for (int idx = 0; idx < vHierFolders.size(); ++idx) {
                    this.addHierarchy(aContext, querySpec, vHierFolders.get(idx), anEntity);
                }
            } else {
                this.addHierarchy(aContext, querySpec, objNode, anEntity);
            }
            anEntity = response.getNextEntity();
        }
    }

    private void addHierarchy(MFWRequestContextUser aContext, MFWQuerySpec querySpec, MFWNodeObject parentObj, Element anEntity) {
        MFWModelRes gModelRes = MFWModelRes.getInstance();
        MFWNodeObject hierObj = parentObj.addExpandableObjectNode(gModelRes.RID_hierarchy);
        String sTemp = null;
        this.genObjectProperties(anEntity, hierObj, "Caption");
        sTemp = MFWMetadataResponse.getPropertyValue(anEntity, "PPDS_CODE");
        hierObj.addProperty(gModelRes.RID_PPDS_CODE, sTemp);
        sTemp = MFWMetadataResponse.getPropertyValue(anEntity, "Hierarchy_Unique_Name");
        hierObj.addProperty(gModelRes.RID_externalName, sTemp);
        boolean bIsSingleRoot = false;
        String visibleDimProp = parentObj.getPropertyValue(gModelRes.RID_visible);
        String visibleHierProp = hierObj.getPropertyValue(gModelRes.RID_visible);
        boolean bVisible = visibleDimProp == null || !"hiddenAndAccessible".equals(visibleDimProp) && (visibleHierProp == null || !"hiddenAndAccessible".equals(visibleHierProp));
        MFWMetadataResponse hlprRootMember = null;
        Element singleRootMemEntity = null;
        if (bVisible) {
            hlprRootMember = this.mDimConnection.queryHierarchyRootMember(aContext, hierObj);
            singleRootMemEntity = hlprRootMember.getFirstEntity();
            bIsSingleRoot = singleRootMemEntity != null && hlprRootMember.getNextEntity() == null;
        }
        hierObj.addProperty(gModelRes.RID_multiRoot, bIsSingleRoot ? "false" : "true");
        sTemp = MFWMetadataResponse.getPropertyValue(anEntity, "Balanced_Hierarchy");
        hierObj.addProperty(gModelRes.RID_balanced, sTemp);
        sTemp = MFWMetadataResponse.getPropertyValue(anEntity, "Ragged_Hierarchy");
        hierObj.addProperty(gModelRes.RID_ragged, sTemp);
        if (bIsSingleRoot) {
            sTemp = MFWMetadataResponse.getPropertyValue(singleRootMemEntity, "_rollupType");
            hierObj.addProperty(gModelRes.RID_rootMemberRollup, sTemp);
            sTemp = MFWMetadataResponse.getPropertyValue(singleRootMemEntity, "Member_Unique_Name");
            String modifiedMUN = MFWMUNTransformations.providerMUNToCognosMUN(this.mDimConnection.getSource().getType(), sTemp);
            hierObj.addProperty(gModelRes.RID_rootMUN, modifiedMUN);
            String sCaption = MFWMetadataResponse.getPropertyValue(singleRootMemEntity, "Caption");
            this.mHlprLocale.addLocalizedProperties(hierObj, gModelRes.RID_rootCaption, sCaption, singleRootMemEntity, "Caption");
        }
        hierObj.addProperty(gModelRes.RID_sortedHierarchy, "none");
        String sParentChild = MFWMetadataResponse.getPropertyValue(anEntity, "Parent_Child_Hierarchy");
        hierObj.addProperty(gModelRes.RID_parentChild, sParentChild);
        sTemp = MFWMetadataResponse.getPropertyValue(anEntity, "SSAS_Attribute_Hierarchy");
        if ("true".equals(sTemp)) {
            MFWNodeObject pCustProp = hierObj.addObjectNode(gModelRes.RID_property);
            pCustProp.addProperty(gModelRes.RID_name, "attributeHierarchy");
            pCustProp.addProperty(gModelRes.RID_type, "hidden");
            pCustProp.addProperty(gModelRes.RID__Value, sTemp);
        }
        String sDefaultMem = MFWMetadataResponse.getPropertyValue(anEntity, "Default_Member");
        String modifiedMUN = MFWMUNTransformations.providerMUNToCognosMUN(this.mDimConnection.getSource().getType(), sDefaultMem);
        hierObj.addProperty(gModelRes.getResourceID("defaultMemberExternalName"), modifiedMUN);
        if ("true".equals(sParentChild)) {
            this.populatePreDefinedAttributes(hierObj);
        }
    }

    private void populateLevels(MFWRequestContextUser aContext, MFWQuerySpec querySpec, MFWNodeObject objNode, MFWMetadataResponse response) {
        MFWModelRes gModelRes = MFWModelRes.getInstance();
        Element anEntity = response.getFirstEntity();
        while (anEntity != null) {
            MFWNodeObject objLevel = objNode.addExpandableObjectNode(gModelRes.RID_level);
            this.genObjectProperties(anEntity, objLevel, "Caption");
            String sTemp = MFWMetadataResponse.getPropertyValue(anEntity, "PPDS_CODE");
            objLevel.addProperty(gModelRes.RID_PPDS_CODE, sTemp);
            sTemp = MFWMetadataResponse.getPropertyValue(anEntity, "Is_Unique");
            objLevel.addProperty(gModelRes.RID_isUnique, sTemp);
            sTemp = MFWMetadataResponse.getPropertyValue(anEntity, "Level_Unique_Name");
            objLevel.addProperty(gModelRes.RID_externalName, sTemp);
            sTemp = MFWMetadataResponse.getPropertyValue(anEntity, "Level_Number");
            objLevel.addProperty(gModelRes.RID_externalOrdinal, sTemp);
            sTemp = MFWMetadataResponse.getPropertyValue(anEntity, "Base_Attribute_Hierarchy");
            if (sTemp != null && sTemp.length() > 0) {
                MFWNodeObject pCustProp = objLevel.addObjectNode(gModelRes.RID_property);
                pCustProp.addProperty(gModelRes.RID_name, "baseAttributeHierarchyRef");
                pCustProp.addProperty(gModelRes.RID_type, "hidden");
                pCustProp.addProperty(gModelRes.RID__Value, sTemp);
            }
            this.populatePreDefinedAttributes(objLevel);
            anEntity = response.getNextEntity();
        }
    }

    private void populateAttributes(MFWRequestContextUser aContext, MFWQuerySpec querySpec, MFWNodeObject objNode, MFWMetadataResponse response) {
        MFWModelRes gModelRes = MFWModelRes.getInstance();
        String visibleProp = objNode.getPropertyValue(gModelRes.RID_visible);
        if (visibleProp != null && "hiddenAndAccessible".equals(visibleProp)) {
            return;
        }
        Element anEntity = response.getFirstEntity();
        while (anEntity != null) {
            MFWNodeObject pQIObj = objNode.addObjectNode(gModelRes.RID_queryItem);
            this.genObjectProperties(anEntity, pQIObj, "Caption");
            String sTemp = MFWMetadataResponse.getPropertyValue(anEntity, "Attribute_Unique_Name");
            pQIObj.addProperty(gModelRes.RID_externalName, sTemp);
            pQIObj.addProperty(gModelRes.RID_usage, "attribute");
            sTemp = MFWMetadataResponse.getPropertyValue(anEntity, "Data_Type");
            pQIObj.addProperty(gModelRes.RID_datatype, this.mOlapSchema.mapType(sTemp, MFWOLAPSchema.mDataTypes));
            sTemp = MFWMetadataResponse.getPropertyValue(anEntity, "Role");
            if (sTemp != null && sTemp.length() > 0) {
                if ("_multiPartBusinessKey".equals(sTemp)) {
                    sTemp = "_businessKey";
                    MFWNodeObject pCustProp = pQIObj.addObjectNode(gModelRes.RID_property);
                    pCustProp.addProperty(gModelRes.RID_name, "multiPartKey");
                    pCustProp.addProperty(gModelRes.RID_type, "hidden");
                    pCustProp.addProperty(gModelRes.RID__Value, "true");
                }
                MFWNodeObject pRoleObj = pQIObj.addObjectNode(gModelRes.RID_role);
                this.mHlprLocale.addLocalizedProperties(pRoleObj, gModelRes.RID_name, sTemp, null, null);
            }
            this.addPropertyWithDefaultValue(pQIObj, gModelRes.RID_format);
            this.addPropertyWithDefaultValue(pQIObj, gModelRes.RID_scale);
            this.addPropertyWithDefaultValue(pQIObj, gModelRes.RID_precision);
            this.addPropertyWithDefaultValue(pQIObj, gModelRes.RID_size);
            this.addPropertyWithDefaultValue(pQIObj, gModelRes.RID_nullable);
            this.addPropertyWithDefaultValue(pQIObj, gModelRes.RID_regularAggregate);
            this.addPropertyWithDefaultValue(pQIObj, gModelRes.RID_semiAggregate);
            anEntity = response.getNextEntity();
        }
    }

    private void populatePreDefinedAttributes(MFWNodeObject objNode) {
        MFWModelRes gModelRes = MFWModelRes.getInstance();
        String visibleProp = objNode.getPropertyValue(gModelRes.RID_visible);
        if (visibleProp != null && "hiddenAndAccessible".equals(visibleProp)) {
            return;
        }
        for (int idx = 0; idx < MFWOLAPSchema.mPredefinedAttributes.length; ++idx) {
            MFWOLAPSchema.PredefinedAttribute predefAttr = MFWOLAPSchema.mPredefinedAttributes[idx];
            MFWNodeObject objAttr = objNode.addObjectNode(gModelRes.RID_queryItem);
            String sCaption = null;
            if ("Caption".equals(predefAttr.mName)) {
                MFWNodeObject nameObj = objNode.getObjectNode(gModelRes.RID_name);
                MFWException.ASSERT((nameObj != null ? 1 : 0) != 0, (String)"Expecting a name object for parent of Caption attribute");
                sCaption = nameObj.getPropertyValue(gModelRes.RID__Value);
                MFWException.ASSERT((sCaption != null ? 1 : 0) != 0, (String)"Expecting a name value for parent of Caption attribute");
            } else {
                sCaption = predefAttr.mName;
            }
            this.genObjectProperties(sCaption, predefAttr.mDescription, objAttr);
            objAttr.addProperty(gModelRes.RID_externalName, predefAttr.mExternalName);
            objAttr.addProperty(gModelRes.RID_usage, "attribute");
            objAttr.addProperty(gModelRes.RID_datatype, predefAttr.mDatatype);
            if (objNode.getNameRID() == gModelRes.RID_level && "_memberUniqueName".equals(predefAttr.mRole)) {
                List vLevels = objNode.getParentObject().getObjectNodes(gModelRes.RID_level);
                int parentIndex = vLevels.indexOf(objNode);
                MFWException.ASSERT((parentIndex >= 0 ? 1 : 0) != 0, (String)"The parent level must appear among the hierarchy's levels");
                if (parentIndex != 0) {
                    int higherIter = parentIndex - 1;
                    boolean bHighLevelFound = false;
                    while (true) {
                        String viProp;
                        boolean bl = bHighLevelFound = (viProp = ((MFWNodeObject)vLevels.get(higherIter)).getPropertyValue(gModelRes.RID_visible)) == null || !"hiddenAndAccessible".equals(viProp);
                        if (bHighLevelFound || higherIter == 0) break;
                        --higherIter;
                    }
                    if (bHighLevelFound) {
                        ArrayList vMUNQItems = new ArrayList();
                        ((MFWNodeObject)vLevels.get(higherIter)).findObjectNodes(gModelRes.RID_queryItem, gModelRes.RID_externalName, "memberUniqueName", vMUNQItems);
                        MFWException.ASSERT((vMUNQItems.size() == 1 ? 1 : 0) != 0, (String)"Expecting one and only one MUN qItem");
                        String pMunID = ((MFWNodeObject)vMUNQItems.get(0)).getPropertyValue(gModelRes.RID_ID);
                        MFWException.ASSERT((pMunID != null ? 1 : 0) != 0, (String)"Expecting an ID property for MUN qItem");
                        ArrayList vCapQItems = new ArrayList();
                        ((MFWNodeObject)vLevels.get(higherIter)).findObjectNodes(gModelRes.RID_queryItem, gModelRes.RID_externalName, "memberCaption", vCapQItems);
                        MFWException.ASSERT((vCapQItems.size() == 1 ? 1 : 0) != 0, (String)"Expecting one and only one Caption qItem");
                        String pCapID = ((MFWNodeObject)vCapQItems.get(0)).getPropertyValue(gModelRes.RID_ID);
                        MFWException.ASSERT((pCapID != null ? 1 : 0) != 0, (String)"Expecting an ID property for Caption qItem");
                        objAttr.addProperty(gModelRes.RID_promptType, "serverDetermined");
                        objAttr.addProperty(gModelRes.RID_promptCascadeOnRef, pMunID);
                        objAttr.addProperty(gModelRes.RID_promptDisplayItemRef, pCapID);
                    }
                }
            }
            MFWNodeObject objRole = objAttr.addObjectNode(gModelRes.RID_role);
            this.mHlprLocale.addLocalizedProperties(objRole, gModelRes.RID_name, predefAttr.mRole, null, null);
            this.addPropertyWithDefaultValue(objAttr, gModelRes.RID_format);
            this.addPropertyWithDefaultValue(objAttr, gModelRes.RID_scale);
            this.addPropertyWithDefaultValue(objAttr, gModelRes.RID_precision);
            this.addPropertyWithDefaultValue(objAttr, gModelRes.RID_size);
            this.addPropertyWithDefaultValue(objAttr, gModelRes.RID_nullable);
            this.addPropertyWithDefaultValue(objAttr, gModelRes.RID_regularAggregate);
            this.addPropertyWithDefaultValue(objAttr, gModelRes.RID_semiAggregate);
        }
        objNode.setExpandStatus(gModelRes.RID_queryItem, (byte)2);
    }

    private void populateMeasures(MFWRequestContextUser aContext, MFWQuerySpec querySpec, MFWNodeObject objNode, MFWMetadataResponse response) {
        MFWModelRes gModelRes = MFWModelRes.getInstance();
        HashMap<String, MFWNodeObject> mDispFolders = new HashMap<String, MFWNodeObject>();
        ArrayList<String> vMsrCaptions = new ArrayList<String>();
        if (this.mSupportsDisplayPath) {
            this.collectObjectCaptions(response, vMsrCaptions);
        }
        Element anEntity = response.getFirstEntity();
        while (anEntity != null) {
            String sDispPath = null;
            if (this.mSupportsDisplayPath) {
                sDispPath = MFWMetadataResponse.getPropertyValue(anEntity, "Display_Path");
            }
            if (sDispPath != null && sDispPath.length() > 0 && !"\\".equals(sDispPath)) {
                ArrayList<MFWNodeObject> vMsrFolders = this.addOrFindFoldersForPath(objNode, sDispPath, vMsrCaptions, gModelRes.RID_measureFolder, mDispFolders);
                for (int idx = 0; idx < vMsrFolders.size(); ++idx) {
                    this.addMeasure(vMsrFolders.get(idx), anEntity);
                }
            } else {
                this.addMeasure(objNode, anEntity);
            }
            anEntity = response.getNextEntity();
        }
    }

    private void addMeasure(MFWNodeObject parentObj, Element anEntity) {
        MFWModelRes gModelRes = MFWModelRes.getInstance();
        MFWNodeObject pMsrObj = parentObj.addExpandableObjectNode(gModelRes.RID_measure);
        this.genObjectProperties(anEntity, pMsrObj, "Caption");
        String sMsrFolder = MFWMetadataResponse.getPropertyValue(anEntity, "Measure_Folder");
        if ("true".equals(sMsrFolder)) {
            MFWNodeObject pCustProp = pMsrObj.addObjectNode(gModelRes.RID_property);
            pCustProp.addProperty(gModelRes.RID_name, "Measure_Folder");
            pCustProp.addProperty(gModelRes.RID_type, "hidden");
            pCustProp.addProperty(gModelRes.RID__Value, "true");
        }
        String sTemp = MFWMetadataResponse.getPropertyValue(anEntity, "Measure_Unique_Name");
        pMsrObj.addProperty(gModelRes.RID_externalName, sTemp);
        pMsrObj.addProperty(gModelRes.RID_usage, "fact");
        sTemp = MFWMetadataResponse.getPropertyValue(anEntity, "Format");
        if (sTemp != null && sTemp.length() > 0) {
            String sFormatAsText = MFWStringHelper.escapeAndTagStr((String)"format", (String)sTemp);
            pMsrObj.addProperty(gModelRes.RID_format, sFormatAsText);
        } else {
            pMsrObj.addProperty(gModelRes.RID_format, sTemp);
        }
        sTemp = MFWMetadataResponse.getPropertyValue(anEntity, "Units");
        if ("Currency".equals(sTemp)) {
            pMsrObj.addProperty(gModelRes.RID_currency, "undefined");
        }
        sTemp = MFWMetadataResponse.getPropertyValue(anEntity, "Data_Type");
        pMsrObj.addProperty(gModelRes.RID_datatype, this.mOlapSchema.mapType(sTemp, MFWOLAPSchema.mDataTypes));
        sTemp = MFWMetadataResponse.getPropertyValue(anEntity, "Precision");
        pMsrObj.addProperty(gModelRes.RID_precision, sTemp == null || sTemp.length() == 0 ? "0" : sTemp);
        sTemp = MFWMetadataResponse.getPropertyValue(anEntity, "Scale");
        pMsrObj.addProperty(gModelRes.RID_scale, sTemp == null || sTemp.length() == 0 ? "0" : sTemp);
        String sAggrVal = MFWMetadataResponse.getPropertyValue(anEntity, "Aggregator");
        String mfwAggrVal = this.mOlapSchema.mapType(sAggrVal, MFWOLAPSchema.mAggregateTypes);
        pMsrObj.addProperty(gModelRes.RID_aggregationRule, mfwAggrVal);
        pMsrObj.addProperty(gModelRes.RID_promptType, "serverDetermined");
        pMsrObj.addProperty(gModelRes.RID_regularAggregate, mfwAggrVal);
        sTemp = MFWMetadataResponse.getPropertyValue(anEntity, "Timestate_Aggregator");
        pMsrObj.addProperty(gModelRes.RID_semiAggregate, this.mOlapSchema.mapType(sTemp, MFWOLAPSchema.mAggregateTypes));
        pMsrObj.addProperty(gModelRes.RID_isHierarchical, "true");
        this.addPropertyWithDefaultValue(pMsrObj, gModelRes.RID_expression);
        this.addPropertyWithDefaultValue(pMsrObj, gModelRes.RID_size);
        this.addPropertyWithDefaultValue(pMsrObj, gModelRes.RID_nullable);
    }

    private void populateNamedSets(MFWRequestContextUser aContext, MFWQuerySpec querySpec, MFWNodeObject objNode, MFWMetadataResponse response) {
        MFWModelRes gModelRes = MFWModelRes.getInstance();
        HashMap<String, MFWNodeObject> mDispFolders = new HashMap<String, MFWNodeObject>();
        ArrayList<String> vCalcCaptions = new ArrayList<String>();
        if (this.mSupportsDisplayPath) {
            this.collectObjectCaptions(response, vCalcCaptions);
        }
        Element anEntity = response.getFirstEntity();
        while (anEntity != null) {
            String sDispPath = null;
            if (this.mSupportsDisplayPath) {
                sDispPath = MFWMetadataResponse.getPropertyValue(anEntity, "Display_Path");
            }
            if (sDispPath != null && sDispPath.length() > 0 && !"\\".equals(sDispPath)) {
                ArrayList<MFWNodeObject> vFolders = this.addOrFindFoldersForPath(objNode, sDispPath, vCalcCaptions, gModelRes.RID_folder, mDispFolders);
                for (int idx = 0; idx < vFolders.size(); ++idx) {
                    this.addNamedSet(aContext, querySpec, vFolders.get(idx), anEntity);
                }
            } else {
                this.addNamedSet(aContext, querySpec, objNode, anEntity);
            }
            anEntity = response.getNextEntity();
        }
    }

    private void addNamedSet(MFWRequestContextUser aContext, MFWQuerySpec querySpec, MFWNodeObject parentObj, Element anEntity) {
        MFWModelRes gModelRes = MFWModelRes.getInstance();
        MFWNodeObject objNamedSet = parentObj.addObjectNode(gModelRes.RID_calculation);
        this.genObjectProperties(anEntity, objNamedSet, "Caption");
        String sTemp = MFWMetadataResponse.getPropertyValue(anEntity, "Expression");
        if (sTemp == null || sTemp.length() == 0) {
            objNamedSet.addProperty(gModelRes.RID_expression, sTemp);
        } else {
            String sExprAsText = MFWStringHelper.escapeAndTagStr((String)"expression", (String)sTemp);
            objNamedSet.addProperty(gModelRes.RID_expression, sExprAsText);
        }
        sTemp = MFWMetadataResponse.getPropertyValue(anEntity, "Named_Set_Name");
        objNamedSet.addProperty(gModelRes.RID_externalName, sTemp);
        objNamedSet.addProperty(gModelRes.RID_calcType, "namedSet");
        ArrayList childDims = new ArrayList();
        sTemp = MFWMetadataResponse.getPropertyValue(anEntity, "Dimensions");
        if (sTemp != null && sTemp.length() > 0) {
            MFWNodeObject parentNS;
            for (parentNS = parentObj; parentNS != null && parentNS.getNameRID() != gModelRes.RID_namespace; parentNS = parentNS.getParentObject()) {
            }
            MFWException.ASSERT((parentNS != null ? 1 : 0) != 0, (String)"Calculation for namedSets must appear under a namespace");
            this.mDimConnection.expand(aContext, querySpec, gModelRes.RID_dimension, parentNS);
            parentNS.findObjectNodesRecursively(gModelRes.RID_dimension, gModelRes.RID_folder, gModelRes.RID_externalName, sTemp, true, childDims);
            if (childDims.size() == 1) {
                MFWNodeObject namedSetDim = (MFWNodeObject)childDims.get(0);
                String propDimID = namedSetDim.getPropertyValue(gModelRes.RID_ID);
                MFWException.ASSERT((propDimID != null ? 1 : 0) != 0, (String)"Proprty ID for namedSet dimension is required.");
                MFWNodeObject pDimensionRefObj = objNamedSet.addObjectNode(gModelRes.RID_dimensions);
                pDimensionRefObj.addProperty(gModelRes.RID_refobj, propDimID);
                ArrayList childHiers = new ArrayList();
                sTemp = MFWMetadataResponse.getPropertyValue(anEntity, "Hierarchies");
                if (sTemp != null && sTemp.length() > 0) {
                    this.mDimConnection.expand(aContext, querySpec, gModelRes.RID_hierarchy, namedSetDim);
                    namedSetDim.findObjectNodesRecursively(gModelRes.RID_hierarchy, gModelRes.RID_hierarchyFolder, gModelRes.RID_externalName, sTemp, true, childHiers);
                    if (childHiers.size() > 0) {
                        MFWException.ASSERT((childHiers.size() == 1 ? 1 : 0) != 0, (String)"Expecting one hierarchy object namedSet's associated hierarchy");
                        String propHierID = ((MFWNodeObject)childHiers.get(0)).getPropertyValue(gModelRes.RID_ID);
                        MFWException.ASSERT((propHierID != null ? 1 : 0) != 0, (String)"Proprty ID for namedSet hierarchy is required.");
                        MFWNodeObject pHierarchyRefObj = objNamedSet.addObjectNode(gModelRes.RID_hierarchies);
                        pHierarchyRefObj.addProperty(gModelRes.RID_refobj, propHierID);
                    }
                }
            } else {
                objNamedSet.addProperty(gModelRes.RID_visible, "hidden");
            }
        }
        MFWNodeObject pDatasourceRefObj = objNamedSet.addObjectNode(gModelRes.RID_datasources);
        pDatasourceRefObj.addProperty(gModelRes.RID_dataSourceRef, this.mDataSourceId);
    }

    private void populateMacros(MFWRequestContextUser aContext, MFWQuerySpec querySpec, MFWNodeObject objNode, MFWMetadataResponse response) {
        MFWModelRes gModelRes = MFWModelRes.getInstance();
        Element anEntity = response.getFirstEntity();
        while (anEntity != null) {
            MFWNodeObject calcObj = objNode.addObjectNode(gModelRes.RID_calculation);
            this.genObjectProperties(anEntity, calcObj, "Macro_Name");
            calcObj.addProperty(gModelRes.RID_expression, "");
            String sTemp = MFWMetadataResponse.getPropertyValue(anEntity, "Macro_Type");
            calcObj.addProperty(gModelRes.RID_datatype, this.mOlapSchema.mapType(sTemp, MFWOLAPSchema.mDataTypes));
            sTemp = MFWMetadataResponse.getPropertyValue(anEntity, "Macro_Name");
            calcObj.addProperty(gModelRes.RID_externalName, sTemp);
            calcObj.addProperty(gModelRes.RID_calcType, "macros");
            MFWNodeObject pDatasourceRefObj = calcObj.addObjectNode(gModelRes.RID_datasources);
            pDatasourceRefObj.addProperty(gModelRes.RID_dataSourceRef, this.mDataSourceId);
            anEntity = response.getNextEntity();
        }
    }

    private void populateScopeRelations(MFWNodeObject objNode, ArrayList<MFWNodeObject> vMsrDims, ArrayList<MFWNodeObject> vRegDims) {
        MFWModelRes gModelRes = MFWModelRes.getInstance();
        for (int mIdx = 0; mIdx < vMsrDims.size(); ++mIdx) {
            MFWNodeObject dimMsr = vMsrDims.get(mIdx);
            MFWNodeObject nameObj1 = dimMsr.getObjectNode(gModelRes.RID_name);
            String propVal1 = nameObj1.getPropertyValue(gModelRes.RID__Value);
            String sMsrDimName = propVal1 == null ? "" : propVal1;
            String propID1 = dimMsr.getPropertyValue(gModelRes.RID_ID);
            String sMsrDimID = propID1 == null ? "" : propID1;
            for (int rIdx = 0; rIdx < vRegDims.size(); ++rIdx) {
                MFWNodeObject dimReg = vRegDims.get(rIdx);
                if (vMsrDims.contains(dimReg)) continue;
                MFWNodeObject nameObj = dimReg.getObjectNode(gModelRes.RID_name);
                String propVal = nameObj.getPropertyValue(gModelRes.RID__Value);
                String sRegDimName = propVal == null ? "" : propVal;
                String propID = dimReg.getPropertyValue(gModelRes.RID_ID);
                String sRegDimID = propID == null ? "" : propID;
                MFWNodeObject pSRObj = objNode.addObjectNode(gModelRes.RID_scopeRelationship);
                StringBuffer sTemp = new StringBuffer(sRegDimName);
                sTemp.append(" <--> ");
                sTemp.append(sMsrDimName);
                String sUsedName = this.mIDGenerator.generate(pSRObj, sTemp.toString(), true);
                pSRObj.addProperty(gModelRes.RID_name, sUsedName);
                pSRObj.addProperty(gModelRes.RID_leftrefobj, sRegDimID);
                pSRObj.addProperty(gModelRes.RID_leftmincard, "one");
                pSRObj.addProperty(gModelRes.RID_leftmaxcard, "one");
                pSRObj.addProperty(gModelRes.RID_rightrefobj, sMsrDimID);
                pSRObj.addProperty(gModelRes.RID_rightmincard, "many");
                pSRObj.addProperty(gModelRes.RID_rightmaxcard, "many");
            }
        }
    }

    private ArrayList<MFWNodeObject> addOrFindFoldersForPath(MFWNodeObject parentObj, String sDisplayPath, ArrayList<String> vObjCaptions, short ridFolder, HashMap<String, MFWNodeObject> mapPath2Objs) {
        ArrayList<MFWNodeObject> outFolderObjs = new ArrayList<MFWNodeObject>();
        ArrayList vPaths = new ArrayList();
        MFWStringHelper.split((String)sDisplayPath, (String)";", vPaths);
        for (int pIdx = 0; pIdx < vPaths.size(); ++pIdx) {
            MFWNodeObject folderParent = parentObj;
            ArrayList vFolders = new ArrayList();
            MFWStringHelper.split((String)((String)vPaths.get(pIdx)), (String)"\\", vFolders);
            StringBuffer sPartialPath = new StringBuffer("");
            MFWNodeObject pInnermostFolder = null;
            for (int fIdx = 0; fIdx < vFolders.size(); ++fIdx) {
                String sFolderName = (String)vFolders.get(fIdx);
                if (sFolderName.length() == 0) continue;
                sPartialPath.append("\\");
                sPartialPath.append(sFolderName);
                pInnermostFolder = mapPath2Objs.get(sPartialPath.toString());
                if (pInnermostFolder == null) {
                    sFolderName = MFWStringHelper.makeUnique((String)((String)vFolders.get(fIdx)), vObjCaptions, (boolean)false);
                    MFWNodeObject folderObj = folderParent.addObjectNode(ridFolder);
                    this.genObjectProperties(sFolderName, "", folderObj);
                    mapPath2Objs.put(sPartialPath.toString(), folderObj);
                    pInnermostFolder = folderObj;
                }
                folderParent = pInnermostFolder;
            }
            MFWException.ASSERT((pInnermostFolder != null ? 1 : 0) != 0, (String)"A valid folder parent must have been added");
            outFolderObjs.add(pInnermostFolder);
        }
        MFWException.ASSERT((outFolderObjs.size() > 0 ? 1 : 0) != 0, (String)"At least one folder must exist for the given display path");
        return outFolderObjs;
    }

    private void addPropertyWithDefaultValue(MFWNodeObject objNode, short ridPropName) {
        MFWInfoObject objInfo = objNode.getObjectInfo();
        MFWInfo childInfo = objInfo.findChildInfo(ridPropName);
        MFWException.ASSERT((childInfo != null && childInfo.getNodeType() == 1 ? 1 : 0) != 0, (String)"must be a property");
        MFWInfoProperty propInfo = (MFWInfoProperty)childInfo;
        switch (propInfo.getDataType()) {
            case 2: {
                objNode.addProperty(ridPropName, propInfo.getDefaultEnumValue());
                break;
            }
            case 4: {
                objNode.addProperty(ridPropName, propInfo.getDefaultBooleanValue());
                break;
            }
            default: {
                objNode.addProperty(ridPropName, propInfo.getDefaultValue());
            }
        }
    }

    private void collectConflictingFolderNames(MFWMetadataResponse respDimensions, ArrayList<String> vConflictingName) {
        Element anEntity = respDimensions.getFirstEntity();
        while (anEntity != null) {
            String sDimGroupName = MFWMetadataResponse.getPropertyValue(anEntity, "Dimension_Group_Name");
            String sDimCaption = MFWMetadataResponse.getPropertyValue(anEntity, "Caption");
            if (sDimGroupName != null && sDimGroupName.length() > 0 && sDimGroupName.equals(sDimCaption)) {
                vConflictingName.add(sDimGroupName);
            }
            anEntity = respDimensions.getNextEntity();
        }
    }

    private void collectObjectCaptions(MFWMetadataResponse respObjects, ArrayList<String> vCaptions) {
        Element anEntity = respObjects.getFirstEntity();
        while (anEntity != null) {
            String sDimCaption = MFWMetadataResponse.getPropertyValue(anEntity, "Caption");
            vCaptions.add(sDimCaption);
            anEntity = respObjects.getNextEntity();
        }
    }

    private String makeDatasourceNameUnique(MFWRequestContextUser aContext, String sCmDataSrcName) {
        MFWModelRes gModelRes = MFWModelRes.getInstance();
        ArrayList<String> vDSNames = new ArrayList<String>();
        MFWCluster gwCluster = aContext.getGatewayCluster();
        if (gwCluster != null) {
            List vLinkedClusters = gwCluster.getAllLinkedClustersFor(aContext);
            for (int idx = 0; idx < vLinkedClusters.size(); ++idx) {
                MFWNodeObject pLinkProjNode = ((MFWCluster)vLinkedClusters.get(idx)).getRootNode().getObjectNode(gModelRes.RID_project);
                if (pLinkProjNode == null) continue;
                List vDatasources = pLinkProjNode.getObjectNodes(gModelRes.RID_dataSource);
                for (int j = 0; j < vDatasources.size(); ++j) {
                    String dsName = ((MFWNodeObject)vDatasources.get(j)).getPropertyValue(gModelRes.RID_name);
                    MFWException.ASSERT((dsName != null ? 1 : 0) != 0, (String)"Expecting a valid name property for linked data source");
                    vDSNames.add(dsName);
                }
            }
        }
        return MFWStringHelper.makeUnique((String)sCmDataSrcName, vDSNames, (boolean)false);
    }
}

