/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfwa4j.adaptorDimMDDS;

import com.cognos.mfw4j.framework.MFWModelRes;
import java.util.ArrayList;

public final class MFWOLAPSchema {
    public static final short OLAP_TYPE_UNKNOWN = -1;
    public static final short OLAP_TYPE_ATTRIBUTE = 10;
    public static final short OLAP_TYPE_CUBE = 20;
    public static final short OLAP_TYPE_DIMENSION = 30;
    public static final short OLAP_TYPE_HIERARCHY = 40;
    public static final short OLAP_TYPE_LEVEL = 50;
    public static final short OLAP_TYPE_MACRO = 60;
    public static final short OLAP_TYPE_MEASURE = 70;
    public static final short OLAP_TYPE_MEMBER = 80;
    public static final short OLAP_TYPE_NAMED_SET = 90;
    public static final short OLAP_TYPE_VARIABLES = 100;
    public static DimObjectSpec[] mObjInfo = null;
    public static DimObjectSpec[] mDatasourceObjInfo = null;
    public static TypeMapping[] mDimensionTypes = null;
    public static TypeMapping[] mDataTypes = null;
    public static TypeMapping[] mAggregateTypes = null;
    public static PredefinedAttribute[] mPredefinedAttributes = null;
    public static PredefinedAttribute mAttributeRollupType = null;

    MFWOLAPSchema() {
        MFWModelRes gRes = MFWModelRes.getInstance();
        mObjInfo = new DimObjectSpec[]{new DimObjectSpec(gRes.RID_dataSource, 20, "Cube", null, new String[]{"Created_On", "Cube_Name", "Current_Period", "Default_Measure", "Description", "Is_Optimized", "Last_Data_Update", "Last_Schema_Update", "Suppression"}), new DimObjectSpec(gRes.RID_namespace, -1, null, new short[]{gRes.RID_dimension, gRes.RID_calculation}, null), new DimObjectSpec(gRes.RID_dimension, 30, "Dimensions", new short[]{gRes.RID_hierarchy, gRes.RID_measure}, new String[]{"Caption", "Description", "Default_Hierarchy", "Dimension_Group_Name", "Dimension_Unique_Name", "Is_Hidden", "Measure_Dimension", "PPDS_CODE", "Regular_Dimension", "Time_Dimension", "Type"}), new DimObjectSpec(gRes.RID_hierarchy, 40, "Hierarchies", new short[]{gRes.RID_level, gRes.RID_queryItem}, new String[]{"Balanced_Hierarchy", "Caption", "Default_Member", "Description", "Display_Path", "Hierarchy_Unique_Name", "Is_Hidden", "Parent_Child_Hierarchy", "PPDS_CODE", "Ragged_Hierarchy", "SSAS_Attribute_Hierarchy"}), new DimObjectSpec(gRes.RID_level, 50, "Levels", new short[]{gRes.RID_queryItem}, new String[]{"Base_Attribute_Hierarchy", "Caption", "Description", "Is_Hidden", "Is_Unique", "Level_Unique_Name", "Level_Number", "PPDS_CODE"}), new DimObjectSpec(gRes.RID_measure, 70, "Measures", new short[]{gRes.RID_measure}, new String[]{"Aggregator", "Caption", "Data_Type", "Description", "Display_Path", "Format", "Measure_Folder", "Measure_Unique_Name", "Precision", "Scale", "Timestate_Aggregator", "Units"}), new DimObjectSpec(gRes.RID_queryItem, 10, "Attributes", null, new String[]{"Attribute_Unique_Name", "Caption", "Data_Type", "Description", "Role"}), new DimObjectSpec(gRes.RID_rootMember, 80, "Members", null, new String[]{"Caption", "Member_Unique_Name", "_rollupType"}), new DimObjectSpec(gRes.RID_calculation, 90, "Named_Sets", null, new String[]{"Caption", "Dimensions", "Display_Path", "Expression", "Hierarchies", "Named_Set_Name"}), new DimObjectSpec(gRes.RID_calculation, 60, "Macro", null, new String[]{"Macro_Name", "Macro_Type"})};
        mDimensionTypes = new TypeMapping[]{new TypeMapping("Measure", "measure"), new TypeMapping("Time", "time"), new TypeMapping("Regular", "regular"), new TypeMapping("", "regular")};
        mDataTypes = new TypeMapping[]{new TypeMapping("int8", "int8"), new TypeMapping("int16", "int16"), new TypeMapping("int32", "int32"), new TypeMapping("int64", "int64"), new TypeMapping("float32", "float32"), new TypeMapping("float64", "float64"), new TypeMapping("character", "character"), new TypeMapping("time", "time"), new TypeMapping("date", "date"), new TypeMapping("dateTime", "dateTime"), new TypeMapping("unsupported", "unsupported"), new TypeMapping("unknown", "unknown"), new TypeMapping("Boolean", "boolean"), new TypeMapping("Float", "float64"), new TypeMapping("Long", "int32"), new TypeMapping("Bigint", "int64"), new TypeMapping("String", "character"), new TypeMapping("Time", "time"), new TypeMapping("Date", "date"), new TypeMapping("Datetime", "dateTime"), new TypeMapping("", "unsupported")};
        mAggregateTypes = new TypeMapping[]{new TypeMapping("average", "average"), new TypeMapping("count", "count"), new TypeMapping("countDistinct", "countDistinct"), new TypeMapping("countNonZero", "countNonZero"), new TypeMapping("maximum", "maximum"), new TypeMapping("median", "median"), new TypeMapping("minimum", "minimum"), new TypeMapping("unsupported", "unsupported"), new TypeMapping("standardDeviation", "standardDeviation"), new TypeMapping("sum", "sum"), new TypeMapping("variance", "variance"), new TypeMapping("unknown", "unknown"), new TypeMapping("AVG", "average"), new TypeMapping("COUNT", "count"), new TypeMapping("COUNT_DISTINCT", "countDistinct"), new TypeMapping("COUNT_NON_ZERO", "countNonZero"), new TypeMapping("MAX", "maximum"), new TypeMapping("MEDIAN", "median"), new TypeMapping("MIN", "minimum"), new TypeMapping("NONE", "unsupported"), new TypeMapping("STDDEV", "standardDeviation"), new TypeMapping("SUM", "sum"), new TypeMapping("VAR", "variance"), new TypeMapping("ANY", "unknown"), new TypeMapping("AVG_CALENDAR_DAYS", "unknown"), new TypeMapping("AVG_NON_ZERO", "unknown"), new TypeMapping("AVG_PERIOD", "unknown"), new TypeMapping("CALC", "unknown"), new TypeMapping("EXTERNAL", "unknown"), new TypeMapping("FIRST", "unknown"), new TypeMapping("LAST", "unknown"), new TypeMapping("UNKNOWN", "unknown"), new TypeMapping("", "unsupported")};
        mPredefinedAttributes = new PredefinedAttribute[]{new PredefinedAttribute("Dimension Unique Name", "Dimension Unique Name", "dimensionUniqueName", "character", "_dimensionUniqueName"), new PredefinedAttribute("Hierarchy Unique Name", "Hierarchy Unique Name", "hierarchyUniqueName", "character", "_hierarchyUniqueName"), new PredefinedAttribute("Level Label", "Level Label", "levelLabel", "character", "_levelLabel"), new PredefinedAttribute("Level Number", "Level Number", "levelNumber", "int32", "_levelNumber"), new PredefinedAttribute("Level Unique Name", "Level Unique Name", "levelUniqueName", "character", "_levelUniqueName"), new PredefinedAttribute("Caption", "Caption", "memberCaption", "character", "_memberCaption"), new PredefinedAttribute("Member Description", "Member Description", "description", "character", "_memberDescription"), new PredefinedAttribute("Member Unique Name", "Member Unique Name", "memberUniqueName", "character", "_memberUniqueName"), new PredefinedAttribute("Parent Unique Name", "Parent Unique Name", "parentUniqueName", "character", "_parentUniqueName")};
        mAttributeRollupType = new PredefinedAttribute("_rollupType", "_rollupType", "_rollupType", "character", "_rollupType");
    }

    short[] getChildTypes(short ridParent) {
        short[] outChildTypes = null;
        for (int idx = 0; outChildTypes == null && idx < mObjInfo.length; ++idx) {
            if (mObjInfo[idx].mObjRID != ridParent) continue;
            outChildTypes = mObjInfo[idx].mContains;
        }
        return outChildTypes;
    }

    ArrayList<DimObjectSpec> getObjectSpecs(short ridType) {
        ArrayList<DimObjectSpec> outChildTypes = new ArrayList<DimObjectSpec>(2);
        for (int idx = 0; idx < mObjInfo.length; ++idx) {
            if (mObjInfo[idx].mObjRID != ridType || mObjInfo[idx].mObjOLAPType == -1) continue;
            outChildTypes.add(mObjInfo[idx]);
        }
        return outChildTypes;
    }

    String mapType(String olapType, TypeMapping[] mappingArray) {
        int idx;
        for (idx = 0; idx < mappingArray.length; ++idx) {
            if (!mappingArray[idx].mOLAPType.equals(olapType)) continue;
            return mappingArray[idx].mMFWType;
        }
        return mappingArray[idx - 1].mMFWType;
    }

    final class PredefinedAttribute {
        public String mName;
        public String mDescription;
        public String mExternalName;
        public String mDatatype;
        public String mRole;

        PredefinedAttribute(String aName, String aDescription, String aExternalName, String aDatatype, String aRole) {
            this.mName = aName;
            this.mDescription = aDescription;
            this.mExternalName = aExternalName;
            this.mDatatype = aDatatype;
            this.mRole = aRole;
        }
    }

    private static final class TypeMapping {
        private String mOLAPType;
        private String mMFWType;

        TypeMapping(String olapType, String mfwType) {
            this.mOLAPType = olapType;
            this.mMFWType = mfwType;
        }
    }

    static final class DimObjectSpec {
        private short mObjRID = (short)-1;
        private short mObjOLAPType = (short)-1;
        private String mMetadataClass = null;
        private short[] mContains = null;
        private String[] mProperties = null;

        DimObjectSpec(short rid, short olapType, String mdClass, short[] contains, String[] props) {
            this.mObjRID = rid;
            this.mObjOLAPType = olapType;
            this.mMetadataClass = mdClass;
            this.mContains = contains;
            this.mProperties = props;
        }

        public short getObjRID() {
            return this.mObjRID;
        }

        public short getOLAPType() {
            return this.mObjOLAPType;
        }

        String getOLAPMetadataClass() {
            return this.mMetadataClass;
        }

        public String[] getOLAPProperties() {
            return this.mProperties;
        }
    }
}

