/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfwa4j.adaptorFM;

import com.cognos.mfw4j.framework.MFWAdaptor;
import com.cognos.mfw4j.framework.MFWConnection;
import com.cognos.mfw4j.framework.MFWConnectionReuseInfo;
import com.cognos.mfw4j.framework.MFWCrnIDAdvancedLookup;
import com.cognos.mfw4j.framework.MFWCrnIDGenerator;
import com.cognos.mfw4j.framework.MFWInfo;
import com.cognos.mfw4j.framework.MFWInfoObject;
import com.cognos.mfw4j.framework.MFWInfoProperty;
import com.cognos.mfw4j.framework.MFWModelRes;
import com.cognos.mfw4j.framework.MFWNode;
import com.cognos.mfw4j.framework.MFWNodeObject;
import com.cognos.mfw4j.framework.MFWQuerySpec;
import com.cognos.mfw4j.framework.MFWRequestContext;
import com.cognos.mfw4j.framework.MFWRequestContextUser;
import com.cognos.mfw4j.framework.log.MFWLogRuntimeIndicators;
import com.cognos.mfw4j.utilities.IMFWCMRequestExecutor;
import com.cognos.mfw4j.utilities.IMFWUsageIndicator;
import com.cognos.mfw4j.utilities.MFWContentHelper;
import com.cognos.mfw4j.utilities.MFWException;
import com.cognos.mfwa4j.adaptorFM.MFWFmAdaptor;
import com.cognos.mfwa4j.adaptorFM.MFWFmConnectionReuseInfo;
import com.cognos.mfwa4j.adaptorFM.MFWFmModelLoader;
import com.cognos.mfwa4j.toolBox.MFWSharedContentHelper;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jaxen.expr.NameStep;
import org.jaxen.expr.Step;
import org.xml.sax.helpers.DefaultHandler;

final class MFWFmConnection
extends MFWConnection {
    private static final String TAG_buildPMC = "MFWA4J/FMConnection/buildPMC";
    private static final String TAG_queryPackage = "MFWA4J/FMConnection/queryPackage";
    private MFWModelRes mModelRes = null;
    private MFWCrnIDGenerator mIDGenerator = null;
    private MFWNodeObject mProjectNode = null;
    private String mQueryStack = null;

    MFWFmConnection(MFWConnectionReuseInfo aReuseInfo, MFWFmAdaptor anAdaptor) {
        super(aReuseInfo, (MFWAdaptor)anAdaptor);
        this.mQueryStack = ((MFWFmConnectionReuseInfo)aReuseInfo).getQueryStack();
        this.mModelRes = MFWModelRes.getInstance();
    }

    public void destroy() {
        this.mModelRes = null;
        this.mProjectNode = null;
        if (this.mIDGenerator != null) {
            this.mIDGenerator.destroy();
        }
        this.mIDGenerator = null;
        super.destroy();
    }

    MFWCrnIDGenerator getIDGenerator() {
        return this.mIDGenerator;
    }

    MFWNodeObject getProjectNode() {
        return this.mProjectNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialSetup(MFWRequestContextUser aContext, MFWNodeObject aLinkParent) {
        this.mProjectNode = this.getCluster().getRootNode().addObjectNode(this.mModelRes.RID_project);
        MFWException.ASSERT((this.mProjectNode != null ? 1 : 0) != 0, (String)"Failed to add the project node");
        this.mIDGenerator = new MFWCrnIDGenerator(this.getCluster());
        String modelCMPath = (String)this.getSource().getConnectionItem("cmSearchPath");
        String modelFilePath = (String)this.getSource().getConnectionItem("modelFilePath");
        MFWException.ASSERT((modelCMPath != null || modelFilePath != null ? 1 : 0) != 0, (String)"Neither connection item 'cmSearchPath' nor 'modelFilePath' are specified");
        MFWLogRuntimeIndicators dbg = null;
        StringBuffer dbgHint = new StringBuffer("Loading FM model ");
        MFWFmModelLoader myLoader = new MFWFmModelLoader(aContext, this);
        try {
            long b4PMCBuildTime = 0L;
            SAXParser myParser = SAXParserFactory.newInstance().newSAXParser();
            if (modelCMPath != null) {
                InputStream isPkg = null;
                MFWContentHelper hlprRCI = null;
                try {
                    hlprRCI = MFWContentHelper.create((String)aContext.getProductLocale(), (String)aContext.getContentLocale(), (IMFWCMRequestExecutor)aContext.getCMRequestExecutor());
                    long b4Time = System.currentTimeMillis();
                    isPkg = hlprRCI.queryPackage(modelCMPath, !aContext.getForceCMTrusted());
                    this.logUsageIndicator(aContext, TAG_queryPackage, b4Time);
                    dbgHint.append(modelCMPath);
                    dbg = new MFWLogRuntimeIndicators(dbgHint.toString());
                    b4PMCBuildTime = System.currentTimeMillis();
                    myParser.parse(isPkg, (DefaultHandler)myLoader);
                }
                finally {
                    if (isPkg != null) {
                        isPkg.close();
                    }
                    if (hlprRCI != null) {
                        hlprRCI.destroy();
                    }
                }
            } else {
                File filePkg = new File(modelFilePath);
                dbgHint.append(modelFilePath);
                dbg = new MFWLogRuntimeIndicators(dbgHint.toString());
                b4PMCBuildTime = System.currentTimeMillis();
                myParser.parse(filePkg, (DefaultHandler)myLoader);
            }
            myLoader.doPostLoad(this.mProjectNode, this.getSource());
            this.logUsageIndicator(aContext, TAG_buildPMC, b4PMCBuildTime);
            myLoader.destroy();
            myLoader = null;
            myParser = null;
            dbg.logEnd();
        }
        catch (RuntimeException rt) {
            if (dbg != null) {
                dbg.logEnd((Throwable)rt);
            }
            if (myLoader != null) {
                myLoader.destroy();
            }
            throw rt;
        }
        catch (Throwable e) {
            if (dbg != null) {
                dbg.logEnd(e);
            }
            if (myLoader != null) {
                myLoader.destroy();
            }
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private void logUsageIndicator(MFWRequestContextUser aContext, String category, long b4Time) {
        long executionTime = System.currentTimeMillis() - b4Time;
        IMFWUsageIndicator usageIndicator = aContext.getXQEUsageIndicatorService();
        if (usageIndicator != null) {
            usageIndicator.logMeasurements(category, executionTime);
        }
    }

    protected void reconstructSetup(MFWRequestContextUser aContext, MFWNodeObject aLinkNodeParent) {
        this.mProjectNode = this.getCluster().getRootNode().getObjectNode(this.mModelRes.RID_project);
        MFWException.ASSERT((this.mProjectNode != null ? 1 : 0) != 0, (String)"Failed to locate the project node");
        this.mIDGenerator = new MFWCrnIDGenerator(this.getCluster());
    }

    protected void expandAll(MFWRequestContextUser aContext, MFWNodeObject aLinkNodeParent) {
    }

    public void expand(MFWRequestContextUser aContext, MFWQuerySpec aQuerySpec, MFWNodeObject objNode) {
        Step currStep = aQuerySpec.getCurrentStepPattern();
        MFWException.ASSERT((boolean)(currStep instanceof NameStep), (String)"Expecting a NameStep to expand");
        if ("*".equals(((NameStep)currStep).getLocalName())) {
            MFWInfoObject objInfo = objNode.getObjectInfo();
            MFWInfo[] vChildrenInfo = objInfo.getChildrenInfo();
            for (int idx = 0; idx < vChildrenInfo.length; ++idx) {
                MFWInfo childInfo = vChildrenInfo[idx];
                super.defaultExpand(aContext, childInfo.getRID(), objNode);
            }
        } else {
            super.defaultExpand(aContext, aQuerySpec.getCurrentStepPatternRID(), objNode);
        }
    }

    protected String evaluateDynamicProperty(MFWRequestContextUser aContext, short ridDynProp, MFWNodeObject parentNode) {
        if (ridDynProp == this.mModelRes.RID_visible) {
            return this.calculateObjectVisibilityByLookingAtSecurityViews(parentNode, aContext);
        }
        return super.evaluateDynamicProperty(aContext, ridDynProp, parentNode);
    }

    public MFWNodeObject lookup(MFWRequestContextUser context, MFWInfoProperty indexProp, String indexValue, MFWNodeObject rootNode, List<MFWNodeObject> ancestorsChain) {
        MFWNodeObject objNode = null;
        if (indexValue.startsWith("[:physicalSources]")) {
            return null;
        }
        MFWCrnIDAdvancedLookup myLookup = new MFWCrnIDAdvancedLookup(this.mProjectNode, this.mIDGenerator, (MFWRequestContext)context);
        objNode = myLookup.lookup(indexValue, ancestorsChain);
        if (objNode == null && ancestorsChain != null) {
            ancestorsChain.clear();
        }
        return objNode;
    }

    private String calculateObjectVisibilityByLookingAtSecurityViews(MFWNodeObject objNode, MFWRequestContextUser aContext) {
        List<MFWNode> securityViews;
        if (!(aContext.areSecuritySetsCalculatedFor(this.getCluster()) || (securityViews = this.applySecurityForUser(aContext)) != null && securityViews.size() != 0)) {
            return "visibleAndAccessible";
        }
        boolean visible = true;
        boolean accessible = true;
        if (aContext.areSecuritySetsCalculatedFor(this.getCluster())) {
            visible = aContext.isObjectVisibleBySecurityViews(this.getCluster(), objNode);
            accessible = aContext.isObjectAccessibleBySecurityViews(this.getCluster(), objNode);
        }
        String outValue = null;
        outValue = visible ? (accessible ? "visibleAndAccessible" : "visible") : (accessible ? "hiddenAndAccessible" : "hidden");
        return outValue;
    }

    public List<MFWNode> applySecurityForUser(MFWRequestContextUser aContext) {
        String sModelCMPath;
        MFWNodeObject securityViewCollection = this.mProjectNode.getObjectNode(this.mModelRes.RID_securityViews);
        List securityViews = null;
        if (securityViewCollection != null) {
            securityViews = securityViewCollection.getObjectNodes(this.mModelRes.RID_securityView);
        }
        if ((sModelCMPath = (String)this.getSource().getConnectionItem("cmSearchPath")) != null) {
            this.applySecurity(sModelCMPath, aContext, securityViews);
            aContext.setSecuritySetsCalculatedFor(this.getCluster());
        }
        return securityViews;
    }

    private void applySecurity(String modelCMPath, MFWRequestContextUser aContext, List<MFWNode> securityViews) {
        List<String> userViews = null;
        List<String> identities = null;
        MFWNodeObject baseSecurityView = null;
        for (int secIdx = 0; securityViews != null && secIdx < securityViews.size(); ++secIdx) {
            MFWNodeObject aSecurityView = (MFWNodeObject)securityViews.get(secIdx);
            boolean isRoleBased = aSecurityView.getBooleanPropertyValue(this.mModelRes.RID_isRoleBased);
            boolean getRolesFromView = aSecurityView.getBooleanPropertyValue(this.mModelRes.RID_isViewBased);
            if (getRolesFromView) {
                isRoleBased = true;
            }
            if (!isRoleBased) {
                if (userViews == null) {
                    userViews = MFWSharedContentHelper.getViews((MFWRequestContext)aContext, modelCMPath);
                }
                String viewName = aSecurityView.getPropertyValue(this.mModelRes.RID_ID);
                boolean accessibleView = false;
                if (userViews.contains(viewName)) {
                    List vSets = aSecurityView.getObjectNodes(this.mModelRes.RID_set);
                    accessibleView = true;
                    for (int setIdx = 0; setIdx < vSets.size(); ++setIdx) {
                        MFWNodeObject aSet = (MFWNodeObject)vSets.get(setIdx);
                        String includeRule = aSet.getPropertyValue(this.mModelRes.RID_includeRule);
                        if (!"include".equals(includeRule)) continue;
                        aContext.addIncludeSet(this.getCluster(), aSet);
                    }
                }
                if (!accessibleView) continue;
                aContext.addAccessibleSecurityView(aSecurityView);
                continue;
            }
            MFWNodeObject securityObject = aSecurityView.getObjectNode(this.mModelRes.RID_securityObject);
            if (securityObject == null && !getRolesFromView) {
                baseSecurityView = (MFWNodeObject)securityViews.get(secIdx);
                continue;
            }
            aContext.setRoleBasedDefined(this.getCluster(), true);
            if (getRolesFromView) {
                String viewName = aSecurityView.getPropertyValue(this.mModelRes.RID_ID);
                if (userViews == null) {
                    userViews = MFWSharedContentHelper.getViews((MFWRequestContext)aContext, modelCMPath);
                }
                if (userViews != null && !userViews.contains(viewName)) {
                    continue;
                }
            } else {
                String role;
                if (identities == null) {
                    identities = MFWSharedContentHelper.getUserIdentity((MFWRequestContext)aContext);
                }
                if (!identities.contains(role = securityObject.getPropertyValue(this.mModelRes.RID_cmSearchPath))) continue;
            }
            List vSets = aSecurityView.getObjectNodes(this.mModelRes.RID_set);
            for (int setIdx = 0; setIdx < vSets.size(); ++setIdx) {
                MFWNodeObject aSet = (MFWNodeObject)vSets.get(setIdx);
                String includeRule = aSet.getPropertyValue(this.mModelRes.RID_includeRule);
                if ("include".equals(includeRule)) {
                    aContext.addRoleBasedIncludeSet(this.getCluster(), aSet);
                    continue;
                }
                if ("hide".equals(includeRule)) {
                    aContext.addRoleBasedHideSet(this.getCluster(), aSet);
                    continue;
                }
                if (!"exclude".equals(includeRule)) continue;
                aContext.addRoleExcludeSet(this.getCluster(), aSet);
            }
        }
        if (baseSecurityView == null) {
            aContext.setBaseViewDefined(this.getCluster(), false);
            return;
        }
        aContext.setBaseViewDefined(this.getCluster(), true);
        List vSecObjs = baseSecurityView.getObjectNodes(this.mModelRes.RID_securityObject);
        for (int soIdx = 0; soIdx < vSecObjs.size(); ++soIdx) {
            MFWNodeObject aSecurityObj = (MFWNodeObject)vSecObjs.get(soIdx);
            String includeRule = aSecurityObj.getPropertyValue(this.mModelRes.RID_includeRule);
            if (!"hide".equals(includeRule)) continue;
            aContext.addBaseViewHideSet(this.getCluster(), aSecurityObj);
        }
    }

    protected String getQueryStack() {
        return this.mQueryStack;
    }
}

