/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfwa4j.adaptorFM;

import com.cognos.ccl4j.util.CCLFileUtils;
import com.cognos.mfw4j.framework.MFWConnectionReuseInfo;
import com.cognos.mfw4j.framework.MFWMetadataSource;
import com.cognos.mfw4j.framework.MFWRequestContext;
import com.cognos.mfw4j.framework.MFWRequestContextUser;
import com.cognos.mfw4j.framework.implPersistence.MFWPersistentMetadataCluster;
import com.cognos.mfw4j.utilities.IMFWCMRequestExecutor;
import com.cognos.mfw4j.utilities.MFWConfiguration;
import com.cognos.mfw4j.utilities.MFWContentHelper;
import com.cognos.mfw4j.utilities.MFWException;
import com.cognos.mfw4j.utilities.MFWStringHelper;
import java.io.File;
import java.util.Calendar;

class MFWFmConnectionReuseInfo
extends MFWConnectionReuseInfo {
    private static int gModelInfoRetainPeriod = 30000;
    private String mModelPath = null;
    private boolean mIsCMModel = false;
    private Calendar mModelLastModifiedTime = null;
    private String mParentStoreID = null;
    private String mQueryStack = null;
    private boolean mIsTempFileForOLAPModule = false;

    MFWFmConnectionReuseInfo(MFWRequestContextUser aContext, MFWMetadataSource aMetadataSrc) {
        super(aMetadataSrc);
        this.mModelPath = (String)aMetadataSrc.getConnectionItem("cmSearchPath");
        if (this.mModelPath != null) {
            this.mIsCMModel = true;
            MFWContentHelper myHelper = MFWContentHelper.create((String)aContext.getProductLocale(), (String)aContext.getContentLocale(), (IMFWCMRequestExecutor)aContext.getCMRequestExecutor());
            MFWContentHelper.CMObjectInfo objectInfo = myHelper.getCMObjectProperties(this.mModelPath, (MFWRequestContext)aContext);
            MFWException.ASSERT((objectInfo != null ? 1 : 0) != 0, (String)"Expecting valid information when querying for model:", (String)this.mModelPath);
            this.mModelLastModifiedTime = objectInfo.getLastModificationTime();
            this.mParentStoreID = objectInfo.getPackageStoreID();
            Object queryStack = aMetadataSrc.getConnectionItem("queryStack");
            this.mQueryStack = queryStack != null ? queryStack.toString() : objectInfo.getQueryStack();
        } else {
            this.mModelPath = (String)aMetadataSrc.getConnectionItem("modelFilePath");
            this.mQueryStack = "queryFramework";
            this.mIsTempFileForOLAPModule = this.mModelPath.endsWith("tempOLAPmodel.xml");
            this.mModelLastModifiedTime = !this.mIsTempFileForOLAPModule ? MFWFmConnectionReuseInfo.getFileModificationTime(this.mModelPath) : MFWFmConnectionReuseInfo.getCalendarFromTime(System.currentTimeMillis());
        }
        aMetadataSrc.addConnectionItem("cmModificationTime", (Object)this.mModelLastModifiedTime.getTimeInMillis());
        MFWException.ASSERT((this.mModelPath != null ? 1 : 0) != 0, (String)"The FM model source must contain either modelFilePath or cmSearchPath");
    }

    static MFWFmConnectionReuseInfo reconstruct(MFWPersistentMetadataCluster aPMC, int aPosition) {
        MFWFmConnectionReuseInfo outRI = new MFWFmConnectionReuseInfo();
        outRI.load(aPMC, aPosition);
        return outRI;
    }

    private MFWFmConnectionReuseInfo() {
    }

    public void destroy() {
        super.destroy();
    }

    protected boolean isReusableFor(MFWConnectionReuseInfo thatReuseInfo) {
        boolean result = false;
        if (this.mIsCMModel) {
            MFWFmConnectionReuseInfo thatFMReuseInfo = (MFWFmConnectionReuseInfo)thatReuseInfo;
            result = this.mParentStoreID.equals(thatFMReuseInfo.mParentStoreID);
        } else {
            result = this.mModelPath.equals(thatReuseInfo.getMetadataSource().getConnectionItem("modelFilePath"));
        }
        return result;
    }

    public StringBuffer getPersistentPath() {
        StringBuffer path = new StringBuffer(MFWConfiguration.getInstance().getPMCDirectoryPath());
        path.append("/");
        if (this.mIsCMModel) {
            path.append(this.mParentStoreID);
        } else {
            path.append(MFWStringHelper.cleanupFileName((String)this.mModelPath));
        }
        path.append("/");
        path.append(Long.toString(this.mModelLastModifiedTime.getTimeInMillis()));
        return path;
    }

    protected boolean isCacheUpToDate(MFWRequestContextUser aContext, MFWConnectionReuseInfo thatReuseInfo) {
        if (this.mIsTempFileForOLAPModule) {
            return true;
        }
        MFWFmConnectionReuseInfo thatFMReuseInfo = (MFWFmConnectionReuseInfo)thatReuseInfo;
        return this.mModelLastModifiedTime.equals(thatFMReuseInfo.mModelLastModifiedTime);
    }

    protected String getQueryStack() {
        return this.mQueryStack;
    }

    private static Calendar getFileModificationTime(String filePath) {
        File aFile = null;
        try {
            aFile = CCLFileUtils.check((String)filePath, (int)49);
        }
        catch (CCLFileUtils.FileCheckException fileCheckException) {
            // empty catch block
        }
        MFWException.ASSERT((aFile != null ? 1 : 0) != 0, (String)"Unable to get the last modification time for:", (String)filePath);
        return MFWFmConnectionReuseInfo.getCalendarFromTime(aFile.lastModified());
    }

    public static Calendar getCalendarFromTime(long lastModifiedTime) {
        Calendar lastModified = Calendar.getInstance();
        lastModified.setTimeInMillis(lastModifiedTime);
        return lastModified;
    }

    static {
        String maxRetain = MFWConfiguration.getInstance().getConfigInfoFor("modelFM").getCapability("modelInfoRetainPeriod");
        if (maxRetain != null && maxRetain.length() > 0) {
            gModelInfoRetainPeriod = Integer.parseInt(maxRetain) * 1000;
        }
    }
}

