/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfwa4j.adaptorFM;

import com.cognos.ccl4j.exceptions.CCLRuntimeException;
import com.cognos.mfw4j.utilities.MFWException;
import com.cognos.mfw4j.utilities.MFWStringHelper;
import java.io.StringReader;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

final class MFWFmDynamicSource
extends DefaultHandler {
    private static final String TAG_ITEM = "item";
    private String mCMSource = null;
    private String mDSType = null;
    private String mLastCatalog = null;
    private String mLastSchema = null;
    private String mLastCube = null;
    private String mLastDimUName = null;
    private String mLastDimName = null;
    private Map<String, String> mAliasInfo = new LinkedHashMap<String, String>();
    private HashMap mOtherInfo = new HashMap();
    private boolean mContinue = true;

    static MFWFmDynamicSource create(String importSpec) {
        MFWFmDynamicSource myHandler = new MFWFmDynamicSource();
        try {
            SAXParser myParser = SAXParserFactory.newInstance().newSAXParser();
            String excapedSpec = MFWStringHelper.unescapeXMLChars((String)importSpec);
            InputSource myInputSrc = new InputSource(new StringReader(excapedSpec));
            myParser.parse(myInputSrc, (DefaultHandler)myHandler);
        }
        catch (Exception e) {
            myHandler.destroy();
            throw new CCLRuntimeException((Throwable)e, e.getMessage());
        }
        return myHandler;
    }

    private MFWFmDynamicSource() {
    }

    public void destroy() {
        this.mAliasInfo.clear();
        this.mOtherInfo.clear();
    }

    String getCMDataSource() {
        return this.mCMSource;
    }

    String getDataSourceType() {
        return this.mDSType;
    }

    String getCatalog() {
        return this.mLastCatalog;
    }

    String getSchema() {
        return this.mLastSchema;
    }

    String getCube() {
        return this.mLastCube;
    }

    String getOtherValue(String propName) {
        return (String)this.mOtherInfo.get(propName);
    }

    Set getAliasInfo() {
        return this.mAliasInfo.entrySet();
    }

    @Override
    public final void startElement(String uri, String localName, String qName, Attributes attributes) {
        if (!TAG_ITEM.equals(qName)) {
            return;
        }
        String itemType = attributes.getValue("", "Type");
        MFWException.ASSERT((itemType != null ? 1 : 0) != 0, (String)"Missing type for import spec. item");
        if (this.mContinue && itemType.equals("database")) {
            this.mCMSource = attributes.getValue("", "Name");
            this.mDSType = attributes.getValue("", "dbType");
        } else if (this.mContinue && itemType.equals("catalog")) {
            this.mLastCatalog = attributes.getValue("", "uniqueName");
        } else if (this.mContinue && itemType.equals("schema")) {
            this.mLastSchema = attributes.getValue("", "uniqueName");
        } else if (this.mContinue && itemType.equals("cube")) {
            String sTemp = attributes.getValue("", "Value");
            if ("true".equals(sTemp)) {
                this.mContinue = false;
                this.mLastCube = attributes.getValue("", "uniqueName");
                String tempValue = attributes.getValue("", "attributeDimensionsAsProperties");
                if ("false".equals(tempValue)) {
                    this.mOtherInfo.put("attributeDimensionsAsProperties", tempValue);
                }
            }
        } else if ("TM".equals(this.mDSType) && (itemType.equals("dimension") || itemType.equals("measures"))) {
            this.mLastDimName = attributes.getValue("", "Name");
            this.mLastDimUName = attributes.getValue("", "uniqueName");
        } else if (itemType.equals("aliasTableLang")) {
            String sTable = attributes.getValue("", "Name");
            String sLocale = attributes.getValue("", "uniqueName");
            if ("TM".equals(this.mDSType) && this.mLastDimUName != null) {
                StringBuffer sDimLocale = new StringBuffer(this.mLastDimUName);
                sDimLocale.append("+++***DELIMITER***+++");
                sDimLocale.append(this.mLastDimName);
                sDimLocale.append("+++***DELIMITER***+++");
                sDimLocale.append(sLocale);
                this.mAliasInfo.put(sDimLocale.toString(), sTable);
            } else {
                this.mAliasInfo.put(sLocale, sTable);
            }
        }
    }
}

