/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfwa4j.adaptorOData;

import com.cognos.mfw4j.framework.MFWAdaptor;
import com.cognos.mfw4j.framework.MFWConnection;
import com.cognos.mfw4j.framework.MFWConnectionReuseInfo;
import com.cognos.mfw4j.framework.MFWCrnIDAdvancedLookup;
import com.cognos.mfw4j.framework.MFWCrnIDGenerator;
import com.cognos.mfw4j.framework.MFWInfo;
import com.cognos.mfw4j.framework.MFWInfoObject;
import com.cognos.mfw4j.framework.MFWInfoProperty;
import com.cognos.mfw4j.framework.MFWModelRes;
import com.cognos.mfw4j.framework.MFWNodeObject;
import com.cognos.mfw4j.framework.MFWQuerySpec;
import com.cognos.mfw4j.framework.MFWRequestContext;
import com.cognos.mfw4j.framework.MFWRequestContextUser;
import com.cognos.mfw4j.resourcePool.MFWDSConnectionSpec;
import com.cognos.mfw4j.resourcePool.MFWDSSelectionCriteria;
import com.cognos.mfw4j.resourcePool.MFWUserPool;
import com.cognos.mfw4j.utilities.MFWException;
import com.cognos.mfwa4j.adaptorOData.MFWODataAdaptor;
import com.cognos.mfwa4j.adaptorOData.MFWODataModelLoader;
import java.util.List;
import org.jaxen.expr.NameStep;
import org.jaxen.expr.Step;

final class MFWODataConnection
extends MFWConnection {
    private MFWModelRes mModelRes = MFWModelRes.getInstance();
    private MFWCrnIDGenerator mIDGenerator = null;
    private MFWODataModelLoader mObjLoader = null;
    private MFWNodeObject mProjectNode = null;
    private static final String URL = "URL";

    MFWODataConnection(MFWConnectionReuseInfo aReuseInfo, MFWODataAdaptor anAdaptor) {
        super(aReuseInfo, (MFWAdaptor)anAdaptor);
    }

    MFWCrnIDGenerator getIDGenerator() {
        return this.mIDGenerator;
    }

    MFWNodeObject getProjectNode() {
        return this.mProjectNode;
    }

    protected void initialSetup(MFWRequestContextUser aContext, MFWNodeObject aLinkParent) {
        String defaultLocale;
        String dataSource = (String)this.getSource().getConnectionItem("cmDataSource");
        MFWDSSelectionCriteria dsSelection = new MFWDSSelectionCriteria(dataSource);
        MFWDSConnectionSpec connectionSpec = MFWUserPool.getInstance().getConnectionSpec((MFWRequestContext)aContext, dsSelection);
        String connectionString = connectionSpec.getConnectionString();
        String[] tokens = connectionString.split(";");
        String uri = tokens[3];
        for (String token : tokens) {
            if (!token.startsWith(URL)) continue;
            uri = token.substring(4);
        }
        MFWNodeObject rootNode = this.getCluster().getRootNode();
        this.mIDGenerator = new MFWCrnIDGenerator(this.getCluster());
        if (aLinkParent == null) {
            defaultLocale = aContext.getContentLocale();
        } else {
            MFWNodeObject parentProj = aLinkParent.getCluster().getRootNode().getObjectNode(this.mModelRes.RID_project);
            MFWException.ASSERT((parentProj != null ? 1 : 0) != 0, (String)"Parent project node must exist");
            defaultLocale = parentProj.getPropertyValue(this.mModelRes.RID_defaultLocale);
            MFWException.ASSERT((defaultLocale != null && defaultLocale.length() > 0 ? 1 : 0) != 0, (String)"Expecting a valid default locale");
        }
        this.mObjLoader = new MFWODataModelLoader(aContext, this, defaultLocale);
        this.mProjectNode = this.mObjLoader.setupProject(rootNode, uri);
        this.mObjLoader.load(this.mProjectNode, dataSource, connectionSpec, uri);
    }

    protected void reconstructSetup(MFWRequestContextUser aContext, MFWNodeObject aLinkNodeParent) {
        this.mProjectNode = this.getCluster().getRootNode().getObjectNode(this.mModelRes.RID_project);
        MFWException.ASSERT((this.mProjectNode != null ? 1 : 0) != 0, (String)"Failed to locate the project node");
        this.mIDGenerator = new MFWCrnIDGenerator(this.getCluster());
    }

    protected void expandAll(MFWRequestContextUser aContext, MFWNodeObject aLinkNodeParent) {
    }

    public void expand(MFWRequestContextUser aContext, MFWQuerySpec aQuerySpec, MFWNodeObject objNode) {
        Step currStep = aQuerySpec.getCurrentStepPattern();
        MFWException.ASSERT((boolean)(currStep instanceof NameStep), (String)"Expecting a NameStep to expand");
        if ("*".equals(((NameStep)currStep).getLocalName())) {
            MFWInfoObject objInfo = objNode.getObjectInfo();
            MFWInfo[] vChildrenInfo = objInfo.getChildrenInfo();
            for (int idx = 0; idx < vChildrenInfo.length; ++idx) {
                MFWInfo childInfo = vChildrenInfo[idx];
                super.defaultExpand(aContext, childInfo.getRID(), objNode);
            }
        } else {
            super.defaultExpand(aContext, aQuerySpec.getCurrentStepPatternRID(), objNode);
        }
    }

    protected String evaluateDynamicProperty(MFWRequestContextUser aContext, short ridDynProp, MFWNodeObject parentNode) {
        return super.evaluateDynamicProperty(aContext, ridDynProp, parentNode);
    }

    public MFWNodeObject lookup(MFWRequestContextUser context, MFWInfoProperty indexProp, String indexValue, MFWNodeObject rootNode, List<MFWNodeObject> ancestorsChain) {
        MFWNodeObject objNode = null;
        if (indexValue.startsWith("[:physicalSources]")) {
            return null;
        }
        MFWCrnIDAdvancedLookup myLookup = new MFWCrnIDAdvancedLookup(this.mProjectNode, this.mIDGenerator, (MFWRequestContext)context);
        objNode = myLookup.lookup(indexValue, ancestorsChain);
        if (objNode == null && ancestorsChain != null) {
            ancestorsChain.clear();
        }
        return objNode;
    }

    public void destroy() {
        this.mModelRes = null;
        if (this.mIDGenerator != null) {
            this.mIDGenerator.destroy();
            this.mIDGenerator = null;
        }
        if (this.mObjLoader != null) {
            this.mObjLoader.destroy();
            this.mObjLoader = null;
        }
        super.destroy();
    }
}

