/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfwa4j.adaptorOData;

import com.cognos.mfw4j.framework.MFWCrnIDGenerator;
import com.cognos.mfw4j.framework.MFWMetadataSource;
import com.cognos.mfw4j.framework.MFWModelRes;
import com.cognos.mfw4j.framework.MFWNodeObject;
import com.cognos.mfw4j.framework.MFWRequestContextUser;
import com.cognos.mfw4j.resourcePool.MFWDSConnectionSpec;
import com.cognos.mfw4j.utilities.MFWCrnIDHelper;
import com.cognos.mfw4j.utilities.MFWException;
import com.cognos.mfwa4j.adaptorOData.MFWODataConnection;
import com.cognos.mfwa4j.adaptorOData.SimpleDataTypeConverter;
import java.util.LinkedList;
import java.util.List;
import org.core4j.Enumerable;
import org.odata4j.consumer.ODataConsumer;
import org.odata4j.consumer.ODataConsumers;
import org.odata4j.consumer.behaviors.OClientBehavior;
import org.odata4j.consumer.behaviors.OClientBehaviors;
import org.odata4j.core.ImmutableList;
import org.odata4j.edm.EdmAssociationEnd;
import org.odata4j.edm.EdmCollectionType;
import org.odata4j.edm.EdmDataServices;
import org.odata4j.edm.EdmEntityContainer;
import org.odata4j.edm.EdmEntitySet;
import org.odata4j.edm.EdmEntityType;
import org.odata4j.edm.EdmFunctionImport;
import org.odata4j.edm.EdmFunctionParameter;
import org.odata4j.edm.EdmMultiplicity;
import org.odata4j.edm.EdmNavigationProperty;
import org.odata4j.edm.EdmProperty;
import org.odata4j.edm.EdmSchema;
import org.odata4j.edm.EdmStructuralType;
import org.odata4j.edm.EdmType;

final class MFWODataModelLoader {
    private static final String USAGE_IDENTIFIER = "identifier";
    private static final String USAGE_ATTRIBUTE = "attribute";
    private static final String USAGE_FACT = "fact";
    private MFWModelRes gModelRes = MFWModelRes.getInstance();
    private MFWODataConnection mOwnerConnection = null;
    private MFWCrnIDGenerator mIDGenerator = null;
    private String mContentLocale = null;
    private EdmDataServices dataServices;

    MFWODataModelLoader(MFWRequestContextUser aContext, MFWODataConnection odataConnection, String designLocale) {
        this.mOwnerConnection = odataConnection;
        this.mIDGenerator = odataConnection.getIDGenerator();
        this.mContentLocale = designLocale;
    }

    public void destroy() {
        this.gModelRes = null;
        this.mOwnerConnection = null;
        this.mIDGenerator = null;
    }

    public MFWNodeObject setupProject(MFWNodeObject rootNode, String name) {
        MFWNodeObject objProj = rootNode.addObjectNode(this.gModelRes.RID_project);
        MFWException.ASSERT((objProj != null ? 1 : 0) != 0, (String)"Failed to add the project node");
        objProj.addProperty(this.gModelRes.RID_ID, "[]");
        objProj.addProperty(this.gModelRes.RID_name, name);
        objProj.addProperty(this.gModelRes.RID_locale, this.mContentLocale);
        objProj.addProperty(this.gModelRes.RID_defaultLocale, this.mContentLocale);
        objProj.addObjectNode(this.gModelRes.RID_parameterMaps);
        objProj.addObjectNode(this.gModelRes.RID_securityViews);
        return objProj;
    }

    void load(MFWNodeObject objProj, String dataSrcName, MFWDSConnectionSpec connectionSpec, String url) {
        ODataConsumer consumer;
        if (connectionSpec.getSignonUserID() != null) {
            OClientBehavior behaviour = OClientBehaviors.basicAuth((String)connectionSpec.getSignonUserID(), (String)connectionSpec.getSignonUserPWD());
            consumer = ODataConsumers.newBuilder((String)url).setClientBehaviors(new OClientBehavior[]{behaviour}).build();
        } else {
            consumer = ODataConsumers.create((String)url);
        }
        this.dataServices = consumer.getMetadata();
        ImmutableList schemas = this.dataServices.getSchemas();
        for (EdmSchema schema : schemas) {
            List containers = schema.getEntityContainers();
            if (containers.isEmpty()) continue;
            MFWNodeObject objNamespace = objProj.addObjectNode(this.gModelRes.RID_namespace);
            String nsName = this.mIDGenerator.generate(objNamespace, schema.getNamespace(), true);
            this.addLocalizedProp(objNamespace, nsName);
            MFWNodeObject objDataSrc = objProj.addObjectNode(this.gModelRes.RID_dataSource);
            String dsName = this.mIDGenerator.generate(objDataSrc, dataSrcName, true);
            String sDataSourceID = objDataSrc.getPropertyValue(this.gModelRes.RID_ID);
            MFWException.ASSERT((sDataSourceID != null ? 1 : 0) != 0, (String)"Failed to generate an ID property");
            objDataSrc.addProperty(this.gModelRes.RID_name, dsName);
            objDataSrc.addProperty(this.gModelRes.RID_cmDataSource, dataSrcName);
            objDataSrc.addProperty(this.gModelRes.RID_queryType, "relational");
            objDataSrc.addProperty(this.gModelRes.RID_interface, "ODATA");
            this.loadObjects(objNamespace, containers, dataSrcName, sDataSourceID);
        }
        MFWMetadataSource aPhysSourceStatic = MFWMetadataSource.create((String)"modelPhysicalFM");
        aPhysSourceStatic.addConnectionItem("modelFilePath", (Object)dataSrcName);
        short idLinkSrcStatic = this.mOwnerConnection.getCluster().getLinkManager().findOrAddLink(aPhysSourceStatic, objProj);
        objProj.addLinkNode(this.gModelRes.RID_physicalSource, idLinkSrcStatic, "/physicalSources/physicalSource");
    }

    private void loadObjects(MFWNodeObject rootNs, List<EdmEntityContainer> containers, String sCmDataSrcName, String dataSourceID) {
        LinkedList<EdmEntityType> hierarchy = new LinkedList<EdmEntityType>();
        for (EdmEntityContainer container : containers) {
            String qsName;
            MFWNodeObject qsObj;
            MFWNodeObject namespace = rootNs.addObjectNode(this.gModelRes.RID_namespace);
            String name = this.mIDGenerator.generate(namespace, container.getName(), true);
            this.addLocalizedProp(namespace, name);
            for (EdmEntitySet eSet : container.getEntitySets()) {
                EdmEntityType eType = eSet.getType();
                hierarchy.add(eType);
                qsObj = namespace.addObjectNode(this.gModelRes.RID_querySubject);
                qsName = this.mIDGenerator.generate(qsObj, eSet.getName(), true);
                this.addLocalizedProp(qsObj, qsName);
                qsObj.addProperty(this.gModelRes.RID_dataSourceRef, dataSourceID);
                qsObj.addProperty(this.gModelRes.RID_definitionType, 1);
                qsObj.addProperty(this.gModelRes.RID_sql, this.makeSql(sCmDataSrcName, eSet.getName()));
                qsObj.addProperty(this.gModelRes.RID_tableType, "table");
                this.getProperties(qsObj, hierarchy);
                MFWNodeObject determinant = qsObj.addObjectNode(this.gModelRes.RID_determinant);
                determinant.addProperty(this.gModelRes.RID_name, "PK");
                determinant.addProperty(this.gModelRes.RID_identifiesRow, true);
                MFWNodeObject keyObj = determinant.addObjectNode(this.gModelRes.RID_key);
                String parentId = qsObj.getPropertyValue(this.gModelRes.RID_ID);
                List keys = eType.getKeys();
                for (String key : keys) {
                    String refObj = MFWCrnIDHelper.addEntryToID((String)parentId, (String)key);
                    keyObj.addProperty(this.gModelRes.RID_refobj, refObj);
                }
                hierarchy.clear();
            }
            List functions = container.getFunctionImports();
            for (EdmFunctionImport function : functions) {
                qsObj = namespace.addObjectNode(this.gModelRes.RID_querySubject);
                qsName = this.mIDGenerator.generate(qsObj, function.getName(), true);
                this.addLocalizedProp(qsObj, qsName);
                qsObj.addProperty(this.gModelRes.RID_canonicalName, qsName);
                qsObj.addProperty(this.gModelRes.RID_dataSourceRef, dataSourceID);
                qsObj.addProperty(this.gModelRes.RID_definitionType, 3);
                EdmType eType = function.getReturnType();
                if (!eType.isSimple()) {
                    if (eType instanceof EdmCollectionType) {
                        eType = ((EdmCollectionType)eType).getItemType();
                    }
                    hierarchy.add((EdmEntityType)eType);
                    this.getProperties(qsObj, hierarchy);
                }
                List parameters = function.getParameters();
                for (EdmFunctionParameter parameter : parameters) {
                    MFWNodeObject procParm = qsObj.addObjectNode(this.gModelRes.RID_procParameter);
                    SimpleDataTypeConverter.DataTypeInfo mappedDType = SimpleDataTypeConverter.getMappingInfo(parameter);
                    procParm.addProperty(this.gModelRes.RID_parameterName, parameter.getName());
                    procParm.addProperty(this.gModelRes.RID_datatype, mappedDType.getTypeName());
                    procParm.addProperty(this.gModelRes.RID_nullable, Boolean.toString(mappedDType.isNullable()));
                }
            }
        }
    }

    private void getProperties(MFWNodeObject parent, LinkedList<EdmEntityType> hierarchy) {
        EdmEntityType eType = hierarchy.getLast();
        Enumerable properties = eType.getDeclaredProperties();
        for (EdmProperty property : properties) {
            this.handleProperty(parent, (EdmStructuralType)eType, property);
        }
        Enumerable navProperties = eType.getNavigationProperties();
        for (EdmNavigationProperty property : navProperties) {
            this.handleNavigationProperty(parent, property, hierarchy);
        }
    }

    private void handleProperty(MFWNodeObject objParent, EdmStructuralType eType, EdmProperty eProperty) {
        if (eProperty.getType().isSimple()) {
            this.handleSimpleProperty(objParent, eType, eProperty);
        } else {
            this.handleComplexProperty(objParent, eType, eProperty);
        }
    }

    private void handleNavigationProperty(MFWNodeObject parent, EdmNavigationProperty eProperty, LinkedList<EdmEntityType> hierarchy) {
        String name = eProperty.getName();
        EdmAssociationEnd toRole = eProperty.getToRole();
        EdmAssociationEnd fromRole = eProperty.getFromRole();
        EdmEntityType eType = toRole.getType();
        for (int i = 0; i < hierarchy.size(); ++i) {
            if (!hierarchy.get(i).getName().equals(eType.getName())) continue;
            return;
        }
        String dataType = "multiset";
        MFWNodeObject queryItemFolder = parent.addObjectNode(this.gModelRes.RID_queryItemFolder);
        queryItemFolder.addProperty(this.gModelRes.RID_datatype, dataType);
        EdmMultiplicity fromRoleMultiplicity = fromRole.getMultiplicity();
        if (fromRoleMultiplicity == EdmMultiplicity.ZERO_TO_ONE) {
            queryItemFolder.addProperty(this.gModelRes.RID_leftmincard, "zero");
            queryItemFolder.addProperty(this.gModelRes.RID_leftmaxcard, "one");
        } else if (fromRoleMultiplicity == EdmMultiplicity.ONE) {
            queryItemFolder.addProperty(this.gModelRes.RID_leftmincard, "one");
            queryItemFolder.addProperty(this.gModelRes.RID_leftmaxcard, "one");
        } else {
            queryItemFolder.addProperty(this.gModelRes.RID_leftmincard, "one");
            queryItemFolder.addProperty(this.gModelRes.RID_leftmaxcard, "many");
        }
        EdmMultiplicity toRoleMultiplicity = toRole.getMultiplicity();
        if (toRoleMultiplicity == EdmMultiplicity.ZERO_TO_ONE) {
            queryItemFolder.addProperty(this.gModelRes.RID_rightmincard, "zero");
            queryItemFolder.addProperty(this.gModelRes.RID_rightmaxcard, "one");
        } else if (toRoleMultiplicity == EdmMultiplicity.ONE) {
            queryItemFolder.addProperty(this.gModelRes.RID_rightmincard, "one");
            queryItemFolder.addProperty(this.gModelRes.RID_rightmaxcard, "one");
        } else {
            queryItemFolder.addProperty(this.gModelRes.RID_rightmincard, "one");
            queryItemFolder.addProperty(this.gModelRes.RID_rightmaxcard, "many");
        }
        String sUsedName = this.mIDGenerator.generate(queryItemFolder, name, true);
        this.addLocalizedProp(queryItemFolder, sUsedName);
        hierarchy.add(eType);
        this.getProperties(queryItemFolder, hierarchy);
    }

    private void handleSimpleProperty(MFWNodeObject parent, EdmStructuralType eType, EdmProperty property) {
        List keys;
        MFWNodeObject queryItem = parent.addObjectNode(this.gModelRes.RID_queryItem);
        String sUsedName = this.mIDGenerator.generate(queryItem, property.getName(), true);
        this.addLocalizedProp(queryItem, sUsedName);
        queryItem.addProperty(this.gModelRes.RID_externalName, property.getName());
        SimpleDataTypeConverter.DataTypeInfo mappedDType = SimpleDataTypeConverter.getMappingInfo(property);
        queryItem.addProperty(this.gModelRes.RID_datatype, mappedDType.getTypeName());
        queryItem.addProperty(this.gModelRes.RID_precision, Integer.toString(mappedDType.getDefaultPrecision()));
        queryItem.addProperty(this.gModelRes.RID_scale, Integer.toString(mappedDType.getDefaultScale()));
        queryItem.addProperty(this.gModelRes.RID_size, Integer.toString(mappedDType.getDefaultSize()));
        queryItem.addProperty(this.gModelRes.RID_nullable, Boolean.toString(mappedDType.isNullable()));
        String usage = null;
        if (eType instanceof EdmEntityType && (keys = ((EdmEntityType)eType).getKeys()).contains(property.getName())) {
            usage = USAGE_IDENTIFIER;
        }
        if (usage == null) {
            byte typeCategory = mappedDType.getTypeCategory();
            usage = typeCategory == 10 ? USAGE_FACT : USAGE_ATTRIBUTE;
        }
        queryItem.addProperty(this.gModelRes.RID_usage, usage);
    }

    private void handleComplexProperty(MFWNodeObject parent, EdmStructuralType eType, EdmProperty property) {
        EdmType type = property.getType();
        EdmStructuralType complexType = (EdmStructuralType)type;
        Enumerable fields = complexType.getProperties();
        MFWNodeObject queryItemFolder = parent.addObjectNode(this.gModelRes.RID_queryItemFolder);
        queryItemFolder.addProperty(this.gModelRes.RID_datatype, "struct");
        String sUsedName = this.mIDGenerator.generate(queryItemFolder, property.getName(), true);
        this.addLocalizedProp(queryItemFolder, sUsedName);
        for (EdmProperty field : fields) {
            this.handleProperty(queryItemFolder, eType, field);
        }
    }

    private String makeSql(String sCmDataSrcName, String resourceName) {
        StringBuilder out = new StringBuilder("<sql type=\"cognos\">Select <column>*</column>from<table>[");
        out.append(sCmDataSrcName);
        out.append("].\"");
        out.append(resourceName);
        out.append("\"</table></sql>");
        return out.toString();
    }

    private MFWNodeObject addLocalizedProp(MFWNodeObject objParent, String name) {
        MFWNodeObject objLocProp = objParent.addObjectNode(this.gModelRes.RID_name);
        objLocProp.addProperty(this.gModelRes.RID_locale, this.mContentLocale);
        objLocProp.addProperty(this.gModelRes.RID__Value, name);
        return objLocProp;
    }
}

