/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfwa4j.adaptorPhysicalMD;

import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.mfw4j.framework.MFWAdaptor;
import com.cognos.mfw4j.framework.MFWConnection;
import com.cognos.mfw4j.framework.MFWConnectionReuseInfo;
import com.cognos.mfw4j.framework.MFWMetadataSource;
import com.cognos.mfw4j.framework.MFWNodeObject;
import com.cognos.mfw4j.framework.MFWRequestContextUser;
import com.cognos.mfw4j.utilities.MFWConfiguration;
import com.cognos.mfw4j.utilities.MFWException;
import com.cognos.mfwa4j.adaptorPhysicalMD.MFWPhysMDAdaptorConnection;
import com.cognos.mfwa4j.adaptorPhysicalMD.MFWPhysMDAdaptorConnectionReuse;
import com.cognos.mfwa4j.adaptorPhysicalMD.physicalMetadataDBConnectionPool.DbConnectionPool;
import com.cognos.mfwa4j.adaptorPhysicalMD.physicalMetadataUtilities.CheckString;
import com.cognos.mfwa4j.adaptorPhysicalMD.physicalMetadataUtilities.FileUtils;
import com.cognos.mfwa4j.adaptorPhysicalMD.physicalMetadataUtilities.MFWDump;
import com.cognos.mfwa4j.adaptorPhysicalMD.physicalMetadataUtilities.MFWPhysMDLog;
import com.cognos.mfwa4j.adaptorPhysicalMD.physicalMetadataUtilities.StringUtils;
import com.ibm.cognos.internal.relmd.utilities.RelmdConfiguration;

public final class MFWPhysMDAdaptor
extends MFWAdaptor {
    private MFWPhysMDLog mDbgTrace = MFWPhysMDLog.getInstance();
    private static Boolean mbTestcasesFolder = null;
    private static Boolean mbForceUseDBLoader = null;
    private static Boolean mbCreateTestcases = null;
    private static Boolean mbUseXQEConnectionPool = null;
    private static Integer mnMaxSynonymTraversals = null;
    private static String msDBVendorCodes = null;

    public MFWPhysMDAdaptor() {
        this.mDbgTrace.logStart();
        this.mDbgTrace.log("Creating MFWPhysMDAdaptor instance:  %d", ((Object)((Object)this)).hashCode());
    }

    protected void setSourceConfig(MFWConfiguration.MFWConfigSource aSrcConfig) {
        super.setSourceConfig(aSrcConfig);
        this.initAdaptor();
    }

    private synchronized void initAdaptor() {
        this.mDbgTrace.logStart();
        if (mbCreateTestcases == null) {
            String sCreateTestcases = this.adaptorCapability("createTestcases");
            mbCreateTestcases = new Boolean(CheckString.exists(sCreateTestcases) ? CheckString.isTrue(sCreateTestcases) : false);
        }
        if (mbTestcasesFolder == null) {
            String sTestcasesFolder = this.adaptorCapability("testcasesFolder");
            mbTestcasesFolder = new Boolean(CheckString.exists(sTestcasesFolder));
            MFWDump.setRootDumpFolder(CheckString.exists(sTestcasesFolder) ? sTestcasesFolder : "..\\logs\\MFWPhysicalMetadata");
        }
        if (mbForceUseDBLoader == null) {
            String sForceUseDBLoader = this.adaptorCapability("forceUseDBLoader");
            mbForceUseDBLoader = new Boolean(CheckString.exists(sForceUseDBLoader) ? CheckString.isTrue(sForceUseDBLoader) : false);
        }
        if (mbUseXQEConnectionPool == null) {
            ICCLConfiguration icclConfig;
            String sFilePath;
            String sUseXQEConnectionPool = this.adaptorCapability("useXQEConnectionPool");
            mbUseXQEConnectionPool = CheckString.exists(sUseXQEConnectionPool) ? new Boolean(CheckString.exists(sUseXQEConnectionPool) ? CheckString.isTrue(sUseXQEConnectionPool) : true) : Boolean.valueOf(!FileUtils.FilepathExists(sFilePath = (icclConfig = CCLConfigurationFactory.getInstance()).resolveEffectivePath("MFWPhysMDLoaderDBInfo.xml")));
        }
        if (mnMaxSynonymTraversals == null) {
            String sMaxSynonymTraversals = this.adaptorCapability("maxSynonymTraversals");
            mnMaxSynonymTraversals = CheckString.isNumeric(sMaxSynonymTraversals) ? Integer.valueOf(sMaxSynonymTraversals) : Integer.valueOf(-1);
        }
        if (msDBVendorCodes == null) {
            msDBVendorCodes = this.adaptorCapability("vendorCodes");
            MFWException.ASSERT((boolean)CheckString.exists(msDBVendorCodes), (String)"DB Vendor lookup codes missing in MFW4JConfig.xml");
            if (RelmdConfiguration.getBooleanProperty((String)"sqlserver.generic", (boolean)Boolean.TRUE)) {
                this.mDbgTrace.log("Metadata for sql server is through jdbc.", new Object[0]);
                msDBVendorCodes = msDBVendorCodes.replace("sqlserver", "generic");
            } else {
                this.mDbgTrace.log("Metadata for sql server is through vendor sql.", new Object[0]);
            }
            if (RelmdConfiguration.getBooleanProperty((String)"oracle.generic", (boolean)Boolean.TRUE)) {
                this.mDbgTrace.log("Metadata for oracle is through jdbc.", new Object[0]);
                msDBVendorCodes = msDBVendorCodes.replace("oracle", "generic");
            } else {
                this.mDbgTrace.log("Metadata for oracle is through vendor sql.", new Object[0]);
            }
            if (RelmdConfiguration.getBooleanProperty((String)"db2.generic", (boolean)Boolean.TRUE)) {
                this.mDbgTrace.log("Metadata for db2 is through jdbc.", new Object[0]);
                msDBVendorCodes = msDBVendorCodes.replace("db2", "generic");
            } else {
                this.mDbgTrace.log("Metadata for db2 is through vendor sql.", new Object[0]);
            }
            if (RelmdConfiguration.getBooleanProperty((String)"teradata.generic", (boolean)Boolean.TRUE)) {
                this.mDbgTrace.log("Metadata for teradata is through jdbc.", new Object[0]);
                msDBVendorCodes = msDBVendorCodes.replace("teradata", "generic");
            } else {
                this.mDbgTrace.log("Metadata for teradata is through vendor sql.", new Object[0]);
            }
            DbConnectionPool.initDBVendorCodes(msDBVendorCodes);
        }
        this.mDbgTrace.logEnd();
    }

    public MFWConnection connect(MFWConnectionReuseInfo aReuseInfo, MFWRequestContextUser aContext) {
        return new MFWPhysMDAdaptorConnection(aReuseInfo, this);
    }

    protected MFWConnectionReuseInfo createReuseInfo(MFWRequestContextUser aContext, MFWMetadataSource aMetadataSrc, MFWNodeObject aLinkParent) {
        return new MFWPhysMDAdaptorConnectionReuse(aContext, aMetadataSrc, aLinkParent);
    }

    private String adaptorCapability(String sCapabilityKey) {
        String sCapabilityValue = this.getSourceConfig().getCapability(sCapabilityKey);
        this.mDbgTrace.log("adaptorCapability(%s)=%s", sCapabilityKey, StringUtils.null2null(sCapabilityValue));
        return sCapabilityValue;
    }

    public static boolean capability_ForceUseDBLoader() {
        MFWException.ASSERT((mbForceUseDBLoader != null ? 1 : 0) != 0, (String)"Physical metadata settings should not be required before the adapter is loaded");
        return mbForceUseDBLoader;
    }

    public static boolean capability_CreateTestcases() {
        MFWException.ASSERT((mbCreateTestcases != null ? 1 : 0) != 0, (String)"Physical metadata settings should not be required before the adapter is loaded");
        return mbCreateTestcases;
    }

    public static boolean capability_UseXQEConnectionPool() {
        MFWException.ASSERT((mbUseXQEConnectionPool != null ? 1 : 0) != 0, (String)"Physical metadata settings should not be required before the adapter is loaded");
        return mbUseXQEConnectionPool;
    }

    public static int capability_MaxSynonymTraversals() {
        MFWException.ASSERT((mnMaxSynonymTraversals != null ? 1 : 0) != 0, (String)"Physical metadata settings should not be required before the adapter is loaded");
        return mnMaxSynonymTraversals;
    }

    protected void destroy() {
        super.destroy();
        this.mDbgTrace.log("Destroying MFWPhysMDAdaptor:  %d", ((Object)((Object)this)).hashCode());
        this.mDbgTrace.logEnd();
    }
}

