/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfwa4j.adaptorPhysicalMD.physicalMetadataDBConnectionPool;

import com.cognos.mfw4j.utilities.MFWException;
import com.cognos.mfw4j.utilities.MFWXMLDump;
import com.cognos.mfwa4j.adaptorPhysicalMD.physicalMetadataDBConnectionPool.IDbConnectionPool;
import com.cognos.mfwa4j.adaptorPhysicalMD.physicalMetadataUtilities.StringUtils;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.providers.ProviderCategoryEnum;
import com.cognos.xqe.data.providers.ProviderManager;
import com.cognos.xqe.data.providers.connection.parameters.DataSourceParameter;
import com.cognos.xqe.data.providers.relational.IRelationalConnection;
import com.cognos.xqe.data.providers.relational.IRelationalDataProvider;
import com.cognos.xqe.pool.connection.ConnectionParameters;
import com.cognos.xqe.pool.connection.IConnectionParameter;
import com.cognos.xqe.pool.connection.IPooledConnection;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import java.sql.Connection;
import java.util.LinkedHashMap;

public class DbConnectionPool
implements IDbConnectionPool {
    private ExecutionEnvironment mXqeExecEnv;
    private IRelationalDataProvider mProvider;
    private IPooledConnection mPooledConnection;
    private static LinkedHashMap<String, String> mVendorCodes = null;
    int nConnections = 0;
    private final String msConnectionName;
    private final String msConnectionURL;
    private final String msConnectionString;
    private final String msUserID;
    private final String msDatabaseType;
    private final String msDriverClassName;

    public DbConnectionPool(String sConnectionName, ExecutionEnvironment execEnv) {
        this.msConnectionName = sConnectionName;
        this.mXqeExecEnv = execEnv;
        MFWException.ASSERT((this.mXqeExecEnv != null ? 1 : 0) != 0, (String)"Unexpected MFW physical source adapter error due to XQE Execution Environment failure");
        IDataSource dataSource = execEnv.getDataSource(sConnectionName);
        ProviderManager.ProviderInfo info = ProviderManager.getInstance().getProviderInfo(dataSource.getType());
        MFWException.ASSERT((info != null ? 1 : 0) != 0, (String)"Unexpected MFW physical source adapter error due to XQE connection pool failure");
        MFWException.ASSERT((info.getProviderCategory() == ProviderCategoryEnum.RELATIONAL ? 1 : 0) != 0, (String)"Unexpected MFW physical source adapter error due to XQE connection pool failure");
        this.mProvider = ProviderManager.getInstance().getRelationalProvider(dataSource.getType());
        MFWException.ASSERT((this.mProvider != null ? 1 : 0) != 0, (String)"Unexpected MFW physical source adapter error due to XQE connection pool failure");
        this.mPooledConnection = this.borrowConnection(execEnv, this.msConnectionName);
        MFWException.ASSERT((boolean)(this.mPooledConnection.getConnection() instanceof IRelationalConnection), (String)"Unexpected MFW physical source adapter error; connection does not implement IRelationalConnection");
        IRelationalConnection relationalConnectionInfo = (IRelationalConnection)this.mPooledConnection.getConnection();
        this.msConnectionURL = relationalConnectionInfo.getUrl();
        this.msConnectionString = relationalConnectionInfo.getConnectionString();
        this.msUserID = relationalConnectionInfo.getUserId();
        this.msDatabaseType = relationalConnectionInfo.getDatabaseType();
        this.msDriverClassName = relationalConnectionInfo.getDriverClassName();
        this.mPooledConnection.returnConnection();
        this.mPooledConnection = null;
    }

    private IPooledConnection borrowConnection(ExecutionEnvironment execEnv, String dsName) {
        IDataSource dataSource = execEnv.getDataSource(dsName);
        ConnectionParameters parameters = new ConnectionParameters();
        parameters.put((IConnectionParameter)new DataSourceParameter(dataSource));
        return this.mProvider.borrowConnection(parameters, (IExecutionEnvironment)this.mXqeExecEnv);
    }

    @Override
    public String connectionString() {
        return this.msConnectionString;
    }

    @Override
    public String userID() {
        return this.msUserID;
    }

    @Override
    public String password() {
        return null;
    }

    @Override
    public String vendorType() {
        MFWException.ASSERT((mVendorCodes != null ? 1 : 0) != 0, (String)"DB Vendor codes have not been initialized");
        MFWException.ASSERT((boolean)mVendorCodes.containsKey(this.msDatabaseType), (String)("Unknown JDBC vendor type '" + this.msDatabaseType + "' specified in XQE connection pool"));
        return mVendorCodes.get(this.msDatabaseType);
    }

    @Override
    public String driverClass() {
        return this.msDriverClassName;
    }

    @Override
    public Connection doConnectionBorrow() {
        ++this.nConnections;
        MFWException.ASSERT((this.mPooledConnection == null ? 1 : 0) != 0, (String)"A JDBC connection was already borrowed from the connection pool");
        this.mPooledConnection = this.borrowConnection(this.mXqeExecEnv, this.msConnectionName);
        IRelationalConnection relationalConnectionInfo = (IRelationalConnection)this.mPooledConnection.getConnection();
        return relationalConnectionInfo.getConnection();
    }

    @Override
    public void doConnectionReturn() {
        --this.nConnections;
        MFWException.ASSERT((this.mPooledConnection != null ? 1 : 0) != 0, (String)"No JDBC connection was borrowed from the connection pool");
        this.mPooledConnection.returnConnection();
        this.mPooledConnection = null;
    }

    @Override
    public void setNotReusable() {
        MFWException.ASSERT((this.mPooledConnection != null ? 1 : 0) != 0, (String)"No JDBC connection was borrowed from the connection pool");
        this.mPooledConnection.setNotReusable();
    }

    @Override
    public String toXml() {
        MFWXMLDump dump = new MFWXMLDump();
        dump.addElement("jdbcConnection", 0);
        dump.addAttribute("jdbcConnectionName", this.msConnectionName);
        dump.addAttribute("cmDataSource", this.msConnectionName);
        dump.addAttribute("jdbcConnectionString", this.msConnectionURL);
        dump.addAttribute("userID", this.msUserID);
        dump.addAttribute("password", "<NULL>");
        dump.addAttribute("driverClass", this.msDriverClassName);
        dump.addAttribute("vendorType", this.vendorType());
        dump.endElement(false);
        dump.addCData("extendedInfo", this.msConnectionString);
        dump.addElement("jdbcConnection", 2);
        return dump.getXML();
    }

    public static void initDBVendorCodes(String sDBVendorSettingsString) {
        if (mVendorCodes == null) {
            mVendorCodes = new LinkedHashMap();
            StringUtils.convertStringToTable(mVendorCodes, sDBVendorSettingsString);
        }
    }

    protected void finalize() throws Throwable {
        if (this.mPooledConnection != null) {
            try {
                this.doConnectionReturn();
            }
            finally {
                super.finalize();
            }
        }
    }
}

