/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfwa4j.adaptorPhysicalMD.physicalMetadataUtilities;

import com.cognos.mfw4j.framework.MFWCluster;
import com.cognos.mfw4j.framework.MFWMetadataSource;
import com.cognos.mfw4j.framework.MFWModelRes;
import com.cognos.mfw4j.framework.MFWNode;
import com.cognos.mfw4j.framework.MFWNodeObject;
import com.cognos.mfw4j.framework.MFWQuerySpec;
import com.cognos.mfw4j.framework.MFWRequestContextUser;
import com.cognos.mfw4j.utilities.MFWContentHelper;
import com.cognos.mfw4j.utilities.MFWXMLDump;
import com.cognos.mfwa4j.adaptorPhysicalMD.MFWPhysMDAdaptor;
import com.cognos.mfwa4j.adaptorPhysicalMD.MFWPhysMDAdaptorConnection;
import com.cognos.mfwa4j.adaptorPhysicalMD.physicalMetadataDBConnectionPool.IDbConnectionPool;
import com.cognos.mfwa4j.adaptorPhysicalMD.physicalMetadataUtilities.CheckString;
import com.cognos.mfwa4j.adaptorPhysicalMD.physicalMetadataUtilities.FileUtils;
import com.cognos.mfwa4j.adaptorPhysicalMD.physicalMetadataUtilities.MFWPhysID;
import com.cognos.mfwa4j.adaptorPhysicalMD.physicalMetadataUtilities.QueryRelmdGateway;
import com.cognos.mfwa4j.adaptorPhysicalMD.physicalMetadataUtilities.StringUtils;
import java.io.InputStream;

public class MFWDump {
    private static MFWModelRes mPhysMDRes = MFWModelRes.getInstance();
    public static final String DEFAULT_ROOTDUMPDIRECTORY = "..\\logs\\MFWPhysicalMetadata";
    private static String msRootDumpFolder = "..\\logs\\MFWPhysicalMetadata";
    private String msDumpFolder;
    private String msDumpConnection;
    MFWPhysMDAdaptorConnection mAdaptorConnection;

    public MFWDump(MFWPhysMDAdaptorConnection aAdaptorConnection) {
        this.mAdaptorConnection = aAdaptorConnection;
        this.setDumpFolderName();
    }

    public static void setRootDumpFolder(String sTestcasesFolder) {
        msRootDumpFolder = sTestcasesFolder;
    }

    private void setDumpFolderName() {
        StringBuffer sFolderPathname = new StringBuffer();
        sFolderPathname.append(msRootDumpFolder);
        sFolderPathname.append("\\connectionID");
        sFolderPathname.append(String.valueOf(((Object)((Object)this.mAdaptorConnection)).hashCode()));
        this.msDumpConnection = sFolderPathname.toString();
        sFolderPathname.append("\\query");
        sFolderPathname.append(StringUtils.getDateTime("yyyyMMdd_hhmmssSSS"));
        this.msDumpFolder = sFolderPathname.toString();
    }

    public String getDumpFolderName() {
        return this.msDumpFolder;
    }

    public boolean dumpTable(MFWNodeObject aTable, String sDumpFile) {
        boolean rc = true;
        try {
            if (aTable.getNameRID() == MFWDump.mPhysMDRes.RID_table) {
                FileUtils.WriteStringToFile(StringUtils.toXml((MFWNode)aTable), sDumpFile, "UTF-8");
            }
        }
        catch (Exception e) {
            rc = false;
        }
        return rc;
    }

    public boolean dumpPhysicalMetadataQuery(MFWQuerySpec expandQuerySpec, MFWQuerySpec mainQuerySpec, String sDumpFile) {
        boolean rc = true;
        StringBuffer sQuerySpecInfo = new StringBuffer("<query>");
        sQuerySpecInfo.append(FileUtils.NEWLINE);
        try {
            sQuerySpecInfo.append("<currentStep>");
            sQuerySpecInfo.append(expandQuerySpec.getCurrentStepPattern().toString());
            sQuerySpecInfo.append("</currentStep>");
            sQuerySpecInfo.append(FileUtils.NEWLINE);
        }
        catch (Exception e) {
            rc = false;
        }
        try {
            sQuerySpecInfo.append("<expandQuerySpec>");
            sQuerySpecInfo.append(expandQuerySpec.getXPathQuery());
            sQuerySpecInfo.append("</expandQuerySpec>");
            sQuerySpecInfo.append(FileUtils.NEWLINE);
        }
        catch (Exception e) {
            rc = false;
        }
        try {
            sQuerySpecInfo.append("<mainQuerySpec>");
            sQuerySpecInfo.append(mainQuerySpec.getXPathQuery());
            sQuerySpecInfo.append("</mainQuerySpec>");
            sQuerySpecInfo.append(FileUtils.NEWLINE);
        }
        catch (Exception e) {
            rc = false;
        }
        sQuerySpecInfo.append("</query>");
        sQuerySpecInfo.append(FileUtils.NEWLINE);
        try {
            FileUtils.WriteStringToFile(sQuerySpecInfo.toString(), sDumpFile, "UTF-8");
        }
        catch (Exception e) {
            rc = false;
        }
        return rc;
    }

    public boolean dumpPhysicalMetadataIDLookup(String sPhysID, String sDumpFile) {
        StringBuffer sQuerySpecInfo = new StringBuffer();
        sQuerySpecInfo.append("<lookup>");
        sQuerySpecInfo.append(sPhysID);
        sQuerySpecInfo.append("</lookup>");
        sQuerySpecInfo.append(FileUtils.NEWLINE);
        try {
            FileUtils.WriteStringToFile(sQuerySpecInfo.toString(), sDumpFile, "UTF-8");
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dumpFmModel(MFWRequestContextUser aContext, String sDumpFile) {
        block9: {
            try {
                MFWMetadataSource aMetadataSrc = this.mAdaptorConnection.getReuseInfo().getMetadataSource();
                if (CheckString.exists((String)aMetadataSrc.getConnectionItem("cmSearchPath"))) {
                    InputStream istreamModel = null;
                    MFWContentHelper hlprRCI = null;
                    try {
                        String sCmModelPath = (String)aMetadataSrc.getConnectionItem("cmSearchPath");
                        hlprRCI = MFWContentHelper.create((String)aContext.getUserPassport(), (String)aContext.getProductLocale(), (String)aContext.getContentLocale(), null);
                        istreamModel = hlprRCI.queryPackage(sCmModelPath);
                        FileUtils.WriteInputStreamToFile(istreamModel, sDumpFile);
                        break block9;
                    }
                    finally {
                        if (istreamModel != null) {
                            istreamModel.close();
                        }
                        if (hlprRCI != null) {
                            hlprRCI.destroy();
                        }
                    }
                }
                if (CheckString.exists((String)aMetadataSrc.getConnectionItem("modelFilePath"))) {
                    String sFileModelPath = (String)aMetadataSrc.getConnectionItem("modelFilePath");
                    FileUtils.CopyFile(sFileModelPath, sDumpFile);
                }
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    public boolean dumpCache(MFWCluster aCluster, String sDumpFile) {
        try {
            FileUtils.WriteStringToFile(StringUtils.toXml((MFWNode)aCluster.getRootNode()), sDumpFile, "UTF-8");
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean dumpDBConnectionInfo(MFWRequestContextUser aContext, MFWNodeObject aLinkNodeParent, MFWQuerySpec querySpec, String sDumpFile) {
        String sQueryCmDataSource;
        StringBuffer sConnections;
        boolean rc;
        block11: {
            rc = true;
            sConnections = new StringBuffer();
            sConnections.append("<jdbcInfo>");
            sConnections.append(FileUtils.NEWLINE);
            sQueryCmDataSource = "";
            try {
                String sInfo;
                String sXPathQuery = querySpec.getXPathQuery();
                MFWPhysID physID = MFWPhysID.parseXPath(sXPathQuery);
                sQueryCmDataSource = physID.getCmDatasource();
                if (sQueryCmDataSource == null) break block11;
                try {
                    QueryRelmdGateway mGw = new QueryRelmdGateway(aContext, MFWPhysMDAdaptor.capability_UseXQEConnectionPool());
                    IDbConnectionPool aConnection = mGw.lookupConnection(sQueryCmDataSource);
                    sInfo = aConnection.toXml();
                }
                catch (Exception e3) {
                    MFWXMLDump dump = new MFWXMLDump();
                    dump.addElement("jdbcConnection", 0);
                    dump.addAttribute("jdbcConnectionName", sQueryCmDataSource);
                    dump.addAttribute("cmDataSource", sQueryCmDataSource);
                    dump.addAttribute("jdbcConnectionString", "null");
                    dump.addAttribute("userID", "null");
                    dump.addAttribute("password", "null");
                    dump.addAttribute("driverClass", "null");
                    dump.addAttribute("vendorType", "null");
                    dump.endElement(true);
                    sInfo = dump.getXML();
                }
                sConnections.append("    ");
                sConnections.append(sInfo);
                sConnections.append(FileUtils.NEWLINE);
            }
            catch (Exception e) {
                rc = false;
            }
        }
        try {
            for (MFWNode physSourceNode : aLinkNodeParent.getObjectNodes(MFWDump.mPhysMDRes.RID_physicalSource)) {
                String sInfo;
                MFWNodeObject physSource = (MFWNodeObject)physSourceNode;
                String sCmDataSource = physSource.getPropertyValue(MFWDump.mPhysMDRes.RID_name);
                if (sQueryCmDataSource != null && sQueryCmDataSource.equalsIgnoreCase(sCmDataSource)) continue;
                try {
                    QueryRelmdGateway mGw = new QueryRelmdGateway(aContext, MFWPhysMDAdaptor.capability_UseXQEConnectionPool());
                    IDbConnectionPool aConnection = mGw.lookupConnection(sCmDataSource);
                    sInfo = aConnection.toXml();
                }
                catch (Exception e3) {
                    MFWXMLDump dump = new MFWXMLDump();
                    dump.addElement("jdbcConnection", 0);
                    dump.addAttribute("jdbcConnectionName", sCmDataSource);
                    dump.addAttribute("cmDataSource", sCmDataSource);
                    dump.addAttribute("jdbcConnectionString", "null");
                    dump.addAttribute("userID", "null");
                    dump.addAttribute("password", "null");
                    dump.addAttribute("driverClass", "null");
                    dump.addAttribute("vendorType", "null");
                    dump.endElement(true);
                    sInfo = dump.getXML();
                }
                sConnections.append("    ");
                sConnections.append(sInfo);
                sConnections.append(FileUtils.NEWLINE);
            }
        }
        catch (Exception e) {
            rc = false;
        }
        sConnections.append("</jdbcInfo>");
        try {
            FileUtils.WriteStringToFile(sConnections.toString(), sDumpFile, "UTF-8");
        }
        catch (Exception e) {
            rc = false;
        }
        return rc;
    }

    public boolean dumpDBConnectionInfo(MFWRequestContextUser aContext, MFWNodeObject aLinkNodeParent, String sPhysID, String sDumpFile) {
        String sQueryCmDataSource;
        StringBuffer sConnections;
        boolean rc;
        block12: {
            rc = true;
            sConnections = new StringBuffer();
            sConnections.append("<jdbcInfo>");
            sConnections.append(FileUtils.NEWLINE);
            sQueryCmDataSource = "";
            try {
                String sInfo;
                MFWPhysID physID = MFWPhysID.parsePhysID(sPhysID);
                sQueryCmDataSource = physID.getCmDatasource();
                if (sQueryCmDataSource == null) break block12;
                try {
                    QueryRelmdGateway mGw = new QueryRelmdGateway(aContext, MFWPhysMDAdaptor.capability_UseXQEConnectionPool());
                    IDbConnectionPool aConnection = mGw.lookupConnection(sQueryCmDataSource);
                    sInfo = aConnection.toXml();
                }
                catch (Exception e3) {
                    MFWXMLDump dump = new MFWXMLDump();
                    dump.addElement("jdbcConnection", 0);
                    dump.addAttribute("jdbcConnectionName", sQueryCmDataSource);
                    dump.addAttribute("cmDataSource", sQueryCmDataSource);
                    dump.addAttribute("jdbcConnectionString", "null");
                    dump.addAttribute("userID", "null");
                    dump.addAttribute("password", "null");
                    dump.addAttribute("driverClass", "null");
                    dump.addAttribute("vendorType", "null");
                    dump.endElement(true);
                    sInfo = dump.getXML();
                }
                sConnections.append("    ");
                sConnections.append(sInfo);
                sConnections.append(FileUtils.NEWLINE);
            }
            catch (Exception e) {
                rc = false;
            }
        }
        try {
            for (MFWNode physSourceNode : aLinkNodeParent.getObjectNodes(MFWDump.mPhysMDRes.RID_physicalSource)) {
                String sInfo;
                MFWNodeObject physSource = (MFWNodeObject)physSourceNode;
                String sCmDataSource = physSource.getPropertyValue(MFWDump.mPhysMDRes.RID_name);
                if (sQueryCmDataSource.equalsIgnoreCase(sCmDataSource)) continue;
                try {
                    QueryRelmdGateway mGw = new QueryRelmdGateway(aContext, MFWPhysMDAdaptor.capability_UseXQEConnectionPool());
                    IDbConnectionPool aConnection = mGw.lookupConnection(sCmDataSource);
                    sInfo = aConnection.toXml();
                }
                catch (Exception e3) {
                    MFWXMLDump dump = new MFWXMLDump();
                    dump.addElement("jdbcConnection", 0);
                    dump.addAttribute("jdbcConnectionName", sCmDataSource);
                    dump.addAttribute("cmDataSource", sCmDataSource);
                    dump.addAttribute("jdbcConnectionString", "null");
                    dump.addAttribute("userID", "null");
                    dump.addAttribute("password", "null");
                    dump.addAttribute("driverClass", "null");
                    dump.addAttribute("vendorType", "null");
                    dump.endElement(true);
                    sInfo = dump.getXML();
                }
                sConnections.append("    ");
                sConnections.append(sInfo);
                sConnections.append("\n");
            }
        }
        catch (Exception e) {
            rc = false;
        }
        sConnections.append("</jdbcInfo>");
        try {
            if (!sConnections.toString().equals("<jdbcInfo></jdbcInfo>")) {
                FileUtils.WriteStringToFile(sConnections.toString(), sDumpFile, "UTF-8");
            }
        }
        catch (Exception e) {
            rc = false;
        }
        return rc;
    }

    public boolean dumpExceptionMessage(Throwable e, String sDumpFile) {
        if (e != null) {
            try {
                FileUtils.WriteStringToFile(e.getMessage(), sDumpFile, null);
            }
            catch (Exception e2) {
                return false;
            }
        }
        return true;
    }

    public boolean dumpExceptionStack(Throwable e, String sDumpFile) {
        if (e != null) {
            try {
                FileUtils.WriteStringToFile(StringUtils.null2NA(StringUtils.getStackTrace(e)), sDumpFile, null);
            }
            catch (Exception e2) {
                return false;
            }
        }
        return true;
    }

    public boolean createPhysicalMetadataDump(MFWNodeObject aLinkNodeParent, MFWQuerySpec expandQuerySpec, MFWQuerySpec linkQuerySpec, MFWNodeObject aExpandedObject, Throwable e, MFWRequestContextUser aContext) {
        boolean rc = true;
        if (!FileUtils.CreateFolder(msRootDumpFolder)) {
            return false;
        }
        if (!FileUtils.CreateFolder(this.msDumpConnection)) {
            return false;
        }
        if (!FileUtils.CreateFolder(this.msDumpFolder)) {
            return false;
        }
        MFWNodeObject aPhysicalSources = this.mAdaptorConnection.getPhysicalSources();
        rc &= this.dumpPhysicalMetadataQuery(expandQuerySpec, linkQuerySpec, this.msDumpFolder + "/MfwPhysicalMetadataQuery.xml");
        rc &= this.dumpTable(aExpandedObject, this.msDumpFolder + "/table.xml");
        if (!FileUtils.FilepathExists(this.msDumpConnection + "/fmModel.xml")) {
            rc &= this.dumpFmModel(aContext, this.msDumpConnection + "/fmModel.xml");
        }
        rc &= this.dumpCache(aLinkNodeParent.getCluster(), this.msDumpFolder + "/MfwStaticCacheState.xml");
        rc &= this.dumpCache(aPhysicalSources.getCluster(), this.msDumpFolder + "/MfwDynamicCacheState.xml");
        rc &= this.dumpDBConnectionInfo(aContext, aLinkNodeParent, linkQuerySpec, this.msDumpFolder + "/MFWPhysMDLoaderDBInfo.xml");
        rc &= this.dumpExceptionMessage(e, this.msDumpFolder + "/MfwExceptionMsg.txt");
        return rc &= this.dumpExceptionStack(e, this.msDumpFolder + "/exceptionStack.txt");
    }

    public boolean createPhysicalMetadataDump(MFWNodeObject aLinkNodeParent, String sID, MFWNodeObject aTable, Throwable e, MFWRequestContextUser aContext) {
        boolean rc = true;
        if (!FileUtils.CreateFolder(msRootDumpFolder)) {
            return false;
        }
        if (!FileUtils.CreateFolder(this.msDumpConnection)) {
            return false;
        }
        if (!FileUtils.CreateFolder(this.msDumpFolder)) {
            return false;
        }
        MFWNodeObject aPhysicalSources = this.mAdaptorConnection.getPhysicalSources();
        rc &= this.dumpPhysicalMetadataIDLookup(sID, this.msDumpFolder + "/MfwPhysicalMetadataIDLookup.xml");
        rc &= this.dumpTable(aTable, this.msDumpFolder + "/table.xml");
        if (!FileUtils.FilepathExists(this.msDumpConnection + "/fmModel.xml")) {
            rc &= this.dumpFmModel(aContext, this.msDumpConnection + "/fmModel.xml");
        }
        rc &= this.dumpCache(aLinkNodeParent.getCluster(), this.msDumpFolder + "/MfwStaticCacheState.xml");
        rc &= this.dumpCache(aPhysicalSources.getCluster(), this.msDumpFolder + "/MfwDynamicCacheState.xml");
        rc &= this.dumpDBConnectionInfo(aContext, aTable, sID, this.msDumpFolder + "/MFWPhysMDLoaderDBInfo.xml");
        rc &= this.dumpExceptionMessage(e, this.msDumpFolder + "/MfwExceptionMsg.txt");
        return rc &= this.dumpExceptionStack(e, this.msDumpFolder + "/exceptionStack.txt");
    }
}

