/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfwa4j.adaptorPhysicalMDFM;

import com.cognos.mfw4j.framework.MFWModelRes;
import com.cognos.mfw4j.framework.MFWNode;
import com.cognos.mfw4j.framework.MFWNodeObject;
import com.cognos.mfw4j.framework.MFWRequestContextUser;
import com.cognos.mfw4j.utilities.MFWCrnIDHelper;
import com.cognos.mfw4j.utilities.MFWException;
import com.cognos.mfwa4j.adaptorPhysicalMD.physicalMetadataUtilities.FmCclDataTypes;
import com.cognos.mfwa4j.adaptorPhysicalMDFM.MFWPhysMDIDGenerator;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class MFWPhysMDFMLoader {
    private static final int Extract_Success = 1;
    private static final int Extract_Failure_notDbQuerySubject = 2;
    private static final int Extract_Failure_sqlNotSelectAll = 3;
    private static final int Extract_Failure_incorrectTableType = 4;
    private static final int Extract_Failure_duplicateInconsistentQuerySubjects = 5;
    private static String DEFAULT_VALUE_ZERO = "0";
    private static MFWModelRes gModelRes = MFWModelRes.getInstance();
    private static final Pattern gPatternSELECTALL1 = Pattern.compile("(?ims)\\s*<sql.*?>\\s*SELECT\\s*<column>\\s*\\*\\s*</column>\\s*FROM\\s*<table>.*");
    private static final Pattern gPatternSELECTALL2 = Pattern.compile("(?ims)\\s*<sql.*?>\\s*SELECT\\s*\\*\\s*FROM\\s*.*");
    private MFWPhysMDIDGenerator mIDGenerator = null;
    private MFWNodeObject mFmProjectNode = null;
    private String mDefaultLocale = null;
    private MFWNodeObject mObjPhysSources = null;
    private LinkedHashMap<String, MFWNodeObject> mDataSrcRef2Schema = null;
    private MFWRequestContextUser mUserContext;

    static boolean areEqual(String s1, String s2, String sDefValue) {
        if (s1 == null && sDefValue != null) {
            s1 = sDefValue;
        }
        if (s2 == null && sDefValue != null) {
            s2 = sDefValue;
        }
        if (s1 != null && s2 != null) {
            return s1.equals(s2);
        }
        return s1 == null && s2 == null;
    }

    private static boolean isSelectAllSql(MFWNodeObject objQSubj) {
        String sSQL = objQSubj.getPropertyValue(MFWPhysMDFMLoader.gModelRes.RID_sql);
        Matcher myMatcher1 = gPatternSELECTALL1.matcher(sSQL);
        boolean bUsingSelectALL = myMatcher1.matches();
        if (!bUsingSelectALL) {
            Matcher myMatcher2 = gPatternSELECTALL2.matcher(sSQL);
            bUsingSelectALL = myMatcher2.matches();
        }
        return bUsingSelectALL;
    }

    MFWPhysMDFMLoader(MFWPhysMDIDGenerator anIDGenerator, MFWNodeObject objPhysSources, MFWNodeObject fmProjectNode, MFWRequestContextUser aContext) {
        this.mIDGenerator = anIDGenerator;
        this.mObjPhysSources = objPhysSources;
        this.mFmProjectNode = fmProjectNode;
        this.mDataSrcRef2Schema = new LinkedHashMap();
        this.mDefaultLocale = this.mFmProjectNode.getPropertyValue(MFWPhysMDFMLoader.gModelRes.RID_defaultLocale);
        this.mUserContext = aContext;
    }

    void destroy() {
        this.mObjPhysSources = null;
        this.mFmProjectNode = null;
        this.mDataSrcRef2Schema.clear();
    }

    void extractMetadata() {
        boolean bAllowMetadataCallback = this.checkMetadataCallbackGovernor();
        this.collectModelDataSources();
        ArrayList<MFWNodeObject> vQuerySubjs = new ArrayList<MFWNodeObject>(100);
        this.mFmProjectNode.getCluster().getIndexManager().lookupObjectsByType((short)238, vQuerySubjs);
        if (bAllowMetadataCallback && !this.isDescribeDatasourceQueryOrValidateFromFM(this.mUserContext)) {
            this.extractTableMetadata(vQuerySubjs);
        }
        this.extractSubRoutineMetadata(vQuerySubjs);
    }

    private boolean isDescribeDatasourceQueryOrValidateFromFM(MFWRequestContextUser userContext) {
        if (userContext != null && userContext.getXQEExecutionEnvironment() instanceof ExecutionEnvironment) {
            ExecutionEnvironment exeEnv = null;
            exeEnv = (ExecutionEnvironment)userContext.getXQEExecutionEnvironment();
            if (exeEnv != null && exeEnv.getRequestEnvironment() != null && "describeDataSourceQuery".equals(((RequestEnvironment)exeEnv.getRequestEnvironment()).getOperationName())) {
                return true;
            }
        }
        return false;
    }

    private void collectModelDataSources() {
        HashMap<String, MFWNodeObject> vUnqiueDataSrc2Schema = new HashMap<String, MFWNodeObject>();
        for (MFWNode nodeDataSrc : this.mFmProjectNode.getObjectNodes(MFWPhysMDFMLoader.gModelRes.RID_dataSource)) {
            String dataSrcID;
            String sSchema;
            int iQueryType;
            MFWNodeObject objDataSrc = (MFWNodeObject)nodeDataSrc;
            String sCmDataSource = objDataSrc.getPropertyValue(MFWPhysMDFMLoader.gModelRes.RID_cmDataSource);
            if (sCmDataSource == null || sCmDataSource.length() == 0 || (iQueryType = objDataSrc.getEnumPropertyValue(MFWPhysMDFMLoader.gModelRes.RID_queryType)) != 0) continue;
            String sCatalog = objDataSrc.getPropertyValue(MFWPhysMDFMLoader.gModelRes.RID_catalog);
            if (sCatalog == null) {
                sCatalog = "";
            }
            if ((sSchema = objDataSrc.getPropertyValue(MFWPhysMDFMLoader.gModelRes.RID_schema)) == null) {
                sSchema = "";
            }
            StringBuilder myKey = new StringBuilder(sCmDataSource);
            myKey.append("||");
            myKey.append(sCatalog);
            myKey.append("||");
            myKey.append(sSchema);
            String combinedKey = myKey.toString();
            MFWNodeObject objSchema = (MFWNodeObject)vUnqiueDataSrc2Schema.get(combinedKey);
            if (objSchema == null) {
                objSchema = this.addSchema(sCmDataSource, sCatalog, sSchema);
                vUnqiueDataSrc2Schema.put(combinedKey, objSchema);
            }
            MFWException.ASSERT(((dataSrcID = objDataSrc.getPropertyValue(MFWPhysMDFMLoader.gModelRes.RID_ID)) != null && dataSrcID.length() > 0 ? 1 : 0) != 0, (String)"Expecting a valid data source ID for data source whose cmDataSource is:", (String)sCmDataSource);
            this.mDataSrcRef2Schema.put(dataSrcID, objSchema);
        }
    }

    private MFWNodeObject addSchema(String aCMDataSrc, String aCatalog, String aSchema) {
        MFWNodeObject objSchema = null;
        ArrayList vOutValues = new ArrayList(2);
        this.mObjPhysSources.findObjectNodes(MFWPhysMDFMLoader.gModelRes.RID_physicalSource, MFWPhysMDFMLoader.gModelRes.RID_name, aCMDataSrc, vOutValues);
        MFWException.ASSERT((vOutValues.size() <= 1 ? 1 : 0) != 0, (String)"Expecting at most one physical source node corresponding to cmDataSource", (String)aCMDataSrc);
        MFWNodeObject objPhysSrc = null;
        if (vOutValues.size() == 0) {
            objPhysSrc = this.addObject(this.mObjPhysSources, MFWPhysMDFMLoader.gModelRes.RID_physicalSource, aCMDataSrc, true);
            MFWNodeObject objCatalog = this.addObject(objPhysSrc, MFWPhysMDFMLoader.gModelRes.RID_catalog, aCatalog, true);
            objSchema = this.addObject(objCatalog, MFWPhysMDFMLoader.gModelRes.RID_schema, aSchema, true);
            return objSchema;
        }
        objPhysSrc = (MFWNodeObject)vOutValues.get(0);
        vOutValues.clear();
        objPhysSrc.findObjectNodes(MFWPhysMDFMLoader.gModelRes.RID_catalog, MFWPhysMDFMLoader.gModelRes.RID_name, aCatalog, vOutValues);
        MFWException.ASSERT((vOutValues.size() <= 1 ? 1 : 0) != 0, (String)"Expecting at most one catalog node corresponding to catalog", (String)aCatalog);
        MFWNodeObject objCatalog = null;
        if (vOutValues.size() == 0) {
            objCatalog = this.addObject(objPhysSrc, MFWPhysMDFMLoader.gModelRes.RID_catalog, aCatalog, true);
            objSchema = this.addObject(objCatalog, MFWPhysMDFMLoader.gModelRes.RID_schema, aSchema, true);
            return objSchema;
        }
        objCatalog = (MFWNodeObject)vOutValues.get(0);
        vOutValues.clear();
        objCatalog.findObjectNodes(MFWPhysMDFMLoader.gModelRes.RID_schema, MFWPhysMDFMLoader.gModelRes.RID_name, aSchema, vOutValues);
        MFWException.ASSERT((vOutValues.size() <= 1 ? 1 : 0) != 0, (String)"Expecting at most one schema node corresponding to schema", (String)aSchema);
        objSchema = vOutValues.size() == 0 ? this.addObject(objCatalog, MFWPhysMDFMLoader.gModelRes.RID_schema, aSchema, true) : (MFWNodeObject)vOutValues.get(0);
        return objSchema;
    }

    private MFWNodeObject addObject(MFWNodeObject objParent, short ridChild, String name, boolean bGenerateID) {
        MFWNodeObject newObj = objParent.addObjectNode(ridChild);
        newObj.addProperty(MFWPhysMDFMLoader.gModelRes.RID_name, name);
        if (bGenerateID) {
            this.mIDGenerator.generate(newObj, name);
        }
        return newObj;
    }

    private boolean checkMetadataCallbackGovernor() {
        boolean outValue = true;
        List listParamMaps = this.mFmProjectNode.getObjectNodes(MFWPhysMDFMLoader.gModelRes.RID_parameterMaps);
        if (listParamMaps.size() == 0) {
            return outValue;
        }
        MFWNodeObject objParamMaps = (MFWNodeObject)listParamMaps.get(0);
        ArrayList vFoundObjs = new ArrayList();
        objParamMaps.findObjectNodes(MFWPhysMDFMLoader.gModelRes.RID_parameterMap, MFWPhysMDFMLoader.gModelRes.RID_name, "_governor", vFoundObjs);
        if (vFoundObjs.size() == 0) {
            return outValue;
        }
        MFWNodeObject objGovMap = (MFWNodeObject)vFoundObjs.get(0);
        vFoundObjs.clear();
        objGovMap.findObjectNodes(MFWPhysMDFMLoader.gModelRes.RID_parameterMapEntry, MFWPhysMDFMLoader.gModelRes.RID_key, "useMetadataCallback", vFoundObjs);
        if (vFoundObjs.size() == 0) {
            return outValue;
        }
        MFWNodeObject govEntry = (MFWNodeObject)vFoundObjs.get(0);
        outValue = !"false".equals(govEntry.getPropertyValue(MFWPhysMDFMLoader.gModelRes.RID_value));
        return outValue;
    }

    private String getObjectName(MFWNodeObject objNode) {
        ArrayList vNames = new ArrayList(1);
        objNode.findObjectNodes(MFWPhysMDFMLoader.gModelRes.RID_name, MFWPhysMDFMLoader.gModelRes.RID_locale, this.mDefaultLocale, vNames);
        if (vNames.size() > 0) {
            return ((MFWNodeObject)vNames.get(0)).getPropertyValue(MFWPhysMDFMLoader.gModelRes.RID__Value);
        }
        return objNode.getPropertyValue(MFWPhysMDFMLoader.gModelRes.RID_ID);
    }

    private void extractTableMetadata(ArrayList<MFWNodeObject> vQuerySubjs) {
        LinkedHashMap<MFWNodeObject, NameObjects> mapSchema2QuerySubjs = new LinkedHashMap<MFWNodeObject, NameObjects>(this.mDataSrcRef2Schema.size());
        for (MFWNodeObject aSchema : this.mDataSrcRef2Schema.values()) {
            mapSchema2QuerySubjs.put(aSchema, new NameObjects());
        }
        for (MFWNodeObject objQS : vQuerySubjs) {
            String sDataSrcRef = objQS.getPropertyValue(MFWPhysMDFMLoader.gModelRes.RID_dataSourceRef);
            MFWNodeObject objSchema = sDataSrcRef != null ? this.mDataSrcRef2Schema.get(sDataSrcRef) : null;
            if (objSchema == null) continue;
            int iDefType = objQS.getEnumPropertyValue(MFWPhysMDFMLoader.gModelRes.RID_definitionType);
            if (iDefType != 1) {
                this.addExtractFeedback(2, objSchema, objQS);
                continue;
            }
            int iTableType = objQS.getEnumPropertyValue(MFWPhysMDFMLoader.gModelRes.RID_tableType);
            if (iTableType != 1 && iTableType != 2) {
                this.addExtractFeedback(4, objSchema, objQS);
                continue;
            }
            if (!MFWPhysMDFMLoader.isSelectAllSql(objQS)) {
                this.addExtractFeedback(3, objSchema, objQS);
                continue;
            }
            String sName = this.getObjectName(objQS);
            if (sName == null) continue;
            ((NameObjects)mapSchema2QuerySubjs.get(objSchema)).trackObject(objQS, sName);
        }
        for (Map.Entry entry1 : mapSchema2QuerySubjs.entrySet()) {
            MFWNodeObject objSchema = (MFWNodeObject)entry1.getKey();
            NameObjects namedObjects = (NameObjects)entry1.getValue();
            for (Map.Entry<String, ConsistentSubj> entry2 : namedObjects.mName2Objects.entrySet()) {
                String qSubjName = entry2.getKey();
                ConsistentSubj qSubjConst = entry2.getValue();
                if (qSubjConst.mIsConsistent) {
                    this.loadTable(objSchema, qSubjName, qSubjConst.mBaseSubj);
                    this.addExtractFeedback(1, objSchema, qSubjConst.mBaseSubj);
                    continue;
                }
                this.addExtractFeedback(5, objSchema, qSubjConst.mBaseSubj);
            }
        }
    }

    private MFWNodeObject addExtractFeedback(int eReason, MFWNodeObject objSchema, MFWNodeObject objQSubj) {
        MFWNodeObject objFeedback = this.mObjPhysSources.addObjectNode(MFWPhysMDFMLoader.gModelRes.RID_physMDExtractFeedback);
        String anID = MFWCrnIDHelper.addEntryToID((String)objSchema.getPropertyValue(MFWPhysMDFMLoader.gModelRes.RID_ID), (String)this.getObjectName(objQSubj));
        objFeedback.addProperty(MFWPhysMDFMLoader.gModelRes.RID_appliesTo, anID);
        objFeedback.addProperty(MFWPhysMDFMLoader.gModelRes.RID_type, eReason);
        return objFeedback;
    }

    private void loadTable(MFWNodeObject objSchema, String sQSubjName, MFWNodeObject objQSubj) {
        MFWNodeObject objTable = this.addObject(objSchema, MFWPhysMDFMLoader.gModelRes.RID_table, sQSubjName, true);
        objTable.addProperty(MFWPhysMDFMLoader.gModelRes.RID_type, objQSubj.getPropertyValue(MFWPhysMDFMLoader.gModelRes.RID_tableType));
        String sNumRows = objQSubj.getPropertyValue(MFWPhysMDFMLoader.gModelRes.RID_numberOfRows);
        if (sNumRows != null && sNumRows.length() > 0) {
            objTable.addProperty(MFWPhysMDFMLoader.gModelRes.RID_numberOfRows, sNumRows);
        }
        List properties = objQSubj.getObjectNodes(MFWPhysMDFMLoader.gModelRes.RID_property);
        for (MFWNode property : properties) {
            MFWNodeObject objProp = (MFWNodeObject)property;
            MFWNodeObject uriObj = objTable.addObjectNode(MFWPhysMDFMLoader.gModelRes.RID_property);
            uriObj.addProperty(MFWPhysMDFMLoader.gModelRes.RID_name, objProp.getPropertyValue(MFWPhysMDFMLoader.gModelRes.RID_name));
            uriObj.addProperty(MFWPhysMDFMLoader.gModelRes.RID__Value, objProp.getPropertyValue(MFWPhysMDFMLoader.gModelRes.RID__Value));
        }
        this.loadQueryItems(objTable, objQSubj.getChildNodes(), MFWPhysMDFMLoader.gModelRes.RID_column, true);
    }

    private void loadQueryItems(MFWNodeObject objParent, List<MFWNode> nodes, short objectType, boolean generateId) {
        for (MFWNode node : nodes) {
            if (node.getNameRID() == MFWPhysMDFMLoader.gModelRes.RID_queryItem) {
                this.loadQueryItem(objParent, (MFWNodeObject)node, objectType, generateId);
                continue;
            }
            if (node.getNameRID() != MFWPhysMDFMLoader.gModelRes.RID_queryItemFolder) continue;
            this.loadQueryItemFolder(objParent, (MFWNodeObject)node, objectType, generateId);
        }
    }

    private void loadQueryItem(MFWNodeObject objParent, MFWNodeObject qItem, short objectType, boolean generateId) {
        String sExtName = qItem.getPropertyValue(MFWPhysMDFMLoader.gModelRes.RID_externalName);
        if (sExtName == null || sExtName.length() == 0) {
            return;
        }
        MFWNodeObject objColumn = this.addObject(objParent, objectType, sExtName, generateId);
        this.addScalarAttributes(objColumn, qItem);
        MFWNodeObject childNode = qItem.getObjectNode(MFWPhysMDFMLoader.gModelRes.RID_queryItem);
        if (objColumn.getPropertyValue(MFWPhysMDFMLoader.gModelRes.RID_datatype).equals("cclDTypeArray") && childNode != null) {
            this.loadQueryItem(objColumn, childNode, objectType, generateId);
        }
    }

    private void loadQueryItemFolder(MFWNodeObject objParent, MFWNodeObject qItemFolder, short objectType, boolean generateId) {
        MFWNodeObject nameObj = qItemFolder.getObjectNode(MFWPhysMDFMLoader.gModelRes.RID_name);
        String sExtName = nameObj.getPropertyValue(MFWPhysMDFMLoader.gModelRes.RID__Value);
        String sFmDataType = qItemFolder.getPropertyValue(MFWPhysMDFMLoader.gModelRes.RID_datatype);
        if (sFmDataType != null) {
            String sCclDataType = FmCclDataTypes.convertToCCL(sFmDataType);
            MFWNodeObject objColumn = this.addObject(objParent, objectType, sExtName, generateId);
            objColumn.addProperty(MFWPhysMDFMLoader.gModelRes.RID_datatype, sCclDataType);
            objParent = objColumn;
        }
        this.loadQueryItems(objParent, qItemFolder.getChildNodes(), objectType, generateId);
    }

    private void addScalarAttributes(MFWNodeObject objScalar, MFWNodeObject objBaseItem) {
        String sNullable;
        String sScale;
        String sPrecs;
        String sFmDataType = objBaseItem.getPropertyValue(MFWPhysMDFMLoader.gModelRes.RID_datatype);
        String sCclDataType = FmCclDataTypes.convertToCCL(sFmDataType);
        MFWException.ASSERT((sCclDataType != null ? 1 : 0) != 0, (String)"Missing CCL data type for FM data type:", (String)sFmDataType);
        objScalar.addProperty(MFWPhysMDFMLoader.gModelRes.RID_datatype, sCclDataType);
        String sSize = objBaseItem.getPropertyValue(MFWPhysMDFMLoader.gModelRes.RID_size);
        if (sSize != null && sSize.length() > 0) {
            objScalar.addProperty(MFWPhysMDFMLoader.gModelRes.RID_size, sSize);
        }
        if ((sPrecs = objBaseItem.getPropertyValue(MFWPhysMDFMLoader.gModelRes.RID_precision)) != null && sPrecs.length() > 0) {
            objScalar.addProperty(MFWPhysMDFMLoader.gModelRes.RID_precision, sPrecs);
        }
        if ((sScale = objBaseItem.getPropertyValue(MFWPhysMDFMLoader.gModelRes.RID_scale)) != null && sScale.length() > 0) {
            objScalar.addProperty(MFWPhysMDFMLoader.gModelRes.RID_scale, sScale);
        }
        if ((sNullable = objBaseItem.getPropertyValue(MFWPhysMDFMLoader.gModelRes.RID_nullable)) != null && sNullable.length() > 0 && !sNullable.equals("false")) {
            objScalar.addProperty(MFWPhysMDFMLoader.gModelRes.RID_nullable, sNullable);
        }
    }

    private void extractSubRoutineMetadata(ArrayList<MFWNodeObject> vQuerySubjs) {
        LinkedHashMap<MFWNodeObject, NameObjects> mapSchema2QuerySubjs = new LinkedHashMap<MFWNodeObject, NameObjects>(this.mDataSrcRef2Schema.size());
        for (MFWNodeObject aSchema : this.mDataSrcRef2Schema.values()) {
            mapSchema2QuerySubjs.put(aSchema, new NameObjects());
        }
        this.collectStoredProcedures(mapSchema2QuerySubjs, vQuerySubjs);
        this.collectUpdateSubjects(mapSchema2QuerySubjs);
        for (Map.Entry<MFWNodeObject, NameObjects> entry1 : mapSchema2QuerySubjs.entrySet()) {
            MFWNodeObject objSchema = entry1.getKey();
            NameObjects namedObjects = entry1.getValue();
            for (Map.Entry<String, ConsistentSubj> entry2 : namedObjects.mName2Objects.entrySet()) {
                String qSubjName = entry2.getKey();
                ConsistentSubj qSubjConst = entry2.getValue();
                if (!qSubjConst.mIsConsistent) continue;
                this.loadSubroutine(objSchema, qSubjName, qSubjConst.mBaseSubj);
                this.addExtractFeedback(1, objSchema, qSubjConst.mBaseSubj);
            }
        }
    }

    private void collectStoredProcedures(Map<MFWNodeObject, NameObjects> mapSchema2QuerySubjs, ArrayList<MFWNodeObject> vQuerySubjs) {
        for (MFWNodeObject objQS : vQuerySubjs) {
            String sName;
            String sCanName;
            String sDataSrcRef;
            MFWNodeObject objSchema;
            int iDefType = objQS.getEnumPropertyValue(MFWPhysMDFMLoader.gModelRes.RID_definitionType);
            if (iDefType != 3 || (objSchema = this.mDataSrcRef2Schema.get(sDataSrcRef = objQS.getPropertyValue(MFWPhysMDFMLoader.gModelRes.RID_dataSourceRef))) == null || (sCanName = objQS.getPropertyValue(MFWPhysMDFMLoader.gModelRes.RID_canonicalName)) == null || sCanName.length() == 0 || (sName = this.getObjectName(objQS)) == null) continue;
            mapSchema2QuerySubjs.get(objSchema).trackObject(objQS, sName);
        }
    }

    private void collectUpdateSubjects(Map<MFWNodeObject, NameObjects> mapSchema2QuerySubjs) {
        ArrayList vUpdateSubjs = new ArrayList(100);
        this.mFmProjectNode.getCluster().getIndexManager().lookupObjectsByType((short)242, vUpdateSubjs);
        for (MFWNodeObject objUS : vUpdateSubjs) {
            String sName;
            String sCanName;
            String sDataSrcRef = objUS.getPropertyValue(MFWPhysMDFMLoader.gModelRes.RID_dataSourceRef);
            MFWNodeObject objSchema = this.mDataSrcRef2Schema.get(sDataSrcRef);
            if (objSchema == null || (sCanName = objUS.getPropertyValue(MFWPhysMDFMLoader.gModelRes.RID_canonicalName)) == null || sCanName.length() == 0 || (sName = this.getObjectName(objUS)) == null) continue;
            mapSchema2QuerySubjs.get(objSchema).trackObject(objUS, sName);
        }
    }

    private void loadSubroutine(MFWNodeObject objSchema, String sBaseSubjName, MFWNodeObject objBaseSubj) {
        MFWNodeObject objSubroutine = this.addObject(objSchema, MFWPhysMDFMLoader.gModelRes.RID_subroutine, sBaseSubjName, true);
        objSubroutine.addProperty(MFWPhysMDFMLoader.gModelRes.RID_invocationType, "procedure");
        objSubroutine.addProperty(MFWPhysMDFMLoader.gModelRes.RID_canonicalName, objBaseSubj.getPropertyValue(MFWPhysMDFMLoader.gModelRes.RID_canonicalName));
        for (MFWNode aNode : objBaseSubj.getObjectNodes(MFWPhysMDFMLoader.gModelRes.RID_procParameter)) {
            MFWNodeObject objProcParam = (MFWNodeObject)aNode;
            String sParameterName = objProcParam.getPropertyValue(gModelRes.getResourceID("parameterName"));
            MFWNodeObject objSubProcArg = this.addObject(objSubroutine, MFWPhysMDFMLoader.gModelRes.RID_procArgument, sParameterName, false);
            this.addScalarAttributes(objSubProcArg, objProcParam);
        }
        this.loadQueryItems(objSubroutine, objBaseSubj.getChildNodes(), MFWPhysMDFMLoader.gModelRes.RID_procResult, false);
    }

    private class NameObjects {
        LinkedHashMap<String, ConsistentSubj> mName2Objects = new LinkedHashMap(100);

        NameObjects() {
        }

        void trackObject(MFWNodeObject inQSubj, String sName) {
            ConsistentSubj consQSubj = this.mName2Objects.get(sName);
            if (consQSubj == null) {
                this.mName2Objects.put(sName, new ConsistentSubj(inQSubj));
            } else if (consQSubj.mIsConsistent) {
                consQSubj.mIsConsistent = this.areConsistent(consQSubj.mBaseSubj, inQSubj);
            }
        }

        private boolean areConsistent(MFWNodeObject baseObj, MFWNodeObject targetObj) {
            ArrayList sourceQItems = new ArrayList(20);
            baseObj.findObjectNodesRecursively(gModelRes.RID_queryItem, gModelRes.RID_queryItemFolder, (short)-1, null, false, sourceQItems);
            ArrayList targetQItems = new ArrayList(20);
            targetObj.findObjectNodesRecursively(gModelRes.RID_queryItem, gModelRes.RID_queryItemFolder, (short)-1, null, false, targetQItems);
            if (sourceQItems.size() != targetQItems.size()) {
                return false;
            }
            for (int idx = 0; idx < sourceQItems.size(); ++idx) {
                MFWNodeObject qItem1 = (MFWNodeObject)sourceQItems.get(idx);
                MFWNodeObject qItem2 = (MFWNodeObject)targetQItems.get(idx);
                if (!MFWPhysMDFMLoader.areEqual(qItem1.getPropertyValue(gModelRes.RID_externalName), qItem2.getPropertyValue(gModelRes.RID_externalName), null)) {
                    return false;
                }
                if (qItem1.getEnumPropertyValue(gModelRes.RID_datatype) != qItem2.getEnumPropertyValue(gModelRes.RID_datatype)) {
                    return false;
                }
                if (!MFWPhysMDFMLoader.areEqual(qItem1.getPropertyValue(gModelRes.RID_size), qItem2.getPropertyValue(gModelRes.RID_size), null)) {
                    return false;
                }
                if (!MFWPhysMDFMLoader.areEqual(qItem1.getPropertyValue(gModelRes.RID_externalName), qItem2.getPropertyValue(gModelRes.RID_externalName), null)) {
                    return false;
                }
                if (!MFWPhysMDFMLoader.areEqual(qItem1.getPropertyValue(gModelRes.RID_precision), qItem2.getPropertyValue(gModelRes.RID_precision), DEFAULT_VALUE_ZERO)) {
                    return false;
                }
                if (MFWPhysMDFMLoader.areEqual(qItem1.getPropertyValue(gModelRes.RID_scale), qItem2.getPropertyValue(gModelRes.RID_scale), DEFAULT_VALUE_ZERO)) continue;
                return false;
            }
            return true;
        }
    }

    private static class ConsistentSubj {
        MFWNodeObject mBaseSubj;
        boolean mIsConsistent;

        ConsistentSubj(MFWNodeObject anObj) {
            this.mBaseSubj = anObj;
            this.mIsConsistent = true;
        }
    }
}

