/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfwa4j.adaptorPhysicalMDFM;

import com.cognos.mfw4j.framework.MFWIndexManager;
import com.cognos.mfw4j.framework.MFWInfoProperty;
import com.cognos.mfw4j.framework.MFWModel;
import com.cognos.mfw4j.framework.MFWModelRes;
import com.cognos.mfw4j.framework.MFWNodeObject;
import com.cognos.mfw4j.utilities.MFWCrnIDHelper;
import com.cognos.mfw4j.utilities.MFWException;

public final class MFWPhysMDIDGenerator {
    private MFWIndexManager mIndexManager = null;
    private MFWInfoProperty mIDInfo = null;

    public MFWPhysMDIDGenerator(MFWIndexManager anIndexMngr) {
        this.mIndexManager = anIndexMngr;
        this.mIDInfo = (MFWInfoProperty)MFWModel.getInstance().findInfoByGUID((short)100);
    }

    public void destroy() {
        this.mIndexManager = null;
    }

    public void generate(MFWNodeObject objPhys, String aCaption) {
        MFWModelRes gModelRes = MFWModelRes.getInstance();
        MFWException.ASSERT((objPhys.getObjectInfo().findChildInfo(gModelRes.RID_ID) != null ? 1 : 0) != 0, (String)"Generating ID for a physical node that does not support an ID property");
        if (objPhys.getNameRID() == gModelRes.RID_physicalSources) {
            objPhys.addProperty(gModelRes.RID_ID, "[:physicalSources]");
            return;
        }
        MFWNodeObject objParent = objPhys.getParentObject();
        MFWException.ASSERT((objParent != null && objParent.getInfo().getGUID() != 0 ? 1 : 0) != 0, (String)"Expecting a valid parent for the given physical node");
        String parentID = objParent.getPropertyValue(gModelRes.RID_ID);
        MFWException.ASSERT((parentID != null && parentID.length() > 0 ? 1 : 0) != 0, (String)"Expecting a valid parent ID for the given physical node");
        String sID = MFWCrnIDHelper.addEntryToID((String)parentID, (String)aCaption);
        MFWException.ASSERT((this.mIndexManager.lookup(this.mIDInfo, sID) == null ? 1 : 0) != 0, (String)"Unexpected duplicate ID for a physical node:", (String)sID);
        objPhys.addProperty(gModelRes.RID_ID, sID);
    }
}

