/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfwa4j.adaptorReport;

import com.cognos.mfw4j.framework.MFWAdaptor;
import com.cognos.mfw4j.framework.MFWConnection;
import com.cognos.mfw4j.framework.MFWConnectionReuseInfo;
import com.cognos.mfw4j.framework.MFWInfo;
import com.cognos.mfw4j.framework.MFWInfoObject;
import com.cognos.mfw4j.framework.MFWInfoProperty;
import com.cognos.mfw4j.framework.MFWModelRes;
import com.cognos.mfw4j.framework.MFWNodeObject;
import com.cognos.mfw4j.framework.MFWQuerySpec;
import com.cognos.mfw4j.framework.MFWRequestContextUser;
import com.cognos.mfw4j.framework.log.MFWLogReportToV5Event;
import com.cognos.mfw4j.utilities.IMFWCMRequestExecutor;
import com.cognos.mfw4j.utilities.MFWContentHelper;
import com.cognos.mfw4j.utilities.MFWException;
import com.cognos.mfw4j.utilities.MFWSimpleCMRequestExecutor;
import com.cognos.mfw4j.utilities.QFException;
import com.cognos.mfwa4j.adaptorReport.MFWRptAdaptor;
import com.cognos.mfwa4j.adaptorReport.MFWV5DBModelLoader;
import com.cognos.mfwa4j.adaptorReport.MFWV5ModelLoader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.jaxen.expr.NameStep;
import org.jaxen.expr.Step;

public class MFWRptConnection
extends MFWConnection {
    boolean m_mustAttemptRepopulateOnAccess = true;
    String m_spec = "";

    public MFWRptConnection(MFWConnectionReuseInfo aReuseInfo, MFWRptAdaptor anAdaptor) {
        super(aReuseInfo, (MFWAdaptor)anAdaptor);
    }

    public void destroy() {
        super.destroy();
    }

    public void expand(MFWRequestContextUser aContext, MFWQuerySpec aQuerySpec, MFWNodeObject objNode) {
        boolean canMarkExpanded = true;
        if (this.m_mustAttemptRepopulateOnAccess) {
            MFWNodeObject projNode;
            canMarkExpanded = false;
            if (!this.isPreventReportPlanning(aContext) && (projNode = objNode.getCluster().getRootNode().getObjectNode(MFWModelRes.getInstance().RID_project)) != null) {
                this.populateFromStoredSpec(objNode.getCluster().getRootNode(), aContext);
                canMarkExpanded = true;
            }
        }
        Step currStep = aQuerySpec.getCurrentStepPattern();
        MFWException.ASSERT((boolean)(currStep instanceof NameStep), (String)"Expecting a NameStep to expand");
        if ("*".equals(((NameStep)currStep).getLocalName())) {
            MFWInfoObject pObjInfo = (MFWInfoObject)objNode.getInfo();
            MFWInfo[] vChildrenInfo = pObjInfo.getChildrenInfo();
            for (int i = 0; i < vChildrenInfo.length; ++i) {
                if (canMarkExpanded) {
                    this.defaultExpand(aContext, vChildrenInfo[i].getRID(), objNode);
                    continue;
                }
                objNode.setExpandStatus(vChildrenInfo[i].getRID(), (byte)2);
            }
        } else if (canMarkExpanded) {
            super.defaultExpand(aContext, aQuerySpec.getCurrentStepPatternRID(), objNode);
        } else {
            objNode.setExpandStatus(aQuerySpec.getCurrentStepPatternRID(), (byte)2);
        }
    }

    public MFWNodeObject lookup(MFWRequestContextUser aContext, MFWInfoProperty indexProp, String indexValue, MFWNodeObject pRootNode, List<MFWNodeObject> ancestorsChain) {
        MFWNodeObject projNode;
        if (this.m_mustAttemptRepopulateOnAccess && !this.isPreventReportPlanning(aContext) && (projNode = pRootNode.getCluster().getRootNode().getObjectNode(MFWModelRes.getInstance().RID_project)) != null) {
            this.populateFromStoredSpec(projNode.getCluster().getRootNode(), aContext);
            return projNode.getCluster().lookup(indexProp, indexValue, aContext, ancestorsChain);
        }
        return null;
    }

    public void initialSetup(MFWRequestContextUser aContext, MFWNodeObject pLinkNodeParent) {
        String cmSearchPath = (String)this.getSource().getConnectionItem("cmSearchPath");
        StringBuffer sV5ReportSpec = new StringBuffer();
        MFWLogReportToV5Event log = new MFWLogReportToV5Event("MFWRptConnection::initialSetup", cmSearchPath, sV5ReportSpec);
        try {
            MFWNodeObject rootNode = this.getCluster().getRootNode();
            MFWNodeObject projNode = rootNode.addExpandableObjectNode(MFWModelRes.getInstance().RID_project);
            projNode.addProperty(MFWModelRes.getInstance().RID_ID, "[]");
            StringBuffer sPrompt = new StringBuffer();
            MFWContentHelper hlprRCI = MFWContentHelper.create((String)aContext.getProductLocale(), (String)aContext.getContentLocale(), (IMFWCMRequestExecutor)new MFWSimpleCMRequestExecutor(aContext.getBiBusEnvelope(), aContext.getUserPassport()));
            hlprRCI.queryReport(cmSearchPath, aContext.getConnectionSpec(), aContext.getPromptResolution(), sV5ReportSpec, sPrompt);
            log.logEnd();
            if (!"".equals(sPrompt.toString())) {
                this.buildAndThrowPromptException(sPrompt.toString());
            }
            String modelQueryMode = "modelQueryMode";
            String value = (String)this.getSource().getConnectionItem(modelQueryMode);
            if (value == null && (value = this.getAdaptor().getSourceConfig().getCapability(modelQueryMode)).isEmpty()) {
                value = "true";
            }
            if (value.equals("true")) {
                this.m_mustAttemptRepopulateOnAccess = false;
                MFWV5ModelLoader loader = new MFWV5ModelLoader(this.getCluster(), this.getSource(), aContext);
                loader.load(sV5ReportSpec.toString());
            } else {
                MFWV5DBModelLoader loader = new MFWV5DBModelLoader(this.getCluster(), this.getCluster().getRootNode(), this.getSource(), aContext);
                loader.initializeModel(sV5ReportSpec.toString());
                this.m_spec = sV5ReportSpec.toString();
            }
        }
        catch (RuntimeException t) {
            log.logEnd((Throwable)t);
            this.setReusable(false);
            throw t;
        }
    }

    protected void reconstructSetup(MFWRequestContextUser aContext, MFWNodeObject aLinkNodeParent) {
    }

    public void buildAndThrowPromptException(String sPrompt) {
        SAXReader reader = new SAXReader();
        try {
            Document document = reader.read((Reader)new StringReader(sPrompt));
            Element rootElem = document.getRootElement();
            if (rootElem != null) {
                Element faultCode = (Element)rootElem.selectSingleNode("faultcode | *//faultcode");
                if (faultCode != null) {
                    String faultCodeStr = faultCode.getText();
                    if (faultCodeStr.length() <= 4) {
                        MFWRptAdaptor.ThrowException("RPT_CON_UNRECOGNIZED_FAULT_CODE");
                    }
                    String errorCode = faultCodeStr.substring(4);
                    int errorCodeInt = Integer.parseInt(errorCode);
                    QFException qfException = new QFException(errorCodeInt);
                    qfException.setDOM(rootElem);
                    throw qfException;
                }
                Element parameters = (Element)rootElem.selectSingleNode("parameters | *//parameters");
                if (parameters != null) {
                    QFException qfException = new QFException(888);
                    qfException.setDOM(parameters);
                    throw qfException;
                }
                MFWRptAdaptor.ThrowException("RPT_CON_UNRECOGNIZED_FAULT_CODE");
            }
        }
        catch (DocumentException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    void populateFromStoredSpec(MFWNodeObject pRootObjNode, MFWRequestContextUser aContext) {
        MFWV5DBModelLoader loader = new MFWV5DBModelLoader(this.getCluster(), pRootObjNode, this.getSource(), aContext);
        this.m_mustAttemptRepopulateOnAccess = false;
        try {
            loader.planAndBuildQueries(this.m_spec);
        }
        catch (RuntimeException e) {
            this.m_mustAttemptRepopulateOnAccess = true;
            throw e;
        }
    }

    public boolean isPreventReportPlanning(MFWRequestContextUser aContext) {
        Element connectionDom = aContext.getConnectionSpec();
        if (connectionDom == null) {
            return false;
        }
        Iterator itr = connectionDom.elementIterator();
        while (itr.hasNext()) {
            Element elem = (Element)itr.next();
            if (!elem.getName().equals("preventReportPlanning")) continue;
            String value = elem.attributeValue("value");
            return "true".equals(value);
        }
        return false;
    }
}

