/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfwa4j.adaptorReport;

import com.cognos.mfw4j.framework.MFWConnectionReuseInfo;
import com.cognos.mfw4j.framework.MFWMetadataSource;
import com.cognos.mfw4j.framework.MFWRequestContextUser;
import com.cognos.mfw4j.utilities.MFWConfiguration;
import com.cognos.mfw4j.utilities.MFWContentHelper;
import com.cognos.mfw4j.utilities.MFWException;
import com.cognos.mfw4j.utilities.MFWStringHelper;
import java.util.Calendar;
import java.util.List;

class MFWRptConnectionReuseInfo
extends MFWConnectionReuseInfo {
    private String mCMSearchPath;
    private Calendar mModelLastModifedTime = null;
    private String mModelStoreID = null;
    private String m_originatingPassport = null;

    MFWRptConnectionReuseInfo(MFWRequestContextUser aContext, MFWMetadataSource aMetadataSrc) {
        super(aMetadataSrc);
        this.mCMSearchPath = (String)aMetadataSrc.getConnectionItem("cmSearchPath");
        MFWException.ASSERT((this.mCMSearchPath != null && this.mCMSearchPath.length() > 0 ? 1 : 0) != 0, (String)"Expecting a valid cmSearchPath connection item for a CRN report");
        MFWContentHelper hlprRCI = MFWContentHelper.create((String)aContext.getUserPassport(), (String)aContext.getProductLocale(), (String)aContext.getContentLocale(), null);
        List cmProps = hlprRCI.getObjectProperties(this.mCMSearchPath, new String[]{"modificationTime", "storeID"}, aContext.getForceCMTrusted());
        MFWException.ASSERT((cmProps.size() == 2 ? 1 : 0) != 0, (String)"Expecting two values back after querying report properties");
        this.mModelLastModifedTime = (Calendar)cmProps.get(0);
        this.mModelStoreID = (String)cmProps.get(1);
        this.m_originatingPassport = aContext.getUserPassport();
    }

    public void destroy() {
        super.destroy();
    }

    protected boolean isReusableFor(MFWConnectionReuseInfo thatReuseInfo) {
        MFWRptConnectionReuseInfo reuseInfo = (MFWRptConnectionReuseInfo)thatReuseInfo;
        return this.mCMSearchPath.equals(thatReuseInfo.getMetadataSource().getConnectionItem("cmSearchPath")) && this.m_originatingPassport.equals(reuseInfo.m_originatingPassport);
    }

    public StringBuffer getPersistentPath() {
        StringBuffer path = new StringBuffer(MFWConfiguration.getInstance().getPMCDirectoryPath());
        String fileName = null;
        fileName = this.mModelStoreID != null ? this.mModelStoreID : MFWStringHelper.cleanupFileName((String)this.mCMSearchPath);
        path.append("/");
        path.append(fileName);
        return path;
    }

    protected boolean isCacheUpToDate(MFWRequestContextUser aContext, MFWConnectionReuseInfo thatReuseInfo) {
        MFWRptConnectionReuseInfo thatRptReuseInfo = (MFWRptConnectionReuseInfo)thatReuseInfo;
        return this.mModelLastModifedTime.equals(thatRptReuseInfo.mModelLastModifedTime);
    }
}

