/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfwa4j.adaptorReport;

import com.cognos.mfw4j.framework.MFWCluster;
import com.cognos.mfw4j.framework.MFWCrnIDGenerator;
import com.cognos.mfw4j.framework.MFWMetadataSource;
import com.cognos.mfw4j.framework.MFWModelRes;
import com.cognos.mfw4j.framework.MFWNode;
import com.cognos.mfw4j.framework.MFWNodeObject;
import com.cognos.mfw4j.framework.MFWQuerySpec;
import com.cognos.mfw4j.framework.MFWRequestContextUser;
import com.cognos.mfw4j.framework.MFWXPathEvaluator;
import com.cognos.mfw4j.utilities.MFWStringHelper;
import com.cognos.mfwa4j.adaptorReport.MFWDBConversions;
import com.cognos.mfwa4j.adaptorReport.MFWRptAdaptor;
import com.cognos.mfwa4j.adaptorReport.MFWV5QRDReportSpecPreProcessor;
import com.cognos.mfwa4j.adaptorReport.MFWV5QueryHelper;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.bibushandler.ResponseAdapter;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.QueryEngine;
import com.cognos.xqe.query.engine.UnresolvedParameterException;
import com.cognos.xqe.util.pool.XQESAXReaderPool;
import com.cognos.xqebifw.bibushandler.SimpleResponseAdapter;
import com.cognos.xqebifw.bibushandler.ValidateRequestAdapter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class MFWV5DBModelLoader {
    private MFWCluster m_cluster;
    private MFWRequestContextUser m_pContext;
    private MFWNodeObject m_rootNamespaceNode;
    private MFWNodeObject m_projectNode;
    private MFWCrnIDGenerator m_pIDGenerator;
    private Locale m_pReportExprLocale;
    private MFWMetadataSource m_srcMetadata;
    private MFWNodeObject m_rootObjectNode;
    private MFWModelRes m_gModelRes;
    private ArrayList<MFWNodeObject> m_dataSources = new ArrayList();
    private String m_modelPathValue;

    MFWV5DBModelLoader(MFWCluster cluster, MFWNodeObject rootObjectNode, MFWMetadataSource aMetadataSrc, MFWRequestContextUser pContext) {
        this.m_cluster = cluster;
        this.m_pContext = pContext;
        this.m_pIDGenerator = new MFWCrnIDGenerator(this.m_cluster);
        this.m_srcMetadata = aMetadataSrc;
        this.m_rootObjectNode = rootObjectNode;
        this.m_rootNamespaceNode = null;
        this.m_projectNode = null;
        this.m_pReportExprLocale = null;
        this.m_gModelRes = MFWModelRes.getInstance();
    }

    void initializeModel(String v5Spec) {
        try {
            StringReader myReader = new StringReader(v5Spec);
            SAXReader myParser = new SAXReader();
            Document document = myParser.read((Reader)myReader);
            Element reportRoot = document.getRootElement();
            MFWV5QRDReportSpecPreProcessor processor = new MFWV5QRDReportSpecPreProcessor();
            processor.preProcessReportSpec(reportRoot);
            Node querySet = reportRoot.selectSingleNode("//*[name()='querySet']");
            this.initModel((Element)querySet);
            this.setupLinkedSources(reportRoot);
        }
        catch (DocumentException de) {
            throw new RuntimeException(de);
        }
    }

    private MFWNodeObject addLocalizedProperty(MFWNodeObject parentObj, short ridPropName, String value, String locale) {
        MFWNodeObject pLocProp = parentObj.addExpandableObjectNode(ridPropName);
        pLocProp.addProperty(this.m_gModelRes.RID_locale, locale);
        pLocProp.addProperty(this.m_gModelRes.RID__Value, value);
        return pLocProp;
    }

    void planAndBuildQueries(String v5Spec) {
        try {
            StringReader myReader = new StringReader(v5Spec);
            SAXReader myParser = new SAXReader();
            Document document = myParser.read((Reader)myReader);
            Element reportRoot = document.getRootElement();
            MFWV5QRDReportSpecPreProcessor processor = new MFWV5QRDReportSpecPreProcessor();
            processor.preProcessReportSpec(reportRoot);
            Node querySet = reportRoot.selectSingleNode("//*[name()='querySet']");
            String locale = ((Element)querySet).attributeValue("expressionLocale");
            if (locale.isEmpty()) {
                MFWRptAdaptor.ThrowException("RPT_FAC_EXPRESSION_LOCALE_NOT_FOUND");
            }
            this.m_pReportExprLocale = new Locale(locale);
            this.m_projectNode = this.m_rootObjectNode.getObjectNode(this.m_gModelRes.RID_project);
            if (this.m_projectNode == null) {
                MFWRptAdaptor.ThrowException("RPT_FAC_INTERNAL_EXCEPTION");
            }
            this.m_rootNamespaceNode = this.m_projectNode.getObjectNode(this.m_gModelRes.RID_namespace);
            if (this.m_rootNamespaceNode == null) {
                String rootNamespaceName = (String)this.m_srcMetadata.getConnectionItem("ReportName");
                if (rootNamespaceName == null || "".equals(rootNamespaceName)) {
                    rootNamespaceName = "Report";
                }
                this.m_rootNamespaceNode = this.m_projectNode.addExpandableObjectNode(this.m_gModelRes.RID_namespace);
                String sUsedName = this.m_pIDGenerator.generate(this.m_rootNamespaceNode, rootNamespaceName, false);
                this.addLocalizedProperty(this.m_rootNamespaceNode, this.m_gModelRes.RID_name, sUsedName, this.m_pReportExprLocale.toString());
            }
            this.buildQueriesFromQRD(reportRoot);
        }
        catch (DocumentException de) {
            throw new RuntimeException(de);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void buildQueriesFromQRD(Element reportRoot) {
        Element responseElement;
        block17: {
            Document validateDocument = DocumentHelper.createDocument();
            Element validateCommand = this.buildV5Request(validateDocument, reportRoot);
            responseElement = null;
            Document responseDocument = DocumentHelper.createDocument();
            responseDocument.addElement("response");
            try {
                ExecutionEnvironment exeEnv = null;
                exeEnv = (ExecutionEnvironment)this.m_pContext.getXQEExecutionEnvironment();
                if (exeEnv != null && exeEnv.getRequestEnvironment() != null) {
                    RequestEnvironment reqEnv = ((RequestEnvironment)exeEnv.getRequestEnvironment()).duplicate();
                    reqEnv.setModelPath(this.m_modelPathValue);
                    reqEnv.resetRequestPAC();
                    BIBusEnvelope requestEnvelope = reqEnv.getRequestEnvelope();
                    requestEnvelope.getBody().add(validateCommand);
                    ValidateRequestAdapter validateRequestAdapter = new ValidateRequestAdapter();
                    validateRequestAdapter.setEngine(QueryEngine.getInstance());
                    ResponseAdapter responseAdapter = validateRequestAdapter.executeRequest(reqEnv, false);
                    SimpleResponseAdapter response = (SimpleResponseAdapter)responseAdapter;
                    Iterator attachmentIter = response.getAttachmentIterator();
                    if (!attachmentIter.hasNext()) break block17;
                    InputStream inStream = (InputStream)attachmentIter.next();
                    SAXReader xmlReader = null;
                    try {
                        xmlReader = XQESAXReaderPool.getInstance().borrowReader();
                        Document document = xmlReader.read(inStream);
                        responseElement = document.getRootElement();
                        break block17;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        break block17;
                    }
                    finally {
                        if (xmlReader != null) {
                            try {
                                XQESAXReaderPool.getInstance().returnReader(xmlReader);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
                MFWRptAdaptor.ThrowException("RPT_FAC_INTERNAL_EXCEPTION");
            }
            catch (UnresolvedParameterException upe) {
                throw upe;
            }
            catch (RuntimeException rt) {
                throw rt;
            }
            catch (IOException e) {
                System.err.println("Exception:" + e.getLocalizedMessage());
                e.printStackTrace();
            }
        }
        this.checkForMDX(responseElement);
        this.buildMFWModel(responseElement, reportRoot);
    }

    void setupLinkedSources(Element reportRoot) {
        String modelXPath = "//*[name()='modelPath']";
        Element modelPath = (Element)reportRoot.selectSingleNode(modelXPath);
        String searchPath = modelPath.getText();
        MFWMetadataSource aLinkedSrc = MFWMetadataSource.create((String)"modelFM");
        aLinkedSrc.addConnectionItem("cmSearchPath", (Object)searchPath);
        short idLinkSrc = this.m_rootNamespaceNode.getCluster().getLinkManager().findOrAddLink(aLinkedSrc, this.m_rootNamespaceNode);
        this.m_rootNamespaceNode.addLinkNode(this.m_gModelRes.RID_namespace, idLinkSrc, "/project/namespace[0]");
    }

    void checkForMDX(Element response) {
        List properties = response.selectNodes("//*[name()='property']");
        for (Node aProperty : properties) {
            String value;
            String nameValue = ((Element)aProperty).attributeValue("name");
            if (!nameValue.equals("nativeCommandType") || !(value = aProperty.getText()).equals("MDX")) continue;
            MFWRptAdaptor.ThrowException("RPT_MDL_NONRELATIONAL_SOURCE");
        }
    }

    Element buildV5Request(Document validateDoc, Element reportSpecRoot) {
        Element validate = validateDoc.addElement("validate");
        Node querySet = reportSpecRoot.selectSingleNode("//*[name()='querySet']");
        Node clonedQuerySet = (Node)querySet.clone();
        clonedQuerySet.detach();
        validate.add(clonedQuerySet);
        Node modelPathNode = clonedQuerySet.selectSingleNode("modelPath");
        this.m_modelPathValue = modelPathNode.getText();
        Element queryFeedback = validate.addElement("queryFeedback");
        Element columnListProperty = queryFeedback.addElement("property");
        columnListProperty.addAttribute("name", "columnList");
        Element cognosCommandTextProperty = queryFeedback.addElement("property");
        cognosCommandTextProperty.addAttribute("name", "CognosCommandText");
        Element nativeCommandTextProperty = queryFeedback.addElement("property");
        nativeCommandTextProperty.addAttribute("name", "nativeCommandText");
        Element nativeCommandTypeProperty = queryFeedback.addElement("property");
        nativeCommandTypeProperty.addAttribute("name", "nativeCommandType");
        Element connectionsProperty = queryFeedback.addElement("property");
        connectionsProperty.addAttribute("name", "connections");
        Element promptDom = this.m_pContext.getPromptResolution();
        if (promptDom != null) {
            Node clonedPrompt = (Node)promptDom.clone();
            clonedPrompt.detach();
            validate.add(clonedPrompt);
        }
        return validate;
    }

    private void initModel(Element querySet) {
        if (this.m_pReportExprLocale == null) {
            String locale = querySet.attributeValue("expressionLocale");
            if (locale.isEmpty()) {
                MFWRptAdaptor.ThrowException("RPT_FAC_EXPRESSION_LOCALE_NOT_FOUND");
            }
            this.m_pReportExprLocale = new Locale(locale);
            String rootNamespaceName = (String)this.m_srcMetadata.getConnectionItem("ReportName");
            if (rootNamespaceName == null || "".equals(rootNamespaceName)) {
                rootNamespaceName = "Report";
            }
            this.m_projectNode = this.m_rootObjectNode.getObjectNode(this.m_gModelRes.RID_project);
            if (this.m_projectNode == null) {
                MFWRptAdaptor.ThrowException("RPT_FAC_INTERNAL_EXCEPTION");
            }
            this.m_projectNode.addProperty(this.m_gModelRes.RID_name, rootNamespaceName);
            this.m_projectNode.addProperty(this.m_gModelRes.RID_locale, locale);
            this.m_projectNode.addProperty(this.m_gModelRes.RID_defaultLocale, locale);
            this.m_rootNamespaceNode = this.m_projectNode.addExpandableObjectNode(this.m_gModelRes.RID_namespace);
            String sUsedName = this.m_pIDGenerator.generate(this.m_rootNamespaceNode, rootNamespaceName, false);
            this.addLocalizedProperty(this.m_rootNamespaceNode, this.m_gModelRes.RID_name, sUsedName, this.m_pReportExprLocale.toString());
            Element modelPath = querySet.element("modelPath");
            if (modelPath == null) {
                MFWRptAdaptor.ThrowException("RPT_FAC_INTERNAL_EXCEPTION");
            }
            this.m_modelPathValue = modelPath.getText();
            MFWNodeObject pCustomProp = this.m_rootNamespaceNode.addExpandableObjectNode(this.m_gModelRes.RID_property);
            pCustomProp.addProperty(this.m_gModelRes.RID_name, "package");
            pCustomProp.addProperty(this.m_gModelRes.RID__Value, this.m_modelPathValue);
            MFWNodeObject pParamMaps = this.m_projectNode.getObjectNode(this.m_gModelRes.RID_parameterMaps);
            if (pParamMaps == null) {
                this.m_projectNode.addExpandableObjectNode(this.m_gModelRes.RID_parameterMaps);
            }
        }
    }

    void buildMFWModel(Element response, Element reportSpec) {
        List propertyNodes = response.selectNodes("//*[name()='property']");
        for (int i = 0; i < propertyNodes.size(); ++i) {
            Element elem = (Element)propertyNodes.get(i);
            String name = elem.attributeValue("name");
            if (!name.equals("CognosCommandText")) continue;
            this.buildDBQuerySubject(elem, response);
        }
    }

    private String generateUniqueDataSourceName(ArrayList<MFWNodeObject> dataSources, String name) {
        boolean isDuplicate = true;
        Integer seqNo = 0;
        String candName = name;
        while (isDuplicate) {
            String dataSourceID = "[].[dataSources].[";
            dataSourceID = dataSourceID + candName;
            dataSourceID = dataSourceID + "]";
            boolean foundMatch = false;
            for (int i = 0; i < dataSources.size(); ++i) {
                String nodeID = dataSources.get(i).getPropertyValue(this.m_gModelRes.RID_ID);
                if (!nodeID.equals(dataSourceID)) continue;
                foundMatch = true;
                break;
            }
            if (!(isDuplicate = foundMatch)) continue;
            candName = name + seqNo.toString();
            Integer n = seqNo;
            Integer n2 = seqNo = Integer.valueOf(seqNo + 1);
        }
        return candName;
    }

    MFWNodeObject addDataSourceIfNecessary(String cmDataSourceName, String schema, String catalog) {
        int i;
        List fmCluster = this.m_rootNamespaceNode.getCluster().getAllLinkedClusters();
        ArrayList<MFWNodeObject> dataSourcesToCheck = new ArrayList<MFWNodeObject>();
        for (i = 0; i < this.m_dataSources.size(); ++i) {
            dataSourcesToCheck.add(this.m_dataSources.get(i));
        }
        for (i = 0; i < fmCluster.size(); ++i) {
            MFWQuerySpec aQuerySpec = MFWQuerySpec.create((String)"/project/dataSource");
            ArrayList dataSources = new ArrayList();
            MFWXPathEvaluator evaluator = new MFWXPathEvaluator(this.m_pContext);
            evaluator.evaluate(((MFWCluster)fmCluster.get(i)).getRootNode(), aQuerySpec, dataSources);
            for (int dIdx = 0; dIdx < dataSources.size(); ++dIdx) {
                dataSourcesToCheck.add((MFWNodeObject)dataSources.get(dIdx));
            }
        }
        MFWNodeObject dataSourceNode = null;
        for (int i2 = 0; i2 < dataSourcesToCheck.size(); ++i2) {
            String cmDataSource = ((MFWNodeObject)dataSourcesToCheck.get(i2)).getPropertyValue(this.m_gModelRes.RID_cmDataSource);
            String schemaValue = ((MFWNodeObject)dataSourcesToCheck.get(i2)).getPropertyValue(this.m_gModelRes.RID_schema);
            String catalogValue = dataSourcesToCheck.get(i2).getPropertyValue(this.m_gModelRes.RID_catalog);
            if (!cmDataSource.equals(cmDataSourceName)) continue;
            if (schemaValue == null) {
                schemaValue = "";
            }
            if (catalogValue == null) {
                catalogValue = "";
            }
            if (!catalogValue.equals(catalog) || !schemaValue.equals(schema)) continue;
            dataSourceNode = dataSourcesToCheck.get(i2);
            break;
        }
        if (dataSourceNode == null) {
            dataSourceNode = this.m_projectNode.addExpandableObjectNode(this.m_gModelRes.RID_dataSource);
            this.m_dataSources.add(dataSourceNode);
            String uniqueDSName = this.generateUniqueDataSourceName(dataSourcesToCheck, cmDataSourceName);
            this.genObjectPropertiesSimpleName(dataSourceNode, uniqueDSName);
            dataSourceNode.addProperty(this.m_gModelRes.RID_cmDataSource, cmDataSourceName);
            dataSourceNode.addProperty(this.m_gModelRes.RID_schema, schema);
            dataSourceNode.addProperty(this.m_gModelRes.RID_catalog, catalog);
            dataSourceNode.addProperty(this.m_gModelRes.RID_queryProcessing, "limitedLocal");
        }
        return dataSourceNode;
    }

    void buildDBQuerySubject(Element sqlProperty, Element response) {
        String qrdName;
        String queryName = qrdName = sqlProperty.attributeValue("queryName");
        MFWNodeObject dbQuerySubject = this.m_rootNamespaceNode.addExpandableObjectNode(this.m_gModelRes.RID_querySubject);
        this.genObjectProperties(dbQuerySubject, queryName);
        dbQuerySubject.addProperty(this.m_gModelRes.RID_definitionType, "dbQuery");
        dbQuerySubject.addProperty(this.m_gModelRes.RID_autoSummary, "false");
        String header = "<sql type=\"cognos\">";
        String sqlText = sqlProperty.getText();
        String sqlOut = MFWStringHelper.escapeXMLChars((String)sqlText);
        String ender = "</sql>";
        String sqlValue = header;
        sqlValue = sqlValue + sqlOut;
        sqlValue = sqlValue + ender;
        dbQuerySubject.addProperty(this.m_gModelRes.RID_sql, sqlValue);
        List properties = response.selectNodes("//*[name()='property']");
        boolean foundDataSource = false;
        boolean dropDB = false;
        for (int i = 0; i < properties.size(); ++i) {
            String queryNameOfConn;
            Element elem = (Element)properties.get(i);
            String name = elem.attributeValue("name");
            if (!name.equals("connections") || !(queryNameOfConn = elem.attributeValue("queryName")).equals(qrdName)) continue;
            List individualConnections = elem.selectNodes("//*[name()='connection']");
            for (int connIdx = 0; connIdx < individualConnections.size(); ++connIdx) {
                foundDataSource = true;
                Element connection = (Element)individualConnections.get(connIdx);
                String catalog = connection.attributeValue("catalog");
                String schema = connection.attributeValue("schema");
                String value = connection.attributeValue("value");
                MFWNodeObject dataSourceNode = this.addDataSourceIfNecessary(value, schema, catalog);
                if (dataSourceNode == null) {
                    MFWRptAdaptor.ThrowException("RPT_FAC_INTERNAL_EXCEPTION");
                }
                String idNode = dataSourceNode.getPropertyValue(this.m_gModelRes.RID_ID);
                dbQuerySubject.addProperty(this.m_gModelRes.RID_dataSourceRef, idNode);
            }
            if (individualConnections.size() != 0) continue;
            dropDB = true;
        }
        if (dropDB) {
            this.m_rootNamespaceNode.removeChildNode((MFWNode)dbQuerySubject);
        } else {
            if (!foundDataSource) {
                MFWRptAdaptor.ThrowException("RPT_FAC_INTERNAL_EXCEPTION");
            }
            this.buildQueryItemsForDBQuery(dbQuerySubject, response, qrdName);
        }
    }

    void buildQueryItemsForDBQuery(MFWNodeObject dbQuerySubject, Element response, String qrdQueryName) {
        List properties = response.selectNodes("//*[name()='property']");
        for (int i = 0; i < properties.size(); ++i) {
            String queryName;
            Element property = (Element)properties.get(i);
            String name = property.attributeValue("name");
            if (!name.equals("columnList") || !(queryName = property.attributeValue("queryName")).equals(qrdQueryName)) continue;
            List items = property.selectNodes(".//*[name()='item']");
            for (int itemIdx = 0; itemIdx < items.size(); ++itemIdx) {
                Element item = (Element)items.get(itemIdx);
                String sqlColumnIndex = item.attributeValue("sqlColumnIndex");
                if (sqlColumnIndex.equals("-1")) continue;
                this.createQueryItem(item, dbQuerySubject);
            }
            break;
        }
    }

    void createQueryItem(Element columnInfo, MFWNodeObject dbQuerySubject) {
        String name = columnInfo.attributeValue("name");
        String externalName = columnInfo.attributeValue("sqlColumnName");
        String precisionStr = columnInfo.attributeValue("precision");
        String scaleStr = columnInfo.attributeValue("scale");
        String type = columnInfo.attributeValue("sqlColumnModelType");
        if ("blob".equals(type) || "textBlob".equals(type)) {
            MFWRptAdaptor.ThrowException("RPT_DBL_SQL_TEXT_OR_BLOB_NOT_SUPPORTED");
        }
        MFWNodeObject queryItem = dbQuerySubject.addExpandableObjectNode(this.m_gModelRes.RID_queryItem);
        this.genObjectProperties(queryItem, name);
        queryItem.addProperty(this.m_gModelRes.RID_externalName, externalName);
        queryItem.addProperty(this.m_gModelRes.RID_datatype, type);
        queryItem.addProperty(this.m_gModelRes.RID_scale, scaleStr);
        queryItem.addProperty(this.m_gModelRes.RID_precision, precisionStr);
        short opType = MFWDBConversions.translateOperandType(type);
        String usage = MFWV5QueryHelper.calculateBasicUsage(opType);
        queryItem.addProperty(this.m_gModelRes.RID_usage, usage);
    }

    void genObjectProperties(MFWNodeObject objNode, String sSuggestedName) {
        String sActualName = this.m_pIDGenerator.generate(objNode, sSuggestedName, false);
        if (!sSuggestedName.isEmpty()) {
            this.addLocalizedProperty(objNode, this.m_gModelRes.RID_name, sActualName, this.m_pReportExprLocale.toString());
        }
    }

    void genObjectPropertiesSimpleName(MFWNodeObject objNode, String sSuggestedName) {
        String sActualName = this.m_pIDGenerator.generate(objNode, sSuggestedName, false);
        objNode.addProperty(this.m_gModelRes.RID_name, sActualName);
    }
}

