/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfwa4j.adaptorReport;

import com.cognos.mfw4j.framework.MFWIndexManager;
import com.cognos.mfw4j.framework.MFWInfoProperty;
import com.cognos.mfw4j.framework.MFWModel;
import com.cognos.mfw4j.framework.MFWModelRes;
import com.cognos.mfw4j.framework.MFWNodeObject;
import com.cognos.mfw4j.utilities.MFWCrnIDHelper;
import com.cognos.mfw4j.utilities.MFWException;
import com.cognos.xqe.ast.v5Exp.uniqueName.IV5ExpressionUniqueName;
import com.cognos.xqe.ast.v5Exp.uniqueName.IV5ExpressionUniqueNameListing;
import com.cognos.xqe.ast.v5Exp.uniqueName.IV5ExpressionUniqueNameUpdater;
import com.cognos.xqe.ast.v5Exp.uniqueName.IV5UniqueName;
import com.cognos.xqe.ast.v5Exp.uniqueName.IV5UniqueNamePiece;
import com.cognos.xqe.ast.v5Exp.uniqueName.adapters.V5UniqueNamePartNameValue;
import com.cognos.xqe.ast.v5Exp.uniqueName.adapters.V5UniqueNamePieceNamePartList;
import com.cognos.xqe.ast.v5Exp.uniqueName.parser.V5ExpressionUniqueNameListingParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class MFWV5ExpressionParser {
    private String m_sReportNamespaceID;
    private MFWNodeObject m_exprParent;
    private ArrayList<String> m_exprRefs;
    private MFWIndexManager m_indexManager;
    private HashMap<String, String> m_mappedIds = new HashMap();

    public static String parse(String v5Expression, MFWNodeObject exprParent, String sReportNamespaceID, ArrayList<String> exprRefs, MFWIndexManager manager) {
        MFWV5ExpressionParser expr = new MFWV5ExpressionParser(exprParent, sReportNamespaceID, exprRefs, manager);
        String fixedExpression = expr.parseImpl(v5Expression);
        return fixedExpression;
    }

    private MFWV5ExpressionParser(MFWNodeObject exprParent, String reportNamespaceID, ArrayList<String> exprRefs, MFWIndexManager manager) {
        this.m_indexManager = manager;
        this.m_exprParent = exprParent;
        this.m_exprRefs = exprRefs;
        this.m_sReportNamespaceID = reportNamespaceID;
    }

    private String parseImpl(String v5Expression) {
        V5ExpressionUniqueNameListingParser parser = new V5ExpressionUniqueNameListingParser();
        IV5ExpressionUniqueNameListing listing = parser.parse(v5Expression);
        IV5ExpressionUniqueNameUpdater updater = new IV5ExpressionUniqueNameUpdater(){

            public IV5UniqueName update(IV5ExpressionUniqueName expressionUniqueName) {
                V5UniqueNamePieceNamePartList updated = null;
                IV5UniqueNamePiece metadataPiece = expressionUniqueName.metadataPiece();
                List metadataParts = metadataPiece.nameParts();
                if (metadataParts.size() == 2) {
                    V5UniqueNamePartNameValue nsAddIdPart = new V5UniqueNamePartNameValue(MFWV5ExpressionParser.this.m_sReportNamespaceID);
                    metadataParts.add(0, nsAddIdPart);
                    updated = new V5UniqueNamePieceNamePartList(metadataParts);
                } else if (metadataParts.size() == 1) {
                    MFWNodeObject pParent;
                    for (pParent = MFWV5ExpressionParser.this.m_exprParent; pParent != null && pParent.getNameRID() != MFWModelRes.getInstance().RID_querySubject; pParent = pParent.getParentObject()) {
                    }
                    if (pParent != null) {
                        String anID = pParent.getPropertyValue(MFWModelRes.getInstance().RID_ID);
                        MFWException.ASSERT((anID != null ? 1 : 0) != 0, (String)"MFWV5ExpressionVisitor::VisitOpObjectID -ID property is required");
                        ArrayList entries = new ArrayList();
                        MFWCrnIDHelper.parseID((String)anID, entries);
                        for (int i = entries.size() - 1; i >= 0; --i) {
                            V5UniqueNamePartNameValue nsAddIdPart = new V5UniqueNamePartNameValue(((String)entries.get(i)).toString());
                            metadataParts.add(0, nsAddIdPart);
                        }
                        updated = new V5UniqueNamePieceNamePartList(metadataParts);
                    }
                }
                String mappedId = null;
                if (updated != null) {
                    mappedId = updated.metadataPiece().referenceValue();
                }
                MFWInfoProperty pIDPropInfo = (MFWInfoProperty)MFWModel.getInstance().findInfoByRID(MFWModelRes.getInstance().RID_ID);
                if (mappedId != null && !"".equals(mappedId) && MFWV5ExpressionParser.this.m_indexManager.lookup(pIDPropInfo, mappedId) != null) {
                    if (MFWV5ExpressionParser.this.m_exprRefs != null) {
                        MFWV5ExpressionParser.this.m_exprRefs.add(mappedId);
                    }
                    MFWV5ExpressionParser.this.m_mappedIds.put(expressionUniqueName.metadataPiece().referenceValue(), mappedId);
                } else if (MFWV5ExpressionParser.this.m_exprRefs != null) {
                    MFWV5ExpressionParser.this.m_exprRefs.add(expressionUniqueName.metadataPiece().referenceValue());
                }
                return updated;
            }
        };
        IV5ExpressionUniqueNameListing updatedListing = listing.updateUniqueNames(updater);
        String updatedExpressionValue = updatedListing.expression();
        return updatedExpressionValue;
    }
}

