/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfwa4j.toolBox;

import com.cognos.mfw4j.framework.MFWRequestContext;
import com.cognos.mfw4j.resourcePool.MFWUserPool;
import com.cognos.xqe.bibushandler.IRequestEnvironment;
import com.cognos.xqe.bibushandler.content.ContentManager;
import com.cognos.xqe.bibushandler.content.ICMSessionIdentity;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqebifw.bibushandler.content.CMEntityPool;
import com.cognos.xqebifw.bibushandler.content.CMSession;
import java.util.ArrayList;
import java.util.List;

public final class MFWSharedContentHelper {
    private MFWSharedContentHelper() {
    }

    public static List<String> getUserIdentity(MFWRequestContext aContext) {
        ArrayList<String> outResult = null;
        if (aContext.getXQEExecutionEnvironment() == null) {
            outResult = MFWUserPool.getInstance().getUserIdentity(aContext);
        } else {
            IRequestEnvironment rEnv = ((ExecutionEnvironment)aContext.getXQEExecutionEnvironment()).getRequestEnvironment();
            List usrIdentities = ContentManager.getIdentitiesList((IRequestEnvironment)rEnv);
            outResult = new ArrayList<String>(usrIdentities.size());
            for (ICMSessionIdentity usrIdentity : usrIdentities) {
                outResult.add(usrIdentity.getIdentity());
            }
        }
        return outResult;
    }

    public static byte[] getDigestedUserIdentity(MFWRequestContext aContext) {
        byte[] outResult = null;
        if (aContext.getXQEExecutionEnvironment() == null) {
            outResult = MFWUserPool.getInstance().getDigestedUserIdentity(aContext);
        } else {
            IRequestEnvironment rEnv = ((ExecutionEnvironment)aContext.getXQEExecutionEnvironment()).getRequestEnvironment();
            CMSession usrSession = CMEntityPool.instance().get(aContext.getUserPassport()).getSession(rEnv);
            List usrIdentities = usrSession.getIdentitiesList();
            try {
                StringBuilder myDigest = new StringBuilder();
                for (ICMSessionIdentity usrIdentity : usrIdentities) {
                    myDigest.append(usrIdentity.getIdentity());
                }
                outResult = myDigest.toString().getBytes();
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return outResult;
    }

    public static List<String> getViews(MFWRequestContext aContext, String packagePath) {
        ArrayList userViews = null;
        if (aContext.getXQEExecutionEnvironment() == null) {
            userViews = MFWUserPool.getInstance().getPackageViews(aContext, packagePath);
        } else {
            IRequestEnvironment rEnv = ((ExecutionEnvironment)aContext.getXQEExecutionEnvironment()).getRequestEnvironment();
            userViews = new ArrayList();
            userViews.addAll(ContentManager.getModelViews((IRequestEnvironment)rEnv, (String)packagePath));
        }
        return userViews;
    }

    public static List<String> getModelViewSearchPaths(MFWRequestContext aContext, String viewName) {
        List<String> rolesFromView = null;
        if (aContext.getXQEExecutionEnvironment() == null) {
            rolesFromView = new ArrayList<String>();
        } else {
            IRequestEnvironment rEnv = ((ExecutionEnvironment)aContext.getXQEExecutionEnvironment()).getRequestEnvironment();
            rolesFromView = ContentManager.getModelViewSearchPaths((IRequestEnvironment)rEnv, (String)viewName);
        }
        return rolesFromView;
    }
}

