/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfwa4j.v5Bridge;

import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.mfw4j.framework.MFWRequestContext;
import com.cognos.mfw4j.framework.log.MFWLogMDSRVBridge;
import com.cognos.mfw4j.resourcePool.MFWDSConnectionSpec;
import com.cognos.mfw4j.resourcePool.MFWDSSelectionCriteria;
import com.cognos.mfw4j.utilities.MFWContentHelper;
import com.cognos.mfw4j.utilities.MFWException;
import com.cognos.mfwa4j.v5Bridge.MFWModelCloseException;
import com.cognos.mfwa4j.v5Bridge.MFWV5Bridge;
import com.cognos.pogo.impl.MessageContextImpl;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.Cleanable;
import com.cognos.pogo.pdk.Fault;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.SOAPEnvelope;
import com.cognos.pogo.reportservice.RequestInvoker;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.mail.internet.InternetHeaders;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.io.SAXReader;

public final class MDSRVBridge
extends MFWV5Bridge {
    private static final String MDSERVICE = " seq=\"1\" xmlns:xtsext=\"xalan://com.cognos.xts.ext.XTSExt\" xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:md1=\"http://developer.cognos.com/schemas/metadataService/1\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xts=\"http://developer.cognos.com/schemas/xts/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\">";
    private static final String OPEN_MDPROVIDER = "<mdprovider model=\"";
    private static final String CLOSE_MDPROVIDER = "</mdprovider>";
    private static final String ACTION_EXECUTE = "\" type=\"action\" action=\"execute\"";
    private static final String GENERIC_CREATE_MODEL = "\" type=\"generic\" action=\"createModel\"";
    private static final String GENERIC_CLOSE_MODEL = "\" type=\"generic\" action=\"closeModel\"";
    private static final String OPEN_QFW_TRANSACTION = "<transaction saved=\"false\" seq=\"1\"><action seq=\"1\" type=\"DoQueryServicesRequest4MFWA4J\"><inputparams><param seq=\"1\" type=\"cclnode\"><value><![CDATA[";
    private static final String CLOSE_QFW_TRANSACTION = "]]></value></param></inputparams><domchanges/><result success=\"t\"><outputparams><param seq=\"1\" type=\"cclnode\"><value><output/></value></param></outputparams></result></action></transaction>";
    private static final String OPEN_QE_TRANSACTION = "<transaction saved=\"false\" seq=\"1\"><action seq=\"1\" type=\"GetConnectionInfoFromCM\"><inputparams>";
    private static final String OPEN_PARAM_QE_TRANSACTION = "<param seq=\"";
    private static final String PARAM_QE_TRANSACTION = "\" type=\"i18nstring\"><value>";
    private static final String CLOSE_PARAM_QE_TRANSACTION = "</value></param>";
    private static final String CLOSE_QE_TRANSACTION = "</inputparams><domchanges/><result success=\"t\"><outputparams><param seq=\"1\" type=\"cclnode\"><value><output/></value></param></outputparams></result></action></transaction>";
    private String m_modelName = null;
    private boolean m_bModelOpen = false;
    private MFWContentHelper m_ContentHelper = null;
    private MFWRequestContext m_context;
    private Element m_conversationContext;

    MDSRVBridge(MFWRequestContext context) {
        if (MFWContentHelper.isImposterAround()) {
            this.m_ContentHelper = MFWContentHelper.create((String)context.getUserPassport(), (String)context.getContentLocale(), (String)context.getProductLocale(), null);
        }
        this.m_context = context;
        this.initialize();
    }

    @Override
    public Element doV5Request(String requestID, String v5Request) {
        StringBuffer commandStr = new StringBuffer(OPEN_MDPROVIDER);
        commandStr.append(this.m_modelName);
        commandStr.append(ACTION_EXECUTE);
        commandStr.append(MDSERVICE);
        commandStr.append(OPEN_QFW_TRANSACTION);
        commandStr.append(v5Request);
        commandStr.append(CLOSE_QFW_TRANSACTION);
        commandStr.append(CLOSE_MDPROVIDER);
        try {
            String res = this.invokeRequest(requestID, commandStr.toString(), true);
            SAXReader reader = new SAXReader();
            Document resultsDoc = reader.read((Reader)new StringReader(res));
            return resultsDoc.getRootElement();
        }
        catch (DocumentException de) {
            throw new RuntimeException(de.getMessage(), de);
        }
        catch (MFWModelCloseException mc) {
            this.m_bModelOpen = false;
            this.m_conversationContext = null;
            return this.doV5Request(requestID, v5Request);
        }
    }

    @Override
    public MFWDSConnectionSpec getDataSourceConnection(MFWDSSelectionCriteria datasourceSpec) {
        StringBuffer commandStr = new StringBuffer(OPEN_MDPROVIDER);
        commandStr.append(this.m_modelName);
        commandStr.append(ACTION_EXECUTE);
        commandStr.append(MDSERVICE);
        commandStr.append(OPEN_QE_TRANSACTION);
        int seqNum = 0;
        commandStr.append(this.appendParam(++seqNum, datasourceSpec.getCMDataSourceName()));
        commandStr.append(this.appendParam(++seqNum, datasourceSpec.getCMConnectionName()));
        commandStr.append(this.appendParam(++seqNum, datasourceSpec.getCMConnectionPath()));
        commandStr.append(this.appendParam(++seqNum, datasourceSpec.getCMSignonName()));
        commandStr.append(this.appendParam(++seqNum, datasourceSpec.getCMSignonPath()));
        commandStr.append(this.appendParam(++seqNum, datasourceSpec.getSignonUserID()));
        commandStr.append(this.appendParam(++seqNum, datasourceSpec.getSignonPassword()));
        commandStr.append(this.appendParam(++seqNum, datasourceSpec.getCubeAutnenticationPassword()));
        commandStr.append(this.appendParam(++seqNum, datasourceSpec.getCubeAuthenticationNamespace()));
        commandStr.append(CLOSE_QE_TRANSACTION);
        commandStr.append(CLOSE_MDPROVIDER);
        Element responseNode = null;
        try {
            StringBuffer reqID = new StringBuffer("DataSourceConnection_");
            reqID.append(datasourceSpec.getCMDataSourceName());
            String res = this.invokeRequest(reqID.toString(), commandStr.toString(), true);
            SAXReader reader = new SAXReader();
            Document resultsDoc = reader.read((Reader)new StringReader(res));
            responseNode = resultsDoc.getRootElement();
        }
        catch (DocumentException de) {
            throw new RuntimeException(de.getMessage(), de);
        }
        catch (MFWModelCloseException mc) {
            this.m_bModelOpen = false;
            this.m_conversationContext = null;
            this.getDataSourceConnection(datasourceSpec);
        }
        Element outputParam = (Element)responseNode.getDocument().selectSingleNode("//outputparams");
        Element param = outputParam.element("param");
        Element cclnode = param.element("cclnode");
        MFWDSConnectionSpec spec = new MFWDSConnectionSpec(datasourceSpec.getCMDataSourceName());
        String temp = cclnode.attributeValue("databaseType");
        if (temp != null && temp.length() > 0) {
            spec.setDataSourceType(temp);
        }
        if ((temp = cclnode.attributeValue("connectionString")) != null && temp.length() > 0) {
            spec.setConnectionString(temp);
        }
        if ((temp = cclnode.attributeValue("username")) != null && temp.length() > 0) {
            spec.setSignonUID(temp);
        }
        if ((temp = cclnode.attributeValue("password")) != null && temp.length() > 0) {
            spec.setSignonPWD(temp);
        }
        if ((temp = cclnode.attributeValue("namespace")) != null && temp.length() > 0) {
            spec.setCubeAuthenicationNamespace(temp);
        }
        if ((temp = cclnode.attributeValue("connectionSearchPath")) != null && temp.length() > 0) {
            spec.setConnectionSearchPath(temp);
        }
        if ((temp = cclnode.attributeValue("cryptoHandle")) != null && temp.length() > 0) {
            spec.setCryptoHandle(temp);
        }
        if ((temp = cclnode.attributeValue("cubePassword")) != null && temp.length() > 0) {
            spec.setCubeAuthenticationPassword(temp);
        }
        if ((temp = cclnode.attributeValue("SAPTicket")) != null && temp.length() > 0) {
            spec.setTicket(temp);
        }
        return spec;
    }

    private void initialize() {
        if (!this.m_bModelOpen) {
            String tempRepos = this.getTempRepository();
            long nTime = System.currentTimeMillis();
            StringBuffer modelName = new StringBuffer(tempRepos);
            modelName.append(nTime);
            modelName.append(".cpf");
            this.m_modelName = modelName.toString();
            StringBuffer commandStr = new StringBuffer(OPEN_MDPROVIDER);
            commandStr.append(this.m_modelName);
            commandStr.append(GENERIC_CREATE_MODEL);
            commandStr.append(MDSERVICE);
            commandStr.append(CLOSE_MDPROVIDER);
            try {
                this.invokeRequest("Initialize", commandStr.toString(), false);
            }
            catch (MFWModelCloseException mc) {
                this.initialize();
            }
        }
        this.m_bModelOpen = true;
    }

    @Override
    public void terminate() {
        if (this.m_bModelOpen) {
            StringBuffer commandStr = new StringBuffer(OPEN_MDPROVIDER);
            commandStr.append(this.m_modelName);
            commandStr.append(GENERIC_CLOSE_MODEL);
            commandStr.append(MDSERVICE);
            commandStr.append(CLOSE_MDPROVIDER);
            try {
                if (!MFWContentHelper.isImposterAround()) {
                    this.invokeRequest("Terminate", commandStr.toString(), true);
                }
            }
            catch (MFWModelCloseException mFWModelCloseException) {
                // empty catch block
            }
        }
        this.m_bModelOpen = false;
    }

    private String invokeRequest(String requestId, String commandStr, boolean initIfNecessary) throws MFWModelCloseException {
        try {
            if (initIfNecessary) {
                this.initialize();
            }
            MFWLogMDSRVBridge log = new MFWLogMDSRVBridge(requestId, commandStr);
            if (MFWContentHelper.isImposterAround()) {
                String outResponse = this.m_ContentHelper.updateMetadata(requestId, commandStr);
                log.logResult(requestId, outResponse);
                log.destroy();
                return outResponse;
            }
            RequestInvoker invoker = this.m_context.getInvoker();
            if (invoker != null) {
                int colonPos;
                MessageContextImpl mc = new MessageContextImpl();
                BIBusEnvelope requestEnvelope = new BIBusEnvelope();
                BIBusEnvelope originalRequest = this.m_context.getBiBusEnvelope();
                if (originalRequest != null) {
                    Element header = originalRequest.getBIBusHeader();
                    header = (Element)header.clone();
                    header.detach();
                    requestEnvelope.setBIBusHeader(header);
                } else {
                    Element cam = requestEnvelope.getCAM();
                    Element passport = cam.addElement("CAMPassport");
                    Element id = passport.addElement("id");
                    id.setText(this.m_context.getUserPassport());
                }
                Element soapBody = requestEnvelope.getBody();
                Document request = DocumentHelper.parseText((String)commandStr);
                Element requestBody = request.getRootElement();
                requestBody.detach();
                soapBody.add(requestBody);
                mc.setProperty("request.envelope", (Object)requestEnvelope);
                Element tracking = requestEnvelope.getTracking();
                Namespace theNameSpace = null;
                String typeName = "";
                String type = tracking.attributeValue(SOAPEnvelope.XSI_TYPE);
                if (type != null && (colonPos = type.indexOf(58)) != -1) {
                    String prefix = type.substring(0, colonPos);
                    typeName = type.substring(colonPos + 1);
                    theNameSpace = tracking.getNamespaceForPrefix(prefix);
                }
                tracking.clearContent();
                List headerNamespaces = requestEnvelope.getBIBusHeader().declaredNamespaces();
                if (theNameSpace != null && !headerNamespaces.contains(theNameSpace) && "tracking".equalsIgnoreCase(typeName)) {
                    tracking.add(theNameSpace);
                }
                Element context = tracking.addElement(BIBusEnvelope.BUS_REQUEST_CONTEXT.getName());
                context.setText("bibustkServer");
                if (!initIfNecessary) {
                    mc.setProperty("request.soapaction", (Object)"bibustkServer");
                } else {
                    mc.setProperty("request.soapaction", (Object)"bibustkServer.absolute");
                    this.m_conversationContext.detach();
                    tracking.add(this.m_conversationContext);
                }
                mc.setProperty("request.headers", (Object)new InternetHeaders());
                ArrayList toClean = new ArrayList();
                mc.setProperty("cleanup", toClean);
                invoker.invoke((MessageContext)mc);
                for (int i = 0; i < toClean.size(); ++i) {
                    Object cleanable = toClean.get(i);
                    if (!(cleanable instanceof Cleanable)) continue;
                    ((Cleanable)cleanable).clean((MessageContext)mc);
                }
                Fault f = mc.getFault();
                if (f != null) {
                    if ("MDSRVHandler.missingProcess".equals(f.getMessageCode())) {
                        throw new MFWModelCloseException();
                    }
                    throw new RuntimeException(f.getMessageCode());
                }
                BIBusEnvelope envelope = (BIBusEnvelope)mc.getProperty("response.envelope");
                Element responseBody = envelope.getBody();
                String outResponse = responseBody.asXML();
                MFWV5Bridge.checkQF(envelope.getEnvelope());
                if (!initIfNecessary) {
                    Element convo = (Element)tracking.selectSingleNode("*[local-name()='conversationContext']");
                    this.m_conversationContext = (Element)convo.clone();
                    this.m_conversationContext.detach();
                }
                log.logResult(requestId, outResponse);
                log.destroy();
                return outResponse;
            }
            MFWException.ASSERT((boolean)false, (String)"Request context is not associated with a request invoker, specify request invoker, or configure for XQE useage");
            return null;
        }
        catch (RuntimeException rt) {
            this.m_bModelOpen = false;
            throw rt;
        }
        catch (DocumentException de) {
            this.m_bModelOpen = false;
            throw new RuntimeException(de.getMessage(), de);
        }
        catch (IOException io) {
            throw new RuntimeException(io.getMessage(), io);
        }
    }

    private String getTempRepository() {
        try {
            ICCLConfiguration icclConfig = CCLConfigurationFactory.getInstance();
            String bmtConfigFile = "../configuration/bmt.ini";
            bmtConfigFile = icclConfig.resolveEffectivePath(bmtConfigFile);
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(bmtConfigFile));
            SAXReader reader = new SAXReader();
            Document document = reader.read((InputStream)is);
            Element preference = (Element)document.selectSingleNode("/Preferences/Section[@Name='TempDriver']/Preference[@Name='RepositoryID']");
            if (preference != null) {
                return preference.getText();
            }
            is.close();
        }
        catch (DocumentException de) {
            throw new RuntimeException(de.getMessage(), de);
        }
        catch (IOException io) {
            throw new RuntimeException(io.getMessage(), io);
        }
        return "h://";
    }

    private String appendParam(int seqNum, String valueStr) {
        StringBuffer commandStr = new StringBuffer(OPEN_PARAM_QE_TRANSACTION);
        commandStr.append(seqNum);
        commandStr.append(PARAM_QE_TRANSACTION);
        if (valueStr != null) {
            commandStr.append(valueStr);
        }
        commandStr.append(CLOSE_PARAM_QE_TRANSACTION);
        return commandStr.toString();
    }
}

