/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfwa4j.v5Bridge;

import com.cognos.mfw4j.framework.MFWRequestContext;
import com.cognos.mfw4j.framework.MFWRequestContextUser;
import com.cognos.mfw4j.resourcePool.MFWDSConnectionSpec;
import com.cognos.mfw4j.resourcePool.MFWDSSelectionCriteria;
import com.cognos.mfw4j.utilities.MFWXMLDump;
import com.cognos.mfw4j.utilities.QFException;
import com.cognos.mfwa4j.v5Bridge.MDSRVBridge;
import com.cognos.mfwa4j.v5Bridge.MFWModelCloseException;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import org.apache.axis.AxisFault;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.io.SAXReader;
import org.w3c.dom.Element;

public abstract class MFWV5Bridge {
    public static MFWV5Bridge create(MFWRequestContextUser aContext) {
        return new MDSRVBridge((MFWRequestContext)aContext);
    }

    public abstract org.dom4j.Element doV5Request(String var1, String var2);

    public abstract MFWDSConnectionSpec getDataSourceConnection(MFWDSSelectionCriteria var1);

    public abstract void terminate();

    protected MFWV5Bridge() {
    }

    static void checkQF(org.dom4j.Element soapEnvelope) throws MFWModelCloseException {
        org.dom4j.Element faultCode;
        org.dom4j.Element fault = (org.dom4j.Element)soapEnvelope.selectSingleNode("*//*[local-name()='Fault']");
        if (fault != null && (faultCode = (org.dom4j.Element)fault.selectSingleNode("faultcode")) != null) {
            String code = faultCode.getTextTrim();
            if (code.startsWith("CQE")) {
                org.dom4j.Element faultString = (org.dom4j.Element)fault.selectSingleNode("faultstring");
                MFWV5Bridge.processQF(code, faultString.getTextTrim(), fault.getDocument());
            } else {
                org.dom4j.Element err;
                List errorCode = fault.getDocument().selectNodes("//errorCode");
                if (errorCode.size() > 0 && "BME-AS-0022".equals((err = (org.dom4j.Element)errorCode.get(0)).getTextTrim())) {
                    throw new MFWModelCloseException();
                }
                List msgs = fault.getDocument().selectNodes("//messageString");
                StringBuffer outMsg = new StringBuffer();
                for (int idx = 0; idx < msgs.size(); ++idx) {
                    outMsg.append("\n\t");
                    outMsg.append(((org.dom4j.Element)msgs.get(idx)).getText());
                }
                throw new RuntimeException(outMsg.toString());
            }
        }
    }

    static void checkQF(AxisFault f) {
        String fc = f.getFaultCode().getLocalPart();
        Element[] fd = f.getFaultDetails();
        if (fd.length == 0) {
            return;
        }
        String faultDetail = MFWXMLDump.DumpElement((Element)fd[0]);
        try {
            SAXReader reader = new SAXReader();
            Document resultsDoc = reader.read((Reader)new StringReader(faultDetail));
            if (!fc.startsWith("CQE")) {
                List msgs = resultsDoc.getRootElement().selectNodes("//messageString");
                StringBuffer outMsg = new StringBuffer(f.getMessage());
                for (int idx = 0; idx < msgs.size(); ++idx) {
                    outMsg.append("\n\t");
                    outMsg.append(((org.dom4j.Element)msgs.get(idx)).getText());
                }
                throw new RuntimeException(outMsg.toString(), (Throwable)f);
            }
            MFWV5Bridge.processQF(fc, f.getMessage(), resultsDoc);
        }
        catch (DocumentException de) {
            throw new RuntimeException(de.getMessage(), de);
        }
    }

    private static void processQF(String fc, String fs, Document responseDoc) {
        String code = fc.substring(4);
        org.dom4j.Element ds = (org.dom4j.Element)responseDoc.selectSingleNode("//*[local-name()='dataSource']");
        Document document = DocumentHelper.createDocument();
        org.dom4j.Element fault = document.addElement("Fault");
        org.dom4j.Element faultCode = fault.addElement("faultcode");
        faultCode.setText(fc);
        org.dom4j.Element faultString = fault.addElement("faultstring");
        faultString.setText(fs);
        org.dom4j.Element newDs = (org.dom4j.Element)ds.clone();
        newDs.detach();
        fault.add(newDs);
        QFException qf = new QFException(Integer.parseInt(code));
        qf.setDOM(fault);
        throw qf;
    }
}

