/*
 * Decompiled with CFR 0.152.
 */
package org.mime4j;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MimeBoundaryInputStream
extends InputStream {
    private static Log log = LogFactory.getLog((Class)(class$org$mime4j$MimeBoundaryInputStream == null ? (class$org$mime4j$MimeBoundaryInputStream = MimeBoundaryInputStream.class$("org.mime4j.MimeBoundaryInputStream")) : class$org$mime4j$MimeBoundaryInputStream));
    private PushbackInputStream s = null;
    private byte[] boundary = null;
    private boolean first = true;
    private boolean eof = false;
    private boolean parenteof = false;
    private boolean moreParts = true;
    static /* synthetic */ Class class$org$mime4j$MimeBoundaryInputStream;

    public MimeBoundaryInputStream(InputStream s, String boundary) throws IOException {
        this.s = new PushbackInputStream(s, boundary.length() + 4);
        boundary = "--" + boundary;
        this.boundary = new byte[boundary.length()];
        for (int i = 0; i < this.boundary.length; ++i) {
            this.boundary[i] = (byte)boundary.charAt(i);
        }
        int b = this.read();
        if (b != -1) {
            this.s.unread(b);
        }
    }

    public void close() throws IOException {
        this.s.close();
    }

    public boolean hasMoreParts() {
        return this.moreParts;
    }

    public boolean parentEOF() {
        return this.parenteof;
    }

    public void consume() throws IOException {
        while (this.read() != -1) {
        }
    }

    public int read() throws IOException {
        if (this.eof) {
            return -1;
        }
        if (this.first) {
            this.first = false;
            if (this.matchBoundary()) {
                return -1;
            }
        }
        int b1 = this.s.read();
        int b2 = this.s.read();
        if (b1 == 13 && b2 == 10 && this.matchBoundary()) {
            return -1;
        }
        if (b2 != -1) {
            this.s.unread(b2);
        }
        this.eof = this.parenteof = b1 == -1;
        return b1;
    }

    private boolean matchBoundary() throws IOException {
        for (int i = 0; i < this.boundary.length; ++i) {
            int b = this.s.read();
            if (b == this.boundary[i]) continue;
            if (b != -1) {
                this.s.unread(b);
            }
            for (int j = i - 1; j >= 0; --j) {
                this.s.unread(this.boundary[j]);
            }
            return false;
        }
        int prev = this.s.read();
        int curr = this.s.read();
        boolean bl = this.moreParts = prev != 45 || curr != 45;
        while (curr != 10 || prev != 13) {
            prev = curr;
            curr = this.s.read();
            if (curr != -1) continue;
        }
        if (curr == -1) {
            this.moreParts = false;
            this.parenteof = true;
        }
        this.eof = true;
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

