/*
 * Decompiled with CFR 0.152.
 */
package org.mime4j.field;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mime4j.field.Field;
import org.mime4j.field.contenttype.parser.ContentTypeParser;
import org.mime4j.field.contenttype.parser.ParseException;
import org.mime4j.field.contenttype.parser.TokenMgrError;

public class ContentTypeField
extends Field {
    private static Log log = LogFactory.getLog((Class)(class$org$mime4j$field$ContentTypeField == null ? (class$org$mime4j$field$ContentTypeField = ContentTypeField.class$("org.mime4j.field.ContentTypeField")) : class$org$mime4j$field$ContentTypeField));
    public static final String TYPE_MULTIPART_PREFIX = "multipart/";
    public static final String TYPE_MULTIPART_DIGEST = "multipart/digest";
    public static final String TYPE_TEXT_PLAIN = "text/plain";
    public static final String TYPE_MESSAGE_RFC822 = "message/rfc822";
    public static final String PARAM_BOUNDARY = "boundary";
    public static final String PARAM_CHARSET = "charset";
    private String mimeType = "";
    private HashMap parameters = null;
    private ParseException parseException;
    static /* synthetic */ Class class$org$mime4j$field$ContentTypeField;

    protected ContentTypeField() {
    }

    protected void parseBody(String body) {
        ContentTypeParser parser = new ContentTypeParser(new StringReader(body));
        try {
            parser.parseAll();
        }
        catch (ParseException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Parsing value '" + body + "': " + e.getMessage()));
            }
            this.parseException = e;
        }
        catch (TokenMgrError e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Parsing value '" + body + "': " + e.getMessage()));
            }
            this.parseException = new ParseException(e.getMessage());
        }
        try {
            String type = parser.getType();
            String subType = parser.getSubType();
            if (type == null || subType == null) {
                return;
            }
            this.mimeType = (type + "/" + parser.getSubType()).toLowerCase();
            ArrayList paramNames = parser.getParamNames();
            ArrayList paramValues = parser.getParamValues();
            if (paramNames == null || paramValues == null) {
                return;
            }
            for (int i = 0; i < paramNames.size() && i < paramValues.size(); ++i) {
                if (this.parameters == null) {
                    this.parameters = new HashMap((int)((double)paramNames.size() * 1.3 + 1.0));
                }
                String name = ((String)paramNames.get(i)).toLowerCase();
                String value = (String)paramValues.get(i);
                this.parameters.put(name, value);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public ParseException getParseException() {
        return this.parseException;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public static String getMimeType(ContentTypeField child, ContentTypeField parent) {
        if (child == null || child.getMimeType().length() == 0 || child.isMultipart() && child.getBoundary() == null) {
            if (parent != null && parent.isMimeType(TYPE_MULTIPART_DIGEST)) {
                return TYPE_MESSAGE_RFC822;
            }
            return TYPE_TEXT_PLAIN;
        }
        return child.getMimeType();
    }

    public String getParameter(String name) {
        return this.parameters != null ? (String)this.parameters.get(name.toLowerCase()) : null;
    }

    public Map getParameters() {
        return this.parameters != null ? Collections.unmodifiableMap(this.parameters) : Collections.EMPTY_MAP;
    }

    public String getBoundary() {
        return this.getParameter(PARAM_BOUNDARY);
    }

    public String getCharset() {
        return this.getParameter(PARAM_CHARSET);
    }

    public static String getCharset(ContentTypeField f) {
        if (f != null && f.getCharset() != null && f.getCharset().length() > 0) {
            return f.getCharset();
        }
        return "us-ascii";
    }

    public boolean isMimeType(String mimeType) {
        return this.mimeType.equalsIgnoreCase(mimeType);
    }

    public boolean isMultipart() {
        return this.mimeType.startsWith(TYPE_MULTIPART_PREFIX);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

